/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.cnnc.zone.controller;

import cn.hutool.core.io.FileUtil;
import cn.hutool.http.HttpUtil;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.write.builder.ExcelWriterBuilder;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.alibaba.excel.write.metadata.fill.FillConfig;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ohaotian.plugin.base.annotation.BusiResponseBody;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.cnnc.zone.ability.CnncQueryAgreementSkuAndMaterialService;
import com.tydic.cnnc.zone.ability.bo.CnncQueryAgreementSkuAndMaterialReqBO;
import com.tydic.cnnc.zone.ability.bo.CnncQueryAgreementSkuAndMaterialRspBO;
import com.tydic.cnnc.zone.ability.bo.CnncZoneAgrMaterialChangeExcelTemplateAbilityReqBO;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/cnnc/zone/"})
public class CnncZoneAgrMaterialChangeExcelTemplateController {
    private static final Logger log = LoggerFactory.getLogger(CnncZoneAgrMaterialChangeExcelTemplateController.class);
    @Value(value="${CNNC_ZONE_AGR_MATERIAL_CHANGE_IMPORT_TEMPLATE:http://172.16.100.64:18000/group1/M00/03/F2/rBBkQGazLGeACtj5AAAtjh7-Otk83.xlsx}")
    private String CNNC_ZONE_AGR_MATERIAL_CHANGE_IMPORT_TEMPLATE;
    @Value(value="${plugin.file.type}")
    private String fileType;
    @Value(value="${oss.fileUrl:}")
    private String ossFileUrl;
    @Value(value="${fastdfs.trackerServers:}")
    private String fastdfsTrackerServers;
    @Value(value="${fastdfs.httpTrackerHttpPort:}")
    private String fastdfsHttpTrackerHttpPort;
    public static final String FILE_TYPE_FASTDFS = "FASTDFS";
    @Autowired
    private CnncQueryAgreementSkuAndMaterialService cnncQueryAgreementSkuAndMaterialService;

    @RequestMapping(value={"/getMaterialChangeExcelTemplate"}, method={RequestMethod.GET, RequestMethod.POST})
    @BusiResponseBody
    public void getMaterialChangeExcelTemplate(@RequestBody CnncZoneAgrMaterialChangeExcelTemplateAbilityReqBO reqBo, HttpServletResponse response) {
        List<String> errorMsg = this.parameterValidation(reqBo);
        if (!errorMsg.isEmpty()) {
            throw new ZTBusinessException("\u5165\u53c2\u6821\u9a8c\u4e0d\u901a\u8fc7\uff1a" + String.join((CharSequence)";", errorMsg));
        }
        String rootPath = CnncZoneAgrMaterialChangeExcelTemplateController.class.getResource("/").getPath() + "temp" + System.currentTimeMillis();
        String filePath = this.downloadToFile(rootPath);
        String writeFileName = "\u534f\u8bae\u7269\u8d44\u7f16\u7801\u505c\u7528\u53d8\u66f4\u6a21\u7248\u6587\u4ef6";
        if (this.CNNC_ZONE_AGR_MATERIAL_CHANGE_IMPORT_TEMPLATE.endsWith(".xls")) {
            writeFileName = writeFileName + ".xls";
        } else if (this.CNNC_ZONE_AGR_MATERIAL_CHANGE_IMPORT_TEMPLATE.endsWith(".xlsx")) {
            writeFileName = writeFileName + ".xlsx";
        }
        String jsonReq = JSONObject.toJSONString((Object)reqBo, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
        CnncQueryAgreementSkuAndMaterialReqBO abilityReqBO = (CnncQueryAgreementSkuAndMaterialReqBO)JSON.parseObject((String)jsonReq, CnncQueryAgreementSkuAndMaterialReqBO.class);
        CnncQueryAgreementSkuAndMaterialRspBO abilityRspBO = this.cnncQueryAgreementSkuAndMaterialService.qryAgreementSkuAndMaterial(abilityReqBO);
        try {
            response.setContentType("application/vnd.ms-excel");
            response.setHeader("Content-Disposition", "attachment; filename=" + URLEncoder.encode(writeFileName, "UTF-8"));
            ServletOutputStream outputStream = response.getOutputStream();
            log.error("\u534f\u8bae\u7269\u8d44\u7f16\u7801\u505c\u7528\u53d8\u66f4\u6a21\u7248\u5bfc\u51fa\u6a21\u7248\u5f00\u59cb\u5199\u5165\u6570\u636e");
            ExcelWriterBuilder excelWriterBuilder = EasyExcel.write((OutputStream)outputStream).withTemplate(filePath);
            ExcelWriter excelWriter = excelWriterBuilder.build();
            WriteSheet writeSheet = EasyExcel.writerSheet((Integer)0).build();
            FillConfig fillConfig = FillConfig.builder().forceNewRow(Boolean.TRUE).build();
            log.error("cnncMaterialChangeInfoBOList\uff1a{}", (Object)JSON.toJSONString((Object)abilityRspBO.getCnncMaterialChangeInfoBOList()));
            excelWriter.fill((Object)abilityRspBO.getCnncMaterialChangeInfoBOList(), fillConfig, writeSheet);
            log.error("\u534f\u8bae\u7269\u8d44\u7f16\u7801\u505c\u7528\u53d8\u66f4\u6a21\u7248\u5bfc\u51fa\u6a21\u7248\u6570\u636e\u5199\u5165\u5b8c\u6210");
            excelWriter.finish();
            outputStream.close();
        }
        catch (IOException e) {
            log.error("\u534f\u8bae\u7269\u8d44\u7f16\u7801\u505c\u7528\u53d8\u66f4\u6a21\u7248\u4e0b\u8f7d\u5931\u8d25:{}", (Object)e.getMessage());
            e.printStackTrace();
            throw new ZTBusinessException("\u534f\u8bae\u7269\u8d44\u7f16\u7801\u505c\u7528\u53d8\u66f4\u6a21\u7248\u4e0b\u8f7d\u5931\u8d25");
        }
        finally {
            FileUtil.del((String)rootPath);
        }
    }

    private String downloadToFile(String rootPath) {
        String templateFileName = "\u534f\u8bae\u7269\u8d44\u7f16\u7801\u505c\u7528\u53d8\u66f4\u6a21\u7248\u6587\u4ef6";
        String templateFileUrl = this.CNNC_ZONE_AGR_MATERIAL_CHANGE_IMPORT_TEMPLATE;
        log.error("\u534f\u8bae\u7269\u8d44\u7f16\u7801\u505c\u7528\u53d8\u66f4\u6a21\u7248\u4e0b\u8f7d\u5730\u5740:{}", (Object)templateFileUrl);
        if (!StringUtils.hasText((String)templateFileUrl)) {
            throw new ZTBusinessException("\u534f\u8bae\u7269\u8d44\u7f16\u7801\u505c\u7528\u53d8\u66f4\u6a21\u7248\u5730\u5740\u4e3a\u7a7a,\u8bf7\u5148\u914d\u7f6e");
        }
        if (templateFileUrl.endsWith(".xls")) {
            templateFileName = templateFileName + ".xls";
        } else if (templateFileUrl.endsWith(".xlsx")) {
            templateFileName = templateFileName + ".xlsx";
        } else {
            throw new ZTBusinessException("\u6a21\u7248\u6587\u4ef6\u4e0d\u662fExcel");
        }
        String filePath = rootPath + "/" + templateFileName;
        if (FILE_TYPE_FASTDFS.equals(this.fileType)) {
            for (int i = 0; i < 3; ++i) {
                templateFileUrl = templateFileUrl.substring(templateFileUrl.indexOf("/") + 1);
            }
            templateFileUrl = "http://" + this.fastdfsTrackerServers.substring(0, this.fastdfsTrackerServers.indexOf(":") + 1) + this.fastdfsHttpTrackerHttpPort + "/" + templateFileUrl;
        }
        log.error("\u66ff\u6362\u540e\u4e0b\u8f7d\u5730\u5740\uff1a{}.file:{}", (Object)templateFileUrl, (Object)filePath);
        try {
            HttpUtil.downloadFile((String)templateFileUrl, (String)filePath);
            log.error("\u6587\u4ef6\u4e0b\u8f7d\u6210\u529f.\u4e0b\u8f7d\u5730\u5740\uff1a{}.file:{}", (Object)templateFileUrl, (Object)filePath);
        }
        catch (Exception e) {
            log.error("\u6587\u4ef6\u4e0b\u8f7d\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            throw new ZTBusinessException("\u534f\u8bae\u7269\u8d44\u7f16\u7801\u505c\u7528\u53d8\u66f4\u6a21\u7248\u4e0b\u8f7d\u5931\u8d25");
        }
        return filePath;
    }

    private List<String> parameterValidation(CnncZoneAgrMaterialChangeExcelTemplateAbilityReqBO reqBo) {
        ArrayList<String> errorMsg = new ArrayList<String>();
        if (reqBo == null) {
            errorMsg.add("\u5165\u53c2\u5bf9\u8c61\u4e3a\u7a7a");
            return errorMsg;
        }
        if (null == reqBo.getAgreementId()) {
            errorMsg.add("\u534f\u8baeID\u4e3a\u7a7a");
            return errorMsg;
        }
        return errorMsg;
    }
}

