/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.cfc.ability.impl;

import com.tydic.cfc.ability.api.CfcUniteParamAccessUploadUpdateAbilityService;
import com.tydic.cfc.ability.bo.CfcUniteParamAccessUploadUpdateAbilityReqBO;
import com.tydic.cfc.ability.bo.CfcUniteParamAccessUploadUpdateAbilityRspBO;
import com.tydic.cfc.ability.bo.CfcUniteParamBO;
import com.tydic.cfc.ability.bo.CfcUniteParamVerticalBO;
import com.tydic.cfc.busi.api.CfcUniteParamUpdateBusiService;
import com.tydic.cfc.busi.bo.CfcUniteParamUpdateBusiReqBO;
import com.tydic.cfc.busi.bo.CfcUniteParamUpdateBusiRspBO;
import com.tydic.cfc.exceptions.CfcBusinessException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.cfc.ability.api.CfcUniteParamAccessUploadUpdateAbilityService"})
public class CfcUniteParamAccessUploadUpdateAbilityServiceImpl
implements CfcUniteParamAccessUploadUpdateAbilityService {
    private static final Logger log = LoggerFactory.getLogger(CfcUniteParamAccessUploadUpdateAbilityServiceImpl.class);
    @Autowired
    private CfcUniteParamUpdateBusiService cfcUniteParamUpdateBusiService;

    @PostMapping(value={"updateUniteParamAccessUpload"})
    public CfcUniteParamAccessUploadUpdateAbilityRspBO updateUniteParamAccessUpload(@RequestBody CfcUniteParamAccessUploadUpdateAbilityReqBO reqBO) {
        this.validParam(reqBO);
        CfcUniteParamUpdateBusiReqBO busiReqBO = new CfcUniteParamUpdateBusiReqBO();
        CfcUniteParamBO cfcUniteParamBO = new CfcUniteParamBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)cfcUniteParamBO);
        busiReqBO.setCfcUniteParamBO(cfcUniteParamBO);
        busiReqBO.setCfcUniteParamVerticalList(this.composeCfcUniteParamVerticalList(reqBO));
        CfcUniteParamUpdateBusiRspBO busiRspBO = this.cfcUniteParamUpdateBusiService.updateUniteParam(busiReqBO);
        CfcUniteParamAccessUploadUpdateAbilityRspBO rspBO = new CfcUniteParamAccessUploadUpdateAbilityRspBO();
        rspBO.setRespCode(busiRspBO.getRespCode());
        rspBO.setRespDesc(busiRspBO.getRespDesc());
        return rspBO;
    }

    private List<CfcUniteParamVerticalBO> composeCfcUniteParamVerticalList(CfcUniteParamAccessUploadUpdateAbilityReqBO reqBO) {
        ArrayList<CfcUniteParamVerticalBO> cfcUniteParamVerticalBOS = new ArrayList<CfcUniteParamVerticalBO>();
        cfcUniteParamVerticalBOS.add(this.composeCfcUniteParamVertical("accessUploadNum", "\u9644\u4ef6\u4e0a\u4f20\u4e2a\u6570", "text", reqBO.getAccessUploadNum()));
        cfcUniteParamVerticalBOS.add(this.composeCfcUniteParamVertical("accessUploadSize", "\u9644\u4ef6\u4e0a\u4f20\u5927\u5c0f", "text", reqBO.getAccessUploadSize()));
        String accessUploadType = StringUtils.join((Iterable)reqBO.getAccessUploadType(), (String)",");
        cfcUniteParamVerticalBOS.add(this.composeCfcUniteParamVertical("accessUploadType", "\u9644\u4ef6\u4e0a\u4f20\u7c7b\u578b", "list", accessUploadType));
        return cfcUniteParamVerticalBOS;
    }

    private CfcUniteParamVerticalBO composeCfcUniteParamVertical(String verticalCode, String verticalName, String verticalType, String verticalValue) {
        CfcUniteParamVerticalBO cfcUniteParamVerticalBO = new CfcUniteParamVerticalBO();
        cfcUniteParamVerticalBO.setVerticalCode(verticalCode);
        cfcUniteParamVerticalBO.setVerticalName(verticalName);
        cfcUniteParamVerticalBO.setVerticalType(verticalType);
        cfcUniteParamVerticalBO.setVerticalValue(verticalValue);
        return cfcUniteParamVerticalBO;
    }

    private void validParam(CfcUniteParamAccessUploadUpdateAbilityReqBO reqBO) {
        if (reqBO == null) {
            throw new CfcBusinessException("221040", "\u9644\u4ef6\u4e0a\u4f20\u89c4\u5219\u4fee\u6539\u8bf7\u6c42\u4e3a\u7a7a");
        }
        if (reqBO.getId() == null) {
            throw new CfcBusinessException("221040", "\u9644\u4ef6\u4e0a\u4f20\u89c4\u5219ID\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)reqBO.getAccessUploadNum())) {
            throw new CfcBusinessException("221040", "\u9644\u4ef6\u4e0a\u4f20\u4e2a\u6570\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)reqBO.getAccessUploadSize())) {
            throw new CfcBusinessException("221040", "\u9644\u4ef6\u4e0a\u4f20\u5927\u5c0f\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getAccessUploadType())) {
            throw new CfcBusinessException("221040", "\u9644\u4ef6\u4e0a\u4f20\u7c7b\u578b\u4e3a\u7a7a");
        }
    }
}

