/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.atom.impl;

import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.contract.atom.ContractSendTodoOrMessageAtomService;
import com.tydic.contract.atom.bo.ContractSendTodoOrMessageAtoOrmReqBo;
import com.tydic.contract.atom.bo.ContractSendTodoOrMessageAtoOrmRspBo;
import com.tydic.contract.atom.bo.GeminiReceiverAtomBO;
import com.tydic.contract.atom.bo.GeminiSendAtomBo;
import com.tydic.contract.atom.bo.GeminiSendAtomRspBo;
import com.tydic.dyc.authority.service.user.AuthGetUserByRoleAndOrgService;
import com.tydic.dyc.authority.service.user.bo.AuthByRoleAndOrgQryUserInfoBo;
import com.tydic.dyc.authority.service.user.bo.AuthGetUserByRoleAndOrgReqBo;
import com.tydic.dyc.authority.service.user.bo.AuthGetUserByRoleAndOrgRspBo;
import com.tydic.dyc.base.utils.JUtil;
import com.tydic.dyc.umc.service.todo.UmcQryWaitDoneConfigListService;
import com.tydic.dyc.umc.service.todo.UmcSendTodoService;
import com.tydic.dyc.umc.service.todo.bo.UmcQryWaitDoneConfigListReqBO;
import com.tydic.dyc.umc.service.todo.bo.UmcQryWaitDoneConfigListRspBO;
import com.tydic.dyc.umc.service.todo.bo.UmcSendTodoReqBo;
import com.tydic.dyc.umc.service.todo.bo.UmcSendTodoRspBo;
import com.tydic.dyc.umc.service.todo.bo.UmcTodoBo;
import com.tydic.dyc.umc.service.todo.bo.UmcWaitDoneConfigBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ContractSendTodoOrMessageAtomServiceImpl
implements ContractSendTodoOrMessageAtomService {
    private static final Logger log = LoggerFactory.getLogger(ContractSendTodoOrMessageAtomServiceImpl.class);
    @Autowired
    private UmcSendTodoService umcSendTodoService;
    @Autowired
    private UmcQryWaitDoneConfigListService umcQryWaitDoneConfigListService;
    @Autowired
    private AuthGetUserByRoleAndOrgService authGetUserByRoleAndOrgService;
    @Value(value="${geminiSendUrl:http}")
    private String geminiSendUrl;

    @Override
    public ContractSendTodoOrMessageAtoOrmRspBo sendTodoOrMessage(ContractSendTodoOrMessageAtoOrmReqBo reqBo) {
        ContractSendTodoOrMessageAtoOrmRspBo rspBo = new ContractSendTodoOrMessageAtoOrmRspBo();
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        try {
            String[] itemCodes = reqBo.getItemCode().split(",");
            List<AuthByRoleAndOrgQryUserInfoBo> userInfoBos = reqBo.getUserInfoBos();
            this.sendTodo(reqBo, "", userInfoBos, itemCodes);
            if (reqBo.getTaskCode() == null) {
                return rspBo;
            }
            this.sendMessage(reqBo, userInfoBos);
            return rspBo;
        }
        catch (Exception e) {
            e.printStackTrace();
            return rspBo;
        }
    }

    private void sendMessage(ContractSendTodoOrMessageAtoOrmReqBo reqBo, List<AuthByRoleAndOrgQryUserInfoBo> userInfoBos) {
        GeminiSendAtomBo geminiSendAtomBo = new GeminiSendAtomBo();
        ArrayList<GeminiReceiverAtomBO> geminiReceiverAtomBOS = new ArrayList<GeminiReceiverAtomBO>(userInfoBos.size());
        for (AuthByRoleAndOrgQryUserInfoBo userInfoBo : userInfoBos) {
            GeminiReceiverAtomBO geminiReceiverAtomBO = new GeminiReceiverAtomBO();
            geminiReceiverAtomBO.setReceiverId(userInfoBo.getUserId().toString());
            geminiReceiverAtomBO.setReceiverName(userInfoBo.getCustName());
            geminiReceiverAtomBOS.add(geminiReceiverAtomBO);
        }
        geminiSendAtomBo.setReceivers(geminiReceiverAtomBOS);
        geminiSendAtomBo.setTaskCode(reqBo.getTaskCode());
        geminiSendAtomBo.setData(reqBo.getData());
        geminiSendAtomBo.setSendId("1");
        String geminiSendAtomBoStr = JSON.toJSONString((Object)((Object)geminiSendAtomBo));
        log.info("HTTP\u8c03\u7528\u901a\u77e5\u4e2d\u5fc3-\u5165\u53c2\uff1a{}", (Object)geminiSendAtomBoStr);
        String geminiSendAtomRspBoStr = HttpUtil.post((String)this.geminiSendUrl, (String)geminiSendAtomBoStr);
        log.info("HTTP\u8c03\u7528\u901a\u77e5\u4e2d\u5fc3-\u51fa\u53c2\uff1a{}", (Object)geminiSendAtomRspBoStr);
        GeminiSendAtomRspBo geminiSendAtomRspBo = (GeminiSendAtomRspBo)((Object)JUtil.jss((String)geminiSendAtomRspBoStr, GeminiSendAtomRspBo.class));
        if (!"0000".equals(geminiSendAtomRspBo.getRespCode())) {
            throw new ZTBusinessException("\u8c03\u7528\u901a\u77e5\u4e2d\u5fc3\u5f02\u5e38\uff0c\u5f02\u5e38\u7f16\u7801\u3010" + geminiSendAtomRspBo.getRespCode() + "\u3011," + geminiSendAtomRspBo.getRespDesc());
        }
    }

    private UmcSendTodoRspBo sendTodo(ContractSendTodoOrMessageAtoOrmReqBo reqBo, String itemUrl, List<AuthByRoleAndOrgQryUserInfoBo> userInfoBos, String[] itemCodes) {
        log.info("\u53d1\u9001\u5f85\u529e\u5165\u53c211111\uff1a{}", (Object)JSON.toJSONString((Object)((Object)reqBo)));
        log.info("\u53d1\u9001\u5f85\u529e\u5165\u53c222222\uff1a{}", (Object)JSON.toJSONString(userInfoBos));
        log.info("\u53d1\u9001\u5f85\u529e\u5165\u53c233333\uff1a{}", (Object)JSON.toJSONString((Object)itemCodes));
        UmcSendTodoReqBo umcSendTodoReqBo = new UmcSendTodoReqBo();
        ArrayList<UmcTodoBo> umcTodoBos = new ArrayList<UmcTodoBo>(userInfoBos.size());
        for (AuthByRoleAndOrgQryUserInfoBo userInfoBo : userInfoBos) {
            for (String itemCode : itemCodes) {
                UmcTodoBo umcTodoBo = new UmcTodoBo();
                umcTodoBo.setBusiId(reqBo.getBusiId());
                umcTodoBo.setTodoItemCode(itemCode);
                umcTodoBo.setCreateOperId(String.valueOf(reqBo.getUserId()));
                umcTodoBo.setCreateOperName(reqBo.getUsername());
                umcTodoBo.setCandidateOperId(userInfoBo.getUserId().toString());
                umcTodoBo.setCandidateOperName(userInfoBo.getLoginName());
                umcTodoBo.setTodoName(reqBo.getTodoName());
                umcTodoBo.setTodoUrl(reqBo.getTodoUrl());
                umcTodoBo.setSendType(reqBo.getSendType());
                umcTodoBos.add(umcTodoBo);
            }
        }
        log.info("\u7ec4\u88c5\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)itemCodes));
        umcSendTodoReqBo.setTodoList(umcTodoBos);
        umcSendTodoReqBo.setBatchNumber(reqBo.getBatchNumber());
        log.info("\u53d1\u9001\u5f85\u529e\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)umcSendTodoReqBo));
        UmcSendTodoRspBo umcSendTodoRspBo = this.umcSendTodoService.sendTodo(umcSendTodoReqBo);
        log.info("\u53d1\u9001\u5f85\u529e\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)umcSendTodoRspBo));
        if (!"0000".equals(umcSendTodoRspBo.getRespCode())) {
            throw new ZTBusinessException("\u5904\u7406\u5df2\u529eRPC\u8c03\u7528\u53d1\u9001\u5f85\u529e\u5f02\u5e38" + umcSendTodoRspBo.getRespDesc());
        }
        return umcSendTodoRspBo;
    }

    private List<AuthByRoleAndOrgQryUserInfoBo> qryUser(List<UmcWaitDoneConfigBO> umcWaitDoneConfigBOS) {
        AuthGetUserByRoleAndOrgReqBo authGetUserByRoleAndOrgReqBo = new AuthGetUserByRoleAndOrgReqBo();
        ArrayList<String> roles = new ArrayList<String>(umcWaitDoneConfigBOS.size());
        for (UmcWaitDoneConfigBO umcWaitDoneConfigBO : umcWaitDoneConfigBOS) {
            roles.add(umcWaitDoneConfigBO.getRole());
        }
        authGetUserByRoleAndOrgReqBo.setRoleCodes(roles);
        log.info("\u67e5\u8be2\u6743\u9650\u5ba2\u6237\u4fe1\u606f\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)authGetUserByRoleAndOrgReqBo));
        AuthGetUserByRoleAndOrgRspBo userByRoleAndOrg = this.authGetUserByRoleAndOrgService.getUserByRoleAndOrg(authGetUserByRoleAndOrgReqBo);
        log.info("\u67e5\u8be2\u6743\u9650\u5ba2\u6237\u4fe1\u606f\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)userByRoleAndOrg));
        if (userByRoleAndOrg == null || CollectionUtils.isEmpty((Collection)userByRoleAndOrg.getRows())) {
            throw new ZTBusinessException("\u67e5\u8be2\u6743\u9650\u5ba2\u6237\u4fe1\u606f\u6ca1\u6709\u8fd4\u56de\u503c\uff01");
        }
        if (!"0000".equals(userByRoleAndOrg.getRespCode())) {
            throw new ZTBusinessException("\u67e5\u8be2\u6743\u9650\u5ba2\u6237\u4fe1\u606f\u5f02\u5e38\uff1a" + userByRoleAndOrg.getRespDesc());
        }
        return userByRoleAndOrg.getRows();
    }

    private List<UmcWaitDoneConfigBO> qryWaitDoneConf(String[] itemCodes) {
        UmcQryWaitDoneConfigListReqBO umcQryWaitDoneConfigListReqBO = new UmcQryWaitDoneConfigListReqBO();
        umcQryWaitDoneConfigListReqBO.setCenter("contract");
        umcQryWaitDoneConfigListReqBO.setPageSize(Integer.valueOf(-1));
        log.info("\u67e5\u8be2\u4f1a\u5458\u5f85\u529e\u914d\u7f6e\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)umcQryWaitDoneConfigListReqBO));
        UmcQryWaitDoneConfigListRspBO umcQryWaitDoneConfigListRspBO = this.umcQryWaitDoneConfigListService.qryWaitDoneList(umcQryWaitDoneConfigListReqBO);
        log.info("\u67e5\u8be2\u4f1a\u5458\u5f85\u529e\u914d\u7f6e\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)umcQryWaitDoneConfigListRspBO));
        if (umcQryWaitDoneConfigListRspBO == null) {
            throw new ZTBusinessException("\u5408\u540c\u4e2d\u5fc3\u8c03\u7528\u4f1a\u5458\u67e5\u8be2\u5f85\u529e\u914d\u7f6e\u6ca1\u6709\u8fd4\u56de\u503c\uff01");
        }
        if (!"0000".equals(umcQryWaitDoneConfigListRspBO.getRespCode())) {
            throw new ZTBusinessException("\u5408\u540c\u4e2d\u5fc3\u8c03\u7528\u4f1a\u5458\u67e5\u8be2\u5f85\u529e\u914d\u7f6e\u5f02\u5e38\uff1a" + umcQryWaitDoneConfigListRspBO.getRespDesc());
        }
        List<UmcWaitDoneConfigBO> umcWaitDoneConfigBOS = umcQryWaitDoneConfigListRspBO.getRows().stream().filter(v -> {
            for (String itemCode : itemCodes) {
                if (!itemCode.equals(v.getItemCode())) continue;
                return true;
            }
            return false;
        }).collect(Collectors.toList());
        StringBuilder codes = new StringBuilder();
        for (String itemCode : itemCodes) {
            codes.append(itemCode);
        }
        if (CollectionUtils.isEmpty(umcWaitDoneConfigBOS)) {
            throw new ZTBusinessException("\u5408\u540c\u4e2d\u5fc3\u8c03\u7528\u4f1a\u5458\u4e2d\u5fc3\u67e5\u8be2\u5f85\u529e\u914d\u7f6e\u6ca1\u6709\u8fd4\u56de [itemCode=" + codes + "] \u5bf9\u5e94\u7684\u503c");
        }
        return umcWaitDoneConfigBOS;
    }
}

