/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.busi.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.ohaotian.plugin.common.util.MoneyUtils;
import com.ohaotian.plugin.db.Page;
import com.tydic.contract.ability.bo.ContractListBO;
import com.tydic.contract.busi.ContractAcceptanceQryListBusiService;
import com.tydic.contract.busi.bo.ContractAcceptanceQryListBusiReqBO;
import com.tydic.contract.busi.bo.ContractAcceptanceQryListBusiRspBO;
import com.tydic.contract.dao.CContractLawInfoMapper;
import com.tydic.contract.dao.CContractPayPlanMapper;
import com.tydic.contract.dao.ContractMapper;
import com.tydic.contract.dao.ContractTaskInstMapper;
import com.tydic.contract.po.CContractLawInfoPO;
import com.tydic.contract.po.ContractPo;
import com.tydic.contract.po.ContractTaskInstPO;
import com.tydic.contract.po.OrderContractPo;
import com.tydic.contract.utils.ContractTransFieldUtil;
import com.tydic.contract.utils.DateTimeUtils;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ContractAcceptanceQryListBusiServiceImpl
implements ContractAcceptanceQryListBusiService {
    private static final Logger log = LoggerFactory.getLogger(ContractAcceptanceQryListBusiServiceImpl.class);
    @Autowired
    private ContractMapper contractMapper;
    @Autowired
    private CContractPayPlanMapper contractPayPlanMapper;
    @Autowired
    private ContractTaskInstMapper contractTaskInstMapper;
    @Autowired
    private CContractLawInfoMapper cContractLawInfoMapper;

    @Override
    public ContractAcceptanceQryListBusiRspBO qryAcceptanceList(ContractAcceptanceQryListBusiReqBO reqBO) {
        ContractAcceptanceQryListBusiRspBO rspBO = new ContractAcceptanceQryListBusiRspBO();
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        Object contractAndPayPlanBOS = null;
        return rspBO;
    }

    private List<ContractListBO> transAgrAndEnterContractResult(List<ContractPo> list, Long userId) {
        ArrayList<ContractListBO> rows = new ArrayList<ContractListBO>();
        ContractTaskInstPO contractTaskInstPO = new ContractTaskInstPO();
        for (ContractPo contractPo : list) {
            ContractListBO contractListBO = (ContractListBO)JSON.parseObject((String)JSON.toJSONString((Object)contractPo), ContractListBO.class);
            contractListBO.setContractSignDate(DateTimeUtils.Time2Date(contractListBO.getContractSignDate()));
            contractListBO.setNeedArriveTime(DateTimeUtils.Time2Date(contractListBO.getNeedArriveTime()));
            contractListBO.setContractEndDate(DateTimeUtils.Time2Date(contractListBO.getContractEndDate()));
            if (contractListBO.getContractStatus() != null) {
                contractListBO.setContractStatusStr(ContractTransFieldUtil.transContractStatus(contractListBO.getContractStatus()));
                contractListBO.setStatus(contractListBO.getContractStatus());
                contractListBO.setStatusStr(ContractTransFieldUtil.transContractStatus(contractListBO.getContractStatus()));
            }
            if (contractListBO.getContractType() != null) {
                contractListBO.setContractTypeStr(ContractTransFieldUtil.transZSCMContractType(contractListBO.getContractType()));
            }
            if (contractListBO.getPayType() != null) {
                contractListBO.setPayTypeStr(ContractTransFieldUtil.transPayType(contractListBO.getPayType()));
            }
            if (contractListBO.getExpectSettle() != null) {
                contractListBO.setExpectSettleStr(ContractTransFieldUtil.transExpectSettle(contractListBO.getExpectSettle()));
            }
            if (contractListBO.getSsBusiWay() != null) {
                contractListBO.setSsBusiWayStr(ContractTransFieldUtil.transSsBusiWay(contractListBO.getSsBusiWay()));
            }
            if (contractListBO.getOrgType() != null) {
                contractListBO.setOrgTypeStr(ContractTransFieldUtil.transContractOrgType(contractListBO.getOrgType()));
            }
            try {
                contractListBO.setContractAmountMoney(MoneyUtils.Long2BigDecimal((Long)contractListBO.getContractAmount()));
            }
            catch (Exception e) {
                log.error("\u91d1\u94b1\u8f6c\u6362\u51fa\u9519\uff1a" + e.getMessage());
            }
            contractTaskInstPO.setContractId(contractListBO.getContractId());
            contractTaskInstPO.setFinishTag(0);
            contractTaskInstPO.setUserId(userId);
            List<ContractTaskInstPO> contractTaskInstPOS = this.contractTaskInstMapper.qryTaskInstList(contractTaskInstPO);
            if (ObjectUtil.isNotEmpty(contractTaskInstPOS)) {
                contractListBO.setTaskId(contractTaskInstPOS.get(0).getTaskInstId());
                contractListBO.setTaskSignTag(contractTaskInstPOS.get(0).getTaskSignTag());
                contractListBO.setProcInstId(contractTaskInstPOS.get(0).getProcInstId());
            } else {
                contractTaskInstPO.setFinishTag(1);
                contractTaskInstPOS = this.contractTaskInstMapper.qryTaskInstList(contractTaskInstPO);
                contractListBO.setProcInstId(ObjectUtil.isNotEmpty(contractTaskInstPOS) ? contractTaskInstPOS.get(0).getProcInstId() : null);
            }
            contractListBO.setPartyA(contractPo.getPartyA1Name());
            contractListBO.setPartyB(contractPo.getPartyBName());
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            contractListBO.setContractSignDate(ObjectUtil.isNotEmpty((Object)contractPo.getContractSignDate()) ? dateFormat.format(contractPo.getContractSignDate()) : "-");
            contractListBO.setContractEndDate(ObjectUtil.isNotEmpty((Object)contractPo.getContractEndDate()) ? dateFormat.format(contractPo.getContractEndDate()) : "-");
            contractListBO.setContractStartDate(ObjectUtil.isNotEmpty((Object)contractPo.getContractStartDate()) ? dateFormat.format(contractPo.getContractStartDate()) : "-");
            CContractLawInfoPO cContractLawInfoPO = new CContractLawInfoPO();
            cContractLawInfoPO.setRelateId(contractPo.getContractId());
            CContractLawInfoPO modelBy = this.cContractLawInfoMapper.getModelBy(cContractLawInfoPO);
            if (ObjectUtil.isNotEmpty((Object)modelBy)) {
                contractListBO.setTotalAmount(modelBy.getContractTotalAmount());
            }
            contractListBO.setContractPerformWay(contractPo.getContractPerformanceMode());
            if (contractPo.getContractPerformanceMode() != null) {
                contractListBO.setContractPerformWayStr(ContractTransFieldUtil.transContractPerformanceMode(contractPo.getContractPerformanceMode()));
            }
            rows.add(contractListBO);
        }
        return rows;
    }

    private List<ContractListBO> transOrderContractResult(List<OrderContractPo> list, Long userId) {
        String resultJsonStr = JSON.toJSONString(list);
        List rows = JSONArray.parseArray((String)resultJsonStr).toJavaList(ContractListBO.class);
        ContractTaskInstPO contractTaskInstPO = new ContractTaskInstPO();
        for (ContractListBO contractListBO : rows) {
            List<ContractTaskInstPO> contractTaskInstPOS;
            contractListBO.setContractSignDate(DateTimeUtils.Time2Date(contractListBO.getContractSignDate()));
            contractListBO.setNeedArriveTime(DateTimeUtils.Time2Date(contractListBO.getNeedArriveTime()));
            contractListBO.setContractEndDate(DateTimeUtils.Time2Date(contractListBO.getContractEndDate()));
            if (contractListBO.getContractStatus() != null) {
                contractListBO.setContractStatusStr(ContractTransFieldUtil.transContractStatus(contractListBO.getContractStatus()));
            }
            if (contractListBO.getOrderSource() != null) {
                contractListBO.setOrderSourceStr(ContractTransFieldUtil.transOrderSource(contractListBO.getOrderSource()));
            }
            if (contractListBO.getPayType() != null) {
                contractListBO.setPayTypeStr(ContractTransFieldUtil.transPayType(contractListBO.getPayType()));
            }
            if (contractListBO.getExpectSettle() != null) {
                contractListBO.setExpectSettleStr(ContractTransFieldUtil.transExpectSettle(contractListBO.getExpectSettle()));
            }
            if (contractListBO.getContractType() != null) {
                contractListBO.setContractTypeStr(ContractTransFieldUtil.transContractType(contractListBO.getContractType()));
            }
            if (contractListBO.getSupplierType() != null) {
                contractListBO.setSupplierTypeStr(ContractTransFieldUtil.transSupplierType(contractListBO.getSupplierType()));
            }
            if (contractListBO.getOrgType() != null) {
                contractListBO.setOrgTypeStr(ContractTransFieldUtil.transContractOrgType(contractListBO.getOrgType()));
            }
            try {
                contractListBO.setContractAmountMoney(MoneyUtils.Long2BigDecimal((Long)contractListBO.getContractAmount()));
            }
            catch (Exception e) {
                log.error("\u91d1\u94b1\u8f6c\u6362\u51fa\u9519\uff1a" + e.getMessage());
            }
            contractTaskInstPO.setContractId(contractListBO.getContractId());
            contractTaskInstPO.setFinishTag(0);
            if (userId != 1L) {
                contractTaskInstPO.setUserId(userId);
            }
            if (ObjectUtil.isNotEmpty(contractTaskInstPOS = this.contractTaskInstMapper.qryTaskInstList(contractTaskInstPO))) {
                contractListBO.setTaskId(contractTaskInstPOS.get(0).getTaskInstId());
                contractListBO.setTaskSignTag(contractTaskInstPOS.get(0).getTaskSignTag());
                contractListBO.setProcInstId(contractTaskInstPOS.get(0).getProcInstId());
            }
            if (!ObjectUtil.isEmpty((Object)contractListBO.getProcInstId())) continue;
            contractTaskInstPO.setFinishTag(null);
            contractTaskInstPOS = this.contractTaskInstMapper.qryTaskInstList(contractTaskInstPO);
            if (ObjectUtil.isEmpty(contractTaskInstPOS)) continue;
            contractListBO.setProcInstId(contractTaskInstPOS.get(0).getProcInstId());
        }
        return rows;
    }
}

