/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.busi.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.contract.ability.bo.ContractCooperationCategoryBO;
import com.tydic.contract.atom.ContractCreateApproveAtomService;
import com.tydic.contract.atom.ContractRecordContractNodeOperLogAtomService;
import com.tydic.contract.atom.bo.ContractCreateApproveAtomServiceReqBO;
import com.tydic.contract.atom.bo.ContractCreateApproveAtomServiceRspBO;
import com.tydic.contract.atom.bo.ContractRecordContractNodeOperLogAtomReqBO;
import com.tydic.contract.atom.bo.ContractStartApprovalProcessAtomReqBO;
import com.tydic.contract.busi.ContractAddBusiService;
import com.tydic.contract.busi.bo.ContractAddBusiReqBO;
import com.tydic.contract.busi.bo.ContractAddBusiRspBO;
import com.tydic.contract.constant.ContractConstant;
import com.tydic.contract.dao.CContractCooperationCategoryMapper;
import com.tydic.contract.dao.CContractCooperationInfoMapper;
import com.tydic.contract.dao.CContractLawInfoMapper;
import com.tydic.contract.dao.CContractPayPlanMapper;
import com.tydic.contract.dao.ContractAccessoryMapper;
import com.tydic.contract.dao.ContractItemMapper;
import com.tydic.contract.dao.ContractLadderRateMapper;
import com.tydic.contract.dao.ContractMapper;
import com.tydic.contract.dao.ContractOrderMapper;
import com.tydic.contract.dao.ContractPayTypeMapper;
import com.tydic.contract.dao.ContractSaleCategoryRateMapper;
import com.tydic.contract.po.CContractCooperationCategoryPO;
import com.tydic.contract.po.CContractCooperationInfoPO;
import com.tydic.contract.po.CContractLawInfoPO;
import com.tydic.contract.po.CContractPayPlanPO;
import com.tydic.contract.po.ContractAccessoryPo;
import com.tydic.contract.po.ContractItemPo;
import com.tydic.contract.po.ContractLadderRatePo;
import com.tydic.contract.po.ContractOrderPo;
import com.tydic.contract.po.ContractPayTypePo;
import com.tydic.contract.po.ContractPo;
import com.tydic.contract.po.ContractSaleCategoryRatePo;
import com.tydic.contract.utils.ContractTransFieldUtil;
import com.tydic.contract.utils.DateTimeUtils;
import com.tydic.dyc.umc.service.enterprise.UmcQryEnterpriseInfoService;
import com.tydic.dyc.umc.service.enterprise.bo.UmcQryEnterpriseInfoDetailReqBo;
import com.tydic.dyc.umc.service.enterprise.bo.UmcQryEnterpriseInfoDetailRspBo;
import com.tydic.ppc.busi.api.CalibrationItemUpdateContractInfoBusiService;
import com.tydic.ppc.busi.bo.CalibrationItemUpdateContractInfoBusiReqBO;
import com.tydic.ppc.busi.bo.CalibrationItemUpdateContractInfoBusiRspBO;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
public class ContractAddBusiServiceImpl
implements ContractAddBusiService {
    private static final Logger log = LoggerFactory.getLogger(ContractAddBusiServiceImpl.class);
    @Autowired
    private ContractMapper contractMapper;
    @Autowired
    private ContractOrderMapper contractOrderMapper;
    @Autowired
    private ContractAccessoryMapper contractAccessoryMapper;
    @Autowired
    private ContractPayTypeMapper contractPayTypeMapper;
    @Autowired
    private ContractItemMapper contractItemMapper;
    @Autowired
    private ContractSaleCategoryRateMapper contractSaleCategoryRateMapper;
    @Autowired
    private ContractLadderRateMapper contractLadderRateMapper;
    @Autowired
    private ContractRecordContractNodeOperLogAtomService contractRecordContractNodeOperLogAtomService;
    @Autowired
    private ContractCreateApproveAtomService contractCreateApproveAtomService;
    @Autowired
    private UmcQryEnterpriseInfoService umcQryEnterpriseInfoService;
    @Autowired
    private CContractCooperationInfoMapper contractCooperationInfoMapper;
    @Autowired
    private CContractCooperationCategoryMapper contractCooperationCategoryMapper;
    @Autowired
    private CContractLawInfoMapper contractLawInfoMapper;
    @Autowired
    private CContractPayPlanMapper contractPayPlanMapper;
    @Autowired
    private CalibrationItemUpdateContractInfoBusiService calibrationItemUpdateContractInfoBusiService;
    public static final String FIELD_CONTRACT_ID = "contractId";
    public static final String FIELD_CONTRACT_CODE = "contractCode";
    public static final String FIELD_CONTRACT_TYPE = "contractType";
    public static final String PROCESS = "contract_create";

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public ContractAddBusiRspBO addContract(ContractAddBusiReqBO reqBO) {
        ContractAddBusiRspBO rspBO = new ContractAddBusiRspBO();
        if ("0".equals(reqBO.getOperType())) {
            ContractPo contractPo = new ContractPo();
            if (reqBO.getPurchaseDemandPlanId() == null && reqBO.getContractBaseInfo().getFeeType().equals(ContractConstant.FeeType.PAY_CONTRACT_CODE)) {
                rspBO.setRespCode("1007");
                rspBO.setRespDesc("\u91c7\u8d2d\u65b9\u6848\u4e0d\u80fd\u4e3a\u7a7a,\u8bf7\u9009\u62e9\u91c7\u8d2d\u65b9\u6848\uff01");
                return rspBO;
            }
            if (Objects.equals(ContractConstant.FeeType.PAY_CONTRACT_CODE, reqBO.getContractBaseInfo().getFeeType())) {
                if (ContractConstant.ZYCMContractType.UNIT_AGREE_CONTRACT_TYPE.equals(reqBO.getContractBaseInfo().getContractType())) {
                    Map<String, Object> resultMap = this.addUnitAgreeContract(reqBO);
                    Long contractId = (Long)resultMap.get(FIELD_CONTRACT_ID);
                    this.updateCalibrationInfo(reqBO, contractId);
                    rspBO.setRespCode("0000");
                    rspBO.setRespDesc("\u65b0\u589e\u5e73\u53f0\u4f9b\u5e94\u5546\u5e74\u5ea6\u5408\u4f5c\u534f\u8bae\u5408\u540c\uff08\u5b9e\u7269\u7c7b\uff09\u6210\u529f");
                    rspBO.setContractId((Long)resultMap.get(FIELD_CONTRACT_ID));
                    rspBO.setContractCode((String)resultMap.get(FIELD_CONTRACT_CODE));
                    return rspBO;
                }
                if (ContractConstant.ZYCMContractType.PLATFORM_AGREE_CONTRACT_TYPE.equals(reqBO.getContractBaseInfo().getContractType())) {
                    Map<String, Object> resultMap = this.addUnitAgreeContract(reqBO);
                    Long contractId = (Long)resultMap.get(FIELD_CONTRACT_ID);
                    this.updateCalibrationInfo(reqBO, contractId);
                    rspBO.setRespCode("0000");
                    rspBO.setRespDesc("\u65b0\u589e\u5e73\u53f0\u4f9b\u5e94\u5546\u5e74\u5ea6\u5408\u4f5c\u534f\u8bae\u5408\u540c\uff08\u670d\u52a1\u7c7b\uff09\u6210\u529f");
                    rspBO.setContractId((Long)resultMap.get(FIELD_CONTRACT_ID));
                    rspBO.setContractCode((String)resultMap.get(FIELD_CONTRACT_CODE));
                    return rspBO;
                }
                if (ContractConstant.ZYCMContractType.ORDER_CONTRACT_TYPE.equals(reqBO.getContractBaseInfo().getContractType())) {
                    Map<String, Object> resultMap = this.addUnitAgreeContract(reqBO);
                    Long contractId = (Long)resultMap.get(FIELD_CONTRACT_ID);
                    this.updateCalibrationInfo(reqBO, contractId);
                    rspBO.setRespCode("0000");
                    rspBO.setRespDesc("\u65b0\u589e\u5355\u6b21\u91c7\u8d2d\u5408\u540c\uff08\u5b9e\u7269\u7c7b\uff09\u6210\u529f");
                    rspBO.setContractId((Long)resultMap.get(FIELD_CONTRACT_ID));
                    rspBO.setContractCode((String)resultMap.get(FIELD_CONTRACT_CODE));
                    return rspBO;
                }
                if (ContractConstant.ZYCMContractType.ORDER_CONTRACT_SERVICE_TYPE.equals(reqBO.getContractBaseInfo().getContractType())) {
                    Map<String, Object> resultMap = this.addUnitAgreeContract(reqBO);
                    Long contractId = (Long)resultMap.get(FIELD_CONTRACT_ID);
                    this.updateCalibrationInfo(reqBO, contractId);
                    rspBO.setRespCode("0000");
                    rspBO.setRespDesc("\u65b0\u589e\u5355\u6b21\u91c7\u8d2d\u5408\u540c\uff08\u670d\u52a1\u7c7b\uff09\u6210\u529f");
                    rspBO.setContractId((Long)resultMap.get(FIELD_CONTRACT_ID));
                    rspBO.setContractCode((String)resultMap.get(FIELD_CONTRACT_CODE));
                    return rspBO;
                }
                if (ContractConstant.ZYCMContractType.NON_STANDARD_CONTRACT_TYPE.equals(reqBO.getContractBaseInfo().getContractType())) {
                    Map<String, Object> resultMap = this.addUnitAgreeContract(reqBO);
                    Long contractId = (Long)resultMap.get(FIELD_CONTRACT_ID);
                    this.updateCalibrationInfo(reqBO, contractId);
                    rspBO.setRespCode("0000");
                    rspBO.setRespDesc("\u65b0\u589e\u975e\u6807\u51c6\u5408\u540c\u6210\u529f");
                    rspBO.setContractId((Long)resultMap.get(FIELD_CONTRACT_ID));
                    rspBO.setContractCode((String)resultMap.get(FIELD_CONTRACT_CODE));
                    return rspBO;
                }
                rspBO.setRespCode("1007");
                rspBO.setRespDesc("\u6682\u4e0d\u652f\u6301\u7684\u5408\u540c\u7c7b\u578b");
                return rspBO;
            }
            if (!Objects.equals(ContractConstant.FeeType.INCOME_CONTRACT_CODE, reqBO.getContractBaseInfo().getFeeType())) {
                rspBO.setRespCode("1007");
                rspBO.setRespDesc("\u6682\u4e0d\u652f\u6301\u7684\u8d39\u7528\u7c7b\u578b");
                return rspBO;
            }
            Map<String, Object> resultMap = this.addUnitAgreeContract(reqBO);
            if (ContractConstant.ZYCMIncomeContractType.PURCAHSE_AGREE_CONTRACT_TYPE.equals(reqBO.getContractBaseInfo().getIncomeContractType())) {
                rspBO.setRespCode("0000");
                rspBO.setRespDesc("\u65b0\u589e\u91c7\u8d2d\u670d\u52a1\u534f\u8bae\u6a21\u677f\uff08\u5916\u90e8\u5ba2\u6237\u4f01\u4e1a\uff09\u6210\u529f");
                rspBO.setContractId((Long)resultMap.get(FIELD_CONTRACT_ID));
                rspBO.setContractCode((String)resultMap.get(FIELD_CONTRACT_CODE));
                return rspBO;
            }
            if (ContractConstant.ZYCMIncomeContractType.WELFARE_CONTRACT_TEMPLATE.equals(reqBO.getContractBaseInfo().getIncomeContractType())) {
                rspBO.setRespCode("0000");
                rspBO.setRespDesc("\u65b0\u589e\u798f\u888b\u8d2d\u9500\u5408\u540c\u6a21\u677f\u6210\u529f");
                rspBO.setContractId((Long)resultMap.get(FIELD_CONTRACT_ID));
                rspBO.setContractCode((String)resultMap.get(FIELD_CONTRACT_CODE));
                return rspBO;
            }
            if (ContractConstant.ZYCMIncomeContractType.SERVICE_AGREE_TYPE.equals(reqBO.getContractBaseInfo().getIncomeContractType())) {
                rspBO.setRespCode("0000");
                rspBO.setRespDesc("\u65b0\u589e\u62db\u5546\u5230\u5bb6\u6c47\u4e92\u8054\u7f51\u5e73\u53f0\u7279\u7ea6\u5546\u6237\u670d\u52a1\u534f\u8bae\u4e66\uff08\u5b9e\u7269\u7c7b\uff09\u6210\u529f");
                rspBO.setContractId((Long)resultMap.get(FIELD_CONTRACT_ID));
                rspBO.setContractCode((String)resultMap.get(FIELD_CONTRACT_CODE));
                return rspBO;
            }
            if (ContractConstant.ZYCMIncomeContractType.ELECTRICAL_CONTRACT_TEMPLATE.equals(reqBO.getContractBaseInfo().getIncomeContractType())) {
                rspBO.setRespCode("0000");
                rspBO.setRespDesc("\u65b0\u589e\u7535\u5668\u8d2d\u9500\u5408\u540c\u6a21\u677f\u6210\u529f");
                rspBO.setContractId((Long)resultMap.get(FIELD_CONTRACT_ID));
                rspBO.setContractCode((String)resultMap.get(FIELD_CONTRACT_CODE));
                return rspBO;
            }
            if (ContractConstant.ZYCMIncomeContractType.INCOME_NON_STANDARD_CONTRACT_TYPE.equals(reqBO.getContractBaseInfo().getIncomeContractType())) {
                rspBO.setRespCode("0000");
                rspBO.setRespDesc("\u65b0\u589e\u6536\u5165\u7c7b\u975e\u6807\u5408\u540c\u6210\u529f");
                rspBO.setContractId((Long)resultMap.get(FIELD_CONTRACT_ID));
                rspBO.setContractCode((String)resultMap.get(FIELD_CONTRACT_CODE));
                return rspBO;
            }
            rspBO.setRespCode("1007");
            rspBO.setRespDesc("\u6682\u4e0d\u652f\u6301\u7684\u5408\u540c\u7c7b\u578b");
            return rspBO;
        }
        if ("1".equals(reqBO.getOperType())) {
            this.saveUnitAgreeContract(reqBO);
            rspBO.setContractId(reqBO.getContractBaseInfo().getContractId());
            rspBO.setContractCode(reqBO.getContractBaseInfo().getContractCode());
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u4fdd\u5b58\u8ba2\u5355\u5408\u540c\u6210\u529f");
            return rspBO;
        }
        if (!"2".equals(reqBO.getOperType())) return rspBO;
        ContractAccessoryPo qryContractAccessoryPo = new ContractAccessoryPo();
        qryContractAccessoryPo.setRelateId(reqBO.getContractBaseInfo().getContractId());
        if (ObjectUtils.isEmpty((Object)reqBO.getWordUrl())) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u8bf7\u5148\u751f\u6210\u5408\u540c\u6587\u4ef6");
            return rspBO;
        }
        qryContractAccessoryPo.setAcceessoryUrl(reqBO.getWordUrl());
        List<ContractAccessoryPo> contractAccessoryPos = this.contractAccessoryMapper.qryByCondition(qryContractAccessoryPo);
        if (CollectionUtils.isEmpty(contractAccessoryPos)) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u8bf7\u5148\u751f\u6210\u5408\u540c\u6587\u4ef6");
            return rspBO;
        }
        ContractStartApprovalProcessAtomReqBO atomReqBO = new ContractStartApprovalProcessAtomReqBO();
        atomReqBO.setProcDefKey(PROCESS);
        ContractCreateApproveAtomServiceReqBO atomServiceReqBo = new ContractCreateApproveAtomServiceReqBO();
        UmcQryEnterpriseInfoDetailReqBo umcQryEnterpriseInfoDetailReqBo = new UmcQryEnterpriseInfoDetailReqBo();
        umcQryEnterpriseInfoDetailReqBo.setOrgId(Long.valueOf(Long.parseLong(reqBO.getContractBaseInfo().getPartyBCode())));
        if (Objects.equals(reqBO.getContractBaseInfo().getFeeType(), ContractConstant.FeeType.INCOME_CONTRACT_CODE) && !Objects.equals(reqBO.getContractBaseInfo().getIncomeContractType(), ContractConstant.ZYCMIncomeContractType.SERVICE_AGREE_TYPE)) {
            umcQryEnterpriseInfoDetailReqBo.setOrgId(Long.valueOf(Long.parseLong(reqBO.getContractBaseInfo().getPartyA1Code())));
        }
        UmcQryEnterpriseInfoDetailRspBo umcQryEnterpriseInfoDetailRspBo = this.umcQryEnterpriseInfoService.qryEnterpriseInfo(umcQryEnterpriseInfoDetailReqBo);
        String presenterId = umcQryEnterpriseInfoDetailRspBo.getPresenterId();
        String presenterName = umcQryEnterpriseInfoDetailRspBo.getPresenterName();
        atomServiceReqBo.setPresenterId(presenterId);
        atomServiceReqBo.setPresenterName(presenterName);
        atomServiceReqBo.setUserId(reqBO.getUserId());
        atomServiceReqBo.setUsername(reqBO.getUserName());
        atomServiceReqBo.setOrgId(reqBO.getOrgId());
        atomServiceReqBo.setOrgName(reqBO.getOrgName());
        atomServiceReqBo.setCompanyId(reqBO.getCompanyId());
        atomServiceReqBo.setCompanyName(reqBO.getCompanyName());
        atomServiceReqBo.setContractId(reqBO.getContractBaseInfo().getContractId());
        atomServiceReqBo.setObjId(reqBO.getContractBaseInfo().getContractId());
        atomServiceReqBo.setObjType(ContractConstant.OBJ_TYPE.ADD_CONTRACT);
        atomServiceReqBo.setObjBusiType(ContractConstant.OBJ_TYPE.ADD_CONTRACT);
        atomServiceReqBo.setProcDefKey(PROCESS);
        atomServiceReqBo.setContractType(reqBO.getContractBaseInfo().getContractType());
        atomServiceReqBo.setNeedUnsignTab(reqBO.getNeedUnsignTab());
        ContractCreateApproveAtomServiceRspBO atomRspBO = this.contractCreateApproveAtomService.createApprove(atomServiceReqBo);
        log.info("\u8c03\u7528\u5ba1\u6279\u53d1\u8d77\u670d\u52a1\u51fa\u53c2:{}", (Object)JSON.toJSONString((Object)((Object)atomRspBO)));
        if (!atomRspBO.getRespCode().equals("0000")) {
            throw new ZTBusinessException(atomRspBO.getRespDesc());
        }
        this.saveUnitAgreeContract(reqBO);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u63d0\u4ea4\u8ba2\u5355\u5408\u540c\u6210\u529f");
        return rspBO;
    }

    private void updateCalibrationInfo(ContractAddBusiReqBO reqBO, Long contractId) {
        CalibrationItemUpdateContractInfoBusiReqBO calibrationItemUpdateContractInfoBusiReqBO = new CalibrationItemUpdateContractInfoBusiReqBO();
        calibrationItemUpdateContractInfoBusiReqBO.setOperationType(Integer.valueOf(1));
        calibrationItemUpdateContractInfoBusiReqBO.setContractId(contractId);
        calibrationItemUpdateContractInfoBusiReqBO.setContractCode(reqBO.getContractBaseInfo().getContractCode());
        calibrationItemUpdateContractInfoBusiReqBO.setCalibrationItemId(reqBO.getCalibrationItemId());
        CalibrationItemUpdateContractInfoBusiRspBO calibrationItemUpdateContractInfoBusiRspBO = this.calibrationItemUpdateContractInfoBusiService.updateContractInfo(calibrationItemUpdateContractInfoBusiReqBO);
        if (!Objects.equals("0000", calibrationItemUpdateContractInfoBusiRspBO.getRespCode())) {
            throw new ZTBusinessException("\u5408\u540c\u65b0\u589e\uff0c\u66f4\u65b0\u5408\u540c\u4fe1\u606f\u5230\u5b9a\u6807\u660e\u7ec6\u5931\u8d25");
        }
    }

    private void updatePurchaseDemandPlan(ContractAddBusiReqBO reqBO) {
        if (reqBO.getPurchaseDemandPlanId() == null) {
            throw new ZTBusinessException("\u91c7\u8d2d\u9700\u6c42\u8ba1\u5212id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.contractMapper.updatePurchasePlanIsCreateContract(reqBO.getPurchaseDemandPlanId(), 1);
    }

    private void saveUnitAgreeContract(ContractAddBusiReqBO reqBO) {
        this.saveContractInfo(reqBO);
        this.updateContractAccessoryInfo(reqBO);
        this.updateContractLawInfo(reqBO);
        this.updateContractCooperationInfo(reqBO);
    }

    private void updateContractPayPlanInfo(ContractAddBusiReqBO reqBO) {
        if (CollectionUtils.isEmpty(reqBO.getPayPlanList())) {
            return;
        }
        CContractPayPlanPO cContractPayPlanPO = new CContractPayPlanPO();
        cContractPayPlanPO.setRelateId(reqBO.getContractBaseInfo().getContractId());
        this.contractPayPlanMapper.deleteBy(cContractPayPlanPO);
        this.addContractPayPlanInfo(reqBO.getContractBaseInfo().getContractId(), reqBO);
    }

    private void updateContractCooperationInfo(ContractAddBusiReqBO reqBO) {
        if (ObjectUtil.isEmpty((Object)reqBO.getContractCooperationInfo())) {
            return;
        }
        CContractCooperationInfoPO contractCooperationInfoPo = new CContractCooperationInfoPO();
        contractCooperationInfoPo.setRelateId(reqBO.getContractBaseInfo().getContractId());
        CContractCooperationInfoPO oldCooperationInfoPo = this.contractCooperationInfoMapper.getModelBy(contractCooperationInfoPo);
        if (oldCooperationInfoPo != null) {
            CContractCooperationInfoPO updateCooperationInfoPo = new CContractCooperationInfoPO();
            BeanUtils.copyProperties((Object)oldCooperationInfoPo, (Object)updateCooperationInfoPo);
            BeanUtils.copyProperties((Object)reqBO.getContractCooperationInfo(), (Object)updateCooperationInfoPo);
            updateCooperationInfoPo.setServicePayRatio(reqBO.getContractCooperationInfo().getServicePayRatio());
            updateCooperationInfoPo.setUpdateUserId(reqBO.getUserId());
            updateCooperationInfoPo.setUpdateUserName(reqBO.getName());
            updateCooperationInfoPo.setUpdateTime(new Date());
            updateCooperationInfoPo.setTaxPointS(CollectionUtils.isEmpty((Collection)reqBO.getContractCooperationInfo().getTaxPointList()) ? "" : String.join((CharSequence)",", reqBO.getContractCooperationInfo().getTaxPointList()));
            CContractCooperationInfoPO whereCooperationInfoPo = new CContractCooperationInfoPO();
            whereCooperationInfoPo.setRelateId(reqBO.getContractBaseInfo().getContractId());
            int updateResult = this.contractCooperationInfoMapper.updateBy(updateCooperationInfoPo, whereCooperationInfoPo);
            if (updateResult <= 0) {
                throw new ZTBusinessException("\u66f4\u65b0\u5408\u540c\u5408\u4f5c\u65b9\u4fe1\u606f\u5931\u8d25");
            }
            if (!CollectionUtils.isEmpty((Collection)reqBO.getContractCooperationInfo().getCooperationCategoryList())) {
                CContractCooperationCategoryPO whereCooperationCategoryPo = new CContractCooperationCategoryPO();
                whereCooperationCategoryPo.setRelateId(reqBO.getContractBaseInfo().getContractId());
                this.contractCooperationCategoryMapper.deleteBy(whereCooperationCategoryPo);
                for (ContractCooperationCategoryBO cooperationCategoryBO : reqBO.getContractCooperationInfo().getCooperationCategoryList()) {
                    CContractCooperationCategoryPO cooperationCategoryPo = new CContractCooperationCategoryPO();
                    BeanUtils.copyProperties((Object)cooperationCategoryBO, (Object)cooperationCategoryPo);
                    cooperationCategoryPo.setCooperationCategoryId(Sequence.getInstance().nextId());
                    cooperationCategoryPo.setRelateId(reqBO.getContractBaseInfo().getContractId());
                    cooperationCategoryPo.setRelateCode(reqBO.getContractBaseInfo().getContractCode());
                    updateCooperationInfoPo.setServicePayRatio(reqBO.getContractCooperationInfo().getServicePayRatio());
                    cooperationCategoryPo.setCreateUserName(reqBO.getName());
                    cooperationCategoryPo.setCreateTime(new Date());
                    int cooperationCategoryResult = this.contractCooperationCategoryMapper.insert(cooperationCategoryPo);
                    if (cooperationCategoryResult >= 1) continue;
                    throw new ZTBusinessException("\u53cc\u65b9\u5408\u4f5c\u54c1\u7c7b\u65b0\u589e\u5931\u8d25");
                }
            }
        } else {
            this.addContractCooperationInfo(reqBO.getContractBaseInfo().getContractId(), reqBO);
        }
    }

    private void updateContractLawInfo(ContractAddBusiReqBO reqBO) {
        if (ObjectUtil.isEmpty((Object)reqBO.getContractLawInfo())) {
            return;
        }
        CContractLawInfoPO contractLawInfoPo = new CContractLawInfoPO();
        contractLawInfoPo.setRelateId(reqBO.getContractBaseInfo().getContractId());
        CContractLawInfoPO oldLawInfoPo = this.contractLawInfoMapper.getModelBy(contractLawInfoPo);
        if (oldLawInfoPo != null) {
            CContractLawInfoPO updateLawInfoPo = new CContractLawInfoPO();
            BeanUtils.copyProperties((Object)oldLawInfoPo, (Object)updateLawInfoPo);
            BeanUtils.copyProperties((Object)reqBO.getContractLawInfo(), (Object)updateLawInfoPo);
            updateLawInfoPo.setUpdateUserId(reqBO.getUserId());
            updateLawInfoPo.setUpdateUserName(reqBO.getName());
            updateLawInfoPo.setUpdateTime(new Date());
            CContractLawInfoPO whereLawInfoPo = new CContractLawInfoPO();
            whereLawInfoPo.setRelateId(reqBO.getContractBaseInfo().getContractId());
            whereLawInfoPo.setLawContractId(oldLawInfoPo.getLawContractId());
            int updateResult = this.contractLawInfoMapper.updateBy(updateLawInfoPo, whereLawInfoPo);
            if (updateResult != 1) {
                throw new ZTBusinessException("\u66f4\u65b0\u5408\u540c\u6570\u636e\u5931\u8d25");
            }
        } else {
            this.addContractLawInfo(reqBO.getContractBaseInfo().getContractId(), reqBO);
        }
    }

    private Map<String, Object> addUnitAgreeContract(ContractAddBusiReqBO reqBO) {
        Map<String, Object> addContractResultMap = this.addContractBaseInfo(reqBO);
        if (!CollectionUtils.isEmpty(reqBO.getAcceessoryList())) {
            this.addContractAccessoryInfo((Long)addContractResultMap.get(FIELD_CONTRACT_ID), reqBO);
        }
        if (!ObjectUtils.isEmpty((Object)reqBO.getContractLawInfo())) {
            this.addContractLawInfo((Long)addContractResultMap.get(FIELD_CONTRACT_ID), reqBO);
        }
        if (!ObjectUtils.isEmpty((Object)reqBO.getContractCooperationInfo())) {
            this.addContractCooperationInfo((Long)addContractResultMap.get(FIELD_CONTRACT_ID), reqBO);
        }
        this.recordContractNodeOperLog((Long)addContractResultMap.get(FIELD_CONTRACT_ID), reqBO.getUserId(), reqBO.getName());
        if (Objects.equals(ContractConstant.FeeType.PAY_CONTRACT_CODE, reqBO.getContractBaseInfo().getFeeType())) {
            this.updatePurchaseDemandPlan(reqBO);
        }
        return addContractResultMap;
    }

    private void addContractPayPlanInfo(Long aLong, ContractAddBusiReqBO reqBO) {
        String jsonStr = JSON.toJSONString(reqBO.getPayPlanList());
        List javaList = JSONArray.parseArray((String)jsonStr).toJavaList(CContractPayPlanPO.class);
        for (CContractPayPlanPO contractPayPlanPo : javaList) {
            contractPayPlanPo.setPayPlanId(Sequence.getInstance().nextId());
            contractPayPlanPo.setRelateId(aLong);
            contractPayPlanPo.setRelateCode(reqBO.getContractBaseInfo().getContractCode());
            contractPayPlanPo.setCreateUserName(reqBO.getName());
            contractPayPlanPo.setCreateTime(new Date());
            int result = this.contractPayPlanMapper.insert(contractPayPlanPo);
            if (result >= 1) continue;
            throw new ZTBusinessException("\u5408\u540c\u4ed8\u6b3e\u8ba1\u5212\u65b0\u589e\u5931\u8d25");
        }
    }

    private void addContractCooperationInfo(Long aLong, ContractAddBusiReqBO reqBO) {
        String jsonStr = JSON.toJSONString((Object)reqBO.getContractCooperationInfo());
        CContractCooperationInfoPO contractCooperationInfoPo = (CContractCooperationInfoPO)JSON.parseObject((String)jsonStr, CContractCooperationInfoPO.class);
        contractCooperationInfoPo.setCooperationContractId(Sequence.getInstance().nextId());
        contractCooperationInfoPo.setRelateId(aLong);
        contractCooperationInfoPo.setRelateCode(reqBO.getContractBaseInfo().getContractCode());
        contractCooperationInfoPo.setCreateUserName(reqBO.getName());
        contractCooperationInfoPo.setCreateTime(new Date());
        if (Objects.equals(reqBO.getContractBaseInfo().getContractType(), ContractConstant.ZYCMContractType.UNIT_AGREE_CONTRACT_TYPE)) {
            contractCooperationInfoPo.setTaxPointS(CollectionUtils.isEmpty((Collection)reqBO.getContractCooperationInfo().getTaxPointList()) ? "" : String.join((CharSequence)",", reqBO.getContractCooperationInfo().getTaxPointList()));
        } else if (Objects.equals(reqBO.getContractBaseInfo().getContractType(), ContractConstant.ZYCMContractType.PLATFORM_AGREE_CONTRACT_TYPE)) {
            contractCooperationInfoPo.setTaxPointS(CollectionUtils.isEmpty((Collection)reqBO.getContractCooperationInfo().getTaxPointList()) ? "" : String.join((CharSequence)",", reqBO.getContractCooperationInfo().getTaxPointList()));
        } else if (!Objects.equals(reqBO.getContractBaseInfo().getContractType(), ContractConstant.ZYCMContractType.ORDER_CONTRACT_TYPE) && !Objects.equals(reqBO.getContractBaseInfo().getContractType(), ContractConstant.ZYCMContractType.ORDER_CONTRACT_SERVICE_TYPE) && Objects.equals(reqBO.getContractBaseInfo().getContractType(), ContractConstant.ZYCMContractType.NON_STANDARD_CONTRACT_TYPE)) {
            contractCooperationInfoPo.setTaxPointS(CollectionUtils.isEmpty((Collection)reqBO.getContractCooperationInfo().getTaxPointList()) ? "" : String.join((CharSequence)",", reqBO.getContractCooperationInfo().getTaxPointList()));
        }
        int result = this.contractCooperationInfoMapper.insert(contractCooperationInfoPo);
        if (result < 1) {
            throw new ZTBusinessException("\u5408\u540c\u5408\u4f5c\u4fe1\u606f\u65b0\u589e\u5931\u8d25");
        }
        if (!CollectionUtils.isEmpty((Collection)reqBO.getContractCooperationInfo().getCooperationCategoryList())) {
            for (ContractCooperationCategoryBO cooperationCategoryBO : reqBO.getContractCooperationInfo().getCooperationCategoryList()) {
                CContractCooperationCategoryPO cooperationCategoryPo = new CContractCooperationCategoryPO();
                BeanUtils.copyProperties((Object)cooperationCategoryBO, (Object)cooperationCategoryPo);
                cooperationCategoryPo.setCooperationCategoryId(Sequence.getInstance().nextId());
                cooperationCategoryPo.setRelateId(aLong);
                cooperationCategoryPo.setRelateCode(reqBO.getContractBaseInfo().getContractCode());
                cooperationCategoryPo.setCreateUserName(reqBO.getName());
                cooperationCategoryPo.setCreateTime(new Date());
                int cooperationCategoryResult = this.contractCooperationCategoryMapper.insert(cooperationCategoryPo);
                if (cooperationCategoryResult >= 1) continue;
                throw new ZTBusinessException("\u53cc\u65b9\u5408\u4f5c\u54c1\u7c7b\u65b0\u589e\u5931\u8d25");
            }
        }
    }

    private void addContractLawInfo(Long aLong, ContractAddBusiReqBO reqBO) {
        String jsonStr = JSON.toJSONString((Object)reqBO.getContractLawInfo());
        CContractLawInfoPO contractLawInfoPo = (CContractLawInfoPO)JSON.parseObject((String)jsonStr, CContractLawInfoPO.class);
        contractLawInfoPo.setLawContractId(Sequence.getInstance().nextId());
        contractLawInfoPo.setRelateId(aLong);
        contractLawInfoPo.setRelateCode(reqBO.getContractBaseInfo().getContractCode());
        contractLawInfoPo.setCreateUserId(reqBO.getUserId());
        contractLawInfoPo.setCreateUserName(reqBO.getName());
        contractLawInfoPo.setCreateTime(new Date());
        int result = this.contractLawInfoMapper.insert(contractLawInfoPo);
        if (result < 1) {
            throw new ZTBusinessException("\u6cd5\u52a1\u7cfb\u7edf\u5408\u540c\u4fe1\u606f\u65b0\u589e\u5931\u8d25");
        }
    }

    private Map<String, Object> addContractBaseInfo(ContractAddBusiReqBO reqBO) {
        int addContractResult;
        ContractPo insertContractPo = new ContractPo();
        BeanUtils.copyProperties((Object)reqBO.getContractBaseInfo(), (Object)insertContractPo);
        insertContractPo.setContractId(Sequence.getInstance().nextId());
        insertContractPo.setPurchaseDemandPlanId(reqBO.getPurchaseDemandPlanId());
        insertContractPo.setCreateUserId(reqBO.getUserId());
        insertContractPo.setCreateUserName(reqBO.getName());
        insertContractPo.setCreateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
        insertContractPo.setUpdateUserId(reqBO.getUserId());
        insertContractPo.setUpdateUserName(reqBO.getName());
        insertContractPo.setUpdateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
        insertContractPo.setAddContractTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
        insertContractPo.setContractStatus(ContractConstant.ContractStatus.CONTRACT_STATUS_DRAFT);
        insertContractPo.setNeedArriveTime(reqBO.getNeedArriveTime());
        insertContractPo.setContractVersion(1);
        insertContractPo.setSsBusiWay(reqBO.getSsBusiWay());
        insertContractPo.setContactName(reqBO.getContractBaseInfo().getContactName());
        insertContractPo.setContactPhoneNumber(reqBO.getContractBaseInfo().getContactPhoneNumber());
        insertContractPo.setSignContractId(reqBO.getSignContractId());
        if (insertContractPo.getSignContractId() != null) {
            log.info("\u5165\u9a7b\u5408\u540c\u65b0\u589e-signContractId\uff1a" + insertContractPo.getSignContractId());
        }
        if (1 == (addContractResult = this.contractMapper.insertSelective(insertContractPo))) {
            HashMap<String, Object> resultMap = new HashMap<String, Object>();
            resultMap.put(FIELD_CONTRACT_ID, insertContractPo.getContractId());
            resultMap.put(FIELD_CONTRACT_CODE, insertContractPo.getContractCode());
            return resultMap;
        }
        throw new ZTBusinessException("\u5408\u540c\u65b0\u589e\u5931\u8d25");
    }

    private void saveEnterContract(ContractAddBusiReqBO reqBO) {
        this.saveContractInfo(reqBO);
        this.updateContractAccessoryInfo(reqBO);
        this.saveSaleCategoryRateInfo(reqBO);
        this.saveLadderRateInfo(reqBO);
    }

    private void saveAgreeContract(ContractAddBusiReqBO reqBO) {
        this.saveContractInfo(reqBO);
        this.updateContractItemInfo(reqBO);
        this.updateContractAccessoryInfo(reqBO);
    }

    private void saveOrderContract(ContractAddBusiReqBO reqBO) {
        this.saveContractInfo(reqBO);
        this.updateContractOrderInfo(reqBO);
        this.updateContractItemInfo(reqBO);
        this.updateContractPayTypeInfo(reqBO);
        this.updateContractAccessoryInfo(reqBO);
    }

    private Map<String, Object> addAgreeContract(ContractAddBusiReqBO reqBO) {
        Map<String, Object> addContractResultMap = this.addContractInfo(reqBO);
        if (!CollectionUtils.isEmpty(reqBO.getItemList())) {
            this.addContractItemInfo((Long)addContractResultMap.get(FIELD_CONTRACT_ID), reqBO);
        }
        if (!CollectionUtils.isEmpty(reqBO.getAcceessoryList())) {
            this.addContractAccessoryInfo((Long)addContractResultMap.get(FIELD_CONTRACT_ID), reqBO);
        }
        this.recordContractNodeOperLog((Long)addContractResultMap.get(FIELD_CONTRACT_ID), reqBO.getUserId(), reqBO.getUserName());
        return addContractResultMap;
    }

    private Map<String, Object> addEnterContract(ContractAddBusiReqBO reqBO) {
        Map<String, Object> addContractResultMap = this.addContractInfo(reqBO);
        if (!CollectionUtils.isEmpty(reqBO.getAcceessoryList())) {
            this.addContractAccessoryInfo((Long)addContractResultMap.get(FIELD_CONTRACT_ID), reqBO);
        }
        if (!CollectionUtils.isEmpty(reqBO.getCategoryRateList())) {
            this.addSaleCategoryRateInfo((Long)addContractResultMap.get(FIELD_CONTRACT_ID), reqBO);
        }
        if (!CollectionUtils.isEmpty(reqBO.getYearEndRateList())) {
            this.addLadderRateInfo((Long)addContractResultMap.get(FIELD_CONTRACT_ID), reqBO);
        }
        this.recordContractNodeOperLog((Long)addContractResultMap.get(FIELD_CONTRACT_ID), reqBO.getUserId(), reqBO.getUserName());
        return addContractResultMap;
    }

    private Map<String, Object> addOrderContract(ContractAddBusiReqBO reqBO) {
        Map<String, Object> addContractResultMap = this.addContractInfo(reqBO);
        this.addContractOrderInfo((Long)addContractResultMap.get(FIELD_CONTRACT_ID), reqBO);
        if (!CollectionUtils.isEmpty(reqBO.getItemList())) {
            this.addContractItemInfo((Long)addContractResultMap.get(FIELD_CONTRACT_ID), reqBO);
        }
        if (!CollectionUtils.isEmpty(reqBO.getPayTypes())) {
            this.addContractPayTypeInfo((Long)addContractResultMap.get(FIELD_CONTRACT_ID), reqBO);
        }
        if (!CollectionUtils.isEmpty(reqBO.getAcceessoryList())) {
            this.addContractAccessoryInfo((Long)addContractResultMap.get(FIELD_CONTRACT_ID), reqBO);
        }
        this.recordContractNodeOperLog((Long)addContractResultMap.get(FIELD_CONTRACT_ID), reqBO.getUserId(), reqBO.getUserName());
        return addContractResultMap;
    }

    private void recordContractNodeOperLog(Long contractId, Long userId, String userName) {
        ContractRecordContractNodeOperLogAtomReqBO contractRecordContractNodeOperLogAtomReqBO = new ContractRecordContractNodeOperLogAtomReqBO();
        contractRecordContractNodeOperLogAtomReqBO.setContractId(contractId);
        contractRecordContractNodeOperLogAtomReqBO.setNodeCode("CREATE_CONTRACT");
        contractRecordContractNodeOperLogAtomReqBO.setNodeName("\u5408\u540c\u521b\u5efa");
        contractRecordContractNodeOperLogAtomReqBO.setOperUserId(userId);
        contractRecordContractNodeOperLogAtomReqBO.setOperUserName(userName);
        this.contractRecordContractNodeOperLogAtomService.recordContractNodeOperLog(contractRecordContractNodeOperLogAtomReqBO);
    }

    private void updateContractAccessoryInfo(ContractAddBusiReqBO reqBO) {
        ContractAccessoryPo deleteContractAccessoryPo = new ContractAccessoryPo();
        deleteContractAccessoryPo.setRelateId(reqBO.getContractBaseInfo().getContractId());
        deleteContractAccessoryPo.setRelateCode(reqBO.getContractBaseInfo().getContractCode());
        this.contractAccessoryMapper.deleteByCondition(deleteContractAccessoryPo);
        if (!CollectionUtils.isEmpty(reqBO.getAcceessoryList())) {
            this.addContractAccessoryInfo(reqBO.getContractBaseInfo().getContractId(), reqBO);
        }
    }

    private void addContractAccessoryInfo(Long contractId, ContractAddBusiReqBO reqBO) {
        String jsonString = JSON.toJSONString(reqBO.getAcceessoryList());
        List list = JSONArray.parseArray((String)jsonString).toJavaList(ContractAccessoryPo.class);
        ArrayList<ContractAccessoryPo> contractAccessoryPos = new ArrayList<ContractAccessoryPo>();
        for (ContractAccessoryPo contractAccessoryPo : list) {
            contractAccessoryPo.setAcceessoryId(Sequence.getInstance().nextId());
            contractAccessoryPo.setRelateId(contractId);
            contractAccessoryPo.setRelateCode(reqBO.getContractBaseInfo().getContractCode());
            contractAccessoryPo.setCreateUserId(reqBO.getUserId());
            contractAccessoryPo.setCreateUserName(reqBO.getName());
            contractAccessoryPo.setCreateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
            contractAccessoryPos.add(contractAccessoryPo);
        }
        int result = this.contractAccessoryMapper.insertBatch(list);
        if (result < 1) {
            throw new ZTBusinessException("\u5408\u540c\u9644\u4ef6\u6570\u636e\u65b0\u589e\u5931\u8d25");
        }
    }

    private void updateContractPayTypeInfo(ContractAddBusiReqBO reqBO) {
        ContractPayTypePo deleteContractPayTypePo = new ContractPayTypePo();
        deleteContractPayTypePo.setRelateId(reqBO.getContractId());
        deleteContractPayTypePo.setRelateCode(reqBO.getContractCode());
        this.contractPayTypeMapper.deleteByCondition(deleteContractPayTypePo);
        if (!CollectionUtils.isEmpty(reqBO.getPayTypes())) {
            this.addContractPayTypeInfo(reqBO.getContractId(), reqBO);
        }
    }

    private void addContractPayTypeInfo(Long contractId, ContractAddBusiReqBO reqBO) {
        ArrayList<ContractPayTypePo> list = new ArrayList<ContractPayTypePo>();
        for (Integer payType : reqBO.getPayTypes()) {
            ContractPayTypePo insertContractPayTypePo = new ContractPayTypePo();
            insertContractPayTypePo.setPayTypeId(Sequence.getInstance().nextId());
            insertContractPayTypePo.setRelateCode(reqBO.getContractCode());
            insertContractPayTypePo.setRelateId(contractId);
            insertContractPayTypePo.setRelationType(ContractConstant.ContractPayTypeRelationType.RELATION_TYPE_CONTRACT);
            insertContractPayTypePo.setPayType(payType);
            insertContractPayTypePo.setPayTypeStr(ContractTransFieldUtil.transOrderContractPayType(payType));
            list.add(insertContractPayTypePo);
        }
        int result = this.contractPayTypeMapper.insertBatch(list);
        if (result < 1) {
            throw new ZTBusinessException("\u5408\u540c\u652f\u4ed8\u65b9\u5f0f\u6570\u636e\u65b0\u589e\u5931\u8d25");
        }
    }

    private void updateContractItemInfo(ContractAddBusiReqBO reqBO) {
        ContractItemPo deleteContractItemPo = new ContractItemPo();
        deleteContractItemPo.setRelateId(reqBO.getContractBaseInfo().getContractId());
        deleteContractItemPo.setRelateCode(reqBO.getContractBaseInfo().getContractCode());
        List<ContractItemPo> contractItemPos = this.contractItemMapper.selectByRelateId(reqBO.getContractBaseInfo().getContractId());
        this.contractItemMapper.deleteByCondition(deleteContractItemPo);
        contractItemPos.forEach(item -> {
            CContractCooperationCategoryPO deleteContractCategoryPo = new CContractCooperationCategoryPO();
            deleteContractCategoryPo.setRelateId(item.getItemId());
            this.contractCooperationCategoryMapper.deleteBy(deleteContractCategoryPo);
        });
        if (!CollectionUtils.isEmpty(reqBO.getItemList())) {
            this.addContractItemInfo(reqBO.getContractBaseInfo().getContractId(), reqBO);
        }
    }

    private void addContractItemInfo(Long contractId, ContractAddBusiReqBO reqBO) {
        if (CollectionUtils.isEmpty(reqBO.getItemList())) {
            return;
        }
        reqBO.getItemList().forEach(item -> {
            ContractItemPo contractItemPo = (ContractItemPo)JSON.parseObject((String)JSON.toJSONString((Object)item), ContractItemPo.class);
            long itemId = Sequence.getInstance().nextId();
            contractItemPo.setItemId(itemId);
            contractItemPo.setRelateId(contractId);
            contractItemPo.setRelateCode(reqBO.getContractBaseInfo().getContractCode());
            contractItemPo.setCreateUserId(reqBO.getUserId());
            contractItemPo.setCreateUserName(reqBO.getName());
            contractItemPo.setCreateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
            contractItemPo.setUpdateUserId(reqBO.getUserId());
            contractItemPo.setUpdateUserName(reqBO.getName());
            contractItemPo.setUpdateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
            contractItemPo.setNeedArriveTime(DateTimeUtils.Date2String(contractItemPo.getNeedArriveTime()));
            int result = this.contractItemMapper.insertSelective(contractItemPo);
            if (result < 1) {
                throw new ZTBusinessException("\u5408\u540c\u660e\u7ec6\u6570\u636e\u65b0\u589e\u5931\u8d25");
            }
            if (!CollectionUtils.isEmpty((Collection)item.getCooperationCategoryList())) {
                item.getCooperationCategoryList().forEach(cooperationCategory -> {
                    CContractCooperationCategoryPO cooperationCategoryPo = new CContractCooperationCategoryPO();
                    BeanUtils.copyProperties((Object)cooperationCategory, (Object)cooperationCategoryPo);
                    cooperationCategoryPo.setCooperationCategoryId(Sequence.getInstance().nextId());
                    cooperationCategoryPo.setRelateId(itemId);
                    cooperationCategoryPo.setCreateUserName(reqBO.getName());
                    cooperationCategoryPo.setCreateTime(new Date());
                    int cooperationCategoryResult = this.contractCooperationCategoryMapper.insert(cooperationCategoryPo);
                    if (cooperationCategoryResult < 1) {
                        throw new ZTBusinessException("\u53cc\u65b9\u5408\u4f5c\u54c1\u7c7b\u65b0\u589e\u5931\u8d25");
                    }
                });
            }
        });
    }

    private void updateContractOrderInfo(ContractAddBusiReqBO reqBO) {
        ContractOrderPo queryContractOrderPo = new ContractOrderPo();
        queryContractOrderPo.setRelateId(reqBO.getContractId());
        queryContractOrderPo.setRelateCode(reqBO.getContractCode());
        List<ContractOrderPo> contractOrderPos = this.contractOrderMapper.selectByCondition(queryContractOrderPo);
        if (contractOrderPos != null && contractOrderPos.size() > 0) {
            log.info("\u4f20\u9012orderModel\u7ed9reqBO\uff1a" + contractOrderPos.get(0).getOrderModel());
            reqBO.setOrderModel(contractOrderPos.get(0).getOrderModel());
        }
        ContractOrderPo deleteContractOrderPo = new ContractOrderPo();
        deleteContractOrderPo.setRelateId(reqBO.getContractId());
        deleteContractOrderPo.setRelateCode(reqBO.getContractCode());
        this.contractOrderMapper.deleteByCondition(deleteContractOrderPo);
        this.addContractOrderInfo(reqBO.getContractId(), reqBO);
    }

    private void addContractOrderInfo(Long contractId, ContractAddBusiReqBO reqBO) {
        ContractOrderPo insertContractOrderPo = new ContractOrderPo();
        insertContractOrderPo.setId(Sequence.getInstance().nextId());
        insertContractOrderPo.setRelateId(contractId);
        insertContractOrderPo.setRelateCode(reqBO.getContractCode());
        insertContractOrderPo.setOrderId(reqBO.getOrderId());
        insertContractOrderPo.setOrderCode(reqBO.getOrderCode());
        insertContractOrderPo.setOrderSource(reqBO.getOrderSource());
        insertContractOrderPo.setOrderModel(reqBO.getOrderModel());
        int result = this.contractOrderMapper.insertSelective(insertContractOrderPo);
        if (result != 1) {
            throw new ZTBusinessException("\u5408\u540c\u8ba2\u5355\u65b0\u589e\u5931\u8d25");
        }
    }

    private void submitContractInfo(ContractAddBusiReqBO reqBO) {
    }

    private void saveContractInfo(ContractAddBusiReqBO reqBO) {
        ContractPo oldContractPo = this.contractMapper.selectByPrimaryKey(reqBO.getContractBaseInfo().getContractId());
        if (oldContractPo != null) {
            int updateResult;
            ContractPo updateContractPo = (ContractPo)JSON.parseObject((String)JSON.toJSONString((Object)reqBO.getContractBaseInfo()), ContractPo.class);
            if (Objects.equals(ContractConstant.RelateContractType.RENEW_CONTRACT, oldContractPo.getRelateType())) {
                if (Objects.equals(ContractConstant.CooperationMode.REGULAR_COOPERATION, reqBO.getContractBaseInfo().getCooperationMode())) {
                    updateContractPo.setRenewNum(0);
                    updateContractPo.setRenewStatus(3);
                }
            } else if (Objects.equals(ContractConstant.CooperationMode.STRATEGIC_COOPERATION, reqBO.getContractBaseInfo().getCooperationMode())) {
                updateContractPo.setRenewStatus(1);
                updateContractPo.setRenewNum(2);
            } else if (Objects.equals(ContractConstant.CooperationMode.ANNUAL_COOPERATION, reqBO.getContractBaseInfo().getCooperationMode())) {
                updateContractPo.setRenewStatus(1);
                updateContractPo.setRenewNum(1);
            } else {
                updateContractPo.setRenewNum(0);
                updateContractPo.setRenewStatus(3);
            }
            if (Objects.equals(ContractConstant.RelateContractType.RENEW_CONTRACT, oldContractPo.getRelateType())) {
                // empty if block
            }
            updateContractPo.setUpdateUserId(reqBO.getUserId());
            updateContractPo.setUpdateUserName(reqBO.getName());
            updateContractPo.setSsBusiWay(reqBO.getSsBusiWay());
            updateContractPo.setRemark(reqBO.getContractBaseInfo().getRemark());
            updateContractPo.setContractStatus(ContractConstant.ContractStatus.CONTRACT_STATUS_DRAFT);
            updateContractPo.setContactName(reqBO.getContractBaseInfo().getContactName());
            updateContractPo.setContactPhoneNumber(reqBO.getContractBaseInfo().getContactPhoneNumber());
            updateContractPo.setAddContractTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
            updateContractPo.setUpdateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
            updateContractPo.setContractApprovalSetNull(1);
            if ("2".equals(reqBO.getOperType())) {
                updateContractPo.setContractStatus(ContractConstant.ContractStatus.CONTRACT_STATUS_UNDER_APPROVAL);
            }
            if ((updateResult = this.contractMapper.updateByPrimaryKeySelective(updateContractPo)) != 1) {
                throw new ZTBusinessException("\u66f4\u65b0\u5408\u540c\u6570\u636e\u5931\u8d25");
            }
        } else {
            throw new ZTBusinessException("\u539f\u5408\u540c\u6570\u636e\u4e0d\u5b58\u5728");
        }
    }

    private Map<String, Object> addContractInfo(ContractAddBusiReqBO reqBO) {
        int addContractResult;
        ContractPo insertContractPo = new ContractPo();
        BeanUtils.copyProperties((Object)reqBO, (Object)insertContractPo);
        insertContractPo.setContractId(Sequence.getInstance().nextId());
        insertContractPo.setCreateUserId(reqBO.getUserId());
        insertContractPo.setCreateUserName(reqBO.getUserName());
        insertContractPo.setCreateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
        insertContractPo.setUpdateUserId(reqBO.getUserId());
        insertContractPo.setUpdateUserName(reqBO.getUserName());
        insertContractPo.setUpdateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
        insertContractPo.setContractStatus(ContractConstant.ContractStatus.CONTRACT_STATUS_DRAFT);
        insertContractPo.setNeedArriveTime(reqBO.getNeedArriveTime());
        insertContractPo.setContractVersion(1);
        insertContractPo.setSignContractId(reqBO.getSignContractId());
        if (insertContractPo.getSignContractId() != null) {
            log.info("\u5165\u9a7b\u5408\u540c\u65b0\u589e-signContractId\uff1a" + insertContractPo.getSignContractId());
        }
        if (1 == (addContractResult = this.contractMapper.insertSelective(insertContractPo))) {
            HashMap<String, Object> resultMap = new HashMap<String, Object>();
            resultMap.put(FIELD_CONTRACT_ID, insertContractPo.getContractId());
            resultMap.put(FIELD_CONTRACT_CODE, insertContractPo.getContractCode());
            return resultMap;
        }
        throw new ZTBusinessException("\u5408\u540c\u65b0\u589e\u5931\u8d25");
    }

    private void addSaleCategoryRateInfo(Long contractId, ContractAddBusiReqBO reqBO) {
        String saleCategoryRateJsonStr = JSON.toJSONString(reqBO.getCategoryRateList());
        List addSaleCategoryRateInfos = JSONArray.parseArray((String)saleCategoryRateJsonStr).toJavaList(ContractSaleCategoryRatePo.class);
        for (ContractSaleCategoryRatePo contractSaleCategoryRatePo : addSaleCategoryRateInfos) {
            contractSaleCategoryRatePo.setId(Sequence.getInstance().nextId());
            contractSaleCategoryRatePo.setRelateId(contractId);
            contractSaleCategoryRatePo.setRelateCode(reqBO.getContractCode());
            contractSaleCategoryRatePo.setCreateUserId(reqBO.getUserId());
            contractSaleCategoryRatePo.setCreateUserName(reqBO.getUserName());
            contractSaleCategoryRatePo.setCreateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
        }
        this.contractSaleCategoryRateMapper.insertBatch(addSaleCategoryRateInfos);
    }

    private void saveSaleCategoryRateInfo(ContractAddBusiReqBO reqBO) {
        ContractSaleCategoryRatePo deleteContractSaleCategoryRatePo = new ContractSaleCategoryRatePo();
        deleteContractSaleCategoryRatePo.setRelateCode(reqBO.getContractCode());
        deleteContractSaleCategoryRatePo.setRelateId(reqBO.getContractId());
        this.contractSaleCategoryRateMapper.deleteByCondition(deleteContractSaleCategoryRatePo);
        if (!CollectionUtils.isEmpty(reqBO.getCategoryRateList())) {
            this.addSaleCategoryRateInfo(reqBO.getContractId(), reqBO);
        }
    }

    private void addLadderRateInfo(Long contractId, ContractAddBusiReqBO reqBO) {
        String saleCategoryRateJsonStr = JSON.toJSONString(reqBO.getYearEndRateList());
        List addLadderRateInfos = JSONArray.parseArray((String)saleCategoryRateJsonStr).toJavaList(ContractLadderRatePo.class);
        for (ContractLadderRatePo contractLadderRatePo : addLadderRateInfos) {
            contractLadderRatePo.setId(Sequence.getInstance().nextId());
            contractLadderRatePo.setRelateId(contractId);
            contractLadderRatePo.setRelateCode(reqBO.getContractCode());
            contractLadderRatePo.setCreateUserId(reqBO.getUserId());
            contractLadderRatePo.setCreateUserName(reqBO.getUserName());
            contractLadderRatePo.setCreateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
        }
        this.contractLadderRateMapper.insertBatch(addLadderRateInfos);
    }

    private void saveLadderRateInfo(ContractAddBusiReqBO reqBO) {
        ContractLadderRatePo deleteContractLadderRatePo = new ContractLadderRatePo();
        deleteContractLadderRatePo.setRelateCode(reqBO.getContractCode());
        deleteContractLadderRatePo.setRelateId(reqBO.getContractId());
        this.contractLadderRateMapper.deleteByCondition(deleteContractLadderRatePo);
        if (!CollectionUtils.isEmpty(reqBO.getYearEndRateList())) {
            this.addLadderRateInfo(reqBO.getContractId(), reqBO);
        }
    }
}

