/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.busi.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.contract.ability.bo.ContractAgreePayPlanBO;
import com.tydic.contract.ability.bo.ContractCooperationCategoryBO;
import com.tydic.contract.ability.bo.ContractItemBO;
import com.tydic.contract.ability.bo.ContractQryPayPlanAbilityReqBO;
import com.tydic.contract.ability.bo.ContractQryPayPlanAbilityRspBO;
import com.tydic.contract.atom.ContractCreateApproveAtomService;
import com.tydic.contract.atom.bo.ContractCreateApproveAtomServiceReqBO;
import com.tydic.contract.atom.bo.ContractCreateApproveAtomServiceRspBO;
import com.tydic.contract.busi.ContractAddModApplyBusiService;
import com.tydic.contract.busi.ContractQryItemBusiService;
import com.tydic.contract.busi.ContractQryPayPlanBusiService;
import com.tydic.contract.busi.bo.ContractAddModApplyBusiReqBO;
import com.tydic.contract.busi.bo.ContractAddModApplyBusiRspBO;
import com.tydic.contract.busi.bo.ContractQryItemBusiReqBO;
import com.tydic.contract.busi.bo.ContractQryItemBusiRspBO;
import com.tydic.contract.constant.ContractConstant;
import com.tydic.contract.dao.CContractAccessoryChangeMapper;
import com.tydic.contract.dao.CContractChangeMapper;
import com.tydic.contract.dao.CContractCooperationCategoryChangeMapper;
import com.tydic.contract.dao.CContractCooperationCategoryMapper;
import com.tydic.contract.dao.CContractCooperationInfoChangeMapper;
import com.tydic.contract.dao.CContractCooperationInfoMapper;
import com.tydic.contract.dao.CContractItemChangeMapper;
import com.tydic.contract.dao.CContractLawInfoChangeMapper;
import com.tydic.contract.dao.CContractLawInfoMapper;
import com.tydic.contract.dao.CContractPayPlanChangeMapper;
import com.tydic.contract.dao.CContractPayPlanMapper;
import com.tydic.contract.dao.ContractAccessoryMapper;
import com.tydic.contract.dao.ContractItemMapper;
import com.tydic.contract.dao.ContractMapper;
import com.tydic.contract.dao.ContractModifyApplyMapper;
import com.tydic.contract.dao.ContractPayTypeMapper;
import com.tydic.contract.po.CContractAccessoryChangePO;
import com.tydic.contract.po.CContractChangePO;
import com.tydic.contract.po.CContractCooperationCategoryChangePO;
import com.tydic.contract.po.CContractCooperationCategoryPO;
import com.tydic.contract.po.CContractCooperationInfoChangePO;
import com.tydic.contract.po.CContractItemChangePO;
import com.tydic.contract.po.CContractLawInfoChangePO;
import com.tydic.contract.po.CContractPayPlanChangePO;
import com.tydic.contract.po.CContractPayPlanPO;
import com.tydic.contract.po.ContractAccessoryPo;
import com.tydic.contract.po.ContractItemPo;
import com.tydic.contract.po.ContractModifyApplyPo;
import com.tydic.contract.po.ContractPo;
import com.tydic.contract.utils.DateTimeUtils;
import com.tydic.dyc.umc.service.enterprise.UmcQryEnterpriseInfoService;
import com.tydic.dyc.umc.service.enterprise.bo.UmcQryEnterpriseInfoDetailReqBo;
import com.tydic.dyc.umc.service.enterprise.bo.UmcQryEnterpriseInfoDetailRspBo;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class ContractAddModApplyBusiServiceImpl
implements ContractAddModApplyBusiService {
    private static final Logger log = LoggerFactory.getLogger(ContractAddModApplyBusiServiceImpl.class);
    @Autowired
    private ContractMapper contractMapper;
    @Autowired
    private ContractAccessoryMapper contractAccessoryMapper;
    @Autowired
    private ContractModifyApplyMapper contractModifyApplyMapper;
    @Autowired
    private CContractLawInfoMapper contractLawInfoMapper;
    @Autowired
    private CContractCooperationInfoMapper contractCooperationInfoMapper;
    @Autowired
    private CContractPayPlanMapper contractPayPlanMapper;
    @Autowired
    private CContractCooperationCategoryMapper contractCooperationCategoryMapper;
    @Autowired
    private CContractChangeMapper cContractChangeMapper;
    @Autowired
    private CContractAccessoryChangeMapper cContractAccessoryChangeMapper;
    @Autowired
    private CContractLawInfoChangeMapper cContractLawInfoChangeMapper;
    @Autowired
    private CContractCooperationInfoChangeMapper cContractCooperationInfoChangeMapper;
    @Autowired
    private CContractPayPlanChangeMapper cContractPayPlanChangeMapper;
    @Autowired
    private CContractCooperationCategoryChangeMapper cContractCooperationCategoryChangeMapper;
    @Autowired
    private CContractItemChangeMapper cContractItemChangeMapper;
    public static final String FIELD_CONTRACT_ID = "contractId";
    public static final String FIELD_CONTRACT_CODE = "contractCode";
    public static final String FIELD_CONTRACT_MOD_ID = "updateApplyId";
    public static final String FIELD_CONTRACT_MOD_CODE = "updateApplyCode";
    public static final String FIELD_CONTRACT_CHANGE_ID = "contractChangeId";
    public static final String PROCESS = "contract_modify_create";
    @Autowired
    private ContractPayTypeMapper contractPayTypeMapper;
    @Autowired
    private ContractItemMapper contractItemMapper;
    @Autowired
    private ContractCreateApproveAtomService contractCreateApproveAtomService;
    @Autowired
    private ContractQryItemBusiService contractQryItemBusiService;
    @Autowired
    private ContractQryPayPlanBusiService contractQryPayPlanBusiService;
    @Autowired
    private UmcQryEnterpriseInfoService umcQryEnterpriseInfoService;

    @Override
    public ContractAddModApplyBusiRspBO addContractModApply(ContractAddModApplyBusiReqBO reqBO) {
        ContractAddModApplyBusiRspBO rspBO = new ContractAddModApplyBusiRspBO();
        if ("0".equals(reqBO.getOperType())) {
            Integer noApprovalNum = this.contractModifyApplyMapper.selectNoApprovalNumById(reqBO.getContractBaseInfo().getContractId());
            if (noApprovalNum > 0) {
                rspBO.setRespCode("8888");
                rspBO.setRespDesc("\u8be5\u5408\u540c\u5b58\u5728\u672a\u5ba1\u6279\u901a\u8fc7\u7684\u5408\u540c\u53d8\u66f4\u4fe1\u606f");
                return rspBO;
            }
            Map<String, Object> resultMap = this.addContractModApplyInfo(reqBO);
            Long updateApplyId = (Long)resultMap.get(FIELD_CONTRACT_MOD_ID);
            String updateApplyCode = (String)resultMap.get(FIELD_CONTRACT_MOD_CODE);
            ContractQryItemBusiReqBO contractQryItemBusiReqBO = new ContractQryItemBusiReqBO();
            contractQryItemBusiReqBO.setRelateId(reqBO.getContractBaseInfo().getContractId());
            ContractQryItemBusiRspBO contractQryItemBusiRspBO = this.contractQryItemBusiService.qryContractItem(contractQryItemBusiReqBO);
            ArrayList<CContractItemChangePO> insContractItemChangePOS = new ArrayList<CContractItemChangePO>();
            if (!CollectionUtils.isEmpty((Collection)contractQryItemBusiRspBO.getRows())) {
                for (ContractItemBO itemBO : contractQryItemBusiRspBO.getRows()) {
                    CContractItemChangePO insContractItemChangePO = (CContractItemChangePO)JSON.parseObject((String)JSON.toJSONString((Object)itemBO), CContractItemChangePO.class);
                    insContractItemChangePO.setItemId(Sequence.getInstance().nextId());
                    insContractItemChangePO.setRelateCode(updateApplyCode);
                    insContractItemChangePO.setRelateId(updateApplyId);
                    insContractItemChangePO.setCreateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
                    insContractItemChangePO.setCreateUserId(reqBO.getUserId());
                    insContractItemChangePO.setUpdateUserId(reqBO.getUserId());
                    insContractItemChangePO.setUpdateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
                    insContractItemChangePO.setItemId(Sequence.getInstance().nextId());
                    insContractItemChangePOS.add(insContractItemChangePO);
                    if (CollectionUtils.isEmpty((Collection)itemBO.getCooperationCategoryList())) continue;
                    ArrayList<CContractCooperationCategoryChangePO> insContractCooperationCategoryChangePOS = new ArrayList<CContractCooperationCategoryChangePO>();
                    for (ContractCooperationCategoryBO contractCooperationCategoryBO : itemBO.getCooperationCategoryList()) {
                        CContractCooperationCategoryChangePO insContractCooperationCategoryChangePO = (CContractCooperationCategoryChangePO)JSON.parseObject((String)JSON.toJSONString((Object)contractCooperationCategoryBO), CContractCooperationCategoryChangePO.class);
                        insContractCooperationCategoryChangePO.setCooperationCategoryId(Sequence.getInstance().nextId());
                        insContractCooperationCategoryChangePO.setRelateId(insContractItemChangePO.getItemId());
                        insContractCooperationCategoryChangePO.setCreateTime(new Date());
                        insContractCooperationCategoryChangePO.setUpdateTime(new Date());
                        insContractCooperationCategoryChangePO.setCreateUserName(reqBO.getName());
                        insContractCooperationCategoryChangePO.setUpdateUserId(reqBO.getUserId());
                        insContractCooperationCategoryChangePO.setUpdateUserName(reqBO.getName());
                        insContractCooperationCategoryChangePOS.add(insContractCooperationCategoryChangePO);
                    }
                    this.cContractCooperationCategoryChangeMapper.insertBatch(insContractCooperationCategoryChangePOS);
                }
                this.cContractItemChangeMapper.insertBatch(insContractItemChangePOS);
            }
            ContractQryPayPlanAbilityReqBO qryontractQryPayPlanAbilityReqBO = new ContractQryPayPlanAbilityReqBO();
            qryontractQryPayPlanAbilityReqBO.setRelateId(reqBO.getContractBaseInfo().getContractId());
            ContractQryPayPlanAbilityRspBO contractQryPayPlanAbilityRspBO = this.contractQryPayPlanBusiService.qryContractPayPlan(qryontractQryPayPlanAbilityReqBO);
            if (!CollectionUtils.isEmpty((Collection)contractQryPayPlanAbilityRspBO.getRows())) {
                ArrayList<CContractPayPlanChangePO> insContractPayPlanChangePOS = new ArrayList<CContractPayPlanChangePO>();
                for (ContractAgreePayPlanBO row : contractQryPayPlanAbilityRspBO.getRows()) {
                    CContractPayPlanChangePO insCContractPayPlanChangePO = (CContractPayPlanChangePO)JSON.parseObject((String)JSON.toJSONString((Object)row), CContractPayPlanChangePO.class);
                    insCContractPayPlanChangePO.setPayPlanId(Sequence.getInstance().nextId());
                    insCContractPayPlanChangePO.setRelateId(updateApplyId);
                    insCContractPayPlanChangePO.setRelateCode(updateApplyCode);
                    insCContractPayPlanChangePO.setCreateTime(new Date());
                    insCContractPayPlanChangePO.setUpdateTime(new Date());
                    insCContractPayPlanChangePO.setCreateUserName(reqBO.getName());
                    insCContractPayPlanChangePO.setUpdateUserId(reqBO.getUserId());
                    insCContractPayPlanChangePO.setUpdateUserName(reqBO.getName());
                    insContractPayPlanChangePOS.add(insCContractPayPlanChangePO);
                }
                this.cContractPayPlanChangeMapper.insertBatch(insContractPayPlanChangePOS);
            }
            rspBO.setUpdateApplyCode(updateApplyCode);
            rspBO.setUpdateApplyId(updateApplyId);
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u65b0\u589e\u5408\u540c\u53d8\u66f4\u5355\u4fe1\u606f\u6210\u529f");
        } else if ("1".equals(reqBO.getOperType())) {
            this.validate(reqBO);
            this.saveContractModApplyAndOtherInfo(reqBO);
        } else if ("2".equals(reqBO.getOperType())) {
            this.validate(reqBO);
            ContractCreateApproveAtomServiceReqBO atomServiceReqBo = new ContractCreateApproveAtomServiceReqBO();
            UmcQryEnterpriseInfoDetailReqBo umcQryEnterpriseInfoDetailReqBo = new UmcQryEnterpriseInfoDetailReqBo();
            umcQryEnterpriseInfoDetailReqBo.setOrgId(Long.valueOf(Long.parseLong(reqBO.getContractBaseInfo().getPartyBCode())));
            if (Objects.equals(reqBO.getContractBaseInfo().getFeeType(), ContractConstant.FeeType.INCOME_CONTRACT_CODE) && !Objects.equals(reqBO.getContractBaseInfo().getIncomeContractType(), ContractConstant.ZYCMIncomeContractType.SERVICE_AGREE_TYPE)) {
                umcQryEnterpriseInfoDetailReqBo.setOrgId(Long.valueOf(Long.parseLong(reqBO.getContractBaseInfo().getPartyA1Code())));
            }
            UmcQryEnterpriseInfoDetailRspBo umcQryEnterpriseInfoDetailRspBo = this.umcQryEnterpriseInfoService.qryEnterpriseInfo(umcQryEnterpriseInfoDetailReqBo);
            String presenterId = umcQryEnterpriseInfoDetailRspBo.getPresenterId();
            String presenterName = umcQryEnterpriseInfoDetailRspBo.getPresenterName();
            atomServiceReqBo.setPresenterId(presenterId);
            atomServiceReqBo.setPresenterName(presenterName);
            atomServiceReqBo.setUserId(reqBO.getUserId());
            atomServiceReqBo.setUsername(reqBO.getName());
            atomServiceReqBo.setOrgId(reqBO.getOrgId());
            atomServiceReqBo.setOrgName(reqBO.getOrgName());
            atomServiceReqBo.setCompanyId(reqBO.getCompanyId());
            atomServiceReqBo.setCompanyName(reqBO.getCompanyName());
            atomServiceReqBo.setContractId(reqBO.getUpdateApplyId());
            atomServiceReqBo.setObjId(reqBO.getUpdateApplyId());
            atomServiceReqBo.setObjType(ContractConstant.OBJ_TYPE.MODIFY_CONTRACT);
            atomServiceReqBo.setObjBusiType(ContractConstant.OBJ_TYPE.MODIFY_CONTRACT);
            atomServiceReqBo.setProcDefKey(PROCESS);
            atomServiceReqBo.setContractType(reqBO.getContractBaseInfo().getContractType());
            atomServiceReqBo.setNeedUnsignTab(reqBO.getNeedUnsignTab());
            ContractCreateApproveAtomServiceRspBO atomRspBO = this.contractCreateApproveAtomService.createApprove(atomServiceReqBo);
            log.info("\u8c03\u7528\u5ba1\u6279\u53d1\u8d77\u670d\u52a1\u51fa\u53c2:{}", (Object)JSON.toJSONString((Object)((Object)atomRspBO)));
            if (!atomRspBO.getRespCode().equals("0000")) {
                throw new ZTBusinessException(atomRspBO.getRespDesc());
            }
            this.saveContractModApplyAndOtherInfo(reqBO);
            if (!Objects.equals(reqBO.getModOperType(), ContractConstant.ContractModApplyType.CONTRACT_SUPPLEMENT)) {
                ContractPo updateContractPo = new ContractPo();
                updateContractPo.setContractId(reqBO.getContractBaseInfo().getContractId());
                updateContractPo.setContractStatus(ContractConstant.ContractStatus.CONTRACT_STATUS_CHANGE_APPLY);
                int i = this.contractMapper.updateByPrimaryKeySelective(updateContractPo);
                if (i != 1) {
                    throw new ZTBusinessException("\u5408\u540c\u72b6\u6001\u4fee\u6539\u5931\u8d25");
                }
            }
            ContractModifyApplyPo updateModApply = new ContractModifyApplyPo();
            updateModApply.setUpdateApplyId(reqBO.getUpdateApplyId());
            updateModApply.setModifyStatus(ContractConstant.ModifyStatus.MODIFY_STATUS_EXAMINE);
            updateModApply.setContractModApprovalSetNull(1);
            int update = this.contractModifyApplyMapper.updateByPrimaryKeySelective(updateModApply);
            if (update != 1) {
                throw new ZTBusinessException("\u5408\u540c\u53d8\u66f4\u72b6\u6001\u4fee\u6539\u5931\u8d25");
            }
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u63d0\u4ea4\u8ba2\u5355\u5408\u540c\u6210\u529f");
            return rspBO;
        }
        return rspBO;
    }

    private Map<String, Object> addContractModApplyInfo(ContractAddModApplyBusiReqBO reqBO) {
        ContractPo contractPo = this.contractMapper.selectByPrimaryKey(reqBO.getContractBaseInfo().getContractId());
        if (contractPo == null) {
            throw new ZTBusinessException("\u5408\u540c\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        ContractModifyApplyPo insContractModifyApplyPo = new ContractModifyApplyPo();
        BeanUtils.copyProperties((Object)contractPo, (Object)insContractModifyApplyPo);
        Integer contractModApplyVersion = this.contractModifyApplyMapper.qryMaxVersionByContractId(reqBO.getContractBaseInfo().getContractId());
        if (!ObjectUtil.isEmpty((Object)contractModApplyVersion)) {
            if (contractModApplyVersion < 10) {
                insContractModifyApplyPo.setUpdateApplyCode(reqBO.getContractBaseInfo().getContractCode() + "-C0" + (contractModApplyVersion + 1));
            } else {
                insContractModifyApplyPo.setUpdateApplyCode(reqBO.getContractBaseInfo().getContractCode() + "-C" + (contractModApplyVersion + 1));
            }
            insContractModifyApplyPo.setContractVersion(contractModApplyVersion + 1);
        } else {
            insContractModifyApplyPo.setUpdateApplyCode(reqBO.getContractBaseInfo().getContractCode() + "-C01");
            insContractModifyApplyPo.setContractVersion(2);
        }
        insContractModifyApplyPo.setUpdateApplyId(Sequence.getInstance().nextId());
        insContractModifyApplyPo.setCreateUserId(reqBO.getUserId());
        insContractModifyApplyPo.setUpdateUserId(reqBO.getUserId());
        insContractModifyApplyPo.setCreateUserName(reqBO.getName());
        insContractModifyApplyPo.setUpdateUserName(reqBO.getName());
        insContractModifyApplyPo.setCreateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
        insContractModifyApplyPo.setUpdateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
        insContractModifyApplyPo.setModifyCreateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm").format(new Date()));
        insContractModifyApplyPo.setModifyCreateUserName(reqBO.getName());
        insContractModifyApplyPo.setModifyCreateUserId(reqBO.getUserId());
        insContractModifyApplyPo.setModOperType(reqBO.getModOperType());
        insContractModifyApplyPo.setModifyStatus(ContractConstant.ModifyStatus.MODIFY_STATUS_DRAFT);
        int insert = this.contractModifyApplyMapper.insertSelective(insContractModifyApplyPo);
        if (insert != 1) {
            throw new ZTBusinessException("\u65b0\u589e\u5408\u540c\u53d8\u66f4\u5355\u5931\u8d25");
        }
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put(FIELD_CONTRACT_MOD_ID, insContractModifyApplyPo.getUpdateApplyId());
        resultMap.put(FIELD_CONTRACT_MOD_CODE, insContractModifyApplyPo.getUpdateApplyCode());
        return resultMap;
    }

    private void validate(ContractAddModApplyBusiReqBO reqBO) {
        Integer contractModAppType = reqBO.getModOperType();
        if (ObjectUtils.isEmpty((Object)contractModAppType)) {
            throw new ZTBusinessException("\u8bf7\u9009\u62e9\u5408\u540c\u53d8\u66f4\u7533\u8bf7\u7c7b\u578b");
        }
        if (ObjectUtils.isEmpty((Object)reqBO.getUpdateApplyCode())) {
            throw new ZTBusinessException("\u5408\u540c\u53d8\u66f4\u7f16\u53f7\u4e3a\u7a7a");
        }
        String remark = reqBO.getUpdateApplyRemark();
        if (StringUtils.isEmpty((Object)remark)) {
            throw new ZTBusinessException("\u8bf7\u586b\u5199\u5408\u540c\u53d8\u66f4\u7533\u8bf7\u8bf4\u660e");
        }
    }

    private void saveContractModApplyAndOtherInfo(ContractAddModApplyBusiReqBO reqBO) {
        Map<String, Object> resultModApplyMap = this.updateContractModApplyInfo(reqBO);
        this.saveApplyAccessory(reqBO, resultModApplyMap);
        if (Objects.equals(reqBO.getModOperType(), ContractConstant.ContractModApplyType.CONTRACT_MODIFY)) {
            List<Integer> asList = Arrays.asList(3, 12, 13);
            if (!asList.contains(reqBO.getContractBaseInfo().getContractStatus())) {
                throw new ZTBusinessException("\u8be5\u5408\u540c\u72b6\u6001\u4e0b\u4e0d\u80fd\u8fdb\u884c\u5408\u540c\u4fee\u6539");
            }
            Map<String, Object> resultMap = this.saveContractInfo(reqBO, resultModApplyMap);
            this.saveContractLawInfo(reqBO, resultModApplyMap);
            this.saveContractCooperationInfo(reqBO, resultModApplyMap);
            this.saveContractAccessoryInfo(reqBO, resultModApplyMap);
        } else if (Objects.equals(reqBO.getModOperType(), ContractConstant.ContractModApplyType.CONTRACT_INVALID)) {
            List<Integer> asList = Arrays.asList(3, 6, 7, 12, 13);
            if (!asList.contains(reqBO.getContractBaseInfo().getContractStatus())) {
                throw new ZTBusinessException("\u8be5\u5408\u540c\u72b6\u6001\u4e0b\u4e0d\u80fd\u8fdb\u884c\u5408\u540c\u4f5c\u5e9f");
            }
            Map<String, Object> resultMap = this.saveContractInfo(reqBO, resultModApplyMap);
            this.saveContractLawInfo(reqBO, resultModApplyMap);
            this.saveContractCooperationInfo(reqBO, resultModApplyMap);
            this.saveContractAccessoryInfo(reqBO, resultModApplyMap);
        } else if (Objects.equals(reqBO.getModOperType(), ContractConstant.ContractModApplyType.CONTRACT_SUPPLEMENT)) {
            List<Integer> asList = Arrays.asList(8);
            if (!asList.contains(reqBO.getContractBaseInfo().getContractStatus())) {
                throw new ZTBusinessException("\u8be5\u5408\u540c\u72b6\u6001\u4e0b\u4e0d\u80fd\u8fdb\u884c\u5408\u540c\u8865\u5145");
            }
            Map<String, Object> resultMap = this.saveContractInfo(reqBO, resultModApplyMap);
            this.saveContractLawInfo(reqBO, resultModApplyMap);
            this.saveContractCooperationInfo(reqBO, resultModApplyMap);
            this.saveContractAccessoryInfo(reqBO, resultModApplyMap);
        } else if (Objects.equals(reqBO.getModOperType(), ContractConstant.ContractModApplyType.CONTRACT_CHANGE_APPLY)) {
            List<Integer> asList = Arrays.asList(8);
            if (!asList.contains(reqBO.getContractBaseInfo().getContractStatus())) {
                throw new ZTBusinessException("\u8be5\u5408\u540c\u72b6\u6001\u4e0b\u4e0d\u80fd\u8fdb\u884c\u5408\u540c\u53d8\u66f4");
            }
            Map<String, Object> resultMap = this.saveContractInfo(reqBO, resultModApplyMap);
            this.saveContractLawInfo(reqBO, resultModApplyMap);
            this.saveContractCooperationInfo(reqBO, resultModApplyMap);
            this.saveContractAccessoryInfo(reqBO, resultModApplyMap);
        }
    }

    private void saveApplyAccessory(ContractAddModApplyBusiReqBO reqBO, Map<String, Object> resultMap) {
        Long updateApplyId = (Long)resultMap.get(FIELD_CONTRACT_MOD_ID);
        String updateApplyCode = (String)resultMap.get(FIELD_CONTRACT_MOD_CODE);
        CContractAccessoryChangePO deleteContractAccessoryPo = new CContractAccessoryChangePO();
        deleteContractAccessoryPo.setRelateId(updateApplyId);
        deleteContractAccessoryPo.setRelateCode(updateApplyCode);
        deleteContractAccessoryPo.setAcceessoryType(2);
        deleteContractAccessoryPo.setRelateType(2);
        this.cContractAccessoryChangeMapper.deleteByCondition(deleteContractAccessoryPo);
        if (!CollectionUtils.isEmpty(reqBO.getUpdateAcceessoryList())) {
            String jsonString = JSON.toJSONString(reqBO.getUpdateAcceessoryList());
            List list = JSONArray.parseArray((String)jsonString).toJavaList(CContractAccessoryChangePO.class);
            for (CContractAccessoryChangePO contractAccessoryPo : list) {
                contractAccessoryPo.setAcceessoryId(Sequence.getInstance().nextId());
                contractAccessoryPo.setRelateId(updateApplyId);
                contractAccessoryPo.setRelateCode(updateApplyCode);
                contractAccessoryPo.setCreateUserId(reqBO.getUserId());
                contractAccessoryPo.setCreateUserName(reqBO.getName());
                contractAccessoryPo.setCreateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
                contractAccessoryPo.setAcceessoryType(2);
                contractAccessoryPo.setRelateType(2);
            }
            int result = this.cContractAccessoryChangeMapper.insertBatch(list);
            if (result < 1) {
                throw new ZTBusinessException("\u53d8\u66f4\u5408\u540c\u9644\u4ef6\u6570\u636e\u65b0\u589e\u5931\u8d25");
            }
        }
    }

    private void updateContractModApplyAccessoryInfo(ContractAddModApplyBusiReqBO reqBO) {
        ContractAccessoryPo deleteContractAccessoryPo = new ContractAccessoryPo();
        deleteContractAccessoryPo.setRelateId(reqBO.getUpdateApplyId());
        deleteContractAccessoryPo.setRelateCode(reqBO.getUpdateApplyCode());
        deleteContractAccessoryPo.setAcceessoryType(2);
        deleteContractAccessoryPo.setRelateType(2);
        this.contractAccessoryMapper.deleteByCondition(deleteContractAccessoryPo);
        if (!CollectionUtils.isEmpty(reqBO.getUpdateAcceessoryList())) {
            this.addContractModApplyAccessoryInfo(reqBO.getUpdateApplyId(), reqBO);
        }
    }

    private void addContractModApplyAccessoryInfo(ContractAddModApplyBusiReqBO reqBO) {
        String jsonString = JSON.toJSONString(reqBO.getUpdateAcceessoryList());
        List list = JSONArray.parseArray((String)jsonString).toJavaList(ContractAccessoryPo.class);
        for (ContractAccessoryPo contractAccessoryPo : list) {
            contractAccessoryPo.setAcceessoryId(Sequence.getInstance().nextId());
            contractAccessoryPo.setRelateId(reqBO.getUpdateApplyId());
            contractAccessoryPo.setRelateCode(reqBO.getUpdateApplyCode());
            contractAccessoryPo.setCreateUserId(reqBO.getUserId());
            contractAccessoryPo.setCreateUserName(reqBO.getName());
            contractAccessoryPo.setAcceessoryType(2);
            contractAccessoryPo.setRelateType(2);
            contractAccessoryPo.setCreateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
        }
        int result = this.contractAccessoryMapper.insertBatch(list);
        if (result < 1) {
            throw new ZTBusinessException("\u5408\u540c\u9644\u4ef6\u6570\u636e\u65b0\u589e\u5931\u8d25");
        }
    }

    private Map<String, Object> saveContractInfo(ContractAddModApplyBusiReqBO reqBO, Map<String, Object> resultMap) {
        Long updateApplyId = (Long)resultMap.get(FIELD_CONTRACT_MOD_ID);
        String updateApplyCode = (String)resultMap.get(FIELD_CONTRACT_MOD_CODE);
        CContractChangePO oldContractPo = this.cContractChangeMapper.selectByRelateId(updateApplyId);
        if (ObjectUtils.isEmpty((Object)oldContractPo)) {
            return this.addContractInfo(reqBO, resultMap);
        }
        return this.updateContractInfo(reqBO);
    }

    private Map<String, Object> addContractInfo(ContractAddModApplyBusiReqBO reqBO, Map<String, Object> resultModApplyMap) {
        Long updateApplyId = (Long)resultModApplyMap.get(FIELD_CONTRACT_MOD_ID);
        String updateApplyCode = (String)resultModApplyMap.get(FIELD_CONTRACT_MOD_CODE);
        CContractChangePO insertContractPo = new CContractChangePO();
        BeanUtils.copyProperties((Object)reqBO.getContractBaseInfo(), (Object)insertContractPo);
        insertContractPo.setContractChangeId(Sequence.getInstance().nextId());
        insertContractPo.setCreateUserId(reqBO.getUserId());
        insertContractPo.setCreateUserName(reqBO.getName());
        insertContractPo.setCreateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
        insertContractPo.setUpdateUserId(reqBO.getUserId());
        insertContractPo.setUpdateUserName(reqBO.getName());
        insertContractPo.setUpdateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
        insertContractPo.setRelateId(updateApplyId);
        insertContractPo.setRelateCode(updateApplyCode);
        int addContractResult = this.cContractChangeMapper.insert(insertContractPo);
        if (1 == addContractResult) {
            HashMap<String, Object> resultMap = new HashMap<String, Object>();
            resultMap.put(FIELD_CONTRACT_CHANGE_ID, insertContractPo.getContractChangeId());
            resultMap.put(FIELD_CONTRACT_CODE, insertContractPo.getContractCode());
            return resultMap;
        }
        throw new ZTBusinessException("\u5408\u540c\u65b0\u589e\u5931\u8d25");
    }

    private Map<String, Object> updateContractInfo(ContractAddModApplyBusiReqBO reqBO) {
        CContractChangePO updContractPo = new CContractChangePO();
        BeanUtils.copyProperties((Object)reqBO.getContractBaseInfo(), (Object)updContractPo);
        updContractPo.setUpdateUserId(reqBO.getUserId());
        updContractPo.setUpdateUserName(reqBO.getName());
        updContractPo.setSsBusiWay(reqBO.getSsBusiWay());
        updContractPo.setUpdateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
        CContractChangePO where = new CContractChangePO();
        where.setRelateId(reqBO.getUpdateApplyId());
        int i = this.cContractChangeMapper.updateBy(updContractPo, where);
        if (i != 1) {
            throw new ZTBusinessException("\u66f4\u65b0\u5408\u540c\u6570\u636e\u5931\u8d25");
        }
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put(FIELD_CONTRACT_CHANGE_ID, reqBO.getContractBaseInfo().getContractChangeId());
        resultMap.put(FIELD_CONTRACT_CODE, reqBO.getContractBaseInfo().getContractCode());
        return resultMap;
    }

    private void addContractToModApply(ContractAddModApplyBusiReqBO reqBO) {
        ContractModifyApplyPo updContractModifyApplyPo = new ContractModifyApplyPo();
        updContractModifyApplyPo.setUpdateApplyId(reqBO.getUpdateApplyId());
        updContractModifyApplyPo.setUpdateApplyCode(reqBO.getUpdateApplyCode());
        BeanUtils.copyProperties((Object)reqBO.getContractBaseInfo(), (Object)updContractModifyApplyPo);
        updContractModifyApplyPo.setUpdateUserId(reqBO.getUserId());
        updContractModifyApplyPo.setUpdateUserName(reqBO.getName());
        updContractModifyApplyPo.setUpdateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
        int updContractModResult = this.contractModifyApplyMapper.updateByPrimaryKey(updContractModifyApplyPo);
        if (1 != updContractModResult) {
            throw new ZTBusinessException("\u5408\u540c\u4e3b\u4f53\u4fe1\u606f\u5728\u53d8\u66f4\u8868\u65b0\u589e\u5931\u8d25");
        }
    }

    private void saveContractPayPlanInfo(ContractAddModApplyBusiReqBO reqBO, Map<String, Object> resultMap) {
        Long updateApplyId = (Long)resultMap.get(FIELD_CONTRACT_MOD_ID);
        String updateApplyCode = (String)resultMap.get(FIELD_CONTRACT_MOD_CODE);
        CContractPayPlanChangePO delPayPlan = new CContractPayPlanChangePO();
        delPayPlan.setRelateCode(updateApplyCode);
        delPayPlan.setRelateId(updateApplyId);
        this.cContractPayPlanChangeMapper.deleteBy(delPayPlan);
        if (!CollectionUtils.isEmpty(reqBO.getPayPlanList())) {
            this.addContractPayPlanInfo(reqBO, resultMap);
        }
    }

    private void updateContractPayPlanInfo(ContractAddModApplyBusiReqBO reqBO, Map<String, Object> resultMap) {
        if (CollectionUtils.isEmpty(reqBO.getPayPlanList())) {
            return;
        }
        Long contratId = (Long)resultMap.get(FIELD_CONTRACT_ID);
        String contractCode = (String)resultMap.get(FIELD_CONTRACT_CODE);
        CContractPayPlanPO cContractPayPlanPO = new CContractPayPlanPO();
        cContractPayPlanPO.setRelateId(contratId);
        cContractPayPlanPO.setRelateCode(contractCode);
        this.contractPayPlanMapper.deleteBy(cContractPayPlanPO);
        this.addContractPayPlanInfo(reqBO, resultMap);
    }

    private void addContractPayPlanInfo(ContractAddModApplyBusiReqBO reqBO, Map<String, Object> resultMap) {
        Long updateApplyId = (Long)resultMap.get(FIELD_CONTRACT_MOD_ID);
        String updateApplyCode = (String)resultMap.get(FIELD_CONTRACT_MOD_CODE);
        String jsonStr = JSON.toJSONString(reqBO.getPayPlanList());
        List javaList = JSONArray.parseArray((String)jsonStr).toJavaList(CContractPayPlanChangePO.class);
        for (CContractPayPlanChangePO contractPayPlanPo : javaList) {
            contractPayPlanPo.setPayPlanId(Sequence.getInstance().nextId());
            contractPayPlanPo.setRelateId(updateApplyId);
            contractPayPlanPo.setRelateCode(updateApplyCode);
            contractPayPlanPo.setCreateUserName(reqBO.getName());
            contractPayPlanPo.setCreateTime(new Date());
            int result = this.cContractPayPlanChangeMapper.insert(contractPayPlanPo);
            if (result >= 1) continue;
            throw new ZTBusinessException("\u5408\u540c\u4ed8\u6b3e\u8ba1\u5212\u65b0\u589e\u5931\u8d25");
        }
    }

    private void saveContractItemInfo(ContractAddModApplyBusiReqBO reqBO, Map<String, Object> resultMap) {
        Long updateApplyId = (Long)resultMap.get(FIELD_CONTRACT_MOD_ID);
        String updateApplyCode = (String)resultMap.get(FIELD_CONTRACT_MOD_CODE);
        CContractItemChangePO deleteContractItemPo = new CContractItemChangePO();
        deleteContractItemPo.setRelateId(updateApplyId);
        deleteContractItemPo.setRelateCode(updateApplyCode);
        List<CContractItemChangePO> contractItemPos = this.cContractItemChangeMapper.selectByRelateId(updateApplyId);
        this.cContractItemChangeMapper.deleteByCondition(deleteContractItemPo);
        contractItemPos.forEach(item -> {
            CContractCooperationCategoryChangePO deleteContractCategoryPo = new CContractCooperationCategoryChangePO();
            deleteContractCategoryPo.setRelateId(item.getItemId());
            this.cContractCooperationCategoryChangeMapper.deleteBy(deleteContractCategoryPo);
        });
        if (!CollectionUtils.isEmpty(reqBO.getItemList())) {
            this.addContractItemInfo(reqBO, resultMap);
        }
    }

    private void updateContractItemInfo(ContractAddModApplyBusiReqBO reqBO, Map<String, Object> resultMap) {
        Long contratId = (Long)resultMap.get(FIELD_CONTRACT_ID);
        String contractCode = (String)resultMap.get(FIELD_CONTRACT_CODE);
        ContractItemPo deleteContractItemPo = new ContractItemPo();
        deleteContractItemPo.setRelateId(contratId);
        deleteContractItemPo.setRelateCode(contractCode);
        List<ContractItemPo> contractItemPos = this.contractItemMapper.selectByRelateId(contratId);
        this.contractItemMapper.deleteByCondition(deleteContractItemPo);
        contractItemPos.forEach(item -> {
            CContractCooperationCategoryPO deleteContractCategoryPo = new CContractCooperationCategoryPO();
            deleteContractCategoryPo.setRelateId(item.getItemId());
            this.contractCooperationCategoryMapper.deleteBy(deleteContractCategoryPo);
        });
        if (!CollectionUtils.isEmpty(reqBO.getItemList())) {
            this.addContractItemInfo(reqBO, resultMap);
        }
    }

    private void addContractItemInfo(ContractAddModApplyBusiReqBO reqBO, Map<String, Object> resultMap) {
        Long updateApplyId = (Long)resultMap.get(FIELD_CONTRACT_MOD_ID);
        String updateApplyCode = (String)resultMap.get(FIELD_CONTRACT_MOD_CODE);
        if (!CollectionUtils.isEmpty(reqBO.getItemList())) {
            reqBO.getItemList().forEach(item -> {
                CContractItemChangePO contractItemPo = (CContractItemChangePO)JSON.parseObject((String)JSON.toJSONString((Object)item), CContractItemChangePO.class);
                long itemId = Sequence.getInstance().nextId();
                contractItemPo.setItemId(itemId);
                contractItemPo.setRelateId(updateApplyId);
                contractItemPo.setRelateCode(updateApplyCode);
                contractItemPo.setCreateUserId(reqBO.getUserId());
                contractItemPo.setCreateUserName(reqBO.getName());
                contractItemPo.setCreateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
                contractItemPo.setUpdateUserId(reqBO.getUserId());
                contractItemPo.setUpdateUserName(reqBO.getName());
                contractItemPo.setUpdateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
                contractItemPo.setNeedArriveTime(DateTimeUtils.Date2String(contractItemPo.getNeedArriveTime()));
                int result = this.cContractItemChangeMapper.insertSelective(contractItemPo);
                if (result < 1) {
                    throw new ZTBusinessException("\u5408\u540c\u660e\u7ec6\u6570\u636e\u65b0\u589e\u5931\u8d25");
                }
                if (!CollectionUtils.isEmpty((Collection)item.getCooperationCategoryList())) {
                    item.getCooperationCategoryList().forEach(cooperationCategory -> {
                        CContractCooperationCategoryChangePO cooperationCategoryPo = new CContractCooperationCategoryChangePO();
                        BeanUtils.copyProperties((Object)cooperationCategory, (Object)cooperationCategoryPo);
                        cooperationCategoryPo.setCooperationCategoryId(Sequence.getInstance().nextId());
                        cooperationCategoryPo.setRelateId(itemId);
                        cooperationCategoryPo.setCreateUserName(reqBO.getName());
                        cooperationCategoryPo.setCreateTime(new Date());
                        int cooperationCategoryResult = this.cContractCooperationCategoryChangeMapper.insert(cooperationCategoryPo);
                        if (cooperationCategoryResult < 1) {
                            throw new ZTBusinessException("\u53cc\u65b9\u5408\u4f5c\u54c1\u7c7b\u65b0\u589e\u5931\u8d25");
                        }
                    });
                }
            });
        }
    }

    private void saveContractAccessoryInfo(ContractAddModApplyBusiReqBO reqBO, Map<String, Object> resultMap) {
        Long updateApplyId = (Long)resultMap.get(FIELD_CONTRACT_MOD_ID);
        String updateApplyCode = (String)resultMap.get(FIELD_CONTRACT_MOD_CODE);
        CContractAccessoryChangePO deleteContractAccessoryPo = new CContractAccessoryChangePO();
        deleteContractAccessoryPo.setRelateId(updateApplyId);
        deleteContractAccessoryPo.setRelateCode(updateApplyCode);
        deleteContractAccessoryPo.setRelateType(1);
        this.cContractAccessoryChangeMapper.deleteByCondition(deleteContractAccessoryPo);
        if (!CollectionUtils.isEmpty(reqBO.getContractAcceessoryList())) {
            this.addContractAccessoryInfo(reqBO, resultMap);
        }
    }

    private void addContractAccessoryInfo(ContractAddModApplyBusiReqBO reqBO, Map<String, Object> resultMap) {
        String jsonString = JSON.toJSONString(reqBO.getContractAcceessoryList());
        Long updateApplyId = (Long)resultMap.get(FIELD_CONTRACT_MOD_ID);
        String updateApplyCode = (String)resultMap.get(FIELD_CONTRACT_MOD_CODE);
        List list = JSONArray.parseArray((String)jsonString).toJavaList(CContractAccessoryChangePO.class);
        for (CContractAccessoryChangePO contractAccessoryPo : list) {
            contractAccessoryPo.setAcceessoryId(Sequence.getInstance().nextId());
            contractAccessoryPo.setRelateId(updateApplyId);
            contractAccessoryPo.setRelateCode(updateApplyCode);
            contractAccessoryPo.setCreateUserId(reqBO.getUserId());
            contractAccessoryPo.setCreateUserName(reqBO.getName());
            contractAccessoryPo.setCreateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
        }
        int result = this.cContractAccessoryChangeMapper.insertBatch(list);
        if (result < 1) {
            throw new ZTBusinessException("\u5408\u540c\u9644\u4ef6\u6570\u636e\u65b0\u589e\u5931\u8d25");
        }
    }

    private void updateContractAccessoryInfo(ContractAddModApplyBusiReqBO reqBO, Map<String, Object> resultMap) {
        Long contratId = (Long)resultMap.get(FIELD_CONTRACT_ID);
        String contractCode = (String)resultMap.get(FIELD_CONTRACT_CODE);
        ContractAccessoryPo deleteContractAccessoryPo = new ContractAccessoryPo();
        deleteContractAccessoryPo.setRelateId(contratId);
        deleteContractAccessoryPo.setRelateCode(contractCode);
        this.contractAccessoryMapper.deleteByCondition(deleteContractAccessoryPo);
        if (!CollectionUtils.isEmpty(reqBO.getContractAcceessoryList())) {
            this.addContractAccessoryInfo(reqBO, resultMap);
        }
    }

    private void saveContractLawInfo(ContractAddModApplyBusiReqBO reqBO, Map<String, Object> resultMap) {
        CContractLawInfoChangePO qryContractLawInfoPO = new CContractLawInfoChangePO();
        Long updateApplyId = (Long)resultMap.get(FIELD_CONTRACT_MOD_ID);
        String updateApplyCode = (String)resultMap.get(FIELD_CONTRACT_MOD_CODE);
        qryContractLawInfoPO.setRelateId(updateApplyId);
        qryContractLawInfoPO.setRelateCode(updateApplyCode);
        CContractLawInfoChangePO oldLawInfo = this.cContractLawInfoChangeMapper.getModelBy(qryContractLawInfoPO);
        if (ObjectUtils.isEmpty((Object)oldLawInfo)) {
            this.addContractLawInfo(reqBO, resultMap);
            return;
        }
        this.updateContractLawInfo(reqBO, resultMap);
    }

    private void addContractLawInfo(ContractAddModApplyBusiReqBO reqBO, Map<String, Object> resultMap) {
        Long updateApplyId = (Long)resultMap.get(FIELD_CONTRACT_MOD_ID);
        String updateApplyCode = (String)resultMap.get(FIELD_CONTRACT_MOD_CODE);
        String jsonStr = JSON.toJSONString((Object)reqBO.getContractLawInfo());
        CContractLawInfoChangePO contractLawInfoPo = (CContractLawInfoChangePO)JSON.parseObject((String)jsonStr, CContractLawInfoChangePO.class);
        contractLawInfoPo.setLawContractId(Sequence.getInstance().nextId());
        contractLawInfoPo.setRelateId(updateApplyId);
        contractLawInfoPo.setRelateCode(updateApplyCode);
        contractLawInfoPo.setCreateUserId(reqBO.getUserId());
        contractLawInfoPo.setCreateUserName(reqBO.getName());
        contractLawInfoPo.setCreateTime(new Date());
        int result = this.cContractLawInfoChangeMapper.insert(contractLawInfoPo);
        if (result < 1) {
            throw new ZTBusinessException("\u6cd5\u52a1\u7cfb\u7edf\u5408\u540c\u4fe1\u606f\u65b0\u589e\u5931\u8d25");
        }
    }

    private void updateContractLawInfo(ContractAddModApplyBusiReqBO reqBO, Map<String, Object> resultMap) {
        if (ObjectUtil.isEmpty((Object)reqBO.getContractLawInfo())) {
            return;
        }
        Long updateApplyId = (Long)resultMap.get(FIELD_CONTRACT_MOD_ID);
        String updateApplyCode = (String)resultMap.get(FIELD_CONTRACT_MOD_CODE);
        CContractLawInfoChangePO updateLawInfoPo = new CContractLawInfoChangePO();
        BeanUtils.copyProperties((Object)reqBO.getContractLawInfo(), (Object)updateLawInfoPo);
        updateLawInfoPo.setUpdateUserId(reqBO.getUserId());
        updateLawInfoPo.setUpdateUserName(reqBO.getName());
        updateLawInfoPo.setUpdateTime(new Date());
        CContractLawInfoChangePO whereLawInfoPo = new CContractLawInfoChangePO();
        whereLawInfoPo.setRelateId(updateApplyId);
        whereLawInfoPo.setRelateCode(updateApplyCode);
        int updateResult = this.cContractLawInfoChangeMapper.updateBy(updateLawInfoPo, whereLawInfoPo);
        if (updateResult != 1) {
            throw new ZTBusinessException("\u66f4\u65b0\u5408\u540c\u6570\u636e\u5931\u8d25");
        }
    }

    private void saveContractCooperationInfo(ContractAddModApplyBusiReqBO reqBO, Map<String, Object> resultMap) {
        if (ObjectUtil.isEmpty((Object)reqBO.getContractCooperationInfo())) {
            return;
        }
        Long updateApplyId = (Long)resultMap.get(FIELD_CONTRACT_MOD_ID);
        String updateApplyCode = (String)resultMap.get(FIELD_CONTRACT_MOD_CODE);
        CContractCooperationInfoChangePO qryCooperInfo = new CContractCooperationInfoChangePO();
        qryCooperInfo.setRelateId(updateApplyId);
        qryCooperInfo.setRelateCode(updateApplyCode);
        CContractCooperationInfoChangePO oldCooperInfo = this.cContractCooperationInfoChangeMapper.getModelBy(qryCooperInfo);
        if (ObjectUtils.isEmpty((Object)oldCooperInfo)) {
            this.addContractCooperationInfo(reqBO, resultMap);
            return;
        }
        this.updateContractCooperationInfo(reqBO, resultMap);
    }

    private void addContractCooperationInfo(ContractAddModApplyBusiReqBO reqBO, Map<String, Object> resultMap) {
        Long updateApplyId = (Long)resultMap.get(FIELD_CONTRACT_MOD_ID);
        String updateApplyCode = (String)resultMap.get(FIELD_CONTRACT_MOD_CODE);
        String jsonStr = JSON.toJSONString((Object)reqBO.getContractCooperationInfo());
        CContractCooperationInfoChangePO contractCooperationInfoPo = (CContractCooperationInfoChangePO)JSON.parseObject((String)jsonStr, CContractCooperationInfoChangePO.class);
        contractCooperationInfoPo.setCooperationContractId(Sequence.getInstance().nextId());
        contractCooperationInfoPo.setRelateId(updateApplyId);
        contractCooperationInfoPo.setRelateCode(updateApplyCode);
        contractCooperationInfoPo.setCreateUserName(reqBO.getName());
        contractCooperationInfoPo.setCreateTime(new Date());
        contractCooperationInfoPo.setUpdateUserId(reqBO.getUserId());
        contractCooperationInfoPo.setUpdateUserName(reqBO.getName());
        contractCooperationInfoPo.setUpdateTime(new Date());
        contractCooperationInfoPo.setTaxPointS(CollectionUtils.isEmpty((Collection)reqBO.getContractCooperationInfo().getTaxPointList()) ? "" : String.join((CharSequence)",", reqBO.getContractCooperationInfo().getTaxPointList()));
        if (Objects.equals(reqBO.getContractType(), ContractConstant.ZYCMContractType.UNIT_AGREE_CONTRACT_TYPE)) {
            contractCooperationInfoPo.setTaxPointS(CollectionUtils.isEmpty((Collection)reqBO.getContractCooperationInfo().getTaxPointList()) ? "" : String.join((CharSequence)",", reqBO.getContractCooperationInfo().getTaxPointList()));
        } else if (Objects.equals(reqBO.getContractType(), ContractConstant.ZYCMContractType.PLATFORM_AGREE_CONTRACT_TYPE)) {
            contractCooperationInfoPo.setTaxPointS(CollectionUtils.isEmpty((Collection)reqBO.getContractCooperationInfo().getTaxPointList()) ? "" : String.join((CharSequence)",", reqBO.getContractCooperationInfo().getTaxPointList()));
        } else if (!Objects.equals(reqBO.getContractType(), ContractConstant.ZYCMContractType.ORDER_CONTRACT_TYPE) && !Objects.equals(reqBO.getContractType(), ContractConstant.ZYCMContractType.ORDER_CONTRACT_SERVICE_TYPE) && Objects.equals(reqBO.getContractType(), ContractConstant.ZYCMContractType.NON_STANDARD_CONTRACT_TYPE)) {
            contractCooperationInfoPo.setTaxPointS(CollectionUtils.isEmpty((Collection)reqBO.getContractCooperationInfo().getTaxPointList()) ? "" : String.join((CharSequence)",", reqBO.getContractCooperationInfo().getTaxPointList()));
        }
        int result = this.cContractCooperationInfoChangeMapper.insert(contractCooperationInfoPo);
        if (result < 1) {
            throw new ZTBusinessException("\u5408\u540c\u5408\u4f5c\u4fe1\u606f\u65b0\u589e\u5931\u8d25");
        }
        if (!CollectionUtils.isEmpty((Collection)reqBO.getContractCooperationInfo().getCooperationCategoryList())) {
            for (ContractCooperationCategoryBO cooperationCategoryBO : reqBO.getContractCooperationInfo().getCooperationCategoryList()) {
                CContractCooperationCategoryChangePO cooperationCategoryPo = new CContractCooperationCategoryChangePO();
                BeanUtils.copyProperties((Object)cooperationCategoryBO, (Object)cooperationCategoryPo);
                cooperationCategoryPo.setCooperationCategoryId(Sequence.getInstance().nextId());
                cooperationCategoryPo.setRelateId(updateApplyId);
                cooperationCategoryPo.setRelateCode(updateApplyCode);
                cooperationCategoryPo.setCreateUserName(reqBO.getName());
                cooperationCategoryPo.setCreateTime(new Date());
                int cooperationCategoryResult = this.cContractCooperationCategoryChangeMapper.insert(cooperationCategoryPo);
                if (cooperationCategoryResult >= 1) continue;
                throw new ZTBusinessException("\u53cc\u65b9\u5408\u4f5c\u54c1\u7c7b\u65b0\u589e\u5931\u8d25");
            }
        }
    }

    private void updateContractCooperationInfo(ContractAddModApplyBusiReqBO reqBO, Map<String, Object> resultMap) {
        if (ObjectUtil.isEmpty((Object)reqBO.getContractCooperationInfo())) {
            return;
        }
        Long updateApplyId = (Long)resultMap.get(FIELD_CONTRACT_MOD_ID);
        String updateApplyCode = (String)resultMap.get(FIELD_CONTRACT_MOD_CODE);
        CContractCooperationInfoChangePO updateCooperationInfoPo = new CContractCooperationInfoChangePO();
        BeanUtils.copyProperties((Object)reqBO.getContractCooperationInfo(), (Object)updateCooperationInfoPo);
        updateCooperationInfoPo.setServicePayRatio(reqBO.getContractCooperationInfo().getServicePayRatio());
        updateCooperationInfoPo.setUpdateUserId(reqBO.getUserId());
        updateCooperationInfoPo.setUpdateUserName(reqBO.getName());
        updateCooperationInfoPo.setUpdateTime(new Date());
        updateCooperationInfoPo.setTaxPointS(CollectionUtils.isEmpty((Collection)reqBO.getContractCooperationInfo().getTaxPointList()) ? "" : String.join((CharSequence)",", reqBO.getContractCooperationInfo().getTaxPointList()));
        CContractCooperationInfoChangePO whereCooperationInfoPo = new CContractCooperationInfoChangePO();
        whereCooperationInfoPo.setRelateId(updateApplyId);
        whereCooperationInfoPo.setRelateCode(updateApplyCode);
        int updateResult = this.cContractCooperationInfoChangeMapper.updateBy(updateCooperationInfoPo, whereCooperationInfoPo);
        if (updateResult <= 0) {
            throw new ZTBusinessException("\u66f4\u65b0\u5408\u540c\u5408\u4f5c\u65b9\u4fe1\u606f\u5931\u8d25");
        }
        if (!CollectionUtils.isEmpty((Collection)reqBO.getContractCooperationInfo().getCooperationCategoryList())) {
            CContractCooperationCategoryChangePO whereCooperationCategoryPo = new CContractCooperationCategoryChangePO();
            whereCooperationCategoryPo.setRelateId(updateApplyId);
            this.cContractCooperationCategoryChangeMapper.deleteBy(whereCooperationCategoryPo);
            for (ContractCooperationCategoryBO cooperationCategoryBO : reqBO.getContractCooperationInfo().getCooperationCategoryList()) {
                CContractCooperationCategoryChangePO cooperationCategoryPo = new CContractCooperationCategoryChangePO();
                BeanUtils.copyProperties((Object)cooperationCategoryBO, (Object)cooperationCategoryPo);
                cooperationCategoryPo.setCooperationCategoryId(Sequence.getInstance().nextId());
                cooperationCategoryPo.setRelateId(updateApplyId);
                cooperationCategoryPo.setRelateCode(updateApplyCode);
                updateCooperationInfoPo.setServicePayRatio(reqBO.getContractCooperationInfo().getServicePayRatio());
                cooperationCategoryPo.setCreateUserName(reqBO.getName());
                cooperationCategoryPo.setCreateTime(new Date());
                int cooperationCategoryResult = this.cContractCooperationCategoryChangeMapper.insert(cooperationCategoryPo);
                if (cooperationCategoryResult >= 1) continue;
                throw new ZTBusinessException("\u53cc\u65b9\u5408\u4f5c\u54c1\u7c7b\u65b0\u589e\u5931\u8d25");
            }
        }
    }

    private void addContractModApplyAccessoryInfo(Long aLong, ContractAddModApplyBusiReqBO reqBO) {
        String jsonString = JSON.toJSONString(reqBO.getUpdateAcceessoryList());
        List list = JSONArray.parseArray((String)jsonString).toJavaList(ContractAccessoryPo.class);
        for (ContractAccessoryPo contractAccessoryPo : list) {
            contractAccessoryPo.setAcceessoryId(Sequence.getInstance().nextId());
            contractAccessoryPo.setRelateId(aLong);
            contractAccessoryPo.setRelateCode(reqBO.getUpdateApplyCode());
            contractAccessoryPo.setCreateUserId(reqBO.getUserId());
            contractAccessoryPo.setCreateUserName(reqBO.getName());
            contractAccessoryPo.setCreateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
            contractAccessoryPo.setAcceessoryType(2);
            contractAccessoryPo.setRelateType(2);
        }
        int result = this.contractAccessoryMapper.insertBatch(list);
        if (result < 1) {
            throw new ZTBusinessException("\u53d8\u66f4\u5408\u540c\u9644\u4ef6\u6570\u636e\u65b0\u589e\u5931\u8d25");
        }
    }

    private Map<String, Object> updateContractModApplyInfo(ContractAddModApplyBusiReqBO reqBO) {
        int updateResult;
        ContractModifyApplyPo oldContractModifyApplyPo = this.contractModifyApplyMapper.selectByPrimaryKey(reqBO.getUpdateApplyId());
        if (ObjectUtils.isEmpty((Object)oldContractModifyApplyPo)) {
            throw new ZTBusinessException("\u4fee\u6539\u7684\u53d8\u66f4\u4fe1\u606f\u5355\u4e0d\u5b58\u5728");
        }
        ContractModifyApplyPo updateContractModifyApplyPo = new ContractModifyApplyPo();
        BeanUtils.copyProperties((Object)oldContractModifyApplyPo, (Object)updateContractModifyApplyPo);
        BeanUtils.copyProperties((Object)((Object)reqBO), (Object)updateContractModifyApplyPo);
        updateContractModifyApplyPo.setBussNode(reqBO.getBussNode());
        updateContractModifyApplyPo.setCreateDeptName(oldContractModifyApplyPo.getCreateDeptName());
        updateContractModifyApplyPo.setCreateDeptId(oldContractModifyApplyPo.getCreateDeptId());
        updateContractModifyApplyPo.setContractSignDate(DateTimeUtils.Date2String(updateContractModifyApplyPo.getContractSignDate()));
        updateContractModifyApplyPo.setContractEndDate(DateTimeUtils.Date2String(updateContractModifyApplyPo.getContractEndDate()));
        updateContractModifyApplyPo.setModifyStatus(ContractConstant.ModifyStatus.MODIFY_STATUS_DRAFT);
        if ("2".equals(reqBO.getOperType())) {
            updateContractModifyApplyPo.setModifyStatus(ContractConstant.ModifyStatus.MODIFY_STATUS_EXAMINE);
        }
        if ((updateResult = this.contractModifyApplyMapper.updateByPrimaryKeySelective(updateContractModifyApplyPo)) != 1) {
            throw new ZTBusinessException("\u66f4\u65b0\u5408\u540c\u53d8\u66f4\u6570\u636e\u5931\u8d25");
        }
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put(FIELD_CONTRACT_MOD_ID, reqBO.getUpdateApplyId());
        resultMap.put(FIELD_CONTRACT_MOD_CODE, reqBO.getUpdateApplyCode());
        return resultMap;
    }
}

