/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.contract.busi.ContractAddPayPlanBusiService;
import com.tydic.contract.busi.bo.ContractAddPayPlanBusiReqBO;
import com.tydic.contract.busi.bo.ContractAddPayPlanBusiRspBO;
import com.tydic.contract.dao.CContractPayPlanChangeMapper;
import com.tydic.contract.dao.CContractPayPlanMapper;
import com.tydic.contract.po.CContractPayPlanChangePO;
import com.tydic.contract.po.CContractPayPlanPO;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
public class ContractAddPayPlanBusiServiceImpl
implements ContractAddPayPlanBusiService {
    private static final Logger log = LoggerFactory.getLogger(ContractAddPayPlanBusiServiceImpl.class);
    @Autowired
    private CContractPayPlanMapper contractPayPlanMapper;
    @Autowired
    private CContractPayPlanChangeMapper cContractPayPlanChangeMapper;

    @Override
    public ContractAddPayPlanBusiRspBO addContractPayPlan(ContractAddPayPlanBusiReqBO reqBO) {
        int insert;
        CContractPayPlanPO contractPayPlanPo;
        String jsonStr;
        ContractAddPayPlanBusiRspBO rspBO = new ContractAddPayPlanBusiRspBO();
        if (ObjectUtils.isEmpty((Object)reqBO)) {
            return rspBO;
        }
        if ("0".equals(reqBO.getOperType())) {
            jsonStr = JSON.toJSONString((Object)reqBO);
            contractPayPlanPo = (CContractPayPlanPO)JSONArray.parseObject((String)jsonStr, CContractPayPlanPO.class);
            contractPayPlanPo.setPayPlanId(Sequence.getInstance().nextId());
            contractPayPlanPo.setRelateId(reqBO.getContractId());
            contractPayPlanPo.setRelateCode(reqBO.getContractCode());
            contractPayPlanPo.setCreateUserName(reqBO.getUserName());
            contractPayPlanPo.setCreateTime(new Date());
            try {
                this.checkPayRatio(contractPayPlanPo);
            }
            catch (Exception e) {
                rspBO.setRespCode("9999");
                rspBO.setRespDesc(e.getMessage());
                return rspBO;
            }
            if (!ObjectUtils.isEmpty((Object)reqBO.getUpdateApplyId())) {
                CContractPayPlanChangePO insContractPayPlanChangePO = new CContractPayPlanChangePO();
                BeanUtils.copyProperties((Object)contractPayPlanPo, (Object)insContractPayPlanChangePO);
                insContractPayPlanChangePO.setRelateCode(reqBO.getUpdateApplyCode());
                insContractPayPlanChangePO.setRelateId(reqBO.getUpdateApplyId());
                insert = this.cContractPayPlanChangeMapper.insert(insContractPayPlanChangePO);
                if (insert < 1) {
                    throw new ZTBusinessException("\u5408\u540c\u4ed8\u6b3e\u8ba1\u5212\u65b0\u589e\u5931\u8d25");
                }
            } else {
                int result = this.contractPayPlanMapper.insert(contractPayPlanPo);
                if (result < 1) {
                    throw new ZTBusinessException("\u5408\u540c\u4ed8\u6b3e\u8ba1\u5212\u65b0\u589e\u5931\u8d25");
                }
            }
            rspBO.setPayPlanId(contractPayPlanPo.getPayPlanId());
        }
        if ("1".equals(reqBO.getOperType())) {
            jsonStr = JSON.toJSONString((Object)reqBO);
            contractPayPlanPo = (CContractPayPlanPO)JSONArray.parseObject((String)jsonStr, CContractPayPlanPO.class);
            contractPayPlanPo.setUpdateUserName(reqBO.getUserName());
            contractPayPlanPo.setUpdateTime(new Date());
            try {
                this.checkPayRatio(contractPayPlanPo);
            }
            catch (Exception e) {
                rspBO.setRespCode("9999");
                rspBO.setRespDesc(e.getMessage());
                return rspBO;
            }
            if (!ObjectUtils.isEmpty((Object)reqBO.getUpdateApplyId())) {
                CContractPayPlanChangePO updContractPayPlanChangePO = new CContractPayPlanChangePO();
                BeanUtils.copyProperties((Object)contractPayPlanPo, (Object)updContractPayPlanChangePO);
                insert = this.cContractPayPlanChangeMapper.updateById(updContractPayPlanChangePO);
                if (insert < 1) {
                    throw new ZTBusinessException("\u5408\u540c\u4ed8\u6b3e\u8ba1\u5212\u4fdd\u5b58\u5931\u8d25");
                }
            } else {
                int result = this.contractPayPlanMapper.updateById(contractPayPlanPo);
                if (result < 1) {
                    throw new ZTBusinessException("\u5408\u540c\u4ed8\u6b3e\u8ba1\u5212\u4fdd\u5b58\u5931\u8d25");
                }
            }
            rspBO.setPayPlanId(contractPayPlanPo.getPayPlanId());
        }
        if ("3".equals(reqBO.getOperType())) {
            CContractPayPlanPO contractPayPlanPo2 = new CContractPayPlanPO();
            if (ObjectUtils.isEmpty((Object)reqBO.getPayPlanId())) {
                throw new ZTBusinessException("\u5408\u540c\u4ed8\u6b3e\u8ba1\u5212\u5220\u9664\u5931\u8d25");
            }
            contractPayPlanPo2.setPayPlanId(reqBO.getPayPlanId());
            if (!ObjectUtils.isEmpty((Object)reqBO.getUpdateApplyId())) {
                CContractPayPlanChangePO delContractPayPlanChangePO = new CContractPayPlanChangePO();
                BeanUtils.copyProperties((Object)contractPayPlanPo2, (Object)delContractPayPlanChangePO);
                int del = this.cContractPayPlanChangeMapper.deleteBy(delContractPayPlanChangePO);
                if (del < 1) {
                    throw new ZTBusinessException("\u5408\u540c\u4ed8\u6b3e\u8ba1\u5212\u5220\u9664\u5931\u8d25");
                }
            } else if (this.contractPayPlanMapper.deleteBy(contractPayPlanPo2) < 1) {
                throw new ZTBusinessException("\u5408\u540c\u4ed8\u6b3e\u8ba1\u5212\u5220\u9664\u5931\u8d25");
            }
            rspBO.setPayPlanId(contractPayPlanPo2.getPayPlanId());
        }
        return rspBO;
    }

    private void checkPayRatio(CContractPayPlanPO contractPayPlanPo) {
        Optional<BigDecimal> reduce;
        CContractPayPlanPO cContractPayPlanPo = new CContractPayPlanPO();
        cContractPayPlanPo.setRelateId(contractPayPlanPo.getRelateId());
        if (contractPayPlanPo.getPayRatio().compareTo(BigDecimal.ONE) > 0) {
            throw new ZTBusinessException("\u652f\u4ed8\u6bd4\u4f8b\u4e0d\u80fd\u5927\u4e8e100%");
        }
        List<CContractPayPlanPO> list = this.contractPayPlanMapper.getList(cContractPayPlanPo);
        if (!CollectionUtils.isEmpty(list) && (reduce = list.stream().map(CContractPayPlanPO::getPayRatio).reduce(BigDecimal::add)).get().add(contractPayPlanPo.getPayRatio()).compareTo(BigDecimal.ONE) > 0) {
            throw new ZTBusinessException("\u652f\u4ed8\u6bd4\u4f8b\u603b\u8ba1\u4e0d\u80fd\u5927\u4e8e100%");
        }
    }
}

