/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.busi.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.contract.busi.ContractCopyBusiService;
import com.tydic.contract.busi.bo.ContractCopyBusiReqBO;
import com.tydic.contract.busi.bo.ContractCopyBusiRspBO;
import com.tydic.contract.constant.ContractConstant;
import com.tydic.contract.dao.CContractCooperationCategoryMapper;
import com.tydic.contract.dao.CContractCooperationInfoMapper;
import com.tydic.contract.dao.CContractLawInfoMapper;
import com.tydic.contract.dao.CContractPayPlanMapper;
import com.tydic.contract.dao.ContractItemMapper;
import com.tydic.contract.dao.ContractMapper;
import com.tydic.contract.po.CContractCooperationCategoryPO;
import com.tydic.contract.po.CContractCooperationInfoPO;
import com.tydic.contract.po.CContractLawInfoPO;
import com.tydic.contract.po.CContractPayPlanPO;
import com.tydic.contract.po.ContractItemPo;
import com.tydic.contract.po.ContractPo;
import com.tydic.plugin.encoded.service.CfcEncodedSerialGetService;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialGetServiceReqBO;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialGetServiceRspBO;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
public class ContractCopyBusiServiceImpl
implements ContractCopyBusiService {
    private static final Logger log = LoggerFactory.getLogger(ContractCopyBusiServiceImpl.class);
    @Autowired
    private CfcEncodedSerialGetService encodedSerialGetService;
    @Autowired
    private ContractMapper contractMapper;
    @Autowired
    private ContractItemMapper contractItemMapper;
    @Autowired
    private CContractCooperationInfoMapper contractCooperationInfoMapper;
    @Autowired
    private CContractCooperationCategoryMapper contractCooperationCategoryMapper;
    @Autowired
    private CContractLawInfoMapper contractLawInfoMapper;
    @Autowired
    private CContractPayPlanMapper contractPayPlanMapper;

    @Override
    public ContractCopyBusiRspBO copyContract(ContractCopyBusiReqBO reqBO) {
        ContractPo contractPo;
        ContractCopyBusiRspBO rspBO = new ContractCopyBusiRspBO();
        if (ObjectUtils.isEmpty((Object)reqBO) || reqBO.getContractId() == null) {
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u53c2\u6570\u4e3a\u7a7a\u6216\u8005\u590d\u5236\u7684\u5408\u540cid\u4e3a\u7a7a");
            return rspBO;
        }
        if (Objects.equals(ContractConstant.FeeType.PAY_CONTRACT_CODE, reqBO.getFeeType())) {
            if (ObjectUtils.isEmpty((Object)reqBO.getPurchaseDemandPlanId())) {
                rspBO.setRespCode("9999");
                rspBO.setRespDesc("\u8bf7\u9009\u62e9\u6b63\u786e\u7684\u65b9\u6848");
                return rspBO;
            }
            if (!Objects.equals(reqBO.getDemandGoodsType(), 0)) {
                rspBO.setRespCode("9999");
                rspBO.setRespDesc("\u5c55\u4e0d\u652f\u6301\u7684\u9700\u6c42\u5546\u54c1\u7c7b\u578b\u65b9\u6848\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\uff01");
                return rspBO;
            }
        }
        if ((contractPo = this.contractMapper.selectByPrimaryKey(reqBO.getContractId())) == null) {
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u5408\u540c\u4e0d\u5b58\u5728");
            return rspBO;
        }
        Long oldContractId = contractPo.getContractId();
        Long newContractId = Sequence.getInstance().nextId();
        contractPo.setContractCode(this.generateCode());
        contractPo.setContractId(newContractId);
        contractPo.setPurchaseDemandPlanId(reqBO.getPurchaseDemandPlanId());
        contractPo.setCreateUserId(reqBO.getUserId());
        contractPo.setCreateUserName(reqBO.getName());
        contractPo.setCreateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
        contractPo.setUpdateUserId(reqBO.getUserId());
        contractPo.setUpdateUserName(reqBO.getUserName());
        contractPo.setUpdateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
        contractPo.setContractStatus(ContractConstant.ContractStatus.CONTRACT_STATUS_DRAFT);
        int addContractResult = this.contractMapper.insertSelective(contractPo);
        if (addContractResult <= 0) {
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u590d\u5236\u5931\u8d25");
            return rspBO;
        }
        this.copyContractItem(oldContractId, contractPo, reqBO);
        this.copyContractLawInfo(oldContractId, contractPo, reqBO);
        this.copyContractCooperationInfo(oldContractId, contractPo, reqBO);
        this.copyContractPayPlan(oldContractId, contractPo, reqBO);
        if (Objects.equals(ContractConstant.FeeType.PAY_CONTRACT_CODE, reqBO.getFeeType())) {
            this.updatePurchaseDemandPlan(reqBO);
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u590d\u5236\u6210\u529f");
        rspBO.setContractId(newContractId);
        rspBO.setContractCode(contractPo.getContractCode());
        return rspBO;
    }

    private void copyContractPayPlan(Long oldContractId, ContractPo contractPo, ContractCopyBusiReqBO reqBO) {
        CContractPayPlanPO payPlanPO = new CContractPayPlanPO();
        payPlanPO.setRelateId(oldContractId);
        List<CContractPayPlanPO> payPlanPOS = this.contractPayPlanMapper.getList(payPlanPO);
        if (!CollectionUtils.isEmpty(payPlanPOS)) {
            for (CContractPayPlanPO payPlanPO1 : payPlanPOS) {
                CContractPayPlanPO newPayPlanPO = new CContractPayPlanPO();
                BeanUtils.copyProperties((Object)payPlanPO1, (Object)newPayPlanPO);
                newPayPlanPO.setPayPlanId(Sequence.getInstance().nextId());
                newPayPlanPO.setRelateId(contractPo.getContractId());
                newPayPlanPO.setRelateCode(contractPo.getContractCode());
                this.contractPayPlanMapper.insert(newPayPlanPO);
            }
        }
    }

    private void copyContractCooperationInfo(Long oldContractId, ContractPo contractPo, ContractCopyBusiReqBO reqBO) {
        CContractCooperationInfoPO cooperationInfoPO = new CContractCooperationInfoPO();
        cooperationInfoPO.setRelateId(oldContractId);
        List<CContractCooperationInfoPO> list = this.contractCooperationInfoMapper.getList(cooperationInfoPO);
        if (!CollectionUtils.isEmpty(list)) {
            for (CContractCooperationInfoPO cooperationInfoPO1 : list) {
                CContractCooperationInfoPO newCooperationInfoPO = new CContractCooperationInfoPO();
                BeanUtils.copyProperties((Object)cooperationInfoPO1, (Object)newCooperationInfoPO);
                newCooperationInfoPO.setCooperationContractId(Sequence.getInstance().nextId());
                newCooperationInfoPO.setRelateId(contractPo.getContractId());
                newCooperationInfoPO.setRelateCode(contractPo.getContractCode());
                this.contractCooperationInfoMapper.insert(newCooperationInfoPO);
                this.copyCategoryInfo(oldContractId, contractPo.getContractId());
            }
        }
    }

    private void copyContractLawInfo(Long oldContractId, ContractPo contractPo, ContractCopyBusiReqBO reqBO) {
        CContractLawInfoPO lawInfo = new CContractLawInfoPO();
        lawInfo.setRelateId(oldContractId);
        List<CContractLawInfoPO> contractLawInfoPOS = this.contractLawInfoMapper.getList(lawInfo);
        if (!CollectionUtils.isEmpty(contractLawInfoPOS)) {
            for (CContractLawInfoPO lawInfoPO : contractLawInfoPOS) {
                CContractLawInfoPO newLawInfoPO = new CContractLawInfoPO();
                BeanUtils.copyProperties((Object)lawInfoPO, (Object)newLawInfoPO);
                newLawInfoPO.setLawContractId(Sequence.getInstance().nextId());
                newLawInfoPO.setRelateId(contractPo.getContractId());
                newLawInfoPO.setRelateCode(contractPo.getContractCode());
                this.contractLawInfoMapper.insert(newLawInfoPO);
            }
        }
    }

    public String generateCode() {
        CfcEncodedSerialGetServiceReqBO encodedSerialGetServiceReqBO = new CfcEncodedSerialGetServiceReqBO();
        encodedSerialGetServiceReqBO.setCenter("CONTRACT");
        encodedSerialGetServiceReqBO.setEncodedRuleCode("AGREE_CONTRACT_CODE");
        CfcEncodedSerialGetServiceRspBO encodedSerial = this.encodedSerialGetService.getEncodedSerial(encodedSerialGetServiceReqBO);
        return (String)encodedSerial.getSerialNoList().get(0);
    }

    public void copyContractItem(Long oldContractId, ContractPo contractPo, ContractCopyBusiReqBO reqBO) {
        List<ContractItemPo> contractItemPos = this.contractItemMapper.selectByRelateId(oldContractId);
        if (!CollectionUtils.isEmpty(contractItemPos)) {
            for (ContractItemPo itemPo : contractItemPos) {
                ContractItemPo newItemPo = new ContractItemPo();
                BeanUtils.copyProperties((Object)itemPo, (Object)newItemPo);
                newItemPo.setItemId(Sequence.getInstance().nextId());
                newItemPo.setRelateId(contractPo.getContractId());
                newItemPo.setRelateCode(contractPo.getContractCode());
                newItemPo.setCreateUserId(reqBO.getUserId());
                newItemPo.setCreateUserName(reqBO.getName());
                newItemPo.setCreateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
                this.contractItemMapper.insert(newItemPo);
                this.copyCategoryInfo(itemPo.getItemId(), newItemPo.getItemId());
            }
        }
    }

    public void copyCategoryInfo(Long oldRelateId, Long newRelateId) {
        CContractCooperationCategoryPO cContractCooperationCategoryPO = new CContractCooperationCategoryPO();
        cContractCooperationCategoryPO.setRelateId(oldRelateId);
        List<CContractCooperationCategoryPO> categoryPOList = this.contractCooperationCategoryMapper.getList(cContractCooperationCategoryPO);
        if (!CollectionUtils.isEmpty(categoryPOList)) {
            categoryPOList.forEach(categoryPO -> {
                CContractCooperationCategoryPO newCategoryPO = new CContractCooperationCategoryPO();
                BeanUtils.copyProperties((Object)categoryPO, (Object)newCategoryPO);
                newCategoryPO.setRelateId(newRelateId);
                newCategoryPO.setCooperationCategoryId(Sequence.getInstance().nextId());
                this.contractCooperationCategoryMapper.insert(newCategoryPO);
            });
        }
    }

    private void updatePurchaseDemandPlan(ContractCopyBusiReqBO reqBO) {
        if (reqBO.getPurchaseDemandPlanId() == null) {
            throw new ZTBusinessException("\u91c7\u8d2d\u9700\u6c42\u8ba1\u5212id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.contractMapper.updatePurchasePlanIsCreateContract(reqBO.getPurchaseDemandPlanId(), 1);
    }
}

