/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.busi.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.contract.busi.ContractDeleteBusiService;
import com.tydic.contract.busi.bo.ContractDeleteBusiReqBO;
import com.tydic.contract.busi.bo.ContractDeleteBusiRspBO;
import com.tydic.contract.constant.ContractConstant;
import com.tydic.contract.dao.ContractAccessoryMapper;
import com.tydic.contract.dao.ContractItemMapper;
import com.tydic.contract.dao.ContractLadderRateMapper;
import com.tydic.contract.dao.ContractMapper;
import com.tydic.contract.dao.ContractOrderMapper;
import com.tydic.contract.dao.ContractPayTypeMapper;
import com.tydic.contract.dao.ContractSaleCategoryRateMapper;
import com.tydic.contract.po.ContractAccessoryPo;
import com.tydic.contract.po.ContractItemPo;
import com.tydic.contract.po.ContractPo;
import com.tydic.ppc.busi.api.CalibrationItemUpdateContractInfoBusiService;
import com.tydic.ppc.busi.bo.CalibrationItemUpdateContractInfoBusiReqBO;
import com.tydic.ppc.busi.bo.CalibrationItemUpdateContractInfoBusiRspBO;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
public class ContractDeleteBusiServiceImpl
implements ContractDeleteBusiService {
    private static final Logger log = LoggerFactory.getLogger(ContractDeleteBusiServiceImpl.class);
    @Autowired
    private ContractMapper contractMapper;
    @Autowired
    private ContractOrderMapper contractOrderMapper;
    @Autowired
    private ContractAccessoryMapper contractAccessoryMapper;
    @Autowired
    private ContractPayTypeMapper contractPayTypeMapper;
    @Autowired
    private ContractItemMapper contractItemMapper;
    @Autowired
    private ContractSaleCategoryRateMapper contractSaleCategoryRateMapper;
    @Autowired
    private ContractLadderRateMapper contractLadderRateMapper;
    @Autowired
    private CalibrationItemUpdateContractInfoBusiService calibrationItemUpdateContractInfoBusiService;

    @Override
    public ContractDeleteBusiRspBO deleteContract(ContractDeleteBusiReqBO reqBO) {
        ContractDeleteBusiRspBO rspBO = new ContractDeleteBusiRspBO();
        List<ContractPo> contractPos = this.contractMapper.qryByContractIdList(reqBO.getContractIdList());
        ContractPo contractPo1 = this.contractMapper.selectByPrimaryKey(reqBO.getContractId());
        if (!ObjectUtils.isEmpty((Object)contractPo1)) {
            Long signContractId = this.getSignContractId(reqBO);
            this.deleteAssociateData(contractPo1);
            if (!Objects.equals(ContractConstant.RelateContractType.RENEW_CONTRACT, reqBO.getRelateType())) {
                this.deleteCalibrationInfo(reqBO);
            }
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u5408\u540c\u5220\u9664\u6210\u529f");
            rspBO.setSignContractId(signContractId);
            return rspBO;
        }
        rspBO.setRespCode("1009");
        rspBO.setRespDesc("\u5408\u540c\u5220\u9664-\u6839\u636e\u5165\u53c2\u6ca1\u6709\u67e5\u5230\u76f8\u5e94\u7684\u5408\u540c\u4fe1\u606f");
        return rspBO;
    }

    private Long getSignContractId(ContractDeleteBusiReqBO reqBO) {
        Long contractId = reqBO.getContractIdList().get(0);
        Long signContractId = this.contractMapper.selectByPrimaryKey(contractId).getSignContractId();
        log.info("\u8be5\u5408\u540c\u5bf9\u5e94\u7684signContractId\uff1a" + signContractId);
        return signContractId;
    }

    private void deleteAssociateData(ContractPo contractPo) {
        if (Objects.equals(ContractConstant.RelateContractType.RENEW_CONTRACT, contractPo.getRelateType())) {
            ContractPo originCcontractPo = this.contractMapper.selectByPrimaryKey(contractPo.getRelateId());
            ContractPo updateOrigincontractPo = new ContractPo();
            updateOrigincontractPo.setContractId(contractPo.getRelateId());
            updateOrigincontractPo.setRenewNum(originCcontractPo.getRenewNum() + 1);
            updateOrigincontractPo.setRenewStatus(1);
            int i = this.contractMapper.updateByPrimaryKeySelective(updateOrigincontractPo);
            if (i != 1) {
                throw new ZTBusinessException("\u539f\u5408\u540c\u7eed\u7b7e\u4fe1\u606f\u6062\u590d\u5931\u8d25");
            }
        }
        this.contractMapper.deleteByPrimaryKey(contractPo.getContractId());
        ContractAccessoryPo deleteContractAccessoryPo = new ContractAccessoryPo();
        deleteContractAccessoryPo.setRelateCode(contractPo.getContractCode());
        deleteContractAccessoryPo.setRelateId(contractPo.getContractId());
        this.contractAccessoryMapper.deleteByCondition(deleteContractAccessoryPo);
        ContractItemPo deleteContractItemPo = new ContractItemPo();
        deleteContractItemPo.setRelateCode(contractPo.getContractCode());
        deleteContractItemPo.setRelateId(contractPo.getContractId());
        this.contractItemMapper.deleteByCondition(deleteContractItemPo);
        if (Objects.equals(ContractConstant.FeeType.PAY_CONTRACT_CODE, contractPo.getFeeType()) && !Objects.equals(ContractConstant.RelateContractType.RENEW_CONTRACT, contractPo.getRelateType())) {
            this.updatePurchaseDemandPlan(contractPo);
        }
    }

    private void updatePurchaseDemandPlan(ContractPo reqBO) {
        log.info("\u5408\u540c\u4fe1\u606f\uff1a{}", JSON.toJSON((Object)reqBO));
        if (reqBO == null || reqBO.getPurchaseDemandPlanId() == null) {
            return;
        }
        this.contractMapper.updatePurchasePlanIsCreateContract(reqBO.getPurchaseDemandPlanId(), 0);
    }

    private void deleteCalibrationInfo(ContractDeleteBusiReqBO reqBO) {
        CalibrationItemUpdateContractInfoBusiReqBO calibrationItemUpdateContractInfoBusiReqBO = new CalibrationItemUpdateContractInfoBusiReqBO();
        calibrationItemUpdateContractInfoBusiReqBO.setOperationType(Integer.valueOf(2));
        calibrationItemUpdateContractInfoBusiReqBO.setContractId(reqBO.getContractId());
        calibrationItemUpdateContractInfoBusiReqBO.setContractCode(reqBO.getContractCode());
        CalibrationItemUpdateContractInfoBusiRspBO calibrationItemUpdateContractInfoBusiRspBO = this.calibrationItemUpdateContractInfoBusiService.updateContractInfo(calibrationItemUpdateContractInfoBusiReqBO);
        if (!Objects.equals("0000", calibrationItemUpdateContractInfoBusiRspBO.getRespCode())) {
            throw new ZTBusinessException("\u5408\u540c\u5220\u9664\uff0c\u5220\u9664\u5408\u540c\u4fe1\u606f\u5230\u5b9a\u6807\u660e\u7ec6\u5931\u8d25");
        }
    }
}

