/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.busi.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.common.util.MoneyUtils;
import com.ohaotian.plugin.db.Page;
import com.tydic.contract.ability.bo.ContractListBO;
import com.tydic.contract.busi.ContractExpireRemindQryListBusiService;
import com.tydic.contract.busi.bo.ContractQryListBusiReqBO;
import com.tydic.contract.busi.bo.ContractQryListBusiRspBO;
import com.tydic.contract.constant.ContractConstant;
import com.tydic.contract.dao.CContractLawInfoMapper;
import com.tydic.contract.dao.ContractMapper;
import com.tydic.contract.dao.ContractTaskInstMapper;
import com.tydic.contract.po.CContractLawInfoPO;
import com.tydic.contract.po.ContractPo;
import com.tydic.contract.po.ContractTaskInstPO;
import com.tydic.contract.utils.ContractTransFieldUtil;
import com.tydic.contract.utils.DateTimeUtils;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class ContractExpireRemindQryListBusiServiceImpl
implements ContractExpireRemindQryListBusiService {
    private static final Logger log = LoggerFactory.getLogger(ContractExpireRemindQryListBusiServiceImpl.class);
    @Autowired
    private ContractMapper contractMapper;
    @Autowired
    private ContractTaskInstMapper contractTaskInstMapper;
    @Autowired
    private CContractLawInfoMapper cContractLawInfoMapper;
    @Value(value="${manager_users:1}")
    private String managerUsers;

    @Override
    public ContractQryListBusiRspBO qryContractExpireList(ContractQryListBusiReqBO reqBO) {
        ContractQryListBusiRspBO rspBO = new ContractQryListBusiRspBO();
        ContractPo queryAgrContractPo = new ContractPo();
        BeanUtils.copyProperties((Object)((Object)reqBO), (Object)queryAgrContractPo);
        queryAgrContractPo.setPartyBName(reqBO.getPartyBName());
        queryAgrContractPo.setPartyA1Name(reqBO.getPurchaserName());
        queryAgrContractPo.setContractName(reqBO.getContractName());
        queryAgrContractPo.setContractStatus(ContractConstant.ContractStatus.CONTRACT_STATUS_EFFECT);
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        ArrayList<ContractPo> contractPos = new ArrayList();
        List<String> managerUserList = Arrays.asList(this.managerUsers.split(","));
        if (ObjectUtil.isEmpty(queryAgrContractPo.getContractAuditStatusList())) {
            if (reqBO.getUserId() != null && managerUserList.contains(reqBO.getUserId().toString())) {
                queryAgrContractPo.setUserId(null);
            }
            contractPos = this.contractMapper.qryExpireByCondition(queryAgrContractPo, page);
        }
        log.info("\u67e5\u8be2\u7ed3\u679c\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)page));
        List<Object> rows = new ArrayList();
        if (!CollectionUtils.isEmpty(contractPos)) {
            rows = this.transAgrAndEnterContractResult(contractPos, reqBO.getUserId());
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u5408\u540c\u5217\u8868\u67e5\u8be2\u6210\u529f");
        rspBO.setRows(rows);
        if (ObjectUtil.isNotEmpty((Object)rspBO.getRows())) {
            for (int i = 0; i < rows.size(); ++i) {
                ((ContractListBO)rspBO.getRows().get(i)).setSort(Integer.valueOf(i + 1));
            }
        }
        rspBO.setPageNo(page.getPageNo());
        rspBO.setTotal(page.getTotalPages());
        rspBO.setRecordsTotal(page.getTotalCount());
        return rspBO;
    }

    private List<ContractListBO> transAgrAndEnterContractResult(List<ContractPo> list, Long userId) {
        ContractPo contractPo;
        ContractListBO contractListBO;
        ArrayList<ContractListBO> rows = new ArrayList<ContractListBO>();
        ContractTaskInstPO contractTaskInstPO = new ContractTaskInstPO();
        Iterator<ContractPo> iterator = list.iterator();
        while (iterator.hasNext() && !ObjectUtil.isEmpty((Object)(contractListBO = (ContractListBO)JSON.parseObject((String)JSON.toJSONString((Object)(contractPo = iterator.next())), ContractListBO.class)))) {
            log.info("\u683c\u5f0f\u5316\u524d\u5408\u540c\u65f6\u95f4\uff1a{}", (Object)contractListBO.getNeedArriveTime());
            log.info("\u683c\u5f0f\u5316\u524d\u5408\u540c\u65f6\u95f4\uff1a{}", (Object)contractListBO.getContractSignDate());
            log.info("\u683c\u5f0f\u5316\u524d\u5408\u540c\u65f6\u95f4\uff1a{}", (Object)contractListBO.getContractSignDate());
            contractListBO.setContractSignDate(DateTimeUtils.Time2Date(contractListBO.getContractSignDate()));
            contractListBO.setNeedArriveTime(DateTimeUtils.Time2Date(contractListBO.getNeedArriveTime()));
            contractListBO.setContractEndDate(DateTimeUtils.Time2Date(contractListBO.getContractEndDate()));
            log.info("\u683c\u5f0f\u5316\u540e\u5408\u540c\u65f6\u95f4\uff1a{}", (Object)DateTimeUtils.Date4String(contractListBO.getNeedArriveTime()));
            log.info("\u683c\u5f0f\u5316\u540e\u5408\u540c\u65f6\u95f4\uff1a{}", (Object)DateTimeUtils.Date4String(contractListBO.getContractSignDate()));
            log.info("\u683c\u5f0f\u5316\u540e\u5408\u540c\u65f6\u95f4\uff1a{}", (Object)DateTimeUtils.Date4String(contractListBO.getContractSignDate()));
            if (!StringUtils.isEmpty((Object)contractListBO.getContractEndDate())) {
                String inputDate = contractListBO.getContractEndDate();
                String s = DateTimeUtils.Date3String(inputDate);
                contractListBO.setContractExpireRemindStr("\u60a8\u597d\uff0c\u60a8\u7684\u5408\u540c\u5728" + s + "\u5373\u5c06\u5230\u671f\uff0c\u8bf7\u5904\u7406\u3002");
            }
            if (contractListBO.getContractStatus() != null) {
                contractListBO.setContractStatusStr(ContractTransFieldUtil.transContractStatus(contractListBO.getContractStatus()));
                contractListBO.setStatus(contractListBO.getContractStatus());
                contractListBO.setStatusStr(ContractTransFieldUtil.transContractStatus(contractListBO.getContractStatus()));
            }
            if (contractListBO.getContractType() != null) {
                contractListBO.setContractTypeStr(ContractTransFieldUtil.transZSCMContractType(contractListBO.getContractType()));
            }
            if (contractListBO.getIncomeContractType() != null) {
                contractListBO.setIncomeContractTypeStr(ContractTransFieldUtil.transZSCMIncomeContractType(contractListBO.getIncomeContractType()));
            }
            if (contractListBO.getFeeType() != null) {
                contractListBO.setFeeTypeStr(ContractTransFieldUtil.transFeeType(contractListBO.getFeeType()));
            }
            if (contractListBO.getPayType() != null) {
                contractListBO.setPayTypeStr(ContractTransFieldUtil.transPayType(contractListBO.getPayType()));
            }
            if (contractListBO.getExpectSettle() != null) {
                contractListBO.setExpectSettleStr(ContractTransFieldUtil.transExpectSettle(contractListBO.getExpectSettle()));
            }
            if (contractListBO.getSsBusiWay() != null) {
                contractListBO.setSsBusiWayStr(ContractTransFieldUtil.transSsBusiWay(contractListBO.getSsBusiWay()));
            }
            if (contractListBO.getOrgType() != null) {
                contractListBO.setOrgTypeStr(ContractTransFieldUtil.transContractOrgType(contractListBO.getOrgType()));
            }
            try {
                contractListBO.setContractAmountMoney(MoneyUtils.Long2BigDecimal((Long)contractListBO.getContractAmount()));
            }
            catch (Exception e) {
                log.error("\u91d1\u94b1\u8f6c\u6362\u51fa\u9519\uff1a" + e.getMessage());
            }
            contractTaskInstPO.setContractId(contractListBO.getContractId());
            contractTaskInstPO.setFinishTag(0);
            contractTaskInstPO.setUserId(userId);
            List<ContractTaskInstPO> contractTaskInstPOS = this.contractTaskInstMapper.qryTaskInstList(contractTaskInstPO);
            if (ObjectUtil.isNotEmpty(contractTaskInstPOS)) {
                contractListBO.setTaskId(contractTaskInstPOS.get(0).getTaskInstId());
                contractListBO.setTaskSignTag(contractTaskInstPOS.get(0).getTaskSignTag());
                contractListBO.setProcInstId(contractTaskInstPOS.get(0).getProcInstId());
            } else {
                contractTaskInstPO.setFinishTag(1);
                contractTaskInstPOS = this.contractTaskInstMapper.qryTaskInstList(contractTaskInstPO);
                contractListBO.setProcInstId(ObjectUtil.isNotEmpty(contractTaskInstPOS) ? contractTaskInstPOS.get(0).getProcInstId() : null);
            }
            contractListBO.setPartyA(contractPo.getPartyA1Name());
            contractListBO.setPartyB(contractPo.getPartyBName());
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            contractListBO.setContractSignDate(ObjectUtil.isNotEmpty((Object)contractPo.getContractSignDate()) ? dateFormat.format(contractPo.getContractSignDate()) : "-");
            contractListBO.setContractEndDate(ObjectUtil.isNotEmpty((Object)contractPo.getContractEndDate()) ? dateFormat.format(contractPo.getContractEndDate()) : "-");
            contractListBO.setContractStartDate(ObjectUtil.isNotEmpty((Object)contractPo.getContractStartDate()) ? dateFormat.format(contractPo.getContractStartDate()) : "-");
            CContractLawInfoPO cContractLawInfoPO = new CContractLawInfoPO();
            cContractLawInfoPO.setRelateId(contractPo.getContractId());
            CContractLawInfoPO modelBy = this.cContractLawInfoMapper.getModelBy(cContractLawInfoPO);
            if (ObjectUtil.isNotEmpty((Object)modelBy)) {
                contractListBO.setTotalAmount(modelBy.getContractTotalAmount());
            }
            contractListBO.setContractPerformWay(contractPo.getContractPerformanceMode());
            if (contractPo.getContractPerformanceMode() != null) {
                contractListBO.setContractPerformWayStr(ContractTransFieldUtil.transContractPerformanceMode(contractPo.getContractPerformanceMode()));
            }
            rows.add(contractListBO);
        }
        return rows;
    }
}

