/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.busi.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Page;
import com.tydic.contract.ability.bo.ContractModApplyInfoBO;
import com.tydic.contract.busi.ContractModApplyQryListBusiService;
import com.tydic.contract.busi.bo.ContractModApplyQryListBusiReqBO;
import com.tydic.contract.busi.bo.ContractModApplyQryListBusiRspBO;
import com.tydic.contract.constant.ContractConstant;
import com.tydic.contract.dao.ContractModifyApplyMapper;
import com.tydic.contract.dao.ContractTaskInstMapper;
import com.tydic.contract.po.ContractModifyApplyPo;
import com.tydic.contract.po.ContractTaskInstPO;
import com.tydic.contract.utils.ContractTransFieldUtil;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ContractModApplyQryListBusiServiceImpl
implements ContractModApplyQryListBusiService {
    private static final Logger log = LoggerFactory.getLogger(ContractModApplyQryListBusiServiceImpl.class);
    @Autowired
    private ContractModifyApplyMapper contractModifyApplyMapper;
    @Autowired
    private ContractTaskInstMapper contractTaskInstMapper;
    @Value(value="${manager_users:1}")
    private String managerUsers;

    @Override
    public ContractModApplyQryListBusiRspBO qryContractModApplyList(ContractModApplyQryListBusiReqBO reqBO) {
        ContractModApplyQryListBusiRspBO rspBO = new ContractModApplyQryListBusiRspBO();
        ContractModifyApplyPo queryContractModifyApplyPo = new ContractModifyApplyPo();
        BeanUtils.copyProperties((Object)((Object)reqBO), (Object)queryContractModifyApplyPo);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        try {
            log.info("\u53d8\u66f4\u521b\u5efa\u65f6\u95f4\u5f00\u59cb\uff1a" + reqBO.getModifyCreateTimeStart() + " \u7ed3\u675f\uff1a" + reqBO.getModifyCreateTimeEnd());
            if (reqBO.getModifyCreateTimeEnd() != null && !reqBO.getModifyCreateTimeEnd().equals("")) {
                queryContractModifyApplyPo.setModifyCreateTimeEnd(sdf.parse(reqBO.getModifyCreateTimeEnd()));
            }
            if (reqBO.getModifyCreateTimeStart() != null && !reqBO.getModifyCreateTimeStart().equals("")) {
                queryContractModifyApplyPo.setModifyCreateTimeStart(sdf.parse(reqBO.getModifyCreateTimeStart()));
            }
        }
        catch (ParseException e) {
            throw new ZTBusinessException("\u5408\u540c\u53d8\u66f4\u7533\u8bf7\u5217\u8868\u67e5\u8be2\u65f6\u95f4\u7531Date\u8f6c\u6362String\u51fa\u9519");
        }
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        List<Object> applyPos = new ArrayList();
        if (Objects.equals(1, reqBO.getOperType())) {
            List<String> managerUserList = Arrays.asList(this.managerUsers.split(","));
            if (reqBO.getUserId() != null && managerUserList.contains(reqBO.getUserId().toString())) {
                queryContractModifyApplyPo.setUserId(null);
            }
            applyPos = this.contractModifyApplyMapper.qryListByCondition(queryContractModifyApplyPo, page);
        } else if (queryContractModifyApplyPo.getModifyStatusList().contains(ContractConstant.ContractStatus.CONTRACT_STATUS_UNDER_APPROVAL) && reqBO.getModifyStatusList().size() == 1) {
            queryContractModifyApplyPo.setUserId(reqBO.getUserId());
            queryContractModifyApplyPo.setFinishTag(ContractConstant.PROC_TASK_FINISHED.NO_FINISHED);
            applyPos = this.contractModifyApplyMapper.qryListByConditionNew(queryContractModifyApplyPo, page);
        } else if (queryContractModifyApplyPo.getModifyStatusList().contains(ContractConstant.ContractStatus.CONTRACT_STATUS_APPROVAL) && queryContractModifyApplyPo.getModifyStatusList().contains(ContractConstant.ContractStatus.CONTRACT_STATUS_REJECT) && reqBO.getModifyStatusList().size() == 2) {
            queryContractModifyApplyPo.setUserId(reqBO.getUserId());
            queryContractModifyApplyPo.setFinishTag(ContractConstant.PROC_TASK_FINISHED.FINISHED);
            queryContractModifyApplyPo.setModifyStatusList(new ArrayList<Integer>());
            queryContractModifyApplyPo.setAuditOrderStatus(Arrays.asList("1", "3", "0"));
            applyPos = this.contractModifyApplyMapper.qryByConditionAudited(queryContractModifyApplyPo, page);
        } else {
            queryContractModifyApplyPo.setFinishTag(null);
            applyPos = this.contractModifyApplyMapper.qryByConditionAudited(queryContractModifyApplyPo, page);
        }
        if (!CollectionUtils.isEmpty(applyPos)) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u5408\u540c\u53d8\u66f4\u7533\u8bf7\u5217\u8868\u67e5\u8be2\u6210\u529f");
            List<ContractModApplyInfoBO> rows = this.transResultData(applyPos, reqBO.getUserId());
            rspBO.setRows(rows);
            rspBO.setPageNo(page.getPageNo());
            rspBO.setTotal(page.getTotalPages());
            rspBO.setRecordsTotal(page.getTotalCount());
        } else {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u672a\u67e5\u8be2\u5230\u6570\u636e");
        }
        return rspBO;
    }

    private List<ContractModApplyInfoBO> transResultData(List<ContractModifyApplyPo> rows, Long userId) {
        ContractModApplyInfoBO contractModApplyInfoBO;
        ContractTaskInstPO contractTaskInstPO = new ContractTaskInstPO();
        for (ContractModifyApplyPo contractModifyApplyPo : rows) {
            if (ObjectUtil.isEmpty((Object)contractModifyApplyPo)) break;
            contractTaskInstPO.setContractId(contractModifyApplyPo.getUpdateApplyId());
            contractTaskInstPO.setFinishTag(0);
            contractTaskInstPO.setUserId(userId);
            List<ContractTaskInstPO> contractTaskInstPOS = this.contractTaskInstMapper.qryTaskInstList(contractTaskInstPO);
            if (ObjectUtil.isNotEmpty(contractTaskInstPOS)) {
                contractModifyApplyPo.setTaskId(Long.valueOf(contractTaskInstPOS.get(0).getTaskInstId()));
                contractModifyApplyPo.setTaskSignTag(contractTaskInstPOS.get(0).getTaskSignTag());
                contractModifyApplyPo.setProcInstId(contractTaskInstPOS.get(0).getProcInstId());
                continue;
            }
            contractTaskInstPO.setFinishTag(1);
            contractTaskInstPOS = this.contractTaskInstMapper.qryTaskInstList(contractTaskInstPO);
            contractModifyApplyPo.setProcInstId(ObjectUtil.isNotEmpty(contractTaskInstPOS) ? contractTaskInstPOS.get(0).getProcInstId() : null);
        }
        String resultJsonStr = JSON.toJSONString(rows);
        log.info("\u67e5\u8be2\u7ed3\u679c\uff1a{}", (Object)resultJsonStr);
        List list = JSONArray.parseArray((String)resultJsonStr).toJavaList(ContractModApplyInfoBO.class);
        Iterator iterator = list.iterator();
        while (iterator.hasNext() && !ObjectUtil.isEmpty((Object)(contractModApplyInfoBO = (ContractModApplyInfoBO)iterator.next()))) {
            if (contractModApplyInfoBO.getModifyStatus() != null) {
                contractModApplyInfoBO.setModifyStatusStr(ContractTransFieldUtil.transModifyStatus(contractModApplyInfoBO.getModifyStatus()));
            }
            if (contractModApplyInfoBO.getIncomeContractType() != null) {
                contractModApplyInfoBO.setIncomeContractTypeStr(ContractTransFieldUtil.transZSCMIncomeContractType(contractModApplyInfoBO.getIncomeContractType()));
            }
            if (contractModApplyInfoBO.getContractType() != null) {
                contractModApplyInfoBO.setContractTypeStr(ContractTransFieldUtil.transZSCMContractType(contractModApplyInfoBO.getContractType()));
            }
            if (contractModApplyInfoBO.getFeeType() != null) {
                contractModApplyInfoBO.setFeeTypeStr(ContractTransFieldUtil.transFeeType(contractModApplyInfoBO.getFeeType()));
            }
            if (contractModApplyInfoBO.getModOperType() == null) continue;
            contractModApplyInfoBO.setModOperTypeStr(ContractTransFieldUtil.transContractModApplyType(contractModApplyInfoBO.getModOperType()));
        }
        return list;
    }
}

