/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.ohaotian.plugin.db.Page;
import com.tydic.contract.ability.bo.ContractListBO;
import com.tydic.contract.busi.ContractQryAgreeContractListBusiService;
import com.tydic.contract.busi.bo.ContractQryAgreeContractListBusiReqBO;
import com.tydic.contract.busi.bo.ContractQryAgreeContractListBusiRspBO;
import com.tydic.contract.constant.ContractConstant;
import com.tydic.contract.dao.ContractMapper;
import com.tydic.contract.po.ContractPo;
import com.tydic.contract.utils.ContractTransFieldUtil;
import com.tydic.contract.utils.DateTimeUtils;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ContractQryAgreeContractListBusiServiceImpl
implements ContractQryAgreeContractListBusiService {
    @Autowired
    private ContractMapper contractMapper;

    @Override
    public ContractQryAgreeContractListBusiRspBO qryAgreeContractList(ContractQryAgreeContractListBusiReqBO reqBO) {
        ContractQryAgreeContractListBusiRspBO rspBO = new ContractQryAgreeContractListBusiRspBO();
        ContractPo queryAgrContractPo = new ContractPo();
        BeanUtils.copyProperties((Object)((Object)reqBO), (Object)queryAgrContractPo);
        ArrayList<Integer> contractTypeList = new ArrayList<Integer>();
        contractTypeList.add(ContractConstant.ZYCMContractType.UNIT_AGREE_CONTRACT_TYPE);
        contractTypeList.add(ContractConstant.ZYCMContractType.PLATFORM_AGREE_CONTRACT_TYPE);
        contractTypeList.add(ContractConstant.ZYCMContractType.ORDER_CONTRACT_TYPE);
        contractTypeList.add(ContractConstant.ZYCMContractType.ORDER_CONTRACT_SERVICE_TYPE);
        contractTypeList.add(ContractConstant.ZYCMContractType.NON_STANDARD_CONTRACT_TYPE);
        queryAgrContractPo.setContractTypeList(contractTypeList);
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        List<ContractPo> contractPos = this.contractMapper.qryByCondition(queryAgrContractPo, page);
        List<ContractListBO> rows = this.transAgrContractResult(contractPos);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u62db\u5546\u5408\u540c\u5217\u8868\u67e5\u8be2\u6210\u529f");
        rspBO.setRows(rows);
        rspBO.setPageNo(page.getPageNo());
        rspBO.setTotal(page.getTotalPages());
        rspBO.setRecordsTotal(page.getTotalCount());
        return rspBO;
    }

    private List<ContractListBO> transAgrContractResult(List<ContractPo> list) {
        String resultJsonStr = JSON.toJSONString(list);
        List rows = JSONArray.parseArray((String)resultJsonStr).toJavaList(ContractListBO.class);
        for (ContractListBO contractListBO : rows) {
            contractListBO.setContractSignDate(DateTimeUtils.Time2Date(contractListBO.getContractSignDate()));
            contractListBO.setContractEndDate(DateTimeUtils.Time2Date(contractListBO.getContractEndDate()));
            contractListBO.setContractEffectDate(DateTimeUtils.Time2Date(contractListBO.getContractEffectDate()));
            if (contractListBO.getContractStatus() != null) {
                contractListBO.setContractStatusStr(ContractTransFieldUtil.transContractStatus(contractListBO.getContractStatus()));
            }
            if (contractListBO.getContractType() != null) {
                contractListBO.setContractTypeStr(ContractTransFieldUtil.transZSCMContractType(contractListBO.getContractType()));
            }
            if (contractListBO.getSealWay() != null) {
                contractListBO.setSealWayStr(ContractTransFieldUtil.transZSCMContractType(contractListBO.getSealWay()));
            }
            if (contractListBO.getArchiveStatus() != null) {
                contractListBO.setArchiveStatusStr(ContractTransFieldUtil.transArchiveStatus(contractListBO.getArchiveStatus()));
            }
            if (contractListBO.getPayStatus() != null) {
                contractListBO.setPayStatusStr(ContractTransFieldUtil.transPayStatus(contractListBO.getPayStatus()));
            }
            if (contractListBO.getIsSyncLegal() != null) {
                contractListBO.setIsSyncLegalStr(ContractTransFieldUtil.transIsSyncLegal(contractListBO.getIsSyncLegal()));
            }
            if (contractListBO.getContractPerformWay() != null) {
                contractListBO.setContractPerformWayStr(ContractTransFieldUtil.transZSCMContractPerformanceMode(contractListBO.getContractPerformWay()));
            }
            if (contractListBO.getPayType() != null) {
                contractListBO.setPayTypeStr(ContractTransFieldUtil.transPayType(contractListBO.getPayType()));
            }
            if (contractListBO.getExpectSettle() != null) {
                contractListBO.setExpectSettleStr(ContractTransFieldUtil.transExpectSettle(contractListBO.getExpectSettle()));
            }
            if (contractListBO.getSsBusiWay() == null) continue;
            contractListBO.setSsBusiWayStr(ContractTransFieldUtil.transSsBusiWay(contractListBO.getSsBusiWay()));
        }
        return rows;
    }
}

