/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.busi.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.contract.ability.bo.ContrackTaskInstInfoBO;
import com.tydic.contract.ability.bo.ContractAccessoryBO;
import com.tydic.contract.ability.bo.ContractAgreePayPlanBO;
import com.tydic.contract.ability.bo.ContractBaseInfoBO;
import com.tydic.contract.ability.bo.ContractCooperationCategoryBO;
import com.tydic.contract.ability.bo.ContractCooperationInfoBO;
import com.tydic.contract.ability.bo.ContractLawInfoBO;
import com.tydic.contract.ability.bo.ContractVersionBO;
import com.tydic.contract.busi.ContractQryDetailBusiService;
import com.tydic.contract.busi.bo.ContractQryDetailBusiReqBO;
import com.tydic.contract.busi.bo.ContractQryDetailBusiRspBO;
import com.tydic.contract.constant.ContractConstant;
import com.tydic.contract.dao.CContractCooperationCategoryMapper;
import com.tydic.contract.dao.CContractCooperationInfoMapper;
import com.tydic.contract.dao.CContractLawInfoMapper;
import com.tydic.contract.dao.CContractPayPlanMapper;
import com.tydic.contract.dao.ContractAccessoryMapper;
import com.tydic.contract.dao.ContractMapper;
import com.tydic.contract.dao.ContractModifyApplyMapper;
import com.tydic.contract.dao.ContractOrderMapper;
import com.tydic.contract.dao.ContractPayTypeMapper;
import com.tydic.contract.dao.ContractTaskDealMapper;
import com.tydic.contract.dao.ContractTaskInstMapper;
import com.tydic.contract.dao.ContractTermsMapper;
import com.tydic.contract.po.CContractCooperationCategoryPO;
import com.tydic.contract.po.CContractCooperationInfoPO;
import com.tydic.contract.po.CContractLawInfoPO;
import com.tydic.contract.po.CContractPayPlanPO;
import com.tydic.contract.po.ContractAccessoryPo;
import com.tydic.contract.po.ContractModifyApplyPo;
import com.tydic.contract.po.ContractPo;
import com.tydic.contract.po.ContractTaskDealPO;
import com.tydic.contract.po.ContractTaskInstPO;
import com.tydic.contract.utils.ContractTransFieldUtil;
import com.tydic.contract.utils.DateTimeUtils;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class ContractQryDetailBusiServiceImpl
implements ContractQryDetailBusiService {
    private static final Logger log = LoggerFactory.getLogger(ContractQryDetailBusiServiceImpl.class);
    @Autowired
    private ContractMapper contractMapper;
    @Autowired
    private ContractModifyApplyMapper contractModifyApplyMapper;
    @Autowired
    private ContractPayTypeMapper contractPayTypeMapper;
    @Autowired
    private ContractAccessoryMapper contractAccessoryMapper;
    @Autowired
    private ContractOrderMapper contractOrderMapper;
    @Autowired
    private ContractTermsMapper contractTermsMapper;
    @Autowired
    private ContractTaskInstMapper contractTaskInstMapper;
    @Autowired
    private ContractTaskDealMapper contractTaskDealMapper;
    @Autowired
    private CContractCooperationInfoMapper contractCooperationInfoMapper;
    @Autowired
    private CContractCooperationCategoryMapper contractCooperationCategoryMapper;
    @Autowired
    private CContractLawInfoMapper contractLawInfoMapper;
    @Autowired
    private CContractPayPlanMapper contractPayPlanMapper;

    @Override
    public ContractQryDetailBusiRspBO qryContractDetail(ContractQryDetailBusiReqBO reqBO) {
        ContractQryDetailBusiRspBO rspBO = new ContractQryDetailBusiRspBO();
        ContractPo contractInfoPo = this.contractMapper.selectByPrimaryKey(reqBO.getContractId());
        if (contractInfoPo != null) {
            BeanUtils.copyProperties((Object)contractInfoPo, (Object)((Object)rspBO));
            ContractBaseInfoBO contractBaseInfo = new ContractBaseInfoBO();
            BeanUtils.copyProperties((Object)contractInfoPo, (Object)contractBaseInfo);
            rspBO.setContractBaseInfo(contractBaseInfo);
            CContractLawInfoPO lawInfoPo = new CContractLawInfoPO();
            lawInfoPo.setRelateId(contractInfoPo.getContractId());
            CContractLawInfoPO lawInfo = this.contractLawInfoMapper.getModelBy(lawInfoPo);
            if (lawInfo != null) {
                rspBO.setContractLawInfo((ContractLawInfoBO)JSON.parseObject((String)JSON.toJSONString((Object)lawInfo), ContractLawInfoBO.class));
            }
            CContractCooperationInfoPO cooperationInfoPo = new CContractCooperationInfoPO();
            cooperationInfoPo.setRelateId(contractInfoPo.getContractId());
            CContractCooperationInfoPO cooperationInfo = this.contractCooperationInfoMapper.getModelBy(cooperationInfoPo);
            if (cooperationInfo != null) {
                List<CContractCooperationCategoryPO> cooperationCategoryPos;
                ContractCooperationInfoBO contractCooperationInfoBO = (ContractCooperationInfoBO)JSON.parseObject((String)JSON.toJSONString((Object)cooperationInfo), ContractCooperationInfoBO.class);
                if (!StringUtils.isEmpty((Object)cooperationInfo.getTaxPointS())) {
                    List<String> list = Arrays.asList(cooperationInfo.getTaxPointS().split(","));
                    contractCooperationInfoBO.setTaxPointList(list);
                }
                CContractCooperationCategoryPO cooperationCategoryPo = new CContractCooperationCategoryPO();
                cooperationCategoryPo.setRelateId(contractInfoPo.getContractId());
                if (ObjectUtil.isNotEmpty((Object)cooperationCategoryPo) && !CollectionUtils.isEmpty(cooperationCategoryPos = this.contractCooperationCategoryMapper.getList(cooperationCategoryPo))) {
                    String resultString = JSON.toJSONString(cooperationCategoryPos);
                    List contractCooperationCategoryBOList = JSONArray.parseArray((String)resultString).toJavaList(ContractCooperationCategoryBO.class);
                    contractCooperationInfoBO.setCooperationCategoryList(contractCooperationCategoryBOList);
                }
                rspBO.setContractCooperationInfo(contractCooperationInfoBO);
            }
            CContractPayPlanPO contractPayPlanPo = new CContractPayPlanPO();
            contractPayPlanPo.setRelateId(contractInfoPo.getContractId());
            List<CContractPayPlanPO> contractPayPlanPos = this.contractPayPlanMapper.getList(contractPayPlanPo);
            if (!CollectionUtils.isEmpty(contractPayPlanPos)) {
                String resultString = JSON.toJSONString(contractPayPlanPos);
                List contractPayPlanBOList = JSONArray.parseArray((String)resultString).toJavaList(ContractAgreePayPlanBO.class);
                rspBO.setPayPlanList(contractPayPlanBOList);
            }
            this.transResult(rspBO);
            rspBO.setContractSignDate(DateTimeUtils.Time2Date(rspBO.getContractSignDate()));
            rspBO.setNeedArriveTime(DateTimeUtils.Time2Date(rspBO.getNeedArriveTime()));
            rspBO.setContractEndDate(DateTimeUtils.Time2Date(rspBO.getContractEndDate()));
            log.info("\u5408\u540c\u8be6\u60c5\u67e5\u8be2API: contractSignDate" + rspBO.getContractSignDate() + " needArriveTime " + rspBO.getNeedArriveTime());
            ContractAccessoryPo queryContractAccessoryPo = new ContractAccessoryPo();
            queryContractAccessoryPo.setRelateCode(contractInfoPo.getContractCode());
            queryContractAccessoryPo.setRelateId(contractInfoPo.getContractId());
            List<ContractAccessoryPo> contractAccessoryPos = this.contractAccessoryMapper.qryByCondition(queryContractAccessoryPo);
            if (!CollectionUtils.isEmpty(contractAccessoryPos)) {
                String resultString = JSON.toJSONString(contractAccessoryPos);
                List acceessoryList = JSONArray.parseArray((String)resultString).toJavaList(ContractAccessoryBO.class);
                rspBO.setAcceessoryList(acceessoryList);
            }
            ContractModifyApplyPo queryContractModifyApplyPo = new ContractModifyApplyPo();
            queryContractModifyApplyPo.setContractCode(contractInfoPo.getContractCode());
            List<ContractModifyApplyPo> contractModifyApplyPos = this.contractModifyApplyMapper.qryByCondition(queryContractModifyApplyPo);
            if (contractModifyApplyPos != null && !contractModifyApplyPos.isEmpty()) {
                rspBO.setHaveChangeRecode(ContractConstant.HaveChangeReCode.YES);
                ArrayList<ContractVersionBO> contractVersionList = new ArrayList<ContractVersionBO>();
                contractModifyApplyPos.forEach(contractModifyApplyPo -> {
                    ContractVersionBO contractVersionBO = new ContractVersionBO();
                    contractVersionBO.setContractId(contractModifyApplyPo.getContractId());
                    contractVersionBO.setContractVersion("V" + contractModifyApplyPo.getContractVersion());
                    contractVersionBO.setChangeApplyCode(contractModifyApplyPo.getUpdateApplyCode());
                    contractVersionBO.setChangeApplyDesc(contractModifyApplyPo.getUpdateApplyRemark());
                    contractVersionBO.setStatus(contractModifyApplyPo.getModifyStatus());
                    contractVersionBO.setCreateUser(contractModifyApplyPo.getUpdateUserName());
                    contractVersionBO.setCreateTime(contractModifyApplyPo.getUpdateTime());
                    contractVersionList.add(contractVersionBO);
                });
                rspBO.setContractVersionList(contractVersionList);
            } else {
                rspBO.setHaveChangeRecode(ContractConstant.HaveChangeReCode.NO);
            }
            ContractTaskInstPO contractTaskInstPO = new ContractTaskInstPO();
            contractTaskInstPO.setContractId(contractInfoPo.getContractId());
            List<ContractTaskInstPO> contractTaskInstPOS = this.contractTaskInstMapper.qryTaskInstList(contractTaskInstPO);
            if (ObjectUtil.isNotEmpty(contractTaskInstPOS)) {
                ContractTaskInstPO newTask = Collections.max(contractTaskInstPOS, Comparator.comparing(ContractTaskInstPO::getCreateTime));
                rspBO.setProcInstId(newTask.getProcInstId());
                ContractTaskDealPO contractTaskDealPO = new ContractTaskDealPO();
                contractTaskDealPO.setContractId(contractInfoPo.getContractId());
                List<ContractTaskDealPO> contractTaskDealPOS = this.contractTaskDealMapper.selectContractTaskInfo(contractTaskDealPO);
                ArrayList<ContrackTaskInstInfoBO> contrackTaskInstInfoBOS = new ArrayList<ContrackTaskInstInfoBO>();
                contractTaskDealPOS.forEach(e -> {
                    ContrackTaskInstInfoBO contrackTaskInstInfoBO = (ContrackTaskInstInfoBO)JSONObject.parseObject((String)JSON.toJSONString((Object)e), ContrackTaskInstInfoBO.class);
                    contrackTaskInstInfoBOS.add(contrackTaskInstInfoBO);
                });
                rspBO.setBusiTaskInstBos(contrackTaskInstInfoBOS);
                ContractTaskInstPO earliestTask = Collections.min(contractTaskInstPOS, Comparator.comparing(ContractTaskInstPO::getCreateTime));
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                rspBO.setContractApprovalStartTime(sdf.format(earliestTask.getCreateTime()));
                rspBO.setContractApprovalPassTime(DateTimeUtils.Date4String(rspBO.getContractApprovalTime()));
                rspBO.setContractCreateTime(DateTimeUtils.Date4String(contractInfoPo.getCreateTime()));
                log.info("\u683c\u5f0f\u5316\u524d\u521b\u5efa\u5408\u540c\u65f6\u95f4\uff1a{}", (Object)rspBO.getContractApprovalTime());
                log.info("\u683c\u5f0f\u5316\u524d\u521b\u5efa\u5408\u540c\u65f6\u95f4\uff1a{}", (Object)contractInfoPo.getCreateTime());
                log.info("\u683c\u5f0f\u5316\u540e\u521b\u5efa\u5408\u540c\u65f6\u95f4\uff1a{}", (Object)DateTimeUtils.Date4String(rspBO.getContractApprovalTime()));
                log.info("\u683c\u5f0f\u5316\u540e\u521b\u5efa\u5408\u540c\u65f6\u95f4\uff1a{}", (Object)DateTimeUtils.Date4String(contractInfoPo.getCreateTime()));
            }
            return rspBO;
        }
        rspBO.setRespCode("1008");
        rspBO.setRespDesc("\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u5408\u540c\u6570\u636e");
        return rspBO;
    }

    private void transResult(ContractQryDetailBusiRspBO rspBO) {
        rspBO.getContractBaseInfo().setAddContractTime(DateTimeUtils.Date4String(rspBO.getContractBaseInfo().getAddContractTime()));
        rspBO.getContractBaseInfo().setContractApprovalPassTime(DateTimeUtils.Date4String(rspBO.getContractBaseInfo().getContractApprovalPassTime()));
        rspBO.getContractBaseInfo().setStartSignTime(DateTimeUtils.Date4String(rspBO.getContractBaseInfo().getStartSignTime()));
        rspBO.getContractBaseInfo().setGenerateSideSignTime(DateTimeUtils.Date4String(rspBO.getContractBaseInfo().getGenerateSideSignTime()));
        rspBO.getContractBaseInfo().setSupplierSideSignTime(DateTimeUtils.Date4String(rspBO.getContractBaseInfo().getSupplierSideSignTime()));
        rspBO.getContractBaseInfo().setContractEffectTime(DateTimeUtils.Date4String(rspBO.getContractBaseInfo().getContractEffectTime()));
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (rspBO.getContractAmount() != null) {
            rspBO.setContractAmountMoney(ContractTransFieldUtil.transContractAmount(rspBO.getContractAmount()));
        }
        if (rspBO.getExpectSettle() != null) {
            rspBO.setExpectSettleStr(ContractTransFieldUtil.transExpectSettle(rspBO.getExpectSettle()));
        }
        if (rspBO.getPayType() != null) {
            rspBO.setPayTypeStr(ContractTransFieldUtil.transPayType(rspBO.getPayType()));
        }
        if (rspBO.getSsBusiWay() != null) {
            rspBO.setSsBusiWayStr(ContractTransFieldUtil.transSsBusiWay(rspBO.getSsBusiWay()));
        }
        if (rspBO.getOrgType() != null) {
            rspBO.setOrgTypeStr(ContractTransFieldUtil.transContractOrgType(rspBO.getOrgType()));
        }
        if (rspBO.getServiceFeeType() != null) {
            rspBO.setServiceFeeTypeStr(ContractTransFieldUtil.transServiceFeeType(rspBO.getServiceFeeType()));
        }
        if (rspBO.getChargeSaleCategoryFee() != null) {
            rspBO.setChargeSaleCategoryFeeStr(ContractTransFieldUtil.transChargeSaleCategoryFee(rspBO.getChargeSaleCategoryFee()));
        }
        if (rspBO.getChargeSaleCategoryFeeNode() != null) {
            rspBO.setChargeSaleCategoryFeeNodeStr(ContractTransFieldUtil.transChargeSaleCategoryFeeNode(rspBO.getChargeSaleCategoryFeeNode()));
        }
        if (rspBO.getChargeLadderRateFee() != null) {
            rspBO.setChargeLadderRateFeeStr(ContractTransFieldUtil.transChargeLadderRateFee(rspBO.getChargeLadderRateFee()));
        }
        if (rspBO.getContractApprovalResult() != null) {
            rspBO.setContractApprovalResultStr(ContractTransFieldUtil.transContractApprovalResult(rspBO.getContractApprovalResult()));
        }
        if (rspBO.getBussNode() != null) {
            log.info("BUSS_NODE:" + rspBO.getBussNode());
            rspBO.setBussNodeStr(ContractTransFieldUtil.transContractBussNode(rspBO.getBussNode()));
        }
        if (ObjectUtil.isNotEmpty((Object)rspBO.getContractBaseInfo())) {
            if (rspBO.getContractBaseInfo().getContractType() != null) {
                rspBO.getContractBaseInfo().setContractTypeStr(ContractTransFieldUtil.transZSCMContractType(rspBO.getContractBaseInfo().getContractType()));
            }
            if (rspBO.getContractBaseInfo().getContractStatus() != null) {
                rspBO.getContractBaseInfo().setContractStatusStr(ContractTransFieldUtil.transContractStatus(rspBO.getContractBaseInfo().getContractStatus()));
            }
            if (rspBO.getContractBaseInfo().getCooperationMode() != null) {
                rspBO.getContractBaseInfo().setCooperationModeStr(ContractTransFieldUtil.transCooperationMode(rspBO.getContractBaseInfo().getCooperationMode()));
            }
            if (rspBO.getContractBaseInfo().getContractPerformanceMode() != null) {
                rspBO.getContractBaseInfo().setContractPerformanceModeStr(ContractTransFieldUtil.transContractPerformanceMode(rspBO.getContractBaseInfo().getContractPerformanceMode()));
            }
            if (rspBO.getContractBaseInfo().getContractExpireRemindStart() != null) {
                rspBO.getContractBaseInfo().setContractExpireRemindStartStr(ContractTransFieldUtil.transContractExpireRemindStart(rspBO.getContractBaseInfo().getContractExpireRemindStart()));
            }
            if (rspBO.getContractBaseInfo().getContractExpireRemindEnd() != null) {
                rspBO.getContractBaseInfo().setContractExpireRemindEndStr(ContractTransFieldUtil.transContractExpireRemindEnd(rspBO.getContractBaseInfo().getContractExpireRemindEnd()));
            }
        }
        if (ObjectUtil.isNotEmpty((Object)rspBO.getContractLawInfo())) {
            if (rspBO.getContractLawInfo().getContractBigType() != null) {
                rspBO.getContractLawInfo().setContractBigTypeStr(ContractTransFieldUtil.transContractBigType(rspBO.getContractLawInfo().getContractBigType()));
            }
            if (rspBO.getContractLawInfo().getContractUrgency() != null) {
                rspBO.getContractLawInfo().setContractUrgencyStr(ContractTransFieldUtil.transContractUrgency(rspBO.getContractLawInfo().getContractUrgency()));
            }
            if (rspBO.getContractLawInfo().getContractMerge() != null) {
                rspBO.getContractLawInfo().setContractMergeStr(ContractTransFieldUtil.transContractMerge(rspBO.getContractLawInfo().getContractMerge()));
            }
            if (rspBO.getContractLawInfo().getContractGuarantee() != null) {
                rspBO.getContractLawInfo().setContractGuaranteeStr(ContractTransFieldUtil.transContractGuarantee(rspBO.getContractLawInfo().getContractGuarantee()));
            }
            if (rspBO.getContractLawInfo().getCompanyRepresentativeSign() != null) {
                rspBO.getContractLawInfo().setCompanyRepresentativeSignStr(ContractTransFieldUtil.transCompanyRepresentativeSign(rspBO.getContractLawInfo().getCompanyRepresentativeSign()));
            }
            if (rspBO.getContractLawInfo().getContractForeign() != null) {
                rspBO.getContractLawInfo().setContractForeignStr(ContractTransFieldUtil.transContractForeign(rspBO.getContractLawInfo().getContractForeign()));
            }
        }
        if (ObjectUtil.isNotEmpty((Object)rspBO.getContractCooperationInfo())) {
            if (rspBO.getContractCooperationInfo().getInvoiceType() != null) {
                rspBO.getContractCooperationInfo().setInvoiceTypeStr(ContractTransFieldUtil.transInvoiceType(rspBO.getContractCooperationInfo().getInvoiceType()));
            }
            if (rspBO.getContractCooperationInfo().getTaxPoint() != null) {
                rspBO.getContractCooperationInfo().setTaxPointStr(ContractTransFieldUtil.transTaxPoint(rspBO.getContractCooperationInfo().getTaxPoint()));
            }
            if (rspBO.getContractCooperationInfo().getContractExpireBefore() != null) {
                rspBO.getContractCooperationInfo().setContractExpireBeforeStr(ContractTransFieldUtil.transContractExpireBefore(rspBO.getContractCooperationInfo().getContractExpireBefore()));
            }
            if (!CollectionUtils.isEmpty((Collection)rspBO.getContractCooperationInfo().getTaxPointList())) {
                ArrayList taxPointStrList = new ArrayList();
                rspBO.getContractCooperationInfo().getTaxPointList().forEach(item -> taxPointStrList.add(ContractTransFieldUtil.transTaxPoint(Integer.valueOf(item))));
                rspBO.getContractCooperationInfo().setTaxPointStrList(taxPointStrList);
            }
        }
    }
}

