/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.busi.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.ohaotian.plugin.db.Page;
import com.tydic.contract.ability.bo.ContractCooperationCategoryBO;
import com.tydic.contract.ability.bo.ContractItemBO;
import com.tydic.contract.busi.ContractQryItemBusiService;
import com.tydic.contract.busi.bo.ContractQryItemBusiReqBO;
import com.tydic.contract.busi.bo.ContractQryItemBusiRspBO;
import com.tydic.contract.dao.CContractCooperationCategoryChangeMapper;
import com.tydic.contract.dao.CContractCooperationCategoryMapper;
import com.tydic.contract.dao.CContractItemChangeMapper;
import com.tydic.contract.dao.ContractItemMapper;
import com.tydic.contract.po.CContractCooperationCategoryChangePO;
import com.tydic.contract.po.CContractCooperationCategoryPO;
import com.tydic.contract.po.CContractItemChangePO;
import com.tydic.contract.po.ContractItemPo;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
public class ContractQryItemBusiServiceImpl
implements ContractQryItemBusiService {
    private static final Logger log = LoggerFactory.getLogger(ContractQryItemBusiServiceImpl.class);
    @Autowired
    private ContractItemMapper contractItemMapper;
    @Autowired
    private CContractCooperationCategoryMapper contractCooperationCategoryMapper;
    @Autowired
    private CContractItemChangeMapper cContractItemChangeMapper;
    @Autowired
    private CContractCooperationCategoryChangeMapper cContractCooperationCategoryChangeMapper;

    @Override
    public ContractQryItemBusiRspBO qryContractItem(ContractQryItemBusiReqBO reqBO) {
        if (ObjectUtils.isEmpty((Object)reqBO.getUpdateApplyId())) {
            Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
            List<ContractItemPo> itemPos = this.contractItemMapper.selectByRelateId(reqBO.getRelateId(), page);
            ContractQryItemBusiRspBO rspBO = new ContractQryItemBusiRspBO();
            if (!CollectionUtils.isEmpty(itemPos)) {
                rspBO.setRespCode("0000");
                rspBO.setRespDesc("\u5408\u540c\u660e\u7ec6\u4fe1\u606f\u5217\u8868\u67e5\u8be2\u6210\u529f");
                List<ContractItemBO> rows = this.transResultData(itemPos);
                rspBO.setRows(rows);
                rspBO.setPageNo(page.getPageNo());
                rspBO.setTotal(page.getTotalPages());
                rspBO.setRecordsTotal(page.getTotalCount());
            } else {
                rspBO.setRespCode("0000");
                rspBO.setRespDesc("\u672a\u67e5\u8be2\u5230\u6570\u636e");
            }
            return rspBO;
        }
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        List<CContractItemChangePO> itemPos = this.cContractItemChangeMapper.selectByRelateId(reqBO.getUpdateApplyId(), page);
        ContractQryItemBusiRspBO rspBO = new ContractQryItemBusiRspBO();
        if (!CollectionUtils.isEmpty(itemPos)) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u5408\u540c\u660e\u7ec6\u4fe1\u606f\u5217\u8868\u67e5\u8be2\u6210\u529f");
            List<ContractItemBO> rows = this.transResultData1(itemPos);
            rspBO.setRows(rows);
            rspBO.setPageNo(page.getPageNo());
            rspBO.setTotal(page.getTotalPages());
            rspBO.setRecordsTotal(page.getTotalCount());
        } else {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u672a\u67e5\u8be2\u5230\u6570\u636e");
        }
        return rspBO;
    }

    private List<ContractItemBO> transResultData(List<ContractItemPo> list) {
        String resultJsonStr = JSON.toJSONString(list);
        List rows = JSONArray.parseArray((String)resultJsonStr).toJavaList(ContractItemBO.class);
        for (ContractItemBO row : rows) {
            try {
                List<CContractCooperationCategoryPO> cooperationCategoryPos;
                row.setUnitPriceMoney(row.getUnitPriceMoney());
                row.setTotalAmountMoney(row.getTotalAmountMoney());
                row.setModel(row.getModel());
                CContractCooperationCategoryPO cooperationCategoryPo = new CContractCooperationCategoryPO();
                cooperationCategoryPo.setRelateId(row.getItemId());
                StringBuilder cooperationCategoryStr = new StringBuilder();
                if (!ObjectUtil.isNotEmpty((Object)cooperationCategoryPo) || CollectionUtils.isEmpty(cooperationCategoryPos = this.contractCooperationCategoryMapper.getList(cooperationCategoryPo))) continue;
                String resultString = JSON.toJSONString(cooperationCategoryPos);
                List contractCooperationCategoryBOList = JSONArray.parseArray((String)resultString).toJavaList(ContractCooperationCategoryBO.class);
                row.setCooperationCategoryList(contractCooperationCategoryBOList);
                for (ContractCooperationCategoryBO cooperationCategoryBO : contractCooperationCategoryBOList) {
                    cooperationCategoryStr.append(cooperationCategoryBO.getCooperationCategoryName()).append("\u3001");
                }
                if (cooperationCategoryStr.length() > 0) {
                    cooperationCategoryStr.deleteCharAt(cooperationCategoryStr.length() - 1);
                }
                row.setCooperationCategoryStr(cooperationCategoryStr.toString());
            }
            catch (Exception e) {
                log.error("\u91d1\u94b1\u8f6c\u5316\u51fa\u9519\uff1a" + e.getMessage());
            }
        }
        return rows;
    }

    private List<ContractItemBO> transResultData1(List<CContractItemChangePO> list) {
        String resultJsonStr = JSON.toJSONString(list);
        List rows = JSONArray.parseArray((String)resultJsonStr).toJavaList(ContractItemBO.class);
        for (ContractItemBO row : rows) {
            try {
                List<CContractCooperationCategoryChangePO> cooperationCategoryPos;
                row.setUnitPriceMoney(row.getUnitPriceMoney());
                row.setTotalAmountMoney(row.getTotalAmountMoney());
                row.setModel(row.getModel());
                CContractCooperationCategoryChangePO cooperationCategoryPo = new CContractCooperationCategoryChangePO();
                cooperationCategoryPo.setRelateId(row.getItemId());
                StringBuilder cooperationCategoryStr = new StringBuilder();
                if (!ObjectUtil.isNotEmpty((Object)cooperationCategoryPo) || CollectionUtils.isEmpty(cooperationCategoryPos = this.cContractCooperationCategoryChangeMapper.getList(cooperationCategoryPo))) continue;
                String resultString = JSON.toJSONString(cooperationCategoryPos);
                List contractCooperationCategoryBOList = JSONArray.parseArray((String)resultString).toJavaList(ContractCooperationCategoryBO.class);
                row.setCooperationCategoryList(contractCooperationCategoryBOList);
                for (ContractCooperationCategoryBO cooperationCategoryBO : contractCooperationCategoryBOList) {
                    cooperationCategoryStr.append(cooperationCategoryBO.getCooperationCategoryName()).append("\u3001");
                }
                if (cooperationCategoryStr.length() > 0) {
                    cooperationCategoryStr.deleteCharAt(cooperationCategoryStr.length() - 1);
                }
                row.setCooperationCategoryStr(cooperationCategoryStr.toString());
            }
            catch (Exception e) {
                log.error("\u91d1\u94b1\u8f6c\u5316\u51fa\u9519\uff1a" + e.getMessage());
            }
        }
        return rows;
    }
}

