/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.busi.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.ohaotian.plugin.common.util.MoneyUtils;
import com.ohaotian.plugin.db.Page;
import com.tydic.contract.ability.bo.ContractListBO;
import com.tydic.contract.busi.ContractQryListBusiService;
import com.tydic.contract.busi.bo.ContractQryListBusiReqBO;
import com.tydic.contract.busi.bo.ContractQryListBusiRspBO;
import com.tydic.contract.constant.ContractConstant;
import com.tydic.contract.dao.CContractLawInfoMapper;
import com.tydic.contract.dao.ContractMapper;
import com.tydic.contract.dao.ContractTaskInstMapper;
import com.tydic.contract.po.CContractLawInfoPO;
import com.tydic.contract.po.ContractPo;
import com.tydic.contract.po.ContractTaskInstPO;
import com.tydic.contract.po.OrderContractPo;
import com.tydic.contract.utils.ContractTransFieldUtil;
import com.tydic.contract.utils.DateTimeUtils;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ContractQryListBusiServiceImpl
implements ContractQryListBusiService {
    private static final Logger log = LoggerFactory.getLogger(ContractQryListBusiServiceImpl.class);
    @Autowired
    private ContractMapper contractMapper;
    @Autowired
    private ContractTaskInstMapper contractTaskInstMapper;
    @Autowired
    private CContractLawInfoMapper cContractLawInfoMapper;
    @Value(value="${manager_users:1}")
    private String managerUsers;

    @Override
    public ContractQryListBusiRspBO qryContractList(ContractQryListBusiReqBO reqBO) {
        ContractQryListBusiRspBO rspBO = new ContractQryListBusiRspBO();
        ContractPo queryAgrContractPo = new ContractPo();
        BeanUtils.copyProperties((Object)((Object)reqBO), (Object)queryAgrContractPo);
        queryAgrContractPo.setContractSignDateEnd(DateTimeUtils.Date2String(queryAgrContractPo.getContractSignDateEnd()));
        queryAgrContractPo.setContractSignDateStart(DateTimeUtils.Date2String(queryAgrContractPo.getContractSignDateStart()));
        queryAgrContractPo.setContractEndDateStart(DateTimeUtils.Date2String(queryAgrContractPo.getContractEndDateStart()));
        queryAgrContractPo.setContractEndDateEnd(DateTimeUtils.Date2String(queryAgrContractPo.getContractEndDateEnd()));
        queryAgrContractPo.setPartyBName(reqBO.getPartyBName());
        queryAgrContractPo.setFeeType(reqBO.getFeeType());
        queryAgrContractPo.setPartyBCode(reqBO.getPartyBCode());
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        List<Object> contractPos = new ArrayList();
        List<String> managerUserList = Arrays.asList(this.managerUsers.split(","));
        if (ObjectUtil.isEmpty(queryAgrContractPo.getContractAuditStatusList())) {
            if (reqBO.getUserId() != null && managerUserList.contains(reqBO.getUserId().toString())) {
                queryAgrContractPo.setUserId(null);
            }
            if (Objects.equals(3, reqBO.getOperType())) {
                queryAgrContractPo.setUserId(null);
            }
            contractPos = this.contractMapper.qryByCondition(queryAgrContractPo, page);
        } else {
            queryAgrContractPo.setUserId(reqBO.getUserId());
            List<Integer> auditStatusS = queryAgrContractPo.getContractAuditStatusList();
            log.info("\u5ba1\u6279\u72b6\u6001,{}", (Object)JSON.toJSONString(auditStatusS));
            queryAgrContractPo.setContractStatusList(new ArrayList<Integer>());
            if (!auditStatusS.contains(Integer.valueOf("1"))) {
                queryAgrContractPo.setFinishTag(ContractConstant.PROC_TASK_FINISHED.NO_FINISHED);
                queryAgrContractPo.setContractStatusList(Arrays.asList(ContractConstant.ContractStatus.CONTRACT_STATUS_UNDER_APPROVAL));
            } else if (!auditStatusS.contains(Integer.valueOf("2"))) {
                queryAgrContractPo.setFinishTag(ContractConstant.PROC_TASK_FINISHED.FINISHED);
            } else {
                queryAgrContractPo.setFinishTag(null);
            }
            contractPos = this.contractMapper.qryByConditionAudited(queryAgrContractPo, page);
        }
        log.info("\u67e5\u8be2\u7ed3\u679c\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)page));
        List<Object> rows = new ArrayList();
        if (!CollectionUtils.isEmpty(contractPos)) {
            rows = this.transAgrAndEnterContractResult(contractPos, reqBO.getUserId());
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u5408\u540c\u5217\u8868\u67e5\u8be2\u6210\u529f");
        rspBO.setRows(rows);
        if (ObjectUtil.isNotEmpty((Object)rspBO.getRows())) {
            for (int i = 0; i < rows.size(); ++i) {
                ((ContractListBO)rspBO.getRows().get(i)).setSort(Integer.valueOf(i + 1));
            }
        }
        rspBO.setPageNo(page.getPageNo());
        rspBO.setTotal(page.getTotalPages());
        rspBO.setRecordsTotal(page.getTotalCount());
        return rspBO;
    }

    private List<ContractListBO> transAgrAndEnterContractResult(List<ContractPo> list, Long userId) {
        ContractPo contractPo;
        ContractListBO contractListBO;
        ArrayList<ContractListBO> rows = new ArrayList<ContractListBO>();
        ContractTaskInstPO contractTaskInstPO = new ContractTaskInstPO();
        Iterator<ContractPo> iterator = list.iterator();
        while (iterator.hasNext() && !ObjectUtil.isEmpty((Object)(contractListBO = (ContractListBO)JSON.parseObject((String)JSON.toJSONString((Object)(contractPo = iterator.next())), ContractListBO.class)))) {
            contractListBO.setContractSignDate(DateTimeUtils.Time2Date(contractListBO.getContractSignDate()));
            contractListBO.setNeedArriveTime(DateTimeUtils.Time2Date(contractListBO.getNeedArriveTime()));
            contractListBO.setContractEndDate(DateTimeUtils.Time2Date(contractListBO.getContractEndDate()));
            if (contractListBO.getContractStatus() != null) {
                contractListBO.setContractStatusStr(ContractTransFieldUtil.transContractStatus(contractListBO.getContractStatus()));
                contractListBO.setStatus(contractListBO.getContractStatus());
                contractListBO.setStatusStr(ContractTransFieldUtil.transContractStatus(contractListBO.getContractStatus()));
            }
            if (contractListBO.getSealWay() != null) {
                contractListBO.setSealWayStr(ContractTransFieldUtil.transSealWay(contractListBO.getSealWay()));
            }
            if (contractListBO.getContractType() != null) {
                contractListBO.setContractTypeStr(ContractTransFieldUtil.transZSCMContractType(contractListBO.getContractType()));
            }
            if (contractListBO.getIncomeContractType() != null) {
                contractListBO.setIncomeContractTypeStr(ContractTransFieldUtil.transZSCMIncomeContractType(contractListBO.getIncomeContractType()));
            }
            if (contractListBO.getFeeType() != null) {
                contractListBO.setFeeTypeStr(ContractTransFieldUtil.transFeeType(contractListBO.getFeeType()));
            }
            if (contractListBO.getPayType() != null) {
                contractListBO.setPayTypeStr(ContractTransFieldUtil.transPayType(contractListBO.getPayType()));
            }
            if (contractListBO.getExpectSettle() != null) {
                contractListBO.setExpectSettleStr(ContractTransFieldUtil.transExpectSettle(contractListBO.getExpectSettle()));
            }
            if (contractListBO.getSsBusiWay() != null) {
                contractListBO.setSsBusiWayStr(ContractTransFieldUtil.transSsBusiWay(contractListBO.getSsBusiWay()));
            }
            if (contractListBO.getOrgType() != null) {
                contractListBO.setOrgTypeStr(ContractTransFieldUtil.transContractOrgType(contractListBO.getOrgType()));
            }
            try {
                contractListBO.setContractAmountMoney(MoneyUtils.Long2BigDecimal((Long)contractListBO.getContractAmount()));
            }
            catch (Exception e) {
                log.error("\u91d1\u94b1\u8f6c\u6362\u51fa\u9519\uff1a" + e.getMessage());
            }
            contractTaskInstPO.setContractId(contractListBO.getContractId());
            contractTaskInstPO.setFinishTag(0);
            contractTaskInstPO.setUserId(userId);
            List<ContractTaskInstPO> contractTaskInstPOS = this.contractTaskInstMapper.qryTaskInstList(contractTaskInstPO);
            if (ObjectUtil.isNotEmpty(contractTaskInstPOS)) {
                contractListBO.setTaskId(contractTaskInstPOS.get(0).getTaskInstId());
                contractListBO.setTaskSignTag(contractTaskInstPOS.get(0).getTaskSignTag());
                contractListBO.setProcInstId(contractTaskInstPOS.get(0).getProcInstId());
            } else {
                contractTaskInstPO.setFinishTag(1);
                contractTaskInstPOS = this.contractTaskInstMapper.qryTaskInstList(contractTaskInstPO);
                contractListBO.setProcInstId(ObjectUtil.isNotEmpty(contractTaskInstPOS) ? contractTaskInstPOS.get(0).getProcInstId() : null);
            }
            contractListBO.setPartyA(contractPo.getPartyA1Name());
            contractListBO.setPartyB(contractPo.getPartyBName());
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            contractListBO.setContractSignDate(ObjectUtil.isNotEmpty((Object)contractPo.getContractSignDate()) ? dateFormat.format(contractPo.getContractSignDate()) : "-");
            contractListBO.setContractEndDate(ObjectUtil.isNotEmpty((Object)contractPo.getContractEndDate()) ? dateFormat.format(contractPo.getContractEndDate()) : "-");
            contractListBO.setContractStartDate(ObjectUtil.isNotEmpty((Object)contractPo.getContractStartDate()) ? dateFormat.format(contractPo.getContractStartDate()) : "-");
            CContractLawInfoPO cContractLawInfoPO = new CContractLawInfoPO();
            cContractLawInfoPO.setRelateId(contractPo.getContractId());
            CContractLawInfoPO modelBy = this.cContractLawInfoMapper.getModelBy(cContractLawInfoPO);
            if (ObjectUtil.isNotEmpty((Object)modelBy)) {
                contractListBO.setTotalAmount(modelBy.getContractTotalAmount());
            }
            contractListBO.setContractPerformWay(contractPo.getContractPerformanceMode());
            if (contractPo.getContractPerformanceMode() != null) {
                contractListBO.setContractPerformWayStr(ContractTransFieldUtil.transContractPerformanceMode(contractPo.getContractPerformanceMode()));
            }
            rows.add(contractListBO);
        }
        return rows;
    }

    private List<ContractListBO> transOrderContractResult(List<OrderContractPo> list, Long userId) {
        String resultJsonStr = JSON.toJSONString(list);
        List rows = JSONArray.parseArray((String)resultJsonStr).toJavaList(ContractListBO.class);
        ContractTaskInstPO contractTaskInstPO = new ContractTaskInstPO();
        for (ContractListBO contractListBO : rows) {
            List<ContractTaskInstPO> contractTaskInstPOS;
            contractListBO.setContractSignDate(DateTimeUtils.Time2Date(contractListBO.getContractSignDate()));
            contractListBO.setNeedArriveTime(DateTimeUtils.Time2Date(contractListBO.getNeedArriveTime()));
            contractListBO.setContractEndDate(DateTimeUtils.Time2Date(contractListBO.getContractEndDate()));
            if (contractListBO.getContractStatus() != null) {
                contractListBO.setContractStatusStr(ContractTransFieldUtil.transContractStatus(contractListBO.getContractStatus()));
            }
            if (contractListBO.getOrderSource() != null) {
                contractListBO.setOrderSourceStr(ContractTransFieldUtil.transOrderSource(contractListBO.getOrderSource()));
            }
            if (contractListBO.getPayType() != null) {
                contractListBO.setPayTypeStr(ContractTransFieldUtil.transPayType(contractListBO.getPayType()));
            }
            if (contractListBO.getExpectSettle() != null) {
                contractListBO.setExpectSettleStr(ContractTransFieldUtil.transExpectSettle(contractListBO.getExpectSettle()));
            }
            if (contractListBO.getContractType() != null) {
                contractListBO.setContractTypeStr(ContractTransFieldUtil.transContractType(contractListBO.getContractType()));
            }
            if (contractListBO.getSupplierType() != null) {
                contractListBO.setSupplierTypeStr(ContractTransFieldUtil.transSupplierType(contractListBO.getSupplierType()));
            }
            if (contractListBO.getOrgType() != null) {
                contractListBO.setOrgTypeStr(ContractTransFieldUtil.transContractOrgType(contractListBO.getOrgType()));
            }
            try {
                contractListBO.setContractAmountMoney(MoneyUtils.Long2BigDecimal((Long)contractListBO.getContractAmount()));
            }
            catch (Exception e) {
                log.error("\u91d1\u94b1\u8f6c\u6362\u51fa\u9519\uff1a" + e.getMessage());
            }
            contractTaskInstPO.setContractId(contractListBO.getContractId());
            contractTaskInstPO.setFinishTag(0);
            if (userId != 1L) {
                contractTaskInstPO.setUserId(userId);
            }
            if (ObjectUtil.isNotEmpty(contractTaskInstPOS = this.contractTaskInstMapper.qryTaskInstList(contractTaskInstPO))) {
                contractListBO.setTaskId(contractTaskInstPOS.get(0).getTaskInstId());
                contractListBO.setTaskSignTag(contractTaskInstPOS.get(0).getTaskSignTag());
                contractListBO.setProcInstId(contractTaskInstPOS.get(0).getProcInstId());
            }
            if (!ObjectUtil.isEmpty((Object)contractListBO.getProcInstId())) continue;
            contractTaskInstPO.setFinishTag(null);
            contractTaskInstPOS = this.contractTaskInstMapper.qryTaskInstList(contractTaskInstPO);
            if (ObjectUtil.isEmpty(contractTaskInstPOS)) continue;
            contractListBO.setProcInstId(contractTaskInstPOS.get(0).getProcInstId());
        }
        return rows;
    }
}

