/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.busi.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.ohaotian.plugin.db.Page;
import com.tydic.contract.ability.bo.ContractTermsInfoBO;
import com.tydic.contract.busi.ContractQryTermsListBusiService;
import com.tydic.contract.busi.bo.ContractQryTermsListBusiReqBO;
import com.tydic.contract.busi.bo.ContractQryTermsListBusiRspBO;
import com.tydic.contract.constant.ContractConstant;
import com.tydic.contract.dao.ContractTermsMapper;
import com.tydic.contract.po.ContractTermsPo;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ContractQryTermsListBusiServiceImpl
implements ContractQryTermsListBusiService {
    @Autowired
    private ContractTermsMapper contractTermsMapper;

    @Override
    public ContractQryTermsListBusiRspBO qryTermsList(ContractQryTermsListBusiReqBO reqBO) {
        ContractQryTermsListBusiRspBO rspBO = new ContractQryTermsListBusiRspBO();
        ContractTermsPo po = new ContractTermsPo();
        BeanUtils.copyProperties((Object)((Object)reqBO), (Object)po);
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        List<ContractTermsPo> contractTermsPos = this.contractTermsMapper.qryContractTermsList(po, page);
        if (!CollectionUtils.isEmpty(contractTermsPos)) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u5408\u540c\u6761\u6b3e\u5217\u8868\u67e5\u8be2\u6210\u529f");
            List<ContractTermsInfoBO> rows = this.transResultData(contractTermsPos);
            for (ContractTermsInfoBO bo : rows) {
                if (bo.getCreateDeptId().equals(reqBO.getCurrentOrgId())) {
                    bo.setIsCurrentData(Boolean.valueOf(true));
                    continue;
                }
                bo.setIsCurrentData(Boolean.valueOf(false));
            }
            rspBO.setRows(rows);
            if (ObjectUtil.isNotEmpty((Object)rspBO.getRows())) {
                for (int i = 0; i < rspBO.getRows().size(); ++i) {
                    ((ContractTermsInfoBO)rspBO.getRows().get(i)).setSort(Integer.valueOf(i + 1));
                }
            }
            rspBO.setPageNo(page.getPageNo());
            rspBO.setTotal(page.getTotalPages());
            rspBO.setRecordsTotal(page.getTotalCount());
        } else {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u672a\u67e5\u8be2\u5230\u6570\u636e");
        }
        return rspBO;
    }

    private List<ContractTermsInfoBO> transResultData(List<ContractTermsPo> list) {
        String resultJsonStr = JSON.toJSONString(list);
        List rows = JSONArray.parseArray((String)resultJsonStr).toJavaList(ContractTermsInfoBO.class);
        for (ContractTermsInfoBO contractTermsInfoBO : rows) {
            if (ContractConstant.TermType.TERM_TYPE_AGREE_CODE == contractTermsInfoBO.getTermType()) {
                contractTermsInfoBO.setTermTypeStr("\u534f\u8bae\u5408\u540c");
                continue;
            }
            if (ContractConstant.TermType.TERM_TYPE_ORDER_CODE == contractTermsInfoBO.getTermType()) {
                contractTermsInfoBO.setTermTypeStr("\u8ba2\u5355\u5408\u540c");
                continue;
            }
            if (ContractConstant.TermType.TERM_TYPE_ENTRY_CODE == contractTermsInfoBO.getTermType()) {
                contractTermsInfoBO.setTermTypeStr("\u5165\u9a7b\u5408\u540c");
                continue;
            }
            contractTermsInfoBO.setTermTypeStr("\u9519\u8bef\u7684\u6761\u6b3e\u7c7b\u578b");
        }
        return rows;
    }
}

