/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.busi.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.contract.busi.ContractRenewBusiService;
import com.tydic.contract.busi.bo.ContractRenewBusiReqBO;
import com.tydic.contract.busi.bo.ContractRenewBusiRspBO;
import com.tydic.contract.constant.ContractConstant;
import com.tydic.contract.dao.CContractCooperationCategoryMapper;
import com.tydic.contract.dao.CContractCooperationInfoMapper;
import com.tydic.contract.dao.CContractLawInfoMapper;
import com.tydic.contract.dao.CContractPayPlanMapper;
import com.tydic.contract.dao.ContractAccessoryMapper;
import com.tydic.contract.dao.ContractItemMapper;
import com.tydic.contract.dao.ContractMapper;
import com.tydic.contract.po.CContractCooperationCategoryPO;
import com.tydic.contract.po.CContractCooperationInfoPO;
import com.tydic.contract.po.CContractLawInfoPO;
import com.tydic.contract.po.CContractPayPlanPO;
import com.tydic.contract.po.ContractAccessoryPo;
import com.tydic.contract.po.ContractItemPo;
import com.tydic.contract.po.ContractPo;
import com.tydic.plugin.encoded.service.CfcEncodedSerialGetService;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialGetServiceReqBO;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialGetServiceRspBO;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
public class ContractRenewBusiServiceImpl
implements ContractRenewBusiService {
    private static final Logger log = LoggerFactory.getLogger(ContractRenewBusiServiceImpl.class);
    @Autowired
    private CfcEncodedSerialGetService encodedSerialGetService;
    @Autowired
    private ContractMapper contractMapper;
    @Autowired
    private ContractItemMapper contractItemMapper;
    @Autowired
    private CContractCooperationInfoMapper contractCooperationInfoMapper;
    @Autowired
    private CContractCooperationCategoryMapper contractCooperationCategoryMapper;
    @Autowired
    private CContractLawInfoMapper contractLawInfoMapper;
    @Autowired
    private CContractPayPlanMapper contractPayPlanMapper;
    @Autowired
    private ContractAccessoryMapper contractAccessoryMapper;

    @Override
    public ContractRenewBusiRspBO renewContract(ContractRenewBusiReqBO reqBO) {
        ContractRenewBusiRspBO rspBO = new ContractRenewBusiRspBO();
        if (ObjectUtils.isEmpty((Object)reqBO) || reqBO.getContractId() == null) {
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u53c2\u6570\u4e3a\u7a7a\u6216\u8005\u7eed\u7b7e\u7684\u5408\u540cid\u4e3a\u7a7a");
            return rspBO;
        }
        ContractPo contractPo = this.contractMapper.selectByPrimaryKey(reqBO.getContractId());
        if (contractPo == null) {
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u5408\u540c\u4e0d\u5b58\u5728");
            return rspBO;
        }
        ContractPo whereOrginContract = new ContractPo();
        whereOrginContract.setRenewStatus(2);
        int renewNum = contractPo.getRenewNum() - 1;
        whereOrginContract.setRenewNum(renewNum);
        whereOrginContract.setContractId(reqBO.getContractId());
        int i = this.contractMapper.updateByPrimaryKeySelective(whereOrginContract);
        if (i != 1) {
            throw new ZTBusinessException("\u66f4\u65b0\u539f\u5408\u540c\u7eed\u7b7e\u4fe1\u606f\u5931\u8d25");
        }
        Long oldContractId = contractPo.getContractId();
        String oldContractCode = contractPo.getContractCode();
        Long newContractId = Sequence.getInstance().nextId();
        contractPo.setRenewStatus(1);
        if (Objects.equals(0, renewNum)) {
            contractPo.setRenewStatus(3);
        }
        contractPo.setRenewNum(renewNum);
        contractPo.setContractSignDate(new Date());
        contractPo.setContractCode(this.generateCode());
        contractPo.setContractId(newContractId);
        contractPo.setRelateId(reqBO.getContractId());
        contractPo.setRelateCode(oldContractCode);
        contractPo.setCreateUserId(reqBO.getUserId());
        contractPo.setCreateUserName(reqBO.getName());
        contractPo.setCreateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
        contractPo.setUpdateUserId(reqBO.getUserId());
        contractPo.setUpdateUserName(reqBO.getName());
        contractPo.setAddContractTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
        contractPo.setContractApprovalPassTime(null);
        contractPo.setStartSignTime(null);
        contractPo.setGenerateSideSignTime(null);
        contractPo.setSupplierSideSignTime(null);
        contractPo.setContractEffectTime(null);
        contractPo.setUpdateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
        contractPo.setRelateType(ContractConstant.RelateContractType.RENEW_CONTRACT);
        contractPo.setContractStatus(ContractConstant.ContractStatus.CONTRACT_STATUS_DRAFT);
        int addContractResult = this.contractMapper.insertSelective(contractPo);
        if (addContractResult <= 0) {
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u521b\u5efa\u7eed\u7b7e\u5408\u540c\u5931\u8d25");
            return rspBO;
        }
        this.copyContractItem(oldContractId, contractPo, reqBO);
        this.copyContractLawInfo(oldContractId, contractPo, reqBO, oldContractCode);
        this.copyContractCooperationInfo(oldContractId, contractPo, reqBO);
        this.copyContractPayPlan(oldContractId, contractPo, reqBO);
        this.copyContractAccessory(oldContractId, contractPo, reqBO);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u7eed\u7b7e\u5408\u540c\u590d\u5236\u6210\u529f");
        rspBO.setContractId(newContractId);
        rspBO.setContractCode(contractPo.getContractCode());
        return rspBO;
    }

    private void copyContractAccessory(Long oldContractId, ContractPo contractPo, ContractRenewBusiReqBO reqBO) {
        ContractAccessoryPo qryContractAccessoryPo = new ContractAccessoryPo();
        qryContractAccessoryPo.setRelateId(oldContractId);
        List<ContractAccessoryPo> oldContractAccessoryPos = this.contractAccessoryMapper.qryByCondition(qryContractAccessoryPo);
        if (!CollectionUtils.isEmpty(oldContractAccessoryPos)) {
            ArrayList<ContractAccessoryPo> ContractAccessoryPos = new ArrayList<ContractAccessoryPo>();
            for (ContractAccessoryPo item : oldContractAccessoryPos) {
                ContractAccessoryPo newContractAccessoryPo = new ContractAccessoryPo();
                BeanUtils.copyProperties((Object)item, (Object)newContractAccessoryPo);
                newContractAccessoryPo.setAcceessoryId(Sequence.getInstance().nextId());
                newContractAccessoryPo.setCreateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
                newContractAccessoryPo.setRelateId(contractPo.getContractId());
                newContractAccessoryPo.setRelateCode(contractPo.getContractCode());
                newContractAccessoryPo.setCreateUserId(reqBO.getUserId());
                newContractAccessoryPo.setCreateUserName(reqBO.getName());
                ContractAccessoryPos.add(newContractAccessoryPo);
            }
            int insertBatch = this.contractAccessoryMapper.insertBatch(ContractAccessoryPos);
            if (insertBatch < 1) {
                throw new ZTBusinessException("\u590d\u5236\u7eed\u7b7e\u5408\u540c\u9644\u4ef6\u4fe1\u606f\u5931\u8d25");
            }
        }
    }

    private void copyContractPayPlan(Long oldContractId, ContractPo contractPo, ContractRenewBusiReqBO reqBO) {
        CContractPayPlanPO payPlanPO = new CContractPayPlanPO();
        payPlanPO.setRelateId(oldContractId);
        List<CContractPayPlanPO> payPlanPOS = this.contractPayPlanMapper.getList(payPlanPO);
        if (!CollectionUtils.isEmpty(payPlanPOS)) {
            for (CContractPayPlanPO payPlanPO1 : payPlanPOS) {
                CContractPayPlanPO newPayPlanPO = new CContractPayPlanPO();
                BeanUtils.copyProperties((Object)payPlanPO1, (Object)newPayPlanPO);
                newPayPlanPO.setPayPlanId(Sequence.getInstance().nextId());
                newPayPlanPO.setRelateId(contractPo.getContractId());
                newPayPlanPO.setRelateCode(contractPo.getContractCode());
                this.contractPayPlanMapper.insert(newPayPlanPO);
            }
        }
    }

    private void copyContractCooperationInfo(Long oldContractId, ContractPo contractPo, ContractRenewBusiReqBO reqBO) {
        CContractCooperationInfoPO cooperationInfoPO = new CContractCooperationInfoPO();
        cooperationInfoPO.setRelateId(oldContractId);
        List<CContractCooperationInfoPO> list = this.contractCooperationInfoMapper.getList(cooperationInfoPO);
        if (!CollectionUtils.isEmpty(list)) {
            for (CContractCooperationInfoPO cooperationInfoPO1 : list) {
                CContractCooperationInfoPO newCooperationInfoPO = new CContractCooperationInfoPO();
                BeanUtils.copyProperties((Object)cooperationInfoPO1, (Object)newCooperationInfoPO);
                newCooperationInfoPO.setCooperationContractId(Sequence.getInstance().nextId());
                newCooperationInfoPO.setRelateId(contractPo.getContractId());
                newCooperationInfoPO.setRelateCode(contractPo.getContractCode());
                this.contractCooperationInfoMapper.insert(newCooperationInfoPO);
                this.copyCategoryInfo(oldContractId, contractPo.getContractId());
            }
        }
    }

    private void copyContractLawInfo(Long oldContractId, ContractPo contractPo, ContractRenewBusiReqBO reqBO, String oldContractCode) {
        CContractLawInfoPO lawInfo = new CContractLawInfoPO();
        lawInfo.setRelateId(oldContractId);
        List<CContractLawInfoPO> contractLawInfoPOS = this.contractLawInfoMapper.getList(lawInfo);
        if (!CollectionUtils.isEmpty(contractLawInfoPOS)) {
            for (CContractLawInfoPO lawInfoPO : contractLawInfoPOS) {
                CContractLawInfoPO newLawInfoPO = new CContractLawInfoPO();
                BeanUtils.copyProperties((Object)lawInfoPO, (Object)newLawInfoPO);
                newLawInfoPO.setLawContractId(Sequence.getInstance().nextId());
                newLawInfoPO.setRelateId(contractPo.getContractId());
                newLawInfoPO.setRelateCode(contractPo.getContractCode());
                newLawInfoPO.setContractRelated(oldContractCode);
                this.contractLawInfoMapper.insert(newLawInfoPO);
            }
        }
    }

    public String generateCode() {
        CfcEncodedSerialGetServiceReqBO encodedSerialGetServiceReqBO = new CfcEncodedSerialGetServiceReqBO();
        encodedSerialGetServiceReqBO.setCenter("CONTRACT");
        encodedSerialGetServiceReqBO.setEncodedRuleCode("AGREE_CONTRACT_CODE");
        CfcEncodedSerialGetServiceRspBO encodedSerial = this.encodedSerialGetService.getEncodedSerial(encodedSerialGetServiceReqBO);
        return (String)encodedSerial.getSerialNoList().get(0);
    }

    public void copyContractItem(Long oldContractId, ContractPo contractPo, ContractRenewBusiReqBO reqBO) {
        List<ContractItemPo> contractItemPos = this.contractItemMapper.selectByRelateId(oldContractId);
        if (!CollectionUtils.isEmpty(contractItemPos)) {
            for (ContractItemPo itemPo : contractItemPos) {
                ContractItemPo newItemPo = new ContractItemPo();
                BeanUtils.copyProperties((Object)itemPo, (Object)newItemPo);
                newItemPo.setItemId(Sequence.getInstance().nextId());
                newItemPo.setRelateId(contractPo.getContractId());
                newItemPo.setRelateCode(contractPo.getContractCode());
                newItemPo.setCreateUserId(reqBO.getUserId());
                newItemPo.setCreateUserName(reqBO.getName());
                newItemPo.setCreateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
                this.contractItemMapper.insert(newItemPo);
                this.copyCategoryInfo(itemPo.getItemId(), newItemPo.getItemId());
            }
        }
    }

    public void copyCategoryInfo(Long oldRelateId, Long newRelateId) {
        CContractCooperationCategoryPO cContractCooperationCategoryPO = new CContractCooperationCategoryPO();
        cContractCooperationCategoryPO.setRelateId(oldRelateId);
        List<CContractCooperationCategoryPO> categoryPOList = this.contractCooperationCategoryMapper.getList(cContractCooperationCategoryPO);
        if (!CollectionUtils.isEmpty(categoryPOList)) {
            categoryPOList.forEach(categoryPO -> {
                CContractCooperationCategoryPO newCategoryPO = new CContractCooperationCategoryPO();
                BeanUtils.copyProperties((Object)categoryPO, (Object)newCategoryPO);
                newCategoryPO.setRelateId(newRelateId);
                newCategoryPO.setCooperationCategoryId(Sequence.getInstance().nextId());
                this.contractCooperationCategoryMapper.insert(newCategoryPO);
            });
        }
    }
}

