/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.busi.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.contract.ability.bo.ContractAccessoryBO;
import com.tydic.contract.busi.ContractStartSignBusiService;
import com.tydic.contract.busi.bo.ContractStartSignBusiReqBO;
import com.tydic.contract.busi.bo.ContractStartSignBusiRspBO;
import com.tydic.contract.constant.ContractConstant;
import com.tydic.contract.dao.ContractAccessoryMapper;
import com.tydic.contract.dao.ContractMapper;
import com.tydic.contract.po.ContractAccessoryPo;
import com.tydic.contract.po.ContractPo;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ContractStartSignBusiServiceImpl
implements ContractStartSignBusiService {
    private static final Logger log = LoggerFactory.getLogger(ContractStartSignBusiServiceImpl.class);
    @Autowired
    private ContractMapper contractMapper;
    @Autowired
    private ContractAccessoryMapper contractAccessoryMapper;

    @Override
    public ContractStartSignBusiRspBO startSign(ContractStartSignBusiReqBO reqBO) {
        ContractStartSignBusiRspBO rspBO = new ContractStartSignBusiRspBO();
        rspBO.setRespCode("0000");
        if (Objects.equals(1, reqBO.getOperType())) {
            Integer sealWay = reqBO.getSealWay();
            if (ObjectUtil.isEmpty((Object)reqBO.getSealWay())) {
                rspBO.setRespCode("8888");
                rspBO.setRespDesc("\u8bf7\u9009\u62e9\u7b7e\u7ae0\u65b9\u5f0f");
                return rspBO;
            }
            ContractPo updateContractPo = new ContractPo();
            BeanUtils.copyProperties((Object)((Object)reqBO), (Object)updateContractPo);
            if (Objects.equals(ContractConstant.ContractStatus.CONTRACT_STATUS_APPROVAL, reqBO.getContractStatus())) {
                if (Objects.equals(ContractConstant.SealWay.ELECTRIC_SEAL_WAY, sealWay)) {
                    updateContractPo.setContractStatus(ContractConstant.ContractStatus.CONTRACT_STATUS_WAIT_FOR_SIGN);
                } else if (Objects.equals(ContractConstant.SealWay.UNDERLINE_SEAL_WAY, sealWay)) {
                    updateContractPo.setContractStatus(ContractConstant.ContractStatus.CONTRACT_STATUS_OFFLINE_SIGN);
                }
                updateContractPo.setStartSignTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
                int i = this.contractMapper.updateByPrimaryKeySelective(updateContractPo);
                if (i != 1) {
                    throw new ZTBusinessException("\u53d1\u8d77\u7b7e\u7ae0\u5931\u8d25");
                }
            } else {
                rspBO.setRespCode("8888");
                rspBO.setRespDesc("\u5408\u540c\u72b6\u6001\u9700\u8981\u4e3a\u5ba1\u6279\u901a\u8fc7\u624d\u80fd\u53d1\u8d77\u7b7e\u7ae0");
                return rspBO;
            }
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u53d1\u8d77\u7b7e\u7ae0\u6210\u529f");
            return rspBO;
        }
        if (Objects.equals(2, reqBO.getOperType())) {
            this.uploadContractFile(reqBO);
            ContractPo updateContractPo = new ContractPo();
            BeanUtils.copyProperties((Object)((Object)reqBO), (Object)updateContractPo);
            if (Objects.equals(ContractConstant.ContractStatus.CONTRACT_STATUS_OFFLINE_SIGN, reqBO.getContractStatus())) {
                updateContractPo.setContractStatus(ContractConstant.ContractStatus.CONTRACT_STATUS_EFFECT);
                updateContractPo.setGenerateSideSignTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
                updateContractPo.setSupplierSideSignTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
                updateContractPo.setContractEffectTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
                updateContractPo.setUpdateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
                int i = this.contractMapper.updateByPrimaryKeySelective(updateContractPo);
                if (i != 1) {
                    throw new ZTBusinessException("\u7ebf\u4e0b\u7b7e\u7ae0\u5931\u8d25");
                }
                rspBO.setRespCode("0000");
                rspBO.setRespDesc("\u7ebf\u4e0b\u7b7e\u7ae0\u6210\u529f\uff0c\u5408\u540c\u751f\u6548");
                return rspBO;
            }
            if (Objects.equals(ContractConstant.ContractStatus.CONTRACT_STATUS_WAIT_FOR_SIGN, reqBO.getContractStatus())) {
                updateContractPo.setContractStatus(ContractConstant.ContractStatus.CONTRACT_STATUS_UNDER_SIGNATORIES_SIGN_);
                updateContractPo.setGenerateSideSignTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
                updateContractPo.setUpdateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
                int i = this.contractMapper.updateByPrimaryKeySelective(updateContractPo);
                if (i != 1) {
                    throw new ZTBusinessException("\u751f\u6210\u65b9\u7b7e\u7ae0\u5931\u8d25");
                }
                rspBO.setRespCode("0000");
                rspBO.setRespDesc("\u751f\u6210\u65b9\u7b7e\u7ae0\u6210\u529f\uff0c\u8bf7\u7b7e\u5b9a\u65b9\u7b7e\u7ae0");
                return rspBO;
            }
            if (Objects.equals(ContractConstant.ContractStatus.CONTRACT_STATUS_UNDER_PRODUCER_SIGN_, reqBO.getContractStatus())) {
                updateContractPo.setContractStatus(ContractConstant.ContractStatus.CONTRACT_STATUS_EFFECT);
                updateContractPo.setGenerateSideSignTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
                updateContractPo.setContractEffectTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
                updateContractPo.setUpdateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
                int i = this.contractMapper.updateByPrimaryKeySelective(updateContractPo);
                if (i != 1) {
                    throw new ZTBusinessException("\u751f\u6210\u65b9\u7b7e\u7ae0\u5931\u8d25");
                }
                rspBO.setRespCode("0000");
                rspBO.setRespDesc("\u751f\u6210\u65b9\u7b7e\u7ae0\u6210\u529f\uff0c\u5408\u540c\u751f\u6548");
                return rspBO;
            }
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u4e0a\u4f20\u7b7e\u7ae0\u5408\u540c\u5931\u8d25\uff0c\u8bf7\u91cd\u65b0\u4e0a\u4f20");
            return rspBO;
        }
        if (Objects.equals(3, reqBO.getOperType())) {
            this.uploadContractFile(reqBO);
            ContractPo updateContractPo = new ContractPo();
            BeanUtils.copyProperties((Object)((Object)reqBO), (Object)updateContractPo);
            if (Objects.equals(ContractConstant.ContractStatus.CONTRACT_STATUS_WAIT_FOR_SIGN, reqBO.getContractStatus())) {
                updateContractPo.setContractStatus(ContractConstant.ContractStatus.CONTRACT_STATUS_UNDER_PRODUCER_SIGN_);
                updateContractPo.setSupplierSideSignTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
                updateContractPo.setUpdateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
                int i = this.contractMapper.updateByPrimaryKeySelective(updateContractPo);
                if (i != 1) {
                    throw new ZTBusinessException("\u7b7e\u5b9a\u65b9\u7b7e\u7ae0\u5931\u8d25");
                }
                rspBO.setRespCode("0000");
                rspBO.setRespDesc("\u7b7e\u5b9a\u65b9\u7b7e\u7ae0\u6210\u529f\uff0c\u8bf7\u751f\u6210\u65b9\u7b7e\u7ae0");
                return rspBO;
            }
            if (Objects.equals(ContractConstant.ContractStatus.CONTRACT_STATUS_UNDER_SIGNATORIES_SIGN_, reqBO.getContractStatus())) {
                updateContractPo.setContractStatus(ContractConstant.ContractStatus.CONTRACT_STATUS_EFFECT);
                updateContractPo.setSupplierSideSignTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
                updateContractPo.setContractEffectTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
                updateContractPo.setUpdateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
                int i = this.contractMapper.updateByPrimaryKeySelective(updateContractPo);
                if (i != 1) {
                    throw new ZTBusinessException("\u7b7e\u5b9a\u65b9\u7b7e\u7ae0\u5931\u8d25");
                }
                rspBO.setRespCode("0000");
                rspBO.setRespDesc("\u7b7e\u5b9a\u65b9\u7b7e\u7ae0\u6210\u529f\uff0c\u5408\u540c\u751f\u6548");
                return rspBO;
            }
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u4e0a\u4f20\u7b7e\u7ae0\u5408\u540c\u5931\u8d25\uff0c\u8bf7\u91cd\u65b0\u4e0a\u4f20");
            return rspBO;
        }
        rspBO.setRespCode("8888");
        rspBO.setRespDesc("\u9519\u8bef\u7684\u64cd\u4f5c\u7c7b\u578b");
        return rspBO;
    }

    private void uploadContractFile(ContractStartSignBusiReqBO reqBO) {
        int insertBatch;
        if (CollectionUtils.isEmpty(reqBO.getContractAccessoryBOList())) {
            throw new ZTBusinessException("\u4e0a\u4f20\u7684\u7b7e\u7ae0\u6587\u4ef6\u4e3a\u7a7a\uff0c\u8bf7\u91cd\u65b0\u4e0a\u4f20");
        }
        ContractAccessoryPo updContractAccessoryPo = new ContractAccessoryPo();
        updContractAccessoryPo.setRelateId(reqBO.getContractId());
        updContractAccessoryPo.setRelateType(1);
        updContractAccessoryPo.setAcceessoryType(10);
        this.contractAccessoryMapper.deleteByCondition(updContractAccessoryPo);
        ArrayList<ContractAccessoryPo> insContractAccessoryPos = new ArrayList<ContractAccessoryPo>();
        if (!CollectionUtils.isEmpty(reqBO.getContractAccessoryBOList())) {
            for (ContractAccessoryBO contractAccessoryBO : reqBO.getContractAccessoryBOList()) {
                ContractAccessoryPo insContractAccessoryPo = (ContractAccessoryPo)JSON.parseObject((String)JSON.toJSONString((Object)contractAccessoryBO), ContractAccessoryPo.class);
                BeanUtils.copyProperties((Object)((Object)reqBO), (Object)insContractAccessoryPo);
                log.info("\u4e0a\u4f20\u9644\u4ef6\u5185\u5bb9\uff1a{}", (Object)contractAccessoryBO);
                insContractAccessoryPo.setAcceessoryName(contractAccessoryBO.getAcceessoryName());
                insContractAccessoryPo.setAcceessoryUrl(contractAccessoryBO.getAcceessoryUrl());
                insContractAccessoryPo.setAcceessoryId(Sequence.getInstance().nextId());
                insContractAccessoryPo.setRelateId(reqBO.getContractId());
                insContractAccessoryPo.setRelateType(1);
                insContractAccessoryPo.setAcceessoryType(10);
                insContractAccessoryPo.setRelateCode(reqBO.getContractCode());
                insContractAccessoryPo.setCreateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
                insContractAccessoryPo.setCreateUserId(reqBO.getUserId());
                insContractAccessoryPo.setCreateUserName(reqBO.getName());
                insContractAccessoryPos.add(insContractAccessoryPo);
            }
        }
        if ((insertBatch = this.contractAccessoryMapper.insertBatch(insContractAccessoryPos)) < 1) {
            throw new ZTBusinessException("\u4e0a\u4f20\u7684\u7b7e\u7ae0\u6587\u4ef6\u5931\u8d25");
        }
    }
}

