/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.busi.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.contract.ability.bo.ContractVersionBO;
import com.tydic.contract.ability.bo.ContractVersionQryAbilityReqBO;
import com.tydic.contract.ability.bo.ContractVersionQryAbilityRspBO;
import com.tydic.contract.busi.ContractVersionQryBusiService;
import com.tydic.contract.dao.CContractLogMapper;
import com.tydic.contract.dao.ContractMapper;
import com.tydic.contract.dao.ContractModifyApplyMapper;
import com.tydic.contract.po.CContractLogPO;
import com.tydic.contract.po.ContractModifyApplyPo;
import com.tydic.contract.po.ContractPo;
import com.tydic.contract.utils.DateTimeUtils;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
public class ContractVersionQryBusiServiceImpl
implements ContractVersionQryBusiService {
    private static final Logger log = LoggerFactory.getLogger(ContractVersionQryBusiServiceImpl.class);
    @Autowired
    private ContractModifyApplyMapper contractModifyApplyMapper;
    @Autowired
    private ContractMapper contractMapper;
    @Autowired
    private CContractLogMapper cContractLogMapper;

    @Override
    public ContractVersionQryAbilityRspBO qryContractVersion(ContractVersionQryAbilityReqBO reqBO) {
        ContractVersionQryAbilityRspBO rspBO = new ContractVersionQryAbilityRspBO();
        ContractVersionQryAbilityRspBO contractVersionQryAbilityRspBO = new ContractVersionQryAbilityRspBO();
        ContractPo contractPo = this.contractMapper.selectByPrimaryKey(reqBO.getContractId());
        if (contractPo == null) {
            return contractVersionQryAbilityRspBO;
        }
        ArrayList<ContractVersionBO> contractVersionList = new ArrayList<ContractVersionBO>();
        CContractLogPO qryContractLogPO = new CContractLogPO();
        qryContractLogPO.setContractId(reqBO.getContractId());
        Page page1 = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        List<CContractLogPO> contractLoglist = this.cContractLogMapper.getListPage(qryContractLogPO, (Page<CContractLogPO>)page1);
        ContractModifyApplyPo queryContractModifyApplyPo = new ContractModifyApplyPo();
        queryContractModifyApplyPo.setContractId(reqBO.getContractId());
        List<Integer> modifyStatusList = Arrays.asList(2, 3);
        queryContractModifyApplyPo.setModifyStatusList(modifyStatusList);
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        List<ContractModifyApplyPo> contractModifyApplyPos = reqBO.getPageSize() == -1 ? this.contractModifyApplyMapper.qryByCondition(queryContractModifyApplyPo) : this.contractModifyApplyMapper.qryListByCondition(queryContractModifyApplyPo, page);
        if (!CollectionUtils.isEmpty(contractLoglist)) {
            for (CContractLogPO cContractLogPO : contractLoglist) {
                ContractVersionBO contractVersionBO1 = new ContractVersionBO();
                if (!Objects.equals(cContractLogPO.getContractVersion(), 1)) continue;
                contractVersionBO1.setContractVersion("V1");
                contractVersionBO1.setStatusStr("\u5ba1\u6838\u901a\u8fc7");
                contractVersionBO1.setCreateUser(cContractLogPO.getCreateUserName());
                contractVersionBO1.setCreateUser(cContractLogPO.getCreateUserName());
                if (!ObjectUtils.isEmpty((Object)cContractLogPO.getCreateTime())) {
                    contractVersionBO1.setCreateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(cContractLogPO.getCreateTime()));
                }
                contractVersionList.add(contractVersionBO1);
                break;
            }
        }
        if (!CollectionUtils.isEmpty(contractModifyApplyPos)) {
            contractModifyApplyPos.forEach(contractModifyApplyPo -> {
                ContractVersionBO contractVersionBO1 = new ContractVersionBO();
                contractVersionBO1.setContractId(contractModifyApplyPo.getContractId());
                contractVersionBO1.setContractVersion("V" + contractModifyApplyPo.getContractVersion());
                contractVersionBO1.setChangeApplyCode(contractModifyApplyPo.getUpdateApplyCode());
                contractVersionBO1.setChangeApplyDesc(contractModifyApplyPo.getUpdateApplyRemark());
                contractVersionBO1.setStatus(contractModifyApplyPo.getModifyStatus());
                contractVersionBO1.setStatusStr(Objects.equals(2, contractModifyApplyPo.getModifyStatus()) ? "\u5ba1\u6279\u4e2d" : "\u5ba1\u6279\u901a\u8fc7");
                contractVersionBO1.setCreateUser(contractModifyApplyPo.getUpdateUserName());
                contractVersionBO1.setCreateTime(DateTimeUtils.Date4String(contractModifyApplyPo.getUpdateTime()));
                contractVersionList.add(contractVersionBO1);
            });
        }
        rspBO.setRows(contractVersionList);
        rspBO.setTotal(Integer.valueOf(contractVersionList.size()));
        rspBO.setPageNo(Integer.valueOf(page.getPageNo()));
        return rspBO;
    }
}

