/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.generateFile.impl;

import cn.hutool.core.net.URLDecoder;
import com.deepoove.poi.XWPFTemplate;
import com.deepoove.poi.config.Configure;
import com.deepoove.poi.policy.HackLoopTableRenderPolicy;
import com.deepoove.poi.policy.RenderPolicy;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.ohaotian.plugin.file.FileClient;
import com.ohaotian.plugin.file.fastdfs.FastdfsFileInfo;
import com.tydic.cfc.ability.api.CfcAddImportTemplateAbilityService;
import com.tydic.contract.ability.ContractQryItemAbilityService;
import com.tydic.contract.ability.ContractSignPartyQryAbilityService;
import com.tydic.contract.ability.UmcGenerateContractFileService;
import com.tydic.contract.ability.bo.ContractBaseInfoBO;
import com.tydic.contract.ability.bo.ContractCooperationInfoBO;
import com.tydic.contract.ability.bo.ContractItemBO;
import com.tydic.contract.ability.bo.ContractLawInfoBO;
import com.tydic.contract.ability.bo.ContractQryItemAbilityReqBO;
import com.tydic.contract.ability.bo.ContractQryItemAbilityRspBO;
import com.tydic.contract.ability.bo.ContractSignPartyInfo;
import com.tydic.contract.ability.bo.ContractSignPartyQryAbilityReqBO;
import com.tydic.contract.ability.bo.ContractSignPartyQryAbilityRspBO;
import com.tydic.contract.ability.bo.UmcGenerateContractFileReqBo;
import com.tydic.contract.ability.bo.UmcGenerateContractFileRspBo;
import com.tydic.contract.busi.ContractSaveWordAccessoryBusiService;
import com.tydic.contract.busi.bo.ContractSaveWordAccessoryBusiReqBO;
import com.tydic.contract.busi.bo.ContractSaveWordAccessoryBusiRspBO;
import com.tydic.contract.constant.ContractConstant;
import com.tydic.contract.dao.ContractAccessoryMapper;
import com.tydic.contract.po.ContractAccessoryPo;
import com.tydic.contract.utils.MoneyToChineseUtil;
import com.tydic.dyc.umc.service.register.bo.UmcSupplierInfoQryDetailReqBO;
import com.tydic.dyc.umc.service.register.bo.UmcSupplierInfoQryDetailRspBO;
import com.tydic.dyc.umc.service.register.service.UmcSupplierInfoQryDetailService;
import com.tydic.dyc.umc.service.supplieraccess.bo.UmcEnterpriseBankInfoAccessBO;
import com.tydic.dyc.umc.service.supplieraccess.bo.UmcEnterpriseInfoAccessBO;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.contract.ability.UmcGenerateContractFileService"})
public class UmcGenerateContractFileServiceImpl
implements UmcGenerateContractFileService {
    private static final Logger log = LoggerFactory.getLogger(UmcGenerateContractFileServiceImpl.class);
    @Autowired
    private FileClient fileClient;
    @Autowired
    private UmcSupplierInfoQryDetailService umcSupplierInfoQryDetailService;
    @Autowired
    private ContractSignPartyQryAbilityService contractSignPartyQryAbilityService;
    @Autowired
    private ContractQryItemAbilityService contractQryItemAbilityService;
    @Autowired
    private ContractAccessoryMapper contractAccessoryMapper;
    @Autowired
    private ContractSaveWordAccessoryBusiService contractSaveWordAccessoryBusiService;
    @Autowired
    private CfcAddImportTemplateAbilityService cfcAddImportTemplateAbilityService;
    @Value(value="${plugin.file.type}")
    private String fileType;
    private List<String> canBeUploadFileTypes;
    private String templateUrl = "/dyc/file/noauth/instData";
    private String templatePath = "a-bucket/dyc/file/instData";
    @Value(value="${dyc.file.inst.data.path:dyc/file/instData}")
    private String instDataPath;
    @Value(value="${minio.accessUrl}")
    private String accessUrl;
    @Value(value="${minio.bucketName}")
    private String bucketName;
    @Value(value="${minio.fileUrl}")
    private String httpFileUrl;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @PostMapping(value={"generateContractFile"})
    public UmcGenerateContractFileRspBo generateContractFile(@RequestBody UmcGenerateContractFileReqBo reqBo) {
        String downUrl;
        UmcGenerateContractFileRspBo rspBO = new UmcGenerateContractFileRspBo();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u751f\u6210\u5408\u540c\u6210\u529f");
        log.info("\u8bf7\u6c42\u5165\u53c2\uff1a{}", (Object)reqBo);
        HashMap<String, Object> params = new HashMap<String, Object>();
        ContractBaseInfoBO contractBaseInfo = reqBo.getContractBaseInfo();
        if (ObjectUtils.isEmpty((Object)contractBaseInfo)) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5408\u540c\u4fe1\u606f\u4e3a\u7a7a");
            return rspBO;
        }
        Date contractSignDatePartyA = contractBaseInfo.getContractSignDate();
        ContractCooperationInfoBO contractCooperationInfo = reqBo.getContractCooperationInfo();
        ContractLawInfoBO contractLawInfo = reqBo.getContractLawInfo();
        UmcSupplierInfoQryDetailReqBO umcSupplierInfoQryDetailReqBO = new UmcSupplierInfoQryDetailReqBO();
        umcSupplierInfoQryDetailReqBO.setQueryType("1");
        umcSupplierInfoQryDetailReqBO.setOrgIdWeb(Long.valueOf(Long.parseLong(reqBo.getContractBaseInfo().getPartyBCode())));
        if (Objects.equals(ContractConstant.FeeType.INCOME_CONTRACT_CODE, reqBo.getContractBaseInfo().getFeeType()) && !Objects.equals(ContractConstant.ZYCMIncomeContractType.SERVICE_AGREE_TYPE, reqBo.getContractBaseInfo().getIncomeContractType())) {
            umcSupplierInfoQryDetailReqBO.setOrgIdWeb(Long.valueOf(Long.parseLong(reqBo.getContractBaseInfo().getPartyA1Code())));
        }
        UmcSupplierInfoQryDetailRspBO umcSupplierInfoQryDetailRspBO = this.umcSupplierInfoQryDetailService.qryInfoDetail(umcSupplierInfoQryDetailReqBO);
        UmcEnterpriseInfoAccessBO umcEnterpriseInfoBO = umcSupplierInfoQryDetailRspBO.getUmcEnterpriseInfoBO();
        UmcEnterpriseBankInfoAccessBO umcEnterpriseBankInfoBO = umcSupplierInfoQryDetailRspBO.getUmcEnterpriseBankInfoBO();
        ContractSignPartyQryAbilityReqBO contractSignPartyQryAbilityReqBO = new ContractSignPartyQryAbilityReqBO();
        contractSignPartyQryAbilityReqBO.setSignPartyId(Long.valueOf(Long.parseLong(contractBaseInfo.getPartyA1Code())));
        if (Objects.equals(ContractConstant.FeeType.INCOME_CONTRACT_CODE, reqBo.getContractBaseInfo().getFeeType()) && !Objects.equals(ContractConstant.ZYCMIncomeContractType.SERVICE_AGREE_TYPE, reqBo.getContractBaseInfo().getIncomeContractType())) {
            contractSignPartyQryAbilityReqBO.setSignPartyId(Long.valueOf(Long.parseLong(contractBaseInfo.getPartyBCode())));
        }
        ContractSignPartyQryAbilityRspBO contractSignPartyARspBO = this.contractSignPartyQryAbilityService.qrySignPartyList(contractSignPartyQryAbilityReqBO);
        ContractQryItemAbilityReqBO contractQryItemAbilityReqBO = new ContractQryItemAbilityReqBO();
        contractQryItemAbilityReqBO.setRelateId(contractBaseInfo.getContractId());
        if (!ObjectUtils.isEmpty((Object)reqBo.getUpdateApplyId())) {
            contractQryItemAbilityReqBO.setRelateId(reqBo.getUpdateApplyId());
        }
        ContractQryItemAbilityRspBO contractQryItemRspBO = this.contractQryItemAbilityService.qryContractItem(contractQryItemAbilityReqBO);
        if (!ObjectUtils.isEmpty((Object)contractSignDatePartyA)) {
            int signYear = contractSignDatePartyA.getYear() + 1900;
            int signMonth = contractSignDatePartyA.getMonth() + 1;
            int signDate = contractSignDatePartyA.getDate();
            params.put("signYear", signYear);
            params.put("signMonth", signMonth);
            params.put("signDate", signDate);
            params.put("formattedDate", signYear + "\u5e74" + signMonth + "\u6708" + signMonth + "\u65e5");
        } else {
            params.put("signYear", "");
            params.put("signMonth", "");
            params.put("signDate", "");
            params.put("formattedDate", "");
        }
        if (Objects.equals(ContractConstant.FeeType.PAY_CONTRACT_CODE, reqBo.getContractBaseInfo().getFeeType())) {
            params.put("checkInvoiceType1", "");
            params.put("checkInvoiceType2", "");
            params.put("qualityGuaranteeDeposit", "");
            params.put("guaranteePeriod", "");
            params.put("taxPointStrList", "");
            if (!ObjectUtils.isEmpty((Object)contractCooperationInfo)) {
                List taxPointStrList = contractCooperationInfo.getTaxPointStrList();
                Integer invoiceType = contractCooperationInfo.getInvoiceType();
                BigDecimal qualityGuaranteeDeposit = contractCooperationInfo.getQualityGuaranteeDeposit();
                String guaranteePeriod = contractCooperationInfo.getGuaranteePeriod();
                String checkInvoiceType1 = "";
                String checkInvoiceType2 = "";
                if (Objects.equals(invoiceType, ContractConstant.InvoiceType.NORMAL_INVOICE) && !Objects.isNull(invoiceType)) {
                    checkInvoiceType1 = "\u2611";
                    checkInvoiceType2 = "\u2610";
                } else if (Objects.equals(invoiceType, ContractConstant.CooperationMode.ANNUAL_COOPERATION) && !Objects.isNull(invoiceType)) {
                    checkInvoiceType2 = "\u2611";
                    checkInvoiceType1 = "\u2610";
                }
                params.put("checkInvoiceType1", checkInvoiceType1);
                params.put("checkInvoiceType2", checkInvoiceType2);
                params.put("qualityGuaranteeDeposit", qualityGuaranteeDeposit);
                params.put("guaranteePeriod", guaranteePeriod);
                params.put("taxPointStrList", taxPointStrList);
            }
        }
        String partyBLegalPerson = umcEnterpriseInfoBO.getLegalPerson();
        String orgCertificateCode = umcEnterpriseInfoBO.getOrgCertificateCode();
        String partyBaddress = umcEnterpriseInfoBO.getAddress();
        Date contractStartDate = contractBaseInfo.getContractStartDate();
        Date contractEndDate = contractBaseInfo.getContractEndDate();
        String partyBEnterpriseName = umcEnterpriseInfoBO.getEnterpriseName();
        String bankName = umcEnterpriseBankInfoBO.getBankName();
        String bankAccount = umcEnterpriseBankInfoBO.getBankAccount();
        ContractSignPartyInfo contractSignPartyA = (ContractSignPartyInfo)contractSignPartyARspBO.getRows().get(0);
        String partyBPhone = umcEnterpriseInfoBO.getPhoneNumber();
        String partyBName = umcEnterpriseInfoBO.getConsignerName();
        String partyBEmail = umcEnterpriseInfoBO.getEmail();
        String partyAlegalPerson = contractSignPartyA.getLegalPersonName();
        Integer cooperationMode = contractBaseInfo.getCooperationMode();
        String checkCoopMode1 = "";
        String checkCoopMode2 = "";
        if (Objects.equals(cooperationMode, ContractConstant.CooperationMode.STRATEGIC_COOPERATION)) {
            checkCoopMode1 = "\u2611";
            checkCoopMode2 = "\u2610";
        } else if (Objects.equals(cooperationMode, ContractConstant.CooperationMode.ANNUAL_COOPERATION)) {
            checkCoopMode2 = "\u2611";
            checkCoopMode1 = "\u2610";
        }
        ArrayList list = new ArrayList();
        int index = 1;
        if (!CollectionUtils.isEmpty((Collection)contractQryItemRspBO.getRows())) {
            for (ContractItemBO item : contractQryItemRspBO.getRows()) {
                HashMap<String, Object> detailMap = new HashMap<String, Object>();
                detailMap.put("index", index++);
                detailMap.put("commodityName", item.getCommodityName());
                detailMap.put("materialName", item.getMaterialName());
                detailMap.put("model", item.getModel());
                detailMap.put("unitName", item.getUnitName());
                detailMap.put("unitPriceMoney", item.getUnitPriceMoney());
                detailMap.put("remark", item.getRemark());
                detailMap.put("spec", item.getSpec());
                detailMap.put("rate", item.getRate());
                detailMap.put("buyCount", item.getBuyCount());
                detailMap.put("unitPrice", item.getUnitPrice());
                detailMap.put("ratePrice", item.getUnitPriceMoney().multiply(new BigDecimal(item.getRate())));
                detailMap.put("totalAmountMoney", item.getTotalAmountMoney());
                list.add(detailMap);
            }
            params.put("list", list);
        } else {
            params.put("list", "");
        }
        if (!ObjectUtils.isEmpty((Object)reqBo.getContractAmount()) && !ObjectUtils.isEmpty((Object)reqBo.getRate())) {
            params.put("contractAmount", reqBo.getContractAmount());
            params.put("contractRateAmount", reqBo.getContractAmount() * (long)reqBo.getRate().intValue());
            params.put("contractRate", reqBo.getRate());
            params.put("contractNoRateAmount", reqBo.getContractAmount() - reqBo.getContractAmount() * (long)reqBo.getRate().intValue());
            params.put("contractAmountCN", MoneyToChineseUtil.toChinese(reqBo.getContractAmount().longValue()));
            params.put("contractRateAmountCN", MoneyToChineseUtil.toChinese(reqBo.getContractAmount() * (long)reqBo.getRate().intValue()));
            params.put("contractNoRateAmountCN", MoneyToChineseUtil.toChinese(reqBo.getContractAmount() - reqBo.getContractAmount() * (long)reqBo.getRate().intValue()));
        }
        params.put("checkCoopMode1", checkCoopMode1);
        params.put("checkCoopMode2", checkCoopMode2);
        params.put("contractName", reqBo.getContractBaseInfo().getContractName());
        params.put("project", reqBo.getContractBaseInfo().getProject());
        params.put("supplier", contractBaseInfo.getPartyBName());
        params.put("contractCode", contractBaseInfo.getContractCode());
        params.put("partyBLegalPerson", partyBLegalPerson);
        params.put("orgCertificateCode", orgCertificateCode);
        params.put("partyBaddress", partyBaddress);
        params.put("contractStartYear", contractStartDate.getYear() + 1900);
        params.put("contractStartMonth", contractStartDate.getMonth() + 1);
        params.put("contractStartDate", contractStartDate.getDate());
        params.put("contractEndYear", contractEndDate.getYear() + 1900);
        params.put("contractEndMonth", contractEndDate.getMonth() + 1);
        params.put("contractEndDate", contractEndDate.getDate());
        params.put("partyBEnterpriseName", partyBEnterpriseName);
        params.put("bankName", bankName);
        params.put("bankAccount", bankAccount);
        params.put("signPartyAName", contractSignPartyA.getSignPartyName());
        params.put("certificateCode", umcEnterpriseInfoBO.getOrgCertificateCode());
        params.put("partyBPhone", partyBPhone);
        params.put("partyBName", partyBName);
        params.put("partyBEmail", partyBEmail);
        params.put("partyAlegalPerson", partyAlegalPerson);
        params.put("contractSignAddress", reqBo.getContractBaseInfo().getContractSignAddr());
        HackLoopTableRenderPolicy policy = new HackLoopTableRenderPolicy();
        Configure config = Configure.newBuilder().bind("list", (RenderPolicy)policy).build();
        params.put("list", list);
        if (Objects.equals(ContractConstant.FeeType.PAY_CONTRACT_CODE, reqBo.getContractBaseInfo().getFeeType())) {
            if (Objects.equals(ContractConstant.ZYCMContractType.UNIT_AGREE_CONTRACT_TYPE, reqBo.getContractBaseInfo().getContractType())) {
                downUrl = this.templateUrl + "/\u5e73\u53f0\u4f9b\u5e94\u5546\u5408\u4f5c\u6846\u67b6\u534f\u8bae\u3010\u5b9e\u7269\u7c7b\u3011\u4e24\u65b9\u7248.docx";
                if (Objects.equals(1, reqBo.getContractBaseInfo().getContractMode())) {
                    downUrl = this.templateUrl + "/\u5e73\u53f0\u4f9b\u5e94\u5546\u5e74\u5ea6\u6216\u6218\u7565\u5408\u4f5c\u534f\u8bae\u6a21\u677f\uff08\u5b9e\u7269\u7c7b\uff09.docx";
                }
            } else if (Objects.equals(ContractConstant.ZYCMContractType.PLATFORM_AGREE_CONTRACT_TYPE, reqBo.getContractBaseInfo().getContractType())) {
                downUrl = this.templateUrl + "/\u5e73\u53f0\u4f9b\u5e94\u5546\u5408\u4f5c\u6846\u67b6\u534f\u8bae\u3010\u670d\u52a1\u7c7b\u3011.docx";
                if (Objects.equals(1, reqBo.getContractBaseInfo().getContractMode())) {
                    downUrl = this.templateUrl + "/\u5e73\u53f0\u4f9b\u5e94\u5546\u5e74\u5ea6\u6216\u6218\u7565\u5408\u4f5c\u534f\u8bae\u6a21\u677f\uff08\u670d\u52a1\u7c7b\uff09.docx";
                }
            } else if (Objects.equals(ContractConstant.ZYCMContractType.ORDER_CONTRACT_TYPE, reqBo.getContractBaseInfo().getContractType())) {
                downUrl = this.templateUrl + "/\u5e73\u53f0\u4f9b\u5e94\u5546\u5355\u6b21\u91c7\u8d2d\u5408\u540c\u3010\u5b9e\u7269\u7c7b\u3011.docx";
                if (Objects.equals(1, reqBo.getContractBaseInfo().getContractMode())) {
                    downUrl = this.templateUrl + "/\u5355\u6b21\u91c7\u8d2d\u5408\u540c\uff08\u5b9e\u7269\u7c7b\uff09.docx";
                }
            } else {
                if (!Objects.equals(ContractConstant.ZYCMContractType.ORDER_CONTRACT_SERVICE_TYPE, reqBo.getContractBaseInfo().getContractType())) throw new ZTBusinessException("\u9519\u8bef\u7684\u5408\u4f5c\u7c7b\u578b");
                downUrl = this.templateUrl + "/\u5e73\u53f0\u4f9b\u5e94\u5546\u5355\u6b21\u91c7\u8d2d\u5408\u540c\u3010\u670d\u52a1\u7c7b\u3011.docx";
                if (Objects.equals(1, reqBo.getContractBaseInfo().getContractMode())) {
                    downUrl = this.templateUrl + "/\u5355\u6b21\u91c7\u8d2d\u5408\u540c\uff08\u670d\u52a1\u7c7b\uff09.docx";
                }
            }
        } else if (Objects.equals(ContractConstant.ZYCMIncomeContractType.PURCAHSE_AGREE_CONTRACT_TYPE, reqBo.getContractBaseInfo().getIncomeContractType())) {
            downUrl = this.templateUrl + "/\u91c7\u8d2d\u670d\u52a1\u534f\u8bae\u6a21\u677f\uff08\u5916\u90e8\u5ba2\u6237\u4f01\u4e1a\uff09.docx";
            if (Objects.equals(1, reqBo.getContractBaseInfo().getContractMode())) {
                downUrl = this.templateUrl + "/\u91c7\u8d2d\u670d\u52a1\u534f\u8bae\u6a21\u677f\uff08\u5916\u90e8\u5ba2\u6237\u4f01\u4e1a\uff09.docx";
            }
        } else if (Objects.equals(ContractConstant.ZYCMIncomeContractType.WELFARE_CONTRACT_TEMPLATE, reqBo.getContractBaseInfo().getIncomeContractType())) {
            downUrl = this.templateUrl + "/\u798f\u888b\u8d2d\u9500\u5408\u540c\u6a21\u677f.docx";
            if (Objects.equals(1, reqBo.getContractBaseInfo().getContractMode())) {
                downUrl = this.templateUrl + "/\u798f\u888b\u8d2d\u9500\u5408\u540c\u6a21\u677f.docx";
            }
        } else if (Objects.equals(ContractConstant.ZYCMIncomeContractType.SERVICE_AGREE_TYPE, reqBo.getContractBaseInfo().getIncomeContractType())) {
            downUrl = this.templateUrl + "/\u62db\u5546\u5230\u5bb6\u6c47\u4e92\u8054\u7f51\u5e73\u53f0\u7279\u7ea6\u5546\u6237\u670d\u52a1\u534f\u8bae\u4e66\uff08\u5b9e\u7269\u7c7b\uff09.docx";
            if (Objects.equals(1, reqBo.getContractBaseInfo().getContractMode())) {
                downUrl = this.templateUrl + "/\u62db\u5546\u5230\u5bb6\u6c47\u4e92\u8054\u7f51\u5e73\u53f0\u7279\u7ea6\u5546\u6237\u670d\u52a1\u534f\u8bae\u4e66\uff08\u5b9e\u7269\u7c7b\uff09.docx";
            }
        } else {
            if (!Objects.equals(ContractConstant.ZYCMIncomeContractType.ELECTRICAL_CONTRACT_TEMPLATE, reqBo.getContractBaseInfo().getIncomeContractType())) throw new ZTBusinessException("\u9519\u8bef\u7684\u5408\u4f5c\u7c7b\u578b");
            downUrl = this.templateUrl + "/\u7535\u5668\u8d2d\u9500\u5408\u540c\u6a21\u677f.docx";
            if (Objects.equals(1, reqBo.getContractBaseInfo().getContractMode())) {
                downUrl = this.templateUrl + "/\u7535\u5668\u8d2d\u9500\u5408\u540c\u6a21\u677f.docx";
            }
        }
        if (downUrl.startsWith("/")) {
            downUrl = downUrl.substring(1);
        }
        InputStream in = this.fileClient.downLoadToInputStream(downUrl);
        XWPFTemplate template = XWPFTemplate.compile((InputStream)in, (Configure)config).render(params);
        Object out = null;
        String wordNewFullUrl = "";
        String templeFile = "";
        String newFileName = "";
        String decodedUrl = "";
        try {
            File tempFile = File.createTempFile(UUID.randomUUID().toString(), ".docx");
            String templeFilePath = tempFile.getAbsolutePath();
            template.writeToFile(templeFilePath);
            newFileName = contractBaseInfo.getContractCode() + downUrl.substring(downUrl.lastIndexOf("/") + 1);
            if (!ObjectUtils.isEmpty((Object)reqBo.getUpdateApplyId())) {
                newFileName = reqBo.getUpdateApplyId() + downUrl.substring(downUrl.lastIndexOf("/") + 1);
            }
            wordNewFullUrl = this.upload(new FileInputStream(templeFilePath), newFileName);
            decodedUrl = URLDecoder.decode((String)wordNewFullUrl, (Charset)StandardCharsets.UTF_8);
            in.close();
            template.close();
            tempFile.delete();
        }
        catch (IOException e) {
            log.error("\u751f\u6210word\u5f02\u5e38", (Throwable)e);
            throw new ZTBusinessException("\u751f\u6210word\u5931\u8d25");
        }
        ContractSaveWordAccessoryBusiReqBO contractSaveWordAccessoryBusiReqBO = new ContractSaveWordAccessoryBusiReqBO();
        contractSaveWordAccessoryBusiReqBO.setContractId(contractBaseInfo.getContractId());
        contractSaveWordAccessoryBusiReqBO.setContractCode(contractBaseInfo.getContractCode());
        if (!ObjectUtils.isEmpty((Object)reqBo.getUpdateApplyId())) {
            contractSaveWordAccessoryBusiReqBO.setUpdateApplyId(reqBo.getUpdateApplyId());
            contractSaveWordAccessoryBusiReqBO.setUpdateApplyCode(reqBo.getUpdateApplyCode());
        }
        contractSaveWordAccessoryBusiReqBO.setUserId(reqBo.getUserId());
        contractSaveWordAccessoryBusiReqBO.setUserName(reqBo.getName());
        contractSaveWordAccessoryBusiReqBO.setWordNewFullUrl(decodedUrl);
        contractSaveWordAccessoryBusiReqBO.setAccessoryName(newFileName);
        contractSaveWordAccessoryBusiReqBO.setContractCode(contractBaseInfo.getContractCode());
        ContractSaveWordAccessoryBusiRspBO contractSaveWordAccessoryBusiRspBO = this.contractSaveWordAccessoryBusiService.saveWordAccessory(contractSaveWordAccessoryBusiReqBO);
        if (!Objects.equals("0000", contractSaveWordAccessoryBusiRspBO.getRespCode())) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u4fdd\u5b58\u751f\u6210\u5408\u540c\u6587\u4ef6\u5931\u8d25");
            return rspBO;
        }
        rspBO.setWordName(newFileName);
        rspBO.setWordUrl(decodedUrl);
        return rspBO;
    }

    private void saveContractWordAccessory(UmcGenerateContractFileReqBo reqBo, ContractBaseInfoBO contractBaseInfo, String wordNewFullUrl, String newFileName) {
        ContractAccessoryPo deleContractAccessoryPo = new ContractAccessoryPo();
        deleContractAccessoryPo.setRelateCode(contractBaseInfo.getContractCode());
        deleContractAccessoryPo.setRelateId(contractBaseInfo.getContractId());
        deleContractAccessoryPo.setAcceessoryType(1);
        deleContractAccessoryPo.setRelateType(1);
        this.contractAccessoryMapper.deleteByCondition(deleContractAccessoryPo);
        ContractAccessoryPo insContractAccessoryPo = new ContractAccessoryPo();
        insContractAccessoryPo.setCreateUserId(reqBo.getUserId());
        insContractAccessoryPo.setCreateUserName(reqBo.getName());
        insContractAccessoryPo.setAcceessoryUrl(wordNewFullUrl);
        insContractAccessoryPo.setCreateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
        insContractAccessoryPo.setAcceessoryName(newFileName);
        insContractAccessoryPo.setRelateCode(contractBaseInfo.getContractCode());
        insContractAccessoryPo.setRelateId(contractBaseInfo.getContractId());
        insContractAccessoryPo.setRelateType(1);
        insContractAccessoryPo.setAcceessoryType(1);
        insContractAccessoryPo.setAcceessoryId(Sequence.getInstance().nextId());
        int insert = this.contractAccessoryMapper.insert(insContractAccessoryPo);
        if (insert != 1) {
            throw new ZTBusinessException("\u4fdd\u5b58\u5408\u540c\u6587\u4ef6\u9644\u4ef6\u4fe1\u606f\u5931\u8d25");
        }
    }

    private String upload(InputStream inputStream, String fileName) {
        String returnFileUrl = "";
        try {
            String innerFileUrl;
            String suffix = fileName.substring(fileName.lastIndexOf("."));
            log.info("\u4e0a\u4f20\u6587\u4ef6\u5f00\u59cb");
            if (!this.instDataPath.endsWith("/")) {
                this.instDataPath = this.instDataPath + "/";
            }
            String path = this.fileClient.uploadFileByInputStream(this.instDataPath, fileName, inputStream);
            log.info("\u4e0a\u4f20\u6587\u4ef6\u7ed3\u675f");
            if ("OSS".equals(this.fileType)) {
                innerFileUrl = path;
                String fileUrl = "/" + path;
            } else if ("FASTDFS".equals(this.fileType)) {
                FastdfsFileInfo fastdfsFileInfo = FastdfsFileInfo.toFastdfsFileInfo((String)path);
                String fileUrl = innerFileUrl = "/" + fastdfsFileInfo.getGroupName() + "/" + fastdfsFileInfo.getFileName();
            } else if ("OBS".equals(this.fileType)) {
                innerFileUrl = path;
                String fileUrl = "/" + path;
            } else if ("MINIO".equals(this.fileType)) {
                if (path.startsWith(this.accessUrl + "/" + this.bucketName)) {
                    path = path.replace(this.accessUrl + "/" + this.bucketName, this.httpFileUrl);
                }
                innerFileUrl = path;
                String fileUrl = path;
            } else {
                throw new ZTBusinessException("\u6682\u4e0d\u652f\u6301\u7684\u6587\u4ef6\u670d\u52a1\u5668\u7c7b\u578b");
            }
            returnFileUrl = innerFileUrl;
        }
        catch (ZTBusinessException e) {
            e.printStackTrace();
            log.info("\u4e0a\u4f20\u6587\u4ef6\u9519\u8bef\u4fe1\u606f11\uff1a{}", (Object)e.getMessage());
            throw new ZTBusinessException(e.resolverException());
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("\u4e0a\u4f20\u6587\u4ef6\u9519\u8bef\u4fe1\u606f\uff1a{}", (Object)e.getMessage());
            throw new ZTBusinessException("\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25");
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException e) {
                log.error("\u6587\u4ef6\u4e0a\u4f20\u5173\u95ed\u6d41\u5931\u8d25");
            }
        }
        return returnFileUrl;
    }
}

