/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.generateFile.impl;

import cn.hutool.core.bean.BeanUtil;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.file.FileClient;
import com.ohaotian.plugin.file.fastdfs.FastdfsFileInfo;
import com.tydic.contract.ability.UmcViewContractFileService;
import com.tydic.contract.ability.bo.UmcViewContractFileReqBo;
import com.tydic.contract.ability.bo.UmcViewContractFileRspBo;
import com.tydic.contract.dao.CContractAccessoryChangeMapper;
import com.tydic.contract.dao.ContractAccessoryMapper;
import com.tydic.contract.po.CContractAccessoryChangePO;
import com.tydic.contract.po.ContractAccessoryPo;
import com.tydic.contract.utils.WordToPdf;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.List;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.contract.ability.UmcViewContractFileService"})
public class UmcViewContractFileServiceImpl
implements UmcViewContractFileService {
    private static final Logger log = LoggerFactory.getLogger(UmcViewContractFileServiceImpl.class);
    @Autowired
    private FileClient fileClient;
    @Autowired
    private ContractAccessoryMapper contractAccessoryMapper;
    @Autowired
    private CContractAccessoryChangeMapper cContractAccessoryChangeMapper;
    @Value(value="${dyc.file.inst.data.path:dyc/file/instData}")
    private String instDataPath;
    @Value(value="${minio.accessUrl}")
    private String accessUrl;
    @Value(value="${plugin.file.type}")
    private String fileType;
    @Value(value="${minio.bucketName}")
    private String bucketName;
    @Value(value="${minio.fileUrl}")
    private String httpFileUrl;
    @Value(value="${PublicIP}")
    private String publicIP;
    @Value(value="${InternalIP}")
    private String internalIP;
    private static final String WORDURLPREFIX_BY_GENERATE = "dyc/file/instData";
    private static final String WORDURLPREFIX_BY_UPLOAD = "/dyc/file/noauth/instData";

    @PostMapping(value={"viewContractFile"})
    public UmcViewContractFileRspBo viewContractFile(@RequestBody UmcViewContractFileReqBo reqBo) {
        UmcViewContractFileRspBo rspBO = new UmcViewContractFileRspBo();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6d4f\u89c8\u5408\u540c\u6210\u529f");
        ContractAccessoryPo qryContractAccessoryPo = new ContractAccessoryPo();
        BeanUtil.copyProperties((Object)reqBo, (Object)qryContractAccessoryPo);
        if (!ObjectUtils.isEmpty((Object)reqBo.getUpdateApplyId())) {
            CContractAccessoryChangePO qryContractAccessoryChangePO = new CContractAccessoryChangePO();
            BeanUtil.copyProperties((Object)reqBo, (Object)qryContractAccessoryChangePO);
            qryContractAccessoryChangePO.setRelateId(reqBo.getUpdateApplyId());
            List<CContractAccessoryChangePO> list = this.cContractAccessoryChangeMapper.getList(qryContractAccessoryChangePO);
            if (CollectionUtils.isEmpty(list)) {
                throw new ZTBusinessException("\u9700\u8981\u5148\u751f\u6210\u5408\u540c\u6587\u6863word\u6587\u4ef6");
            }
            if (list.get(0).getAcceessoryUrl().contains(".pdf")) {
                rspBO.setPdfUrl(list.get(0).getAcceessoryUrl());
                return rspBO;
            }
            String wordAcceessoryUrl = list.get(0).getAcceessoryUrl();
            String wordAcceessoryName = list.get(0).getAcceessoryName();
            log.info("\u67e5\u8be2\u7684word\u6587\u4ef6url\uff1a{}", (Object)wordAcceessoryUrl);
            log.info("\u67e5\u8be2\u7684word\u6587\u4ef6\u540d\u79f0\uff1a{}", (Object)wordAcceessoryName);
            String dowmLoadWordPath = wordAcceessoryUrl.substring(wordAcceessoryUrl.indexOf("dyc"));
            log.info("\u4e0b\u8f7d\u7684word\u5730\u5740\uff1a{}", (Object)dowmLoadWordPath);
            Object tempWordFile = null;
            Object tempPdfFile = null;
            String exportUrl = "";
            String newPdfFileName = wordAcceessoryName.replace("docx", "pdf");
            exportUrl = this.uploadFile(dowmLoadWordPath, newPdfFileName);
            rspBO.setPdfUrl(exportUrl);
            return rspBO;
        }
        qryContractAccessoryPo.setRelateId(reqBo.getContractId());
        qryContractAccessoryPo.setRelateCode(reqBo.getContractCode());
        List<ContractAccessoryPo> contractAccessoryPos = this.contractAccessoryMapper.qryByCondition(qryContractAccessoryPo);
        if (CollectionUtils.isEmpty(contractAccessoryPos)) {
            throw new ZTBusinessException("\u9700\u8981\u5148\u751f\u6210\u5408\u540c\u6587\u6863word\u6587\u4ef6");
        }
        if (contractAccessoryPos.get(0).getAcceessoryUrl().contains(".pdf")) {
            rspBO.setPdfUrl(contractAccessoryPos.get(0).getAcceessoryUrl());
            return rspBO;
        }
        String wordAcceessoryUrl = contractAccessoryPos.get(0).getAcceessoryUrl();
        String wordAcceessoryName = contractAccessoryPos.get(0).getAcceessoryName();
        log.info("\u67e5\u8be2\u7684word\u6587\u4ef6url\uff1a{}", (Object)wordAcceessoryUrl);
        log.info("\u67e5\u8be2\u7684word\u6587\u4ef6\u540d\u79f0\uff1a{}", (Object)wordAcceessoryName);
        String dowmLoadWordPath = wordAcceessoryUrl.substring(wordAcceessoryUrl.indexOf("dyc"));
        log.info("\u4e0b\u8f7d\u7684word\u5730\u5740\uff1a{}", (Object)dowmLoadWordPath);
        File tempWordFile = null;
        File tempPdfFile = null;
        String exportUrl = "";
        String newPdfFileName = wordAcceessoryName.replace("docx", "pdf");
        try {
            tempWordFile = this.fileClient.downloadToFile(dowmLoadWordPath);
            tempPdfFile = File.createTempFile(UUID.randomUUID().toString(), ".pdf");
            log.info("\u4e34\u65f6\u6587\u4ef6pdf\u8def\u5f84\uff1a{},\u76f8\u5bf9\u8def\u5f84\uff1a{}", (Object)tempPdfFile.getAbsoluteFile(), (Object)tempPdfFile.getPath());
            log.info("\u4e0b\u8f7d\u7684word\u672c\u5730\u6587\u4ef6\u8def\u5f84\uff1a{},\u76f8\u5bf9\u8def\u5f84\uff1a{}", (Object)tempWordFile.getAbsoluteFile(), (Object)tempWordFile.getPath());
            try {
                WordToPdf.wordToPdf2(tempWordFile.getAbsolutePath(), tempPdfFile.getAbsolutePath());
            }
            catch (Exception e) {
                log.error("\u8f6c\u6362\u5f02\u5e38" + e.getMessage());
                throw new ZTBusinessException("\u8f6c\u6362pdf\u6587\u6863\u5931\u8d25" + e.getMessage());
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        exportUrl = this.uploadFile(dowmLoadWordPath, newPdfFileName);
        rspBO.setPdfUrl(exportUrl);
        return rspBO;
    }

    private String uploadFile(String dowmLoadWordPath, String newPdfFileName) {
        String exportUrl;
        block25: {
            File tempPdfFile;
            File tempWordFile;
            try {
                tempWordFile = this.fileClient.downloadToFile(dowmLoadWordPath);
                tempPdfFile = File.createTempFile(UUID.randomUUID().toString(), ".pdf");
                log.info("\u4e34\u65f6\u6587\u4ef6pdf\u8def\u5f84\uff1a{},\u76f8\u5bf9\u8def\u5f84\uff1a{}", (Object)tempPdfFile.getAbsoluteFile(), (Object)tempPdfFile.getPath());
                log.info("\u4e0b\u8f7d\u7684word\u672c\u5730\u6587\u4ef6\u8def\u5f84\uff1a{},\u76f8\u5bf9\u8def\u5f84\uff1a{}", (Object)tempWordFile.getAbsoluteFile(), (Object)tempWordFile.getPath());
                try {
                    WordToPdf.wordToPdf2(tempWordFile.getAbsolutePath(), tempPdfFile.getAbsolutePath());
                }
                catch (Exception e) {
                    log.error("\u8f6c\u6362\u5f02\u5e38" + e.getMessage());
                    throw new ZTBusinessException("\u8f6c\u6362pdf\u6587\u6863\u5931\u8d25" + e.getMessage());
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            try {
                if (!this.instDataPath.endsWith("/")) {
                    this.instDataPath = this.instDataPath + "/";
                }
                String path = this.fileClient.uploadFileByInputStream(this.instDataPath, newPdfFileName, (InputStream)new FileInputStream(tempPdfFile));
                if ("OSS".equals(this.fileType)) {
                    exportUrl = path;
                    break block25;
                }
                if ("FASTDFS".equals(this.fileType)) {
                    FastdfsFileInfo fastdfsFileInfo = FastdfsFileInfo.toFastdfsFileInfo((String)path);
                    exportUrl = "/" + fastdfsFileInfo.getGroupName() + "/" + fastdfsFileInfo.getFileName();
                    break block25;
                }
                if ("MINIO".equals(this.fileType)) {
                    if (path.startsWith(this.accessUrl + "/" + this.bucketName)) {
                        path = path.replace(this.accessUrl + "/" + this.bucketName, this.httpFileUrl);
                    }
                    exportUrl = path;
                    break block25;
                }
                throw new ZTBusinessException("\u6682\u4e0d\u652f\u6301\u8be5\u6587\u4ef6\u670d\u52a1\u5668\u7c7b\u578b");
            }
            catch (Exception e) {
                throw new ZTBusinessException("\u83b7\u53d6\u6587\u4ef6\u5931\u8d25" + e.getMessage());
            }
            finally {
                String tempWordPath = tempWordFile.getAbsolutePath();
                String templePdfPath = tempPdfFile.getAbsolutePath();
                if (!tempPdfFile.exists()) {
                    log.info("\u5220\u9664\u6587\u4ef6\u5931\u8d25:" + templePdfPath.substring(templePdfPath.lastIndexOf("/") + 1) + "\u4e0d\u5b58\u5728\uff01");
                } else if (tempPdfFile.isFile()) {
                    if (tempPdfFile.delete()) {
                        log.info("\u5220\u9664\u6587\u4ef6" + templePdfPath.substring(templePdfPath.lastIndexOf("/") + 1) + "\u6210\u529f\uff01");
                    } else {
                        log.info("\u5220\u9664\u6587\u4ef6" + templePdfPath.substring(templePdfPath.lastIndexOf("/") + 1) + "\u5931\u8d25\uff01");
                    }
                }
                if (!tempWordFile.exists()) {
                    log.info("\u5220\u9664\u6587\u4ef6\u5931\u8d25:" + tempWordPath.substring(tempWordPath.lastIndexOf("/") + 1) + "\u4e0d\u5b58\u5728\uff01");
                } else if (tempWordFile.isFile()) {
                    if (tempWordFile.delete()) {
                        log.info("\u5220\u9664\u6587\u4ef6" + tempWordPath.substring(tempWordPath.lastIndexOf("/") + 1) + "\u6210\u529f\uff01");
                    } else {
                        log.info("\u5220\u9664\u6587\u4ef6" + tempWordPath.substring(tempWordPath.lastIndexOf("/") + 1) + "\u5931\u8d25\uff01");
                    }
                }
            }
        }
        return exportUrl;
    }

    private String linuxWordToPdf(File templePdfFile, File wordFile) {
        String sourcePath = wordFile.getAbsolutePath();
        String outDir = templePdfFile.getAbsolutePath().substring(0, templePdfFile.getAbsolutePath().lastIndexOf(File.separator));
        String command = "libreoffice --invisible --convert-to pdf --outdir " + outDir + " " + sourcePath;
        log.info(command);
        try {
            this.executeLinuxCmd(command);
        }
        catch (Exception e) {
            log.error("linuxWordToPdf linux\u73af\u5883word\u8f6c\u6362\u4e3apdf\u65f6\u51fa\u73b0\u5f02\u5e38\uff1a", (Throwable)e);
        }
        return outDir + sourcePath.substring(sourcePath.lastIndexOf("/") + 1);
    }

    private boolean executeLinuxCmd(String cmd) {
        try {
            Process process = Runtime.getRuntime().exec(cmd);
            process.waitFor();
        }
        catch (InterruptedException e) {
            log.error("executeLinuxCmd \u6267\u884cLinux\u547d\u4ee4\u5f02\u5e38\uff1a", (Throwable)e);
            Thread.currentThread().interrupt();
            return false;
        }
        catch (IOException e) {
            log.error("\u83b7\u53d6\u7cfb\u7edf\u547d\u4ee4\u6267\u884c\u73af\u5883\u5f02\u5e38", (Throwable)e);
        }
        return true;
    }

    private String upload(InputStream inputStream, String fileName) {
        String returnFileUrl = "";
        try {
            String innerFileUrl;
            String suffix = fileName.substring(fileName.lastIndexOf("."));
            log.info("\u4e0a\u4f20\u6587\u4ef6\u5f00\u59cb");
            String path = this.fileClient.uploadFileByInputStream(this.instDataPath, fileName, inputStream);
            log.info("\u4e0a\u4f20\u6587\u4ef6\u7ed3\u675f");
            if ("OSS".equals(this.fileType)) {
                innerFileUrl = path;
                String fileUrl = "/" + path;
            } else if ("FASTDFS".equals(this.fileType)) {
                FastdfsFileInfo fastdfsFileInfo = FastdfsFileInfo.toFastdfsFileInfo((String)path);
                String fileUrl = innerFileUrl = "/" + fastdfsFileInfo.getGroupName() + "/" + fastdfsFileInfo.getFileName();
            } else if ("OBS".equals(this.fileType)) {
                innerFileUrl = path;
                String fileUrl = "/" + path;
            } else if ("MINIO".equals(this.fileType)) {
                if (path.startsWith(this.accessUrl + "/" + this.bucketName)) {
                    path = path.replace(this.accessUrl + "/" + this.bucketName, this.httpFileUrl);
                }
                innerFileUrl = path;
                String fileUrl = path;
            } else {
                throw new ZTBusinessException("\u6682\u4e0d\u652f\u6301\u7684\u6587\u4ef6\u670d\u52a1\u5668\u7c7b\u578b");
            }
            returnFileUrl = innerFileUrl;
        }
        catch (ZTBusinessException e) {
            e.printStackTrace();
            log.info("\u4e0a\u4f20\u6587\u4ef6\u9519\u8bef\u4fe1\u606f11\uff1a{}", (Object)e.getMessage());
            throw new ZTBusinessException(e.resolverException());
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("\u4e0a\u4f20\u6587\u4ef6\u9519\u8bef\u4fe1\u606f\uff1a{}", (Object)e.getMessage());
            throw new ZTBusinessException("\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25");
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException e) {
                log.error("\u6587\u4ef6\u4e0a\u4f20\u5173\u95ed\u6d41\u5931\u8d25");
            }
        }
        return returnFileUrl;
    }

    private File downloadFile(String fileUrl) {
        if (fileUrl.contains(this.publicIP)) {
            fileUrl = fileUrl.replaceAll(this.publicIP, this.internalIP);
            log.info("newFileUrl == {}", (Object)fileUrl);
        }
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        FilterOutputStream stream = null;
        InputStream inputStream = null;
        File file = null;
        try {
            URL imageUrl = new URL(fileUrl);
            HttpURLConnection conn = (HttpURLConnection)imageUrl.openConnection();
            conn.setRequestProperty("User-Agent", "Mozilla/4.0 (compatible; MSIE 5.0; Windows NT; DigExt)");
            inputStream = conn.getInputStream();
            byte[] buffer = new byte[1024];
            int len = 0;
            while ((len = inputStream.read(buffer)) != -1) {
                outStream.write(buffer, 0, len);
            }
            file = File.createTempFile("file", ".docx");
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            stream = new BufferedOutputStream(fileOutputStream);
            stream.write(outStream.toByteArray());
        }
        catch (Exception e) {
            log.error("url\u8f6c\u6587\u4ef6\u5931\u8d25\uff1a", (Throwable)e);
            throw new ZTBusinessException("url\u8f6c\u6587\u4ef6\u5931\u8d25");
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
                if (stream != null) {
                    stream.close();
                }
                outStream.close();
            }
            catch (Exception exception) {}
        }
        return file;
    }
}

