/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.utils;

import java.text.DecimalFormat;

public class MoneyToChineseUtil {
    private static final String[] CN_NUMBERS = new String[]{"\u96f6", "\u58f9", "\u8d30", "\u53c1", "\u8086", "\u4f0d", "\u9646", "\u67d2", "\u634c", "\u7396"};
    private static final String[] CN_UNITS = new String[]{"", "\u62fe", "\u4f70", "\u4edf", "\u4e07", "\u62fe", "\u4f70", "\u4edf", "\u4ebf", "\u62fe", "\u4f70", "\u4edf"};
    private static final String[] CN_DECIMAL_UNITS = new String[]{"\u89d2", "\u5206"};

    public static String toChinese(double money) {
        int num;
        int i;
        if (money < 0.0) {
            return "\u91d1\u989d\u4e0d\u80fd\u4e3a\u8d1f\u6570";
        }
        DecimalFormat df = new DecimalFormat("#.##");
        String moneyStr = df.format(money);
        String[] parts = moneyStr.split("\\.");
        String integerPart = parts[0];
        String decimalPart = parts.length > 1 ? parts[1] : "";
        StringBuilder result = new StringBuilder();
        int length = integerPart.length();
        for (i = 0; i < length; ++i) {
            num = integerPart.charAt(i) - 48;
            String unit = CN_UNITS[length - i - 1];
            result.append(CN_NUMBERS[num]).append(unit);
        }
        if (decimalPart.length() > 0) {
            result.append("\u5143");
            for (i = 0; i < decimalPart.length(); ++i) {
                num = decimalPart.charAt(i) - 48;
                if (i >= CN_DECIMAL_UNITS.length) continue;
                result.append(CN_NUMBERS[num]).append(CN_DECIMAL_UNITS[i]);
            }
        } else {
            result.append("\u5143\u6574");
        }
        String finalResult = result.toString().replaceAll("\u96f6[\u62fe\u4f70\u4edf]", "\u96f6").replaceAll("\u96f6+\u4e07", "\u4e07").replaceAll("\u96f6+\u5143", "\u5143").replaceAll("\u96f6+", "\u96f6");
        if (finalResult.endsWith("\u96f6")) {
            finalResult = finalResult.substring(0, finalResult.length() - 1);
        }
        return finalResult;
    }

    public static void main(String[] args) {
        double money = 12345.67;
        String chineseMoney = MoneyToChineseUtil.toChinese(money);
        System.out.println("\u91d1\u989d\u5927\u5199: " + chineseMoney);
    }
}

