/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.atom.qcc.impl;

import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.umc.atom.qcc.QccEnterpriseInfoVerifyService;
import com.tydic.dyc.umc.atom.qcc.bo.QccEnterpriseInfoVerifyReqBo;
import com.tydic.dyc.umc.atom.qcc.bo.QccEnterpriseInfoVerifyRspBo;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.time.Instant;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class QccEnterpriseInfoVerifyServiceImpl
implements QccEnterpriseInfoVerifyService {
    private static final Logger log = LoggerFactory.getLogger(QccEnterpriseInfoVerifyServiceImpl.class);
    @Value(value="${qcc.enterpriseInfoVerifyUrl:http://dyc-ability-web:8080/OSN/api/EnterpriseInfoVerify/v1}")
    private String enterpriseInfoVerifyUrl;
    @Value(value="${qcc.appKey:6b5309e69961409a89dd7ffcf6a28e12}")
    private String appKey;

    @Override
    public QccEnterpriseInfoVerifyRspBo verifyEnterpriseInfo(QccEnterpriseInfoVerifyReqBo reqBO) {
        QccEnterpriseInfoVerifyRspBo rspBo = new QccEnterpriseInfoVerifyRspBo();
        JSONObject body = new JSONObject();
        body.put("key", (Object)this.appKey);
        body.put("searchKey", (Object)reqBO.getCreditCode());
        log.info("\u4f01\u67e5\u67e5-\u4f01\u4e1a\u4fe1\u606f\u6838\u9a8c\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)body.toJSONString());
        String result = HttpUtil.post((String)this.enterpriseInfoVerifyUrl, (String)body.toJSONString());
        if (StringUtils.isEmpty((CharSequence)result)) {
            throw new ZTBusinessException("\u4f01\u67e5\u67e5-\u4f01\u4e1a\u4fe1\u606f\u6838\u9a8c\u63a5\u53e3\u8c03\u7528\u5931\u8d25");
        }
        log.info("\u4f01\u67e5\u67e5-\u4f01\u4e1a\u4fe1\u606f\u6838\u9a8c\u63a5\u53e3\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)result);
        JSONObject resultJson = JSONObject.parseObject((String)result);
        if (!"200".equals(resultJson.getString("Status"))) {
            throw new ZTBusinessException(resultJson.getString("Message"));
        }
        String resultData = resultJson.getString("Result");
        JSONObject resultDataJson = JSONObject.parseObject((String)resultData);
        if ("1".equals(resultDataJson.getString("VerifyResult"))) {
            rspBo = (QccEnterpriseInfoVerifyRspBo)((Object)JSONObject.parseObject((String)resultDataJson.getString("Data"), QccEnterpriseInfoVerifyRspBo.class));
        }
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    public static void main(String[] args) {
        String key = "6b5309e69961409a89dd7ffcf6a28e12";
        String secretKey = "98CF3CB6930507A1E102FF40DE7CF389";
        long timestamp = Instant.now().getEpochSecond();
        String timespanStr = Long.toString(timestamp);
        String tokenStr = key + timespanStr + secretKey;
        String md5Token = QccEnterpriseInfoVerifyServiceImpl.toMd5(tokenStr).toUpperCase();
        System.out.println(timespanStr);
        System.out.println("Generated Token: " + md5Token);
    }

    private static String toMd5(String input) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] messageDigest = md.digest(input.getBytes());
            StringBuilder hexString = new StringBuilder();
            for (byte b : messageDigest) {
                hexString.append(Integer.toHexString(0xFF & b));
            }
            return hexString.toString();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("MD5 algorithm not found", e);
        }
    }
}

