/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.atom.qcc.impl;

import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.umc.atom.qcc.QccShixinCheckService;
import com.tydic.dyc.umc.atom.qcc.bo.QccShixinCheckBo;
import com.tydic.dyc.umc.atom.qcc.bo.QccShixinCheckReqBo;
import com.tydic.dyc.umc.atom.qcc.bo.QccShixinCheckRspBo;
import com.tydic.dyc.umc.utils.IdUtil;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class QccShixinCheckServiceImpl
implements QccShixinCheckService {
    private static final Logger log = LoggerFactory.getLogger(QccShixinCheckServiceImpl.class);
    @Value(value="${qcc.shixinCheckUrl:http://dyc-ability-web:8080/OSN/api/ShixinCheck/v1}")
    private String shixinCheckUrl;
    @Value(value="${qcc.appKey:6b5309e69961409a89dd7ffcf6a28e12}")
    private String appKey;

    @Override
    public QccShixinCheckRspBo checkShixin(QccShixinCheckReqBo reqBO) {
        String resultData;
        JSONObject resultDataJson;
        QccShixinCheckRspBo rspBo = new QccShixinCheckRspBo();
        rspBo.setRecordsTotal(0);
        rspBo.setPageNo(Integer.parseInt(reqBO.getPageIndex()));
        rspBo.setTotal(0);
        JSONObject body = new JSONObject();
        body.put("key", (Object)this.appKey);
        body.put("searchKey", (Object)reqBO.getCreditCode());
        body.put("pageIndex", (Object)reqBO.getPageIndex());
        body.put("pageSize", (Object)reqBO.getPageSize());
        body.put("randomId", (Object)IdUtil.nextId());
        log.info("\u4f01\u67e5\u67e5-\u5931\u4fe1\u6838\u67e5\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)body.toJSONString());
        String result = HttpUtil.post((String)this.shixinCheckUrl, (String)body.toJSONString());
        if (StringUtils.isEmpty((CharSequence)result)) {
            throw new ZTBusinessException("\u4f01\u67e5\u67e5-\u5931\u4fe1\u6838\u67e5\u63a5\u53e3\u8c03\u7528\u5931\u8d25");
        }
        log.info("\u4f01\u67e5\u67e5-\u5931\u4fe1\u6838\u67e5\u63a5\u53e3\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)result);
        JSONObject resultJson = JSONObject.parseObject((String)result);
        if (!"200".equals(resultJson.getString("Status"))) {
            throw new ZTBusinessException(resultJson.getString("Message"));
        }
        if (!StringUtils.isEmpty((CharSequence)resultJson.getString("Paging"))) {
            String paging = resultJson.getString("Paging");
            JSONObject pagingJson = JSONObject.parseObject((String)paging);
            rspBo.setRecordsTotal(pagingJson.getInteger("TotalRecords"));
            rspBo.setPageNo(pagingJson.getInteger("PageIndex"));
            Integer totalPage = rspBo.getRecordsTotal() / pagingJson.getInteger("PageSize") + 1;
            rspBo.setTotal(totalPage);
        }
        if ("1".equals((resultDataJson = JSONObject.parseObject((String)(resultData = resultJson.getString("Result")))).getString("VerifyResult"))) {
            List rows = JSONArray.parseArray((String)resultDataJson.getString("Data"), QccShixinCheckBo.class);
            rspBo.setRows(rows);
        }
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }
}

