/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.atom.zs.impl;

import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.umc.atom.zs.ZsMdmCustomerSearchService;
import com.tydic.dyc.umc.atom.zs.bo.ZsMdmCustomerSearchBo;
import com.tydic.dyc.umc.atom.zs.bo.ZsMdmCustomerSearchReqBo;
import com.tydic.dyc.umc.atom.zs.bo.ZsMdmCustomerSearchRspBo;
import com.tydic.dyc.umc.utils.UmcRu;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class ZsMdmCustomerSearchServiceImpl
implements ZsMdmCustomerSearchService {
    private static final Logger log = LoggerFactory.getLogger(ZsMdmCustomerSearchServiceImpl.class);
    @Value(value="${zsmdm.customerSearchUrl:http://dyc-ability-web:8080/OSN/api/customerSearch/v1}")
    private String customerSearchUrl;

    @Override
    public ZsMdmCustomerSearchRspBo searchCustomer(ZsMdmCustomerSearchReqBo reqBo) {
        JSONObject body = this.getBody(reqBo);
        log.info("\u5ba2\u6237\u4e3b\u6570\u636e\u67e5\u8be2\u63a5\u53e3\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)body.toJSONString());
        String result = HttpUtil.post((String)this.customerSearchUrl, (String)body.toJSONString());
        if (StringUtils.isEmpty((CharSequence)result)) {
            throw new ZTBusinessException("\u5ba2\u6237\u4e3b\u6570\u636e\u67e5\u8be2\u63a5\u53e3\u8c03\u7528\u5931\u8d25");
        }
        log.info("\u5ba2\u6237\u4e3b\u6570\u636e\u67e5\u8be2\u63a5\u53e3\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)result);
        JSONObject resultJson = JSONObject.parseObject((String)result);
        JSONObject esb = resultJson.getJSONObject("esb");
        if (!"S".equals(esb.getString("result"))) {
            throw new ZTBusinessException(esb.getString("desc"));
        }
        return this.getRspBo(esb);
    }

    private ZsMdmCustomerSearchRspBo getRspBo(JSONObject esb) {
        ZsMdmCustomerSearchRspBo rspBo = new ZsMdmCustomerSearchRspBo();
        JSONObject data = esb.getJSONObject("data");
        JSONObject splitpage = data.getJSONObject("splitpage");
        JSONObject datainfos = data.getJSONObject("datainfos");
        String puuid = data.getString("puuid");
        JSONArray datainfo = datainfos.getJSONArray("datainfo");
        List rows = UmcRu.jsl((List)datainfo, ZsMdmCustomerSearchBo.class);
        rspBo.setPuuid(puuid);
        rspBo.setTotal(splitpage.getInteger("totalpages"));
        rspBo.setRecordsTotal(splitpage.getInteger("totalnumber"));
        rspBo.setPageNo(splitpage.getInteger("currentpage"));
        rspBo.setRows(rows);
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private JSONObject getBody(ZsMdmCustomerSearchReqBo reqBo) {
        JSONObject json = new JSONObject();
        json.put("customer_name", (Object)reqBo.getCustomer_name());
        json.put("customer_unique_code", (Object)reqBo.getCustomer_unique_code());
        JSONArray datainfo = new JSONArray();
        datainfo.add((Object)json);
        JSONObject datainfos = new JSONObject();
        datainfos.put("datainfo", (Object)datainfo);
        datainfos.put("puuid", (Object)reqBo.getPuuid());
        JSONObject splitpage = new JSONObject();
        splitpage.put("countperpage", (Object)reqBo.getCountperpage());
        splitpage.put("currentpage", (Object)reqBo.getCurrentpage());
        JSONObject data = new JSONObject();
        data.put("datainfos", (Object)datainfos);
        data.put("splitpage", (Object)splitpage);
        JSONObject esb = new JSONObject();
        esb.put("data", (Object)data);
        JSONObject body = new JSONObject();
        body.put("esb", (Object)esb);
        return body;
    }
}

