/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.atom.zs.impl;

import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.dyc.umc.atom.zs.ZsMdmSupplierVagueService;
import com.tydic.dyc.umc.atom.zs.bo.ZsMdmSupplierVagueBo;
import com.tydic.dyc.umc.atom.zs.bo.ZsMdmSupplierVagueReqBo;
import com.tydic.dyc.umc.atom.zs.bo.ZsMdmSupplierVagueRspBo;
import com.tydic.dyc.umc.repository.dao.UmcEnterpriseInfoMapper;
import com.tydic.dyc.umc.repository.dao.UmcOrgInfoMapper;
import com.tydic.dyc.umc.repository.po.UmcEnterpriseInfoPo;
import com.tydic.dyc.umc.repository.po.UmcOrgInfoPo;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class ZsMdmSupplierVagueServiceImpl
implements ZsMdmSupplierVagueService {
    private static final Logger log = LoggerFactory.getLogger(ZsMdmSupplierVagueServiceImpl.class);
    @Autowired
    private UmcOrgInfoMapper orgInfoMapper;
    @Autowired
    private UmcEnterpriseInfoMapper enterpriseInfoMapper;
    @Value(value="${zsmdm.supplierVagueUrl:http://dyc-ability-web:8080/OSN/api/supplierVague/v1}")
    private String supplierVagueUrl;

    @Override
    public ZsMdmSupplierVagueRspBo querySupplierVague(ZsMdmSupplierVagueReqBo reqBo) {
        JSONObject body = this.getBody(reqBo);
        log.info("\u4f9b\u5e94\u5546\u4e3b\u6570\u636e\u6a21\u7cca\u67e5\u8be2\u63a5\u53e3\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)body.toJSONString());
        String result = HttpUtil.post((String)this.supplierVagueUrl, (String)body.toJSONString());
        if (StringUtils.isEmpty((CharSequence)result)) {
            throw new ZTBusinessException("\u4f9b\u5e94\u5546\u4e3b\u6570\u636e\u6a21\u7cca\u67e5\u8be2\u63a5\u53e3\u8c03\u7528\u5931\u8d25");
        }
        log.info("\u4f9b\u5e94\u5546\u4e3b\u6570\u636e\u6a21\u7cca\u67e5\u8be2\u63a5\u53e3\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)result);
        JSONObject resultJson = JSONObject.parseObject((String)result);
        JSONObject esb = resultJson.getJSONObject("esb");
        if (!"S".equals(esb.getString("result"))) {
            throw new ZTBusinessException(esb.getString("desc"));
        }
        JSONObject data = esb.getJSONObject("data");
        JSONObject datainfos = data.getJSONObject("datainfos");
        JSONArray datainfo = datainfos.getJSONArray("datainfo");
        UmcOrgInfoPo umcOrgInfoPo = new UmcOrgInfoPo();
        UmcEnterpriseInfoPo enterpriseInfoPo = new UmcEnterpriseInfoPo();
        for (ZsMdmSupplierVagueBo zsMdmSupplierVagueBo : datainfo.toJavaList(ZsMdmSupplierVagueBo.class)) {
            umcOrgInfoPo.setExtOrgCode(zsMdmSupplierVagueBo.getSupplier_code());
            UmcOrgInfoPo modelBy = this.orgInfoMapper.getModelBy(umcOrgInfoPo);
            umcOrgInfoPo.setExtOrgCode(zsMdmSupplierVagueBo.getSupplier_code());
            umcOrgInfoPo.setOrgName(zsMdmSupplierVagueBo.getSupplier_name());
            if (zsMdmSupplierVagueBo.getEnterpriseIndividual().equals("\u4f01\u4e1a")) {
                umcOrgInfoPo.setOrgType(Long.valueOf(2L));
            } else {
                umcOrgInfoPo.setOrgType(Long.valueOf(3L));
            }
            if (zsMdmSupplierVagueBo.getSupplier_is_valid().equals("A")) {
                umcOrgInfoPo.setOrgStatus("1");
            } else {
                umcOrgInfoPo.setOrgStatus("0");
            }
            umcOrgInfoPo.setUpdateTime(new Date());
            enterpriseInfoPo.setOrgShortName(zsMdmSupplierVagueBo.getSupplier_name());
            enterpriseInfoPo.setAddress(zsMdmSupplierVagueBo.getSupplier_registered_address());
            enterpriseInfoPo.setLegalPerson(zsMdmSupplierVagueBo.getSupplier_legal_person());
            enterpriseInfoPo.setCountry(zsMdmSupplierVagueBo.getSupplier_country_name());
            enterpriseInfoPo.setProvince(zsMdmSupplierVagueBo.getSupplier_province_state());
            enterpriseInfoPo.setCity(zsMdmSupplierVagueBo.getSupplier_city());
            enterpriseInfoPo.setCurrency(zsMdmSupplierVagueBo.getSupplier_registered_currency());
            enterpriseInfoPo.setCapital(zsMdmSupplierVagueBo.getSupplier_registered_capital());
            enterpriseInfoPo.setLegalCertificateNum(zsMdmSupplierVagueBo.getSupplier_id_no());
            enterpriseInfoPo.setIsAbroad(zsMdmSupplierVagueBo.getSupplier_domestic_foreign().equals("\u5883\u5916") ? "1" : "0");
            if (zsMdmSupplierVagueBo.getSupplier_type().equals("\u5916\u90e8")) {
                enterpriseInfoPo.setOrgClass("2");
            } else if (zsMdmSupplierVagueBo.getSupplier_type().equals("\u5185\u90e8")) {
                enterpriseInfoPo.setOrgClass("4");
            }
            enterpriseInfoPo.setUpdateTime(new Date());
            if (modelBy != null) continue;
            umcOrgInfoPo.setOrgId(Long.valueOf(Sequence.getInstance().nextId()));
            umcOrgInfoPo.setOrgCode(umcOrgInfoPo.getOrgId().toString());
            umcOrgInfoPo.setOrgTreePath("1-305775845729763327-305775845729763332-" + umcOrgInfoPo.getOrgId() + "-");
            umcOrgInfoPo.setTenantId(Long.valueOf(10000L));
            umcOrgInfoPo.setParentId(Long.valueOf(305775845729763332L));
            umcOrgInfoPo.setCompanyId(umcOrgInfoPo.getOrgType() == 2L ? umcOrgInfoPo.getOrgId() : umcOrgInfoPo.getParentId());
            umcOrgInfoPo.setDeep(Integer.valueOf(4));
            if (!zsMdmSupplierVagueBo.getSupplier_domestic_foreign().equals("\u5883\u5185")) continue;
            if (zsMdmSupplierVagueBo.getEnterpriseIndividual().equals("\u4f01\u4e1a")) {
                if (zsMdmSupplierVagueBo.getSupplier_type().equals("\u5916\u90e8")) {
                    enterpriseInfoPo.setOrgClass("2");
                } else if (zsMdmSupplierVagueBo.getSupplier_type().equals("\u5185\u90e8")) {
                    enterpriseInfoPo.setOrgClass("4");
                }
                enterpriseInfoPo.setCreditNo(zsMdmSupplierVagueBo.getSupplier_credit_code());
                UmcEnterpriseInfoPo enterpriseInfoMapperModelBy = this.enterpriseInfoMapper.getModelBy(enterpriseInfoPo);
                if (enterpriseInfoMapperModelBy == null) {
                    enterpriseInfoPo.setOrgId(umcOrgInfoPo.getOrgId());
                    enterpriseInfoPo.setCreateTime(new Date());
                    continue;
                }
                enterpriseInfoPo.setOrgId(modelBy.getOrgId());
                continue;
            }
            if (zsMdmSupplierVagueBo.getSupplier_type().equals("\u5916\u90e8")) {
                enterpriseInfoPo.setOrgClass("1");
            }
            enterpriseInfoPo.setLegalCertificateNum(zsMdmSupplierVagueBo.getSupplier_id_no());
            UmcEnterpriseInfoPo modelBy1 = this.enterpriseInfoMapper.getModelBy(enterpriseInfoPo);
            enterpriseInfoPo.setOrgShortName(zsMdmSupplierVagueBo.getSupplier_name());
            enterpriseInfoPo.setAddress(zsMdmSupplierVagueBo.getSupplier_registered_address());
            enterpriseInfoPo.setLegalPerson(zsMdmSupplierVagueBo.getSupplier_legal_person());
            enterpriseInfoPo.setCountry(zsMdmSupplierVagueBo.getSupplier_country_name());
            enterpriseInfoPo.setProvince(zsMdmSupplierVagueBo.getSupplier_province_state());
            enterpriseInfoPo.setCity(zsMdmSupplierVagueBo.getSupplier_city());
            enterpriseInfoPo.setCurrency(zsMdmSupplierVagueBo.getSupplier_registered_currency());
            enterpriseInfoPo.setCapital(zsMdmSupplierVagueBo.getSupplier_registered_capital());
            enterpriseInfoPo.setLegalCertificateNum(zsMdmSupplierVagueBo.getSupplier_id_no());
            enterpriseInfoPo.setUpdateTime(new Date());
            if (modelBy1 == null) {
                enterpriseInfoPo.setOrgId(umcOrgInfoPo.getOrgId());
                enterpriseInfoPo.setCreateTime(new Date());
                continue;
            }
            enterpriseInfoPo.setOrgId(modelBy.getOrgId());
        }
        return this.getRspBo(esb);
    }

    private ZsMdmSupplierVagueRspBo getRspBo(JSONObject esb) {
        ZsMdmSupplierVagueRspBo rspBo = new ZsMdmSupplierVagueRspBo();
        JSONObject data = esb.getJSONObject("data");
        JSONObject splitpage = data.getJSONObject("splitpage");
        JSONObject datainfos = data.getJSONObject("datainfos");
        String puuid = data.getString("puuid");
        JSONArray datainfo = datainfos.getJSONArray("datainfo");
        List rows = datainfo.toJavaList(ZsMdmSupplierVagueBo.class);
        rspBo.setPuuid(puuid);
        rspBo.setTotal(splitpage.getInteger("totalpages"));
        rspBo.setRecordsTotal(splitpage.getInteger("totalnumber"));
        rspBo.setPageNo(splitpage.getInteger("currentpage"));
        rspBo.setRows(rows);
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private JSONObject getBody(ZsMdmSupplierVagueReqBo reqBo) {
        JSONObject json = new JSONObject();
        json.put("supplier_name", (Object)reqBo.getSupplier_name());
        JSONArray datainfo = new JSONArray();
        datainfo.add((Object)json);
        JSONObject datainfos = new JSONObject();
        datainfos.put("datainfo", (Object)datainfo);
        datainfos.put("puuid", (Object)reqBo.getPuuid());
        JSONObject splitpage = new JSONObject();
        splitpage.put("countperpage", (Object)reqBo.getCountperpage());
        splitpage.put("currentpage", (Object)reqBo.getCurrentpage());
        JSONObject data = new JSONObject();
        data.put("datainfos", (Object)datainfos);
        data.put("splitpage", (Object)splitpage);
        JSONObject esb = new JSONObject();
        esb.put("data", (Object)data);
        JSONObject body = new JSONObject();
        body.put("esb", (Object)esb);
        return body;
    }
}

