/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.model.common.impl;

import com.tydic.dyc.authority.repository.dao.SysOrgTypeInfoMapper;
import com.tydic.dyc.authority.repository.po.SysOrgTypeInfoPo;
import com.tydic.dyc.umc.model.common.MemAffiliatedBusinessUnitQryService;
import com.tydic.dyc.umc.model.common.sub.MemAffiliatedBusinessUnitQryReqBO;
import com.tydic.dyc.umc.model.common.sub.MemAffiliatedBusinessUnitQryRspBO;
import com.tydic.dyc.umc.repository.dao.UmcOrgInfoMapper;
import com.tydic.dyc.umc.repository.dao.UmcUserInfoMapper;
import com.tydic.dyc.umc.repository.po.UmcOrgInfoPo;
import com.tydic.dyc.umc.repository.po.UmcUserInfoPo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class MemAffiliatedBusinessUnitQryServiceImpl
implements MemAffiliatedBusinessUnitQryService {
    private static final Logger log = LoggerFactory.getLogger(MemAffiliatedBusinessUnitQryServiceImpl.class);
    @Autowired
    private UmcOrgInfoMapper umcOrgInfoMapper;
    @Autowired
    private UmcUserInfoMapper umcUserInfoMapper;
    @Autowired
    private SysOrgTypeInfoMapper sysOrgTypeInfoMapper;
    @Value(value="${BUSINESS_UNIT_CODE:BUSINESS_UNIT}")
    private String businessUnitCode;

    @Override
    public MemAffiliatedBusinessUnitQryRspBO qryMemAffiliatedBusinessUnit(MemAffiliatedBusinessUnitQryReqBO reqBO) {
        MemAffiliatedBusinessUnitQryRspBO rspBO = new MemAffiliatedBusinessUnitQryRspBO();
        rspBO.setRespCode("0000");
        if (reqBO.getUserId() == null) {
            return rspBO;
        }
        UmcUserInfoPo umcUserInfoPo = new UmcUserInfoPo();
        umcUserInfoPo.setUserId(reqBO.getUserId());
        umcUserInfoPo = this.umcUserInfoMapper.getModelBy(umcUserInfoPo);
        if (umcUserInfoPo == null) {
            return rspBO;
        }
        UmcOrgInfoPo orgInfoPo = new UmcOrgInfoPo();
        orgInfoPo.setOrgId(umcUserInfoPo.getOrgId());
        orgInfoPo = this.umcOrgInfoMapper.getModelBy(orgInfoPo);
        if (orgInfoPo == null) {
            return rspBO;
        }
        SysOrgTypeInfoPo sysOrgTypeInfoPo = new SysOrgTypeInfoPo();
        sysOrgTypeInfoPo.setOrgTypeCode(this.businessUnitCode);
        List sysOrgTypeInfoPos = this.sysOrgTypeInfoMapper.getList(sysOrgTypeInfoPo);
        if (CollectionUtils.isEmpty((Collection)sysOrgTypeInfoPos)) {
            log.error("\u672a\u914d\u7f6e\u4e1a\u52a1\u5355\u4f4d\u7c7b\u578b");
            return rspBO;
        }
        if (((SysOrgTypeInfoPo)sysOrgTypeInfoPos.get(0)).getOrgTypeId() == orgInfoPo.getOrgType()) {
            rspBO.setOrgId(orgInfoPo.getOrgId());
            rspBO.setOrgName(orgInfoPo.getOrgName());
            return rspBO;
        }
        List<String> orgList = Arrays.asList(orgInfoPo.getOrgTreePath().split("-"));
        ArrayList orgIds = new ArrayList();
        orgList.stream().forEach(a -> {
            if (!StringUtils.isEmpty((Object)a)) {
                orgIds.add(Long.parseLong(a));
            }
        });
        UmcOrgInfoPo umcOrgInfoPo = new UmcOrgInfoPo();
        umcOrgInfoPo.setOrgType(((SysOrgTypeInfoPo)sysOrgTypeInfoPos.get(0)).getOrgTypeId());
        umcOrgInfoPo.setOrgIds(orgIds);
        List umcOrgInfoPoList = this.umcOrgInfoMapper.getList(umcOrgInfoPo);
        if (!CollectionUtils.isEmpty((Collection)umcOrgInfoPoList)) {
            this.getBusiness(umcOrgInfoPoList, orgInfoPo.getOrgTreePath(), rspBO);
        }
        return rspBO;
    }

    private void getBusiness(List<UmcOrgInfoPo> umcOrgInfoPoList, String path, MemAffiliatedBusinessUnitQryRspBO rspBO) {
        if (umcOrgInfoPoList.size() == 1) {
            rspBO.setOrgId(umcOrgInfoPoList.get(0).getOrgId());
            rspBO.setOrgName(umcOrgInfoPoList.get(0).getOrgName());
            return;
        }
        Map mapOrg = umcOrgInfoPoList.stream().collect(Collectors.toMap(UmcOrgInfoPo::getOrgId, Function.identity()));
        List<String> orgList = Arrays.asList(path.split("-"));
        for (String each : orgList) {
            if (StringUtils.isEmpty((Object)each) || !mapOrg.containsKey(Long.valueOf(each))) continue;
            rspBO.setOrgId(((UmcOrgInfoPo)mapOrg.get(Long.valueOf(each))).getOrgId());
            rspBO.setOrgName(((UmcOrgInfoPo)mapOrg.get(Long.valueOf(each))).getOrgName());
            return;
        }
    }
}

