/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.repository.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Page;
import com.tydic.dyc.umc.model.qualif.UmcEnterpriseQualifSaveBusiService;
import com.tydic.dyc.umc.model.qualif.qrybo.UmcEnterpriseQualifSaveBusiReqBO;
import com.tydic.dyc.umc.model.qualif.sub.UmcEnterpriseQualifSaveBusiRspBO;
import com.tydic.dyc.umc.repository.dao.SupplierCategoryQualificationMappingMapper;
import com.tydic.dyc.umc.repository.dao.UmcCategoryMapper;
import com.tydic.dyc.umc.repository.dao.UmcEnterpriseQualifMapper;
import com.tydic.dyc.umc.repository.dao.UmcSupplierCategoryMapper;
import com.tydic.dyc.umc.repository.po.SupplierCategoryQualificationMappingPO;
import com.tydic.dyc.umc.repository.po.UmcEnterpriseQualifPO;
import com.tydic.dyc.umc.repository.po.UmcSupplierCategoryPO;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class UmcEnterpriseQualifSaveBusiServiceImpl
implements UmcEnterpriseQualifSaveBusiService {
    private static final Logger log = LoggerFactory.getLogger(UmcEnterpriseQualifSaveBusiServiceImpl.class);
    @Autowired
    private UmcEnterpriseQualifMapper umcEnterpriseQualifMapper;
    @Autowired
    private SupplierCategoryQualificationMappingMapper supplierCategoryQualificationMappingMapper;
    @Autowired
    private UmcCategoryMapper mcCategoryMapper;
    @Autowired
    private UmcSupplierCategoryMapper umcSupplierCategoryMapper;
    private static final String INVALID = "0";
    private static final String EFFECTIVE = "1";
    private static final String ADVANT = "2";

    @Override
    public UmcEnterpriseQualifSaveBusiRspBO saveEnterpriseQualif(UmcEnterpriseQualifSaveBusiReqBO reqBO) {
        UmcEnterpriseQualifSaveBusiRspBO rspBO = new UmcEnterpriseQualifSaveBusiRspBO();
        UmcSupplierCategoryPO supplierCategoryPO = new UmcSupplierCategoryPO();
        supplierCategoryPO.setOrgId(reqBO.getOrgIdIn());
        List umcSupplierCategoryPOS = this.umcSupplierCategoryMapper.getList(supplierCategoryPO);
        List itemIds = umcSupplierCategoryPOS.stream().map(UmcSupplierCategoryPO::getCategoryId).collect(Collectors.toList());
        SupplierCategoryQualificationMappingPO qualificationMappingPO = new SupplierCategoryQualificationMappingPO();
        qualificationMappingPO.setItemCatIds(itemIds);
        Page qualifMapPage = new Page(-1, -1);
        List qualificationMappingPOS = this.supplierCategoryQualificationMappingMapper.selectList(qualificationMappingPO, qualifMapPage);
        Map<String, List<SupplierCategoryQualificationMappingPO>> qualifMap = qualificationMappingPOS.stream().collect(Collectors.groupingBy(SupplierCategoryQualificationMappingPO::getQualifCode));
        HashMap<String, Integer> qualifMaxTimeMap = new HashMap<String, Integer>();
        for (String key : qualifMap.keySet()) {
            List<SupplierCategoryQualificationMappingPO> list = qualifMap.get(key);
            Integer maxTime = 0;
            for (SupplierCategoryQualificationMappingPO po : list) {
                Integer advent;
                if (StringUtils.isEmpty((Object)po.getAdvent()) || (advent = Integer.valueOf(po.getAdvent())) <= maxTime) continue;
                maxTime = advent;
            }
            qualifMaxTimeMap.put(key, maxTime);
        }
        UmcEnterpriseQualifPO umcEnterpriseQualifPO = new UmcEnterpriseQualifPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)umcEnterpriseQualifPO);
        if (qualifMap.containsKey(umcEnterpriseQualifPO.getQualifCode())) {
            List<SupplierCategoryQualificationMappingPO> supplierCategoryQualificationMappingPOS = qualifMap.get(umcEnterpriseQualifPO.getQualifCode());
            List itemCatIds = supplierCategoryQualificationMappingPOS.stream().map(SupplierCategoryQualificationMappingPO::getItemCatId).collect(Collectors.toList());
            List itemCatNameList = supplierCategoryQualificationMappingPOS.stream().map(SupplierCategoryQualificationMappingPO::getItemCatName).collect(Collectors.toList());
            umcEnterpriseQualifPO.setMaterielCode(itemCatIds.stream().map(String::valueOf).collect(Collectors.joining(",")));
            umcEnterpriseQualifPO.setMaterielName(String.join((CharSequence)",", itemCatNameList));
        }
        LocalDateTime dateTime = LocalDateTime.now();
        LocalDateTime expTime = LocalDateTime.ofInstant(reqBO.getExpDate().toInstant(), ZoneId.systemDefault());
        log.info("dateTime===={}", (Object)dateTime);
        log.info("expTime===={}", (Object)expTime);
        log.info("result===={}", (Object)dateTime.isAfter(expTime));
        if (dateTime.isAfter(expTime)) {
            umcEnterpriseQualifPO.setValidStatus(INVALID);
        } else {
            umcEnterpriseQualifPO.setValidStatus(EFFECTIVE);
        }
        if (EFFECTIVE.equals(umcEnterpriseQualifPO.getValidStatus()) && qualifMaxTimeMap.containsKey(umcEnterpriseQualifPO.getQualifCode())) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(reqBO.getExpDate());
            calendar.roll(5, (Integer)qualifMaxTimeMap.get(umcEnterpriseQualifPO.getQualifCode()));
            LocalDateTime advantTime = LocalDateTime.ofInstant(calendar.getTime().toInstant(), ZoneId.systemDefault());
            if (dateTime.isAfter(advantTime)) {
                umcEnterpriseQualifPO.setValidStatus(ADVANT);
            }
        }
        if (StringUtils.isEmpty((Object)reqBO.getQualifSource())) {
            umcEnterpriseQualifPO.setQualifSource(EFFECTIVE);
        }
        umcEnterpriseQualifPO.setQualifFile(JSONObject.toJSONString((Object)reqBO.getQualifFile()));
        umcEnterpriseQualifPO.setCreateNo(reqBO.getMemIdIn());
        umcEnterpriseQualifPO.setCreateName(reqBO.getUserName());
        umcEnterpriseQualifPO.setCreateTime(new Date());
        umcEnterpriseQualifPO.setAuditStatus(reqBO.getAuditStatus());
        umcEnterpriseQualifPO.setOrgId(reqBO.getOrgIdIn());
        umcEnterpriseQualifPO.setEnterpriseId(reqBO.getOrgIdIn());
        umcEnterpriseQualifPO.setEnterpriseName(reqBO.getCompanyName());
        umcEnterpriseQualifPO.setSupplierId(reqBO.getOrgIdIn());
        umcEnterpriseQualifPO.setSupplierName(reqBO.getCompanyName());
        umcEnterpriseQualifPO.setSubmitName(reqBO.getName());
        umcEnterpriseQualifPO.setSubmitNo(reqBO.getMemIdIn());
        umcEnterpriseQualifPO.setCertificateNum(reqBO.getCertificateNum());
        umcEnterpriseQualifPO.setSubmitTime(new Date());
        if (reqBO.getOperType() == 1) {
            umcEnterpriseQualifPO.setQualifStatus(ADVANT);
        } else {
            umcEnterpriseQualifPO.setQualifStatus(EFFECTIVE);
        }
        UmcEnterpriseQualifPO checkPo = new UmcEnterpriseQualifPO();
        checkPo.setQualifId(reqBO.getQualifId());
        checkPo = this.umcEnterpriseQualifMapper.getModelBy(checkPo);
        if (checkPo != null) {
            UmcEnterpriseQualifPO where = new UmcEnterpriseQualifPO();
            where.setQualifId(reqBO.getQualifId());
            this.umcEnterpriseQualifMapper.updateBy(umcEnterpriseQualifPO, where);
        } else {
            this.umcEnterpriseQualifMapper.insert(umcEnterpriseQualifPO);
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u4f01\u4e1a\u8d44\u8d28\u4fe1\u606f\u65b0\u589e\u6210\u529f\uff01");
        rspBO.setQualifId(umcEnterpriseQualifPO.getQualifId());
        return rspBO;
    }
}

