/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.repository.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Page;
import com.tydic.dyc.umc.model.qualif.UmcEnterpriseQualifUpdateBusiService;
import com.tydic.dyc.umc.model.qualif.sub.UmcEnterpriseQualifUpdateBusiReqBO;
import com.tydic.dyc.umc.model.qualif.sub.UmcEnterpriseQualifUpdateBusiRspBO;
import com.tydic.dyc.umc.repository.dao.SupplierCategoryQualificationMappingMapper;
import com.tydic.dyc.umc.repository.dao.UmcEnterpriseQualifMapper;
import com.tydic.dyc.umc.repository.dao.UmcSupplierCategoryMapper;
import com.tydic.dyc.umc.repository.po.SupplierCategoryQualificationMappingPO;
import com.tydic.dyc.umc.repository.po.UmcEnterpriseQualifPO;
import com.tydic.dyc.umc.repository.po.UmcSupplierCategoryPO;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="umcEnterpriseQualifUpdateBusiService")
public class UmcEnterpriseQualifUpdateBusiServiceImpl
implements UmcEnterpriseQualifUpdateBusiService {
    @Autowired
    private UmcEnterpriseQualifMapper umcEnterpriseQualifMapper;
    @Autowired
    private UmcSupplierCategoryMapper umcSupplierCategoryMapper;
    @Autowired
    private SupplierCategoryQualificationMappingMapper supplierCategoryQualificationMappingMapper;
    private static final String INVALID = "0";
    private static final String EFFECTIVE = "1";
    private static final String ADVANT = "2";

    @Override
    public UmcEnterpriseQualifUpdateBusiRspBO updateEnterpriseQualif(UmcEnterpriseQualifUpdateBusiReqBO reqBO) {
        LocalDateTime expTime;
        LocalDateTime dateTime;
        UmcSupplierCategoryPO supplierCategoryPO = new UmcSupplierCategoryPO();
        supplierCategoryPO.setOrgId(reqBO.getOrgIdIn());
        List umcSupplierCategoryPOS = this.umcSupplierCategoryMapper.getList(supplierCategoryPO);
        List itemIds = umcSupplierCategoryPOS.stream().map(UmcSupplierCategoryPO::getCategoryId).collect(Collectors.toList());
        SupplierCategoryQualificationMappingPO qualificationMappingPO = new SupplierCategoryQualificationMappingPO();
        qualificationMappingPO.setItemCatIds(itemIds);
        Page qualifMapPage = new Page(-1, -1);
        List qualificationMappingPOS = this.supplierCategoryQualificationMappingMapper.selectList(qualificationMappingPO, qualifMapPage);
        Map<String, List<SupplierCategoryQualificationMappingPO>> qualifMap = qualificationMappingPOS.stream().collect(Collectors.groupingBy(SupplierCategoryQualificationMappingPO::getQualifCode));
        HashMap<String, Integer> qualifMaxTimeMap = new HashMap<String, Integer>();
        for (String key : qualifMap.keySet()) {
            List<SupplierCategoryQualificationMappingPO> list = qualifMap.get(key);
            Integer maxTime = 0;
            for (SupplierCategoryQualificationMappingPO po : list) {
                Integer advent;
                if (StringUtils.isEmpty((Object)po.getAdvent()) || (advent = Integer.valueOf(po.getAdvent())) <= maxTime) continue;
                maxTime = advent;
            }
            qualifMaxTimeMap.put(key, maxTime);
        }
        UmcEnterpriseQualifUpdateBusiRspBO rspBO = new UmcEnterpriseQualifUpdateBusiRspBO();
        UmcEnterpriseQualifPO set = new UmcEnterpriseQualifPO();
        BeanUtils.copyProperties((Object)((Object)reqBO), (Object)set);
        set.setQualifFile(JSONObject.toJSONString(reqBO.getQualifFile()));
        if (qualifMap.containsKey(set.getQualifCode())) {
            List<SupplierCategoryQualificationMappingPO> supplierCategoryQualificationMappingPOS = qualifMap.get(set.getQualifCode());
            List itemCatIds = supplierCategoryQualificationMappingPOS.stream().map(SupplierCategoryQualificationMappingPO::getItemCatId).collect(Collectors.toList());
            List itemCatNameList = supplierCategoryQualificationMappingPOS.stream().map(SupplierCategoryQualificationMappingPO::getItemCatName).collect(Collectors.toList());
            set.setMaterielCode(itemCatIds.stream().map(String::valueOf).collect(Collectors.joining(",")));
            set.setMaterielName(String.join((CharSequence)",", itemCatNameList));
        }
        if ((dateTime = LocalDateTime.now()).isBefore(expTime = LocalDateTime.ofInstant(reqBO.getExpDate().toInstant(), ZoneId.systemDefault()))) {
            set.setValidStatus(EFFECTIVE);
        } else {
            set.setValidStatus(INVALID);
        }
        if (EFFECTIVE.equals(set.getValidStatus()) && qualifMaxTimeMap.containsKey(set.getQualifCode())) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(reqBO.getExpDate());
            calendar.roll(5, (Integer)qualifMaxTimeMap.get(set.getQualifCode()));
            LocalDateTime advantTime = LocalDateTime.ofInstant(calendar.getTime().toInstant(), ZoneId.systemDefault());
            if (dateTime.isAfter(advantTime)) {
                set.setValidStatus(ADVANT);
            }
        }
        set.setAuditStatus(reqBO.getAuditStatus());
        if (reqBO.getOperType() == 1) {
            set.setQualifStatus(ADVANT);
        } else {
            set.setQualifStatus(EFFECTIVE);
        }
        set.setSubmitName(reqBO.getName());
        set.setSubmitNo(reqBO.getMemIdIn());
        set.setSubmitTime(new Date());
        UmcEnterpriseQualifPO where = new UmcEnterpriseQualifPO();
        where.setQualifId(reqBO.getQualifId());
        if (EFFECTIVE.equals(reqBO.getChangeFlag())) {
            set.setQualifId(reqBO.getQualifId());
            UmcEnterpriseQualifPO checkPo = new UmcEnterpriseQualifPO();
            checkPo.setQualifId(reqBO.getQualifId());
            checkPo = this.umcEnterpriseQualifMapper.getModelBy(checkPo);
            if (checkPo != null) {
                UmcEnterpriseQualifPO wherePo = new UmcEnterpriseQualifPO();
                wherePo.setQualifId(reqBO.getQualifId());
                this.umcEnterpriseQualifMapper.updateBy(set, wherePo);
            } else {
                set.setQualifSource(EFFECTIVE);
                set.setCreateNo(reqBO.getMemIdIn());
                set.setCreateName(reqBO.getUserName());
                set.setCreateTime(new Date());
                set.setEnterpriseId(reqBO.getOrgIdIn());
                set.setEnterpriseName(reqBO.getCompanyName());
                set.setSupplierId(reqBO.getOrgIdIn());
                set.setSupplierName(reqBO.getCompanyName());
                this.umcEnterpriseQualifMapper.insert(set);
            }
            UmcEnterpriseQualifPO updateSet = new UmcEnterpriseQualifPO();
            updateSet.setChangeQualifId(set.getQualifId());
            updateSet.setChangeQualifCode(set.getCertificateNum());
            updateSet.setChangeQualifStatus(set.getQualifStatus());
            updateSet.setChangeQualifLicenseName(set.getQualifLicenseName());
            UmcEnterpriseQualifPO updateWherePo = new UmcEnterpriseQualifPO();
            updateWherePo.setQualifId(reqBO.getSourceQualifId());
            this.umcEnterpriseQualifMapper.updateBy(updateSet, updateWherePo);
            rspBO.setQualifId(set.getQualifId());
        } else {
            int updateFlag = this.umcEnterpriseQualifMapper.updateBy(set, where);
            if (updateFlag < 1) {
                throw new ZTBusinessException("\u4f01\u4e1a\u8d44\u8d28\u4fe1\u606f\u4fee\u6539\u5931\u8d25!");
            }
            rspBO.setQualifId(reqBO.getQualifId());
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u4f01\u4e1a\u8d44\u8d28\u4fe1\u606f\u4fee\u6539\u6210\u529f\uff01");
        return rspBO;
    }
}

