/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.repository.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.model.score.UmcQrySupMisconductListBusiService;
import com.tydic.dyc.umc.model.score.qrybo.UmcQrySupMisconductListBusiReqBO;
import com.tydic.dyc.umc.model.score.sub.UmcQrySupMisconductListBusiRspBO;
import com.tydic.dyc.umc.repository.dao.SupplierMisconductMapper;
import com.tydic.dyc.umc.repository.po.SupplierMisconductPO;
import com.tydic.dyc.umc.service.enterprise.DictionaryBusiService;
import com.tydic.dyc.umc.service.score.bo.SupplierMisconductBO;
import com.tydic.dyc.umc.service.score.bo.UmcSupMisconductBO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UmcQrySupMisconductListBusiServiceImpl
implements UmcQrySupMisconductListBusiService {
    @Autowired
    private SupplierMisconductMapper supplierMisconductMapper;
    @Autowired
    private DictionaryBusiService dictionaryBusiService;

    @Override
    public UmcQrySupMisconductListBusiRspBO qrySupMisconductList(UmcQrySupMisconductListBusiReqBO reqBO) {
        UmcQrySupMisconductListBusiRspBO rspBO = new UmcQrySupMisconductListBusiRspBO();
        SupplierMisconductBO conditionPO = new SupplierMisconductBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)conditionPO);
        conditionPO.setOrgId(null);
        conditionPO.setUserId(reqBO.getUserId());
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        if (conditionPO.getMisconductStatus() != null) {
            conditionPO.setMisconductStatusList(null);
        }
        if (!StringUtils.isEmpty((CharSequence)reqBO.getHandleResult())) {
            List handleResultList = Arrays.asList(reqBO.getHandleResult().split(",")).stream().map(s -> Long.parseLong(s.trim())).sorted().collect(Collectors.toList());
            conditionPO.setHandleResult(handleResultList.stream().map(s -> String.valueOf(s)).collect(Collectors.joining(",")));
        }
        List smPOList = this.supplierMisconductMapper.selectList(page, conditionPO);
        ArrayList<UmcSupMisconductBO> smBOList = new ArrayList<UmcSupMisconductBO>();
        Map misconductBusiTypeMap = this.dictionaryBusiService.queryBypCodeBackMap("UMC_PLUS", "MISCONDUCT_BUSI_TYPE");
        Map misconductTypeMap = this.dictionaryBusiService.queryBypCodeBackMap("UMC_PLUS", "MISCONDUCT_TYPE_STR");
        Map misconductStatusMap = this.dictionaryBusiService.queryBypCodeBackMap("UMC_PLUS", "MISCONDUCT_STATUS");
        Map misconductHandleResultMap = this.dictionaryBusiService.queryBypCodeBackMap("UMC_PLUS", "MISCONDUCT_HANDLE_RESULT");
        Map misconductHandleStatusMap = this.dictionaryBusiService.queryBypCodeBackMap("UMC_PLUS", "MISCONDUCT_HAND_STATUS");
        Map misconductAppealStatusMap = this.dictionaryBusiService.queryBypCodeBackMap("UMC_PLUS", "MISCONDUCT_APPEAL_STATUS");
        for (SupplierMisconductPO smPO : smPOList) {
            UmcSupMisconductBO smBO = new UmcSupMisconductBO();
            BeanUtils.copyProperties((Object)smPO, (Object)smBO);
            if (smBO.getBusiType() != null) {
                smBO.setBusiTypeStr((String)misconductBusiTypeMap.get(smBO.getBusiType().toString()));
            }
            if (smBO.getMisconductType() != null) {
                smBO.setMisconductTypeStr((String)misconductTypeMap.get(smBO.getMisconductType().toString()));
            }
            if (smBO.getMisconductStatus() != null) {
                smBO.setMisconductStatusStr((String)misconductStatusMap.get(smBO.getMisconductStatus().toString()));
            }
            if (!StringUtils.isEmpty((CharSequence)smBO.getHandleResult())) {
                String[] handleResults = smBO.getHandleResult().split(",");
                ArrayList handleResultStrList = new ArrayList();
                for (String handleResult : handleResults) {
                    handleResultStrList.add(misconductHandleResultMap.get(handleResult));
                }
                smBO.setHandleResultStr(StringUtils.join(handleResultStrList, (String)","));
            }
            if (smBO.getHandleStatus() != null) {
                smBO.setHandleStatusStr((String)misconductHandleStatusMap.get(smBO.getHandleStatus().toString()));
            }
            if (smBO.getAppealStatus() != null) {
                smBO.setAppealStatusStr((String)misconductAppealStatusMap.get(smBO.getAppealStatus().toString()));
            }
            smBOList.add(smBO);
        }
        rspBO.setTotal(page.getTotalPages());
        rspBO.setRecordsTotal(page.getTotalCount());
        rspBO.setPageNo(page.getPageNo());
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setRows(smBOList);
        return rspBO;
    }

    @Override
    public UmcQrySupMisconductListBusiRspBO qrySupMisconductAduitList(UmcQrySupMisconductListBusiReqBO reqBO) {
        List tempBOList;
        UmcQrySupMisconductListBusiRspBO rspBO = new UmcQrySupMisconductListBusiRspBO();
        SupplierMisconductBO conditionPO = new SupplierMisconductBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)conditionPO);
        conditionPO.setOrgId(null);
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        if (conditionPO.getMisconductStatus() != null) {
            conditionPO.setMisconductStatusList(null);
        }
        if (!StringUtils.isEmpty((CharSequence)reqBO.getHandleResult())) {
            List handleResultList = Arrays.asList(reqBO.getHandleResult().split(",")).stream().map(s -> Long.parseLong(s.trim())).sorted().collect(Collectors.toList());
            conditionPO.setHandleResult(handleResultList.stream().map(s -> String.valueOf(s)).collect(Collectors.joining(",")));
        }
        conditionPO.setUserId(reqBO.getUserId());
        if (reqBO.getMisconductStatusList().size() == 1 && ((Integer)reqBO.getMisconductStatusList().get(0) == 3 || (Integer)reqBO.getMisconductStatusList().get(0) == 0)) {
            conditionPO.setTabId(Integer.valueOf(1));
        } else {
            conditionPO.setTabId(Integer.valueOf(2));
        }
        List smPOList = this.supplierMisconductMapper.selectListAppreal(page, conditionPO);
        ArrayList<UmcSupMisconductBO> smBOList = new ArrayList<UmcSupMisconductBO>();
        Map misconductBusiTypeMap = this.dictionaryBusiService.queryBypCodeBackMap("UMC_PLUS", "MISCONDUCT_BUSI_TYPE");
        Map misconductTypeMap = this.dictionaryBusiService.queryBypCodeBackMap("UMC_PLUS", "MISCONDUCT_TYPE_STR");
        Map misconductStatusMap = this.dictionaryBusiService.queryBypCodeBackMap("UMC_PLUS", "MISCONDUCT_STATUS");
        Map misconductHandleResultMap = this.dictionaryBusiService.queryBypCodeBackMap("UMC_PLUS", "MISCONDUCT_HANDLE_RESULT");
        Map misconductHandleStatusMap = this.dictionaryBusiService.queryBypCodeBackMap("UMC_PLUS", "MISCONDUCT_HAND_STATUS");
        Map misconductAppealStatusMap = this.dictionaryBusiService.queryBypCodeBackMap("UMC_PLUS", "MISCONDUCT_APPEAL_STATUS");
        for (SupplierMisconductPO smPO : smPOList) {
            UmcSupMisconductBO smBO = new UmcSupMisconductBO();
            BeanUtils.copyProperties((Object)smPO, (Object)smBO);
            if (smBO.getBusiType() != null) {
                smBO.setBusiTypeStr((String)misconductBusiTypeMap.get(smBO.getBusiType().toString()));
            }
            if (smBO.getMisconductType() != null) {
                smBO.setMisconductTypeStr((String)misconductTypeMap.get(smBO.getMisconductType().toString()));
            }
            if (smBO.getMisconductStatus() != null) {
                smBO.setMisconductStatusStr((String)misconductStatusMap.get(smBO.getMisconductStatus().toString()));
            }
            if (!StringUtils.isEmpty((CharSequence)smBO.getHandleResult())) {
                String[] handleResults = smBO.getHandleResult().split(",");
                ArrayList handleResultStrList = new ArrayList();
                for (String handleResult : handleResults) {
                    handleResultStrList.add(misconductHandleResultMap.get(handleResult));
                }
                smBO.setHandleResultStr(StringUtils.join(handleResultStrList, (String)","));
            }
            if (smBO.getHandleStatus() != null) {
                smBO.setHandleStatusStr((String)misconductHandleStatusMap.get(smBO.getHandleStatus().toString()));
            }
            if (smBO.getAppealStatus() != null) {
                smBO.setAppealStatusStr((String)misconductAppealStatusMap.get(smBO.getAppealStatus().toString()));
            }
            smBOList.add(smBO);
        }
        if (reqBO.getQueryType() == 1) {
            tempBOList = this.supplierMisconductMapper.selectTabCount();
        } else if (reqBO.getQueryType() == 2) {
            tempBOList = this.supplierMisconductMapper.selectTabCountAppeal(conditionPO.getOrgId());
        } else {
            throw new BaseBusinessException("163079", "\u67e5\u8be2\u7c7b\u578b\u4e0d\u5b58\u5728");
        }
        rspBO.setTabList(tempBOList);
        rspBO.setTotal(page.getTotalPages());
        rspBO.setRecordsTotal(page.getTotalCount());
        rspBO.setPageNo(page.getPageNo());
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setRows(smBOList);
        return rspBO;
    }

    @Override
    public UmcQrySupMisconductListBusiRspBO qryMisconductAduitList(UmcQrySupMisconductListBusiReqBO reqBO) {
        UmcQrySupMisconductListBusiRspBO rspBO = new UmcQrySupMisconductListBusiRspBO();
        SupplierMisconductBO conditionPO = new SupplierMisconductBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)conditionPO);
        conditionPO.setOrgId(null);
        conditionPO.setUserId(reqBO.getUserId());
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        if (conditionPO.getMisconductStatus() != null) {
            conditionPO.setMisconductStatusList(null);
        }
        if (!StringUtils.isEmpty((CharSequence)reqBO.getHandleResult())) {
            List handleResultList = Arrays.asList(reqBO.getHandleResult().split(",")).stream().map(s -> Long.parseLong(s.trim())).sorted().collect(Collectors.toList());
            conditionPO.setHandleResult(handleResultList.stream().map(s -> String.valueOf(s)).collect(Collectors.joining(",")));
        }
        List smPOList = this.supplierMisconductMapper.selectMisconduList(page, conditionPO);
        ArrayList<UmcSupMisconductBO> smBOList = new ArrayList<UmcSupMisconductBO>();
        Map misconductBusiTypeMap = this.dictionaryBusiService.queryBypCodeBackMap("UMC_PLUS", "MISCONDUCT_BUSI_TYPE");
        Map misconductTypeMap = this.dictionaryBusiService.queryBypCodeBackMap("UMC_PLUS", "MISCONDUCT_TYPE_STR");
        Map misconductStatusMap = this.dictionaryBusiService.queryBypCodeBackMap("UMC_PLUS", "MISCONDUCT_STATUS");
        Map misconductHandleResultMap = this.dictionaryBusiService.queryBypCodeBackMap("UMC_PLUS", "MISCONDUCT_HANDLE_RESULT");
        Map misconductHandleStatusMap = this.dictionaryBusiService.queryBypCodeBackMap("UMC_PLUS", "MISCONDUCT_HAND_STATUS");
        Map misconductAppealStatusMap = this.dictionaryBusiService.queryBypCodeBackMap("UMC_PLUS", "MISCONDUCT_APPEAL_STATUS");
        for (SupplierMisconductPO smPO : smPOList) {
            UmcSupMisconductBO smBO = new UmcSupMisconductBO();
            BeanUtils.copyProperties((Object)smPO, (Object)smBO);
            if (smBO.getBusiType() != null) {
                smBO.setBusiTypeStr((String)misconductBusiTypeMap.get(smBO.getBusiType().toString()));
            }
            if (smBO.getMisconductType() != null) {
                smBO.setMisconductTypeStr((String)misconductTypeMap.get(smBO.getMisconductType().toString()));
            }
            if (smBO.getMisconductStatus() != null) {
                smBO.setMisconductStatusStr((String)misconductStatusMap.get(smBO.getMisconductStatus().toString()));
            }
            if (!StringUtils.isEmpty((CharSequence)smBO.getHandleResult())) {
                String[] handleResults = smBO.getHandleResult().split(",");
                ArrayList handleResultStrList = new ArrayList();
                for (String handleResult : handleResults) {
                    handleResultStrList.add(misconductHandleResultMap.get(handleResult));
                }
                smBO.setHandleResultStr(StringUtils.join(handleResultStrList, (String)","));
            }
            if (smBO.getHandleStatus() != null) {
                smBO.setHandleStatusStr((String)misconductHandleStatusMap.get(smBO.getHandleStatus().toString()));
            }
            if (smBO.getAppealStatus() != null) {
                smBO.setAppealStatusStr((String)misconductAppealStatusMap.get(smBO.getAppealStatus().toString()));
            }
            smBOList.add(smBO);
        }
        rspBO.setTotal(page.getTotalPages());
        rspBO.setRecordsTotal(page.getTotalCount());
        rspBO.setPageNo(page.getPageNo());
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setRows(smBOList);
        return rspBO;
    }
}

