/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.repository.impl;

import com.ohaotian.plugin.common.util.DateUtils;
import com.ohaotian.plugin.db.OrderSequence;
import com.ohaotian.plugin.db.Page;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.model.feedback.UmcQuestionFeedbackBusiService;
import com.tydic.dyc.umc.model.feedback.qrybo.UmcQuestionFeedbackAddBusiReqBO;
import com.tydic.dyc.umc.model.feedback.qrybo.UmcQuestionFeedbackListBusiReqBO;
import com.tydic.dyc.umc.model.feedback.sub.UmcQuestionFeedbackAddBusiRspBO;
import com.tydic.dyc.umc.model.feedback.sub.UmcQuestionFeedbackDetailBusiRspBO;
import com.tydic.dyc.umc.repository.dao.OhaotianOrderSequenceMapper;
import com.tydic.dyc.umc.repository.dao.QuestionFeedbackMapper;
import com.tydic.dyc.umc.repository.po.OhaotianOrderSequencePO;
import com.tydic.dyc.umc.repository.po.QuestionDealLogPO;
import com.tydic.dyc.umc.repository.po.QuestionFeedbackPO;
import com.tydic.dyc.umc.service.feedback.bo.UmcQuestionDealLogBO;
import com.tydic.dyc.umc.service.feedback.bo.UmcQuestionFeedbackBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class UmcQuestionFeedbackBusiServiceImpl
implements UmcQuestionFeedbackBusiService {
    private static final Logger log = LoggerFactory.getLogger(UmcQuestionFeedbackBusiServiceImpl.class);
    @Autowired
    private QuestionFeedbackMapper questionFeedbackMapper;
    @Autowired
    private OhaotianOrderSequenceMapper ohaotianOrderSequenceMapper;
    @Resource(name="supplierMisconductSequencePager")
    private OrderSequence questionFeedBackSequencePager;
    private static final String wait = "00";
    private static final String aleady = "01";

    @Override
    public UmcQuestionFeedbackAddBusiRspBO addQuestionFeedback(UmcQuestionFeedbackAddBusiReqBO reqBO) {
        UmcQuestionFeedbackAddBusiRspBO rspBO = new UmcQuestionFeedbackAddBusiRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        QuestionFeedbackPO questionFeedbackPO = new QuestionFeedbackPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)questionFeedbackPO);
        questionFeedbackPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
        questionFeedbackPO.setCreateTime(new Date());
        String timeStr = DateUtils.dateToStrYYYYMMdd((Date)new Date()).toString();
        Long serialNumber = this.getRegAccountSequencePager();
        if (serialNumber > 999L) {
            OhaotianOrderSequencePO ohaotianOrderSequencePO = new OhaotianOrderSequencePO();
            ohaotianOrderSequencePO.setId(Long.valueOf(8L));
            ohaotianOrderSequencePO.setCurrentValue(Long.valueOf(1L));
            int update = this.ohaotianOrderSequenceMapper.updateByCondition(ohaotianOrderSequencePO);
            if (update < 1) {
                throw new BaseBusinessException("161000", "\u5e8f\u5217\u5316\u8868\u4fee\u6539\u5931\u8d25\uff01");
            }
            serialNumber = 1L;
        }
        String num = serialNumber + "";
        switch (num.length()) {
            case 1: {
                questionFeedbackPO.setQuestionNo("FKD" + timeStr + wait + num);
                break;
            }
            case 2: {
                questionFeedbackPO.setQuestionNo("FKD" + timeStr + "0" + num);
                break;
            }
            default: {
                questionFeedbackPO.setQuestionNo("FKD" + timeStr + num);
            }
        }
        questionFeedbackPO.setStatus(wait);
        this.questionFeedbackMapper.insert(questionFeedbackPO);
        return rspBO;
    }

    @Override
    public UmcQuestionFeedbackAddBusiRspBO qryQuestionFeedbackList(UmcQuestionFeedbackListBusiReqBO reqBO) {
        UmcQuestionFeedbackAddBusiRspBO rspBO = new UmcQuestionFeedbackAddBusiRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        QuestionFeedbackPO questionFeedbackPO = new QuestionFeedbackPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)questionFeedbackPO);
        ArrayList<UmcQuestionFeedbackBO> rows = new ArrayList<UmcQuestionFeedbackBO>();
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        List questionFeedbackList = this.questionFeedbackMapper.getListByPage(questionFeedbackPO, page);
        if (!CollectionUtils.isEmpty((Collection)questionFeedbackList)) {
            for (QuestionFeedbackPO feedbackPO : questionFeedbackList) {
                UmcQuestionFeedbackBO feedbackBO = new UmcQuestionFeedbackBO();
                BeanUtils.copyProperties((Object)feedbackPO, (Object)feedbackBO);
                rows.add(feedbackBO);
            }
            rspBO.setRows(rows);
            rspBO.setRecordsTotal(page.getTotalCount());
            rspBO.setTotal(page.getTotalPages());
            rspBO.setPageNo(page.getPageNo());
        }
        return rspBO;
    }

    @Override
    public UmcQuestionFeedbackDetailBusiRspBO qryQuestionFeedbackDetail(UmcQuestionFeedbackAddBusiReqBO reqBO) {
        UmcQuestionFeedbackDetailBusiRspBO rspBO = new UmcQuestionFeedbackDetailBusiRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        if (StringUtils.isEmpty((Object)reqBO.getQuestionNo())) {
            return rspBO;
        }
        QuestionFeedbackPO questionFeedbackPO = new QuestionFeedbackPO();
        questionFeedbackPO.setQuestionNo(reqBO.getQuestionNo());
        QuestionFeedbackPO detailPO = this.questionFeedbackMapper.getDetail(questionFeedbackPO);
        if (null == detailPO) {
            return rspBO;
        }
        BeanUtils.copyProperties((Object)detailPO, (Object)((Object)rspBO));
        List logPOList = this.questionFeedbackMapper.getDealLog(reqBO.getQuestionNo());
        if (!CollectionUtils.isEmpty((Collection)logPOList)) {
            ArrayList<UmcQuestionDealLogBO> logBOList = new ArrayList<UmcQuestionDealLogBO>();
            for (QuestionDealLogPO logPO : logPOList) {
                UmcQuestionDealLogBO logBO = new UmcQuestionDealLogBO();
                BeanUtils.copyProperties((Object)logPO, (Object)logBO);
                logBOList.add(logBO);
            }
            rspBO.setLogBOList(logBOList);
        }
        return rspBO;
    }

    @Override
    public UmcQuestionFeedbackAddBusiRspBO dealQuestionFeedback(UmcQuestionFeedbackAddBusiReqBO reqBO) {
        UmcQuestionFeedbackAddBusiRspBO rspBO = new UmcQuestionFeedbackAddBusiRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        if (CollectionUtils.isEmpty((Collection)reqBO.getQuestionNoList()) || StringUtils.isEmpty((Object)reqBO.getDealDesc())) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u67e5\u8be2\u5355\u53f7\u5931\u8d25");
            return rspBO;
        }
        QuestionFeedbackPO questionFeedbackPO = new QuestionFeedbackPO();
        questionFeedbackPO.setQuestionNoList(reqBO.getQuestionNoList());
        List questionFeedbackList = this.questionFeedbackMapper.getList(questionFeedbackPO);
        if (CollectionUtils.isEmpty((Collection)questionFeedbackList)) {
            return rspBO;
        }
        ArrayList<QuestionDealLogPO> logPOList = new ArrayList<QuestionDealLogPO>();
        Date dealTime = new Date();
        ArrayList<Long> questionIdList = new ArrayList<Long>();
        for (QuestionFeedbackPO questionPO : questionFeedbackList) {
            questionIdList.add(questionPO.getId());
            QuestionDealLogPO logPO = new QuestionDealLogPO();
            logPO.setDealOperId(reqBO.getDealOperId());
            logPO.setDealOperName(reqBO.getDealOperName());
            logPO.setDealTime(dealTime);
            logPO.setQuestionId(questionPO.getId());
            logPO.setLogId(Long.valueOf(Sequence.getInstance().nextId()));
            logPO.setDealDesc(reqBO.getDealDesc());
            logPOList.add(logPO);
        }
        QuestionFeedbackPO updateQuestionPO = new QuestionFeedbackPO();
        updateQuestionPO.setQuestionIdList(questionIdList);
        updateQuestionPO.setDealDesc(reqBO.getDealDesc());
        updateQuestionPO.setDealTime(dealTime);
        updateQuestionPO.setDealOperId(reqBO.getDealOperId());
        updateQuestionPO.setDealOperName(reqBO.getDealOperName());
        updateQuestionPO.setStatus(aleady);
        int updateCount = this.questionFeedbackMapper.updateQuestion(updateQuestionPO);
        if (updateCount < 1) {
            throw new BaseBusinessException("8888", "\u6279\u91cf\u5904\u7406\u5931\u8d25!");
        }
        this.questionFeedbackMapper.insertLogBatch(logPOList);
        return rspBO;
    }

    private long getRegAccountSequencePager() {
        try {
            return this.questionFeedBackSequencePager.nextId();
        }
        catch (Exception e) {
            throw new BaseBusinessException("8888", "\u83b7\u53d6\u53cd\u9988\u5355\u7f16\u7801\u6d41\u6c34\u53f7\u5f02\u5e38", (Throwable)e);
        }
    }
}

