/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.repository.impl;

import com.ohaotian.plugin.common.util.MoneyUtils;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.constants.UmcCommConstants;
import com.tydic.dyc.umc.model.bmanagement.PlatformNotifyBusiService;
import com.tydic.dyc.umc.model.bmanagement.UmcSupMisconductHandleBusiService;
import com.tydic.dyc.umc.model.bmanagement.qrybo.UmcSupMisconductHandleBusiReqBO;
import com.tydic.dyc.umc.model.bmanagement.sub.UmcSupMisconductHandleBusiRspBO;
import com.tydic.dyc.umc.repository.dao.MemberMapper;
import com.tydic.dyc.umc.repository.dao.SupplierInfoMapper;
import com.tydic.dyc.umc.repository.dao.SupplierMisconductMapper;
import com.tydic.dyc.umc.repository.dao.SupplierMisconductNoticeMapper;
import com.tydic.dyc.umc.repository.po.SupplierMisconductNoticePO;
import com.tydic.dyc.umc.repository.po.SupplierMisconductPO;
import java.math.BigDecimal;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UmcSupMisconductHandleBusiServiceImpl
implements UmcSupMisconductHandleBusiService {
    private static final Logger log = LoggerFactory.getLogger(UmcSupMisconductHandleBusiServiceImpl.class);
    @Autowired
    private SupplierMisconductMapper supplierMisconductMapper;
    @Autowired
    private SupplierMisconductNoticeMapper supplierMisconductNoticeMapper;
    @Autowired
    private SupplierInfoMapper supplierInfoMapper;
    @Autowired
    private MemberMapper memberMapper;
    @Autowired
    private PlatformNotifyBusiService platformNotifyBusiService;

    @Override
    public UmcSupMisconductHandleBusiRspBO supMisconductHandle(UmcSupMisconductHandleBusiReqBO reqBO) {
        UmcSupMisconductHandleBusiRspBO rspBO = new UmcSupMisconductHandleBusiRspBO();
        SupplierMisconductPO supplierMisconductPO = this.supplierMisconductMapper.selectByPrimaryKey(reqBO.getMisconductId());
        SupplierMisconductPO smPO = new SupplierMisconductPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)smPO);
        String[] handleResults = reqBO.getHandleResult().split(",");
        String handleResultDesc = "";
        SupplierMisconductNoticePO smnPO = new SupplierMisconductNoticePO();
        smnPO.setHandleResult(reqBO.getHandleResult());
        for (String handleResult : handleResults) {
            if (handleResult.equals(UmcCommConstants.MisconductHandleResult.WARNING.toString())) {
                handleResultDesc = handleResultDesc + "\u8b66\u544a;";
            }
            if (handleResult.equals(UmcCommConstants.MisconductHandleResult.DEDUCT.toString())) {
                handleResultDesc = handleResultDesc + "\u6263\u5206:" + reqBO.getDeductPoints() + ";";
                smnPO.setDeductPoints(reqBO.getDeductPoints());
            }
            if (handleResult.equals(UmcCommConstants.MisconductHandleResult.PENALTY.toString())) {
                handleResultDesc = handleResultDesc + "\u7f5a\u6b3e:" + reqBO.getPenaltyAmount() + "\u5143;";
                try {
                    smnPO.setPenaltyAmount(MoneyUtils.BigDecimal2Long((BigDecimal)reqBO.getPenaltyAmount()));
                }
                catch (Exception e) {
                    throw new BaseBusinessException("8888", "\u7f5a\u6b3e\u91d1\u989d\u91d1\u989d\u5904\u7406\u9519\u8bef");
                }
            }
            if (!handleResult.equals(UmcCommConstants.MisconductHandleResult.NO_ADOPT.toString())) continue;
            handleResultDesc = "\u4e0d\u4e88\u91c7\u7eb3;";
            smPO.setMisconductStatus(UmcCommConstants.MisconductStatus.NO_ADOPT);
        }
        smPO.setHandleResultDesc(handleResultDesc);
        smPO.setHandleStatus(UmcCommConstants.MisconductHandleStatus.HANDLED);
        smPO.setHandleId(reqBO.getUserId());
        smPO.setHandleName(reqBO.getUserName());
        smPO.setHandleTime(new Date());
        if (!handleResults[0].equals(UmcCommConstants.MisconductHandleResult.NO_ADOPT.toString())) {
            smPO.setMisconductStatus(Integer.valueOf(Integer.parseInt(reqBO.getAuditStatus())));
            smPO.setHandleStatus(UmcCommConstants.MisconductHandleStatus.HANDLING);
        }
        smPO.setOrgId(null);
        smPO.setOrgName(null);
        this.supplierMisconductMapper.updateByPrimaryKeySelective(smPO);
        smnPO.setCreateId(reqBO.getUserId());
        smnPO.setCreateName(reqBO.getUserName());
        smnPO.setCreateTime(new Date());
        smnPO.setNoticeId(Long.valueOf(Sequence.getInstance().nextId()));
        smnPO.setTemplateId(reqBO.getTemplateId());
        smnPO.setMisconductId(reqBO.getMisconductId());
        smnPO.setNoticeStatus(UmcCommConstants.DicDelFlag.YES);
        smnPO.setSupplierName(supplierMisconductPO.getSupplierName());
        this.supplierMisconductNoticeMapper.insert(smnPO);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void sendUmcSysMailSend(UmcSupMisconductHandleBusiReqBO reqBO, Long supplierId, String handleResultDesc) {
    }
}

