/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.repository.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.cfc.ability.api.CfcDisposalTimeQueryBySupIdAndCompanyIdAbilityService;
import com.tydic.cfc.ability.bo.CfcDisposalTimeQueryBySupIdAndCompanyIdAbilityReqBO;
import com.tydic.cfc.ability.bo.CfcDisposalTimeQueryBySupIdAndCompanyIdAbilityRspBO;
import com.tydic.cfc.ability.bo.CfcDisposalTimeQueryBySupIdAndCompanyIdBO;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.constants.UmcConstant;
import com.tydic.dyc.umc.constants.UmcEnumConstant;
import com.tydic.dyc.umc.model.punish.UmcSupPunishInfoAddBusiService;
import com.tydic.dyc.umc.model.punish.bo.UmcSupPunishInfoAddAbilityReqBO;
import com.tydic.dyc.umc.model.punish.bo.UmcSupPunishInfoAddAbilityRspBO;
import com.tydic.dyc.umc.repository.dao.SupPunishDetailMapper;
import com.tydic.dyc.umc.repository.dao.SupPunishMapper;
import com.tydic.dyc.umc.repository.dao.UmcAccessoryMapper;
import com.tydic.dyc.umc.repository.po.SupPunishDetailPO;
import com.tydic.dyc.umc.repository.po.SupPunishPO;
import com.tydic.dyc.umc.repository.po.UmcAccessoryPO;
import com.tydic.dyc.umc.service.supplieraccess.bo.AnnoxBO;
import com.tydic.dyc.umc.utils.IdUtil;
import com.tydic.plugin.encoded.service.CfcEncodedSerialGetService;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialGetServiceReqBO;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialGetServiceRspBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UmcSupPunishInfoAddBusiServiceImpl
implements UmcSupPunishInfoAddBusiService {
    private static final Logger log = LoggerFactory.getLogger(UmcSupPunishInfoAddBusiServiceImpl.class);
    @Autowired
    private SupPunishMapper supPunishMapper;
    @Autowired
    private SupPunishDetailMapper supPunishDetailMapper;
    @Autowired
    private UmcAccessoryMapper umcAccessoryMapper;
    @Autowired
    private CfcEncodedSerialGetService encodedSerialGetService;
    @Autowired
    private CfcDisposalTimeQueryBySupIdAndCompanyIdAbilityService cfcDisposalTimeQueryBySupIdAndCompanyIdAbilityService;

    @Override
    public UmcSupPunishInfoAddAbilityRspBO addSupPunishInfo(UmcSupPunishInfoAddAbilityReqBO reqBO) {
        CfcEncodedSerialGetServiceReqBO encodedSerialGetServiceReqBO = new CfcEncodedSerialGetServiceReqBO();
        encodedSerialGetServiceReqBO.setCenter("UMC");
        encodedSerialGetServiceReqBO.setEncodedRuleCode(UmcEnumConstant.PunishCodeRuleEnum.getInstance((Integer)reqBO.getPunishType()).getName());
        encodedSerialGetServiceReqBO.setRelType("org");
        encodedSerialGetServiceReqBO.setExtendFlag("1");
        log.debug("\u83b7\u53d6\u5904\u7f6e\u5355\u7f16\u7801\u914d\u7f6e\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)encodedSerialGetServiceReqBO));
        CfcEncodedSerialGetServiceRspBO encodedSerial = this.encodedSerialGetService.getEncodedSerial(encodedSerialGetServiceReqBO);
        log.debug("\u83b7\u53d6\u5904\u7f6e\u5355\u7f16\u7801\u914d\u7f6e\u51fa\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)encodedSerial));
        String punishCode = (String)encodedSerial.getSerialNoList().get(0);
        if ("1".equals(reqBO.getSource())) {
            List returnList = null;
            if (UmcConstant.PunishType.DISABLE.equals(reqBO.getPunishType()) || UmcConstant.PunishType.BLACKLIST.equals(reqBO.getPunishType())) {
                CfcDisposalTimeQueryBySupIdAndCompanyIdAbilityReqBO disposalTimeQueryReqBO = new CfcDisposalTimeQueryBySupIdAndCompanyIdAbilityReqBO();
                ArrayList<CfcDisposalTimeQueryBySupIdAndCompanyIdBO> queryList = new ArrayList<CfcDisposalTimeQueryBySupIdAndCompanyIdBO>();
                CfcDisposalTimeQueryBySupIdAndCompanyIdBO queryBO = new CfcDisposalTimeQueryBySupIdAndCompanyIdBO();
                queryBO.setSupId(reqBO.getSupplierId());
                queryBO.setPurchaseCompanyId(reqBO.getBusinessunitId());
                queryBO.setDisposalType(reqBO.getPunishType().toString());
                queryList.add(queryBO);
                disposalTimeQueryReqBO.setQueryList(queryList);
                log.debug("\u67e5\u8be2\u65f6\u9650\u914d\u7f6e\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)disposalTimeQueryReqBO));
                CfcDisposalTimeQueryBySupIdAndCompanyIdAbilityRspBO disposalTimeQueryRspBO = this.cfcDisposalTimeQueryBySupIdAndCompanyIdAbilityService.queryDisposalTimeQueryBySupIdAndCompanyId(disposalTimeQueryReqBO);
                if (!"0000".equals(disposalTimeQueryRspBO.getRespCode())) {
                    throw new BaseBusinessException("8888", "\u67e5\u8be2\u65f6\u9650\u914d\u7f6e\u5931\u8d25\uff1a" + disposalTimeQueryRspBO.getRespDesc());
                }
                log.debug("\u67e5\u8be2\u65f6\u9650\u914d\u7f6e\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)disposalTimeQueryRspBO));
                returnList = disposalTimeQueryRspBO.getReturnList();
                if (!CollectionUtils.isEmpty((Collection)returnList)) {
                    reqBO.setExpirationType(Integer.valueOf(((CfcDisposalTimeQueryBySupIdAndCompanyIdBO)returnList.get(0)).getUnit()));
                    reqBO.setExpiration(Integer.valueOf(((CfcDisposalTimeQueryBySupIdAndCompanyIdBO)returnList.get(0)).getNumericalValue()));
                }
            }
        }
        SupPunishPO supPunishPO = new SupPunishPO();
        BeanUtils.copyProperties((Object)((Object)reqBO), (Object)supPunishPO);
        if (reqBO.getOperType() == 1) {
            supPunishPO.setPunishStatus(UmcConstant.PunishStatus.WAIT_APPROVE);
        } else {
            supPunishPO.setPunishStatus(UmcConstant.PunishStatus.DRAFT);
        }
        supPunishPO.setPunishNo(punishCode);
        supPunishPO.setCreateTime(new Date());
        supPunishPO.setPunishId(Long.valueOf(Sequence.getInstance().nextId()));
        supPunishPO.setExtCloumns2(reqBO.getApprovalTempId());
        this.supPunishMapper.insert(supPunishPO);
        if (!StringUtils.isEmpty((CharSequence)reqBO.getPunishExplanation())) {
            SupPunishDetailPO detailPO = new SupPunishDetailPO();
            detailPO.setPunishId(supPunishPO.getPunishId());
            detailPO.setPunishExplanation(reqBO.getPunishExplanation());
            this.supPunishDetailMapper.insert(detailPO);
        }
        ArrayList<UmcAccessoryPO> umcAccessoryPOList = new ArrayList<UmcAccessoryPO>();
        if (!CollectionUtils.isEmpty(reqBO.getAnnoxBOList())) {
            for (AnnoxBO annoxBO : reqBO.getAnnoxBOList()) {
                UmcAccessoryPO umcAccessory = new UmcAccessoryPO();
                umcAccessory.setId(Long.valueOf(IdUtil.nextId()));
                umcAccessory.setObjId(supPunishPO.getPunishId());
                umcAccessory.setObjType("22");
                umcAccessory.setAttachmentType("PUNISH_FILE");
                umcAccessory.setTenantId(Long.valueOf(10000L));
                umcAccessory.setAccessoryName(annoxBO.getName());
                umcAccessory.setAccessoryUrl(annoxBO.getPath());
                umcAccessory.setCreateTime(new Date());
                umcAccessory.setCreateOperId(reqBO.getUserId().toString());
                umcAccessoryPOList.add(umcAccessory);
            }
        }
        if (!CollectionUtils.isEmpty(umcAccessoryPOList)) {
            this.umcAccessoryMapper.insertBatch(umcAccessoryPOList);
        }
        UmcSupPunishInfoAddAbilityRspBO rspBO = new UmcSupPunishInfoAddAbilityRspBO();
        rspBO.setPunishId(supPunishPO.getPunishId());
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

