/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.addr;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.dyc.umc.repository.dao.AddrCityMapper;
import com.tydic.dyc.umc.repository.dao.AddrProvinceMapper;
import com.tydic.dyc.umc.repository.po.AddrCityPo;
import com.tydic.dyc.umc.repository.po.AddrProvincePo;
import com.tydic.dyc.umc.service.addr.bo.DycUmcAddrBO;
import com.tydic.dyc.umc.service.addr.bo.DycUmcAddrCitySearchReqBO;
import com.tydic.dyc.umc.service.addr.bo.DycUmcAddrCitySearchRspBO;
import com.tydic.dyc.umc.service.addr.service.DycUmcAddrCitySearchService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.umc.service.addr.service.DycUmcAddrCitySearchService"})
public class DycUmcAddrCitySearchServiceImpl
implements DycUmcAddrCitySearchService {
    private static final Logger log = LoggerFactory.getLogger(DycUmcAddrCitySearchServiceImpl.class);
    @Autowired
    private AddrProvinceMapper addrProvinceMapper;
    @Autowired
    private AddrCityMapper cityMapper;

    @PostMapping(value={"qryAddrCitySearch"})
    public DycUmcAddrCitySearchRspBO qryAddrCitySearch(@RequestBody DycUmcAddrCitySearchReqBO reqBO) {
        DycUmcAddrCitySearchRspBO citySearchRspBO = new DycUmcAddrCitySearchRspBO();
        citySearchRspBO.setRespCode("0000");
        AddrProvincePo addrProvincePo = new AddrProvincePo();
        addrProvincePo.setName(reqBO.getName());
        List addrProvincePoList = this.addrProvinceMapper.getList(addrProvincePo);
        if (!CollectionUtils.isEmpty((Collection)addrProvincePoList)) {
            ArrayList<DycUmcAddrBO> rows = new ArrayList<DycUmcAddrBO>();
            for (AddrProvincePo po : addrProvincePoList) {
                DycUmcAddrBO bo = new DycUmcAddrBO();
                bo.setCode(po.getCode());
                bo.setName(po.getName());
                rows.add(bo);
            }
            AddrCityPo cityPo = new AddrCityPo();
            List addrCityPoList = this.cityMapper.getList(cityPo);
            if (!CollectionUtils.isEmpty((Collection)addrCityPoList)) {
                Map<String, List<AddrCityPo>> groupByProvince = addrCityPoList.stream().collect(Collectors.groupingBy(AddrCityPo::getProvinceCode));
                for (DycUmcAddrBO each : rows) {
                    if (!groupByProvince.containsKey(each.getCode())) continue;
                    List childs = JSONObject.parseArray((String)JSON.toJSONString(groupByProvince.get(each.getCode())), DycUmcAddrBO.class);
                    each.setChilds(childs);
                }
            }
            citySearchRspBO.setRows(rows);
        }
        return citySearchRspBO;
    }

    private List<DycUmcAddrBO> serachName(List<DycUmcAddrBO> rows, String searchName) {
        ArrayList<DycUmcAddrBO> returnBoList = new ArrayList<DycUmcAddrBO>();
        for (DycUmcAddrBO each : rows) {
            if (!CollectionUtils.isEmpty((Collection)each.getChilds())) {
                List<Object> childList = new ArrayList();
                childList = this.serachName(each.getChilds(), searchName);
                if (!CollectionUtils.isEmpty(childList)) {
                    each.setChilds(childList);
                    returnBoList.add(each);
                    continue;
                }
                if (!each.getName().contains(searchName)) continue;
                returnBoList.add(each);
                continue;
            }
            if (!each.getName().contains(searchName)) continue;
            returnBoList.add(each);
        }
        return returnBoList;
    }
}

