/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.correction;

import cn.hutool.core.util.ObjectUtil;
import com.ohaotian.plugin.db.Page;
import com.tydic.dyc.umc.repository.dao.SupCorrectionMapper;
import com.tydic.dyc.umc.repository.po.SupCorrectionPO;
import com.tydic.dyc.umc.service.correction.bo.UmcQuerySupCorrectionApprovalPageListReqBO;
import com.tydic.dyc.umc.service.correction.bo.UmcQuerySupCorrectionApprovalPageListRspBO;
import com.tydic.dyc.umc.service.correction.bo.UmcSupCorrectionBO;
import com.tydic.dyc.umc.service.correction.service.UmcQuerySupCorrectionApprovalPageListService;
import com.tydic.dyc.umc.service.enterprise.DictionaryBusiService;
import com.tydic.dyc.umc.service.inspectionapproval.bo.SupInspectionApprovalCountBO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.umc.service.correction.service.UmcQuerySupCorrectionApprovalPageListService"})
public class UmcQuerySupCorrectionApprovalPageListServiceImpl
implements UmcQuerySupCorrectionApprovalPageListService {
    private static final Logger log = LoggerFactory.getLogger(UmcQuerySupCorrectionApprovalPageListServiceImpl.class);
    @Autowired
    private SupCorrectionMapper supCorrectionMapper;
    @Value(value="${manager_users:1}")
    private String managerUsers;
    @Autowired
    private DictionaryBusiService dictionaryBusiService;

    @PostMapping(value={"querySupCorrectionApprovalPageList"})
    public UmcQuerySupCorrectionApprovalPageListRspBO querySupCorrectionApprovalPageList(@RequestBody UmcQuerySupCorrectionApprovalPageListReqBO reqBO) {
        UmcQuerySupCorrectionApprovalPageListRspBO rspBO = new UmcQuerySupCorrectionApprovalPageListRspBO();
        ArrayList<UmcSupCorrectionBO> rows = new ArrayList<UmcSupCorrectionBO>();
        Page page = new Page(reqBO.getPageNo(), reqBO.getPageSize());
        SupCorrectionPO selectPO = new SupCorrectionPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)selectPO);
        selectPO.setCompanyId(null);
        selectPO.setCompanyName("");
        List<String> managerUserList = Arrays.asList(this.managerUsers.split(","));
        if (managerUserList.contains(reqBO.getUserId().toString())) {
            selectPO.setUserId(null);
        }
        selectPO.setOrderBy("sc.create_date desc");
        List supCorrectionPOList = this.supCorrectionMapper.getApprovalListPage(selectPO, page);
        List<SupInspectionApprovalCountBO> countBOList = this.countTab(reqBO);
        rspBO.setCountBOList(countBOList);
        rspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        rspBO.setTotal(Integer.valueOf(page.getTotalPages()));
        if (!ObjectUtil.isEmpty((Object)supCorrectionPOList)) {
            Map correctionMap = this.dictionaryBusiService.queryBypCodeBackMap("UMC_PLUS", "CORRECTION_TYPE");
            Map operStatusMap = this.dictionaryBusiService.queryBypCodeBackMap("UMC_PLUS", "CORRECTION_STATUS_OPERATION");
            Map supStatusMap = this.dictionaryBusiService.queryBypCodeBackMap("UMC_PLUS", "CORRECTION_STATUS_SUP");
            Map auditStatusMap = this.dictionaryBusiService.queryBypCodeBackMap("UMC_PLUS", "UMC_AUDIT_STATUS_NEW");
            Map statusMap = this.dictionaryBusiService.queryBypCodeBackMap("UMC_PLUS", "CORRECTION_STATUS");
            Map punishOpinionMap = this.dictionaryBusiService.queryBypCodeBackMap("UMC_PLUS", "PUNISH_TYPE");
            for (SupCorrectionPO item : supCorrectionPOList) {
                UmcSupCorrectionBO bo = new UmcSupCorrectionBO();
                BeanUtils.copyProperties((Object)item, (Object)bo);
                if (!ObjectUtil.isEmpty((Object)bo.getCorrectionType())) {
                    bo.setCorrectionTypeStr(correctionMap.getOrDefault(bo.getCorrectionType(), ""));
                }
                if (!ObjectUtil.isEmpty((Object)bo.getSupStatus())) {
                    bo.setSupStatusStr(statusMap.getOrDefault(bo.getSupStatus(), ""));
                }
                if (!ObjectUtil.isEmpty((Object)bo.getOperationStatus())) {
                    bo.setOperationStatusStr(statusMap.getOrDefault(bo.getOperationStatus(), ""));
                }
                if (!ObjectUtil.isEmpty((Object)bo.getPunishOpinion())) {
                    bo.setPunishOpinionStr(punishOpinionMap.getOrDefault(bo.getPunishOpinion(), ""));
                }
                if (!ObjectUtil.isEmpty((Object)bo.getApprovalStatus())) {
                    bo.setApprovalStatusStr(bo.getApprovalStatus().equals("0") ? "\u5f85\u5ba1\u6279" : (bo.getApprovalStatus().equals("1") ? "\u901a\u8fc7" : "\u9a73\u56de"));
                }
                bo.setAuditStatusStr(StringUtils.isBlank((CharSequence)bo.getAuditStatus()) ? "\u5f85\u5ba1\u6279" : (String)auditStatusMap.get(bo.getAuditStatus()));
                rows.add(bo);
            }
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setRows(rows);
        rspBO.setPageNo(Integer.valueOf(page.getPageNo()));
        rspBO.setTotal(Integer.valueOf(page.getTotalCount()));
        rspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        return rspBO;
    }

    private List<SupInspectionApprovalCountBO> countTab(UmcQuerySupCorrectionApprovalPageListReqBO busiReqBO) {
        ArrayList<SupInspectionApprovalCountBO> approvalCountBOS = new ArrayList<SupInspectionApprovalCountBO>();
        UmcQuerySupCorrectionApprovalPageListReqBO busiBO = new UmcQuerySupCorrectionApprovalPageListReqBO();
        busiBO.setUserId(busiReqBO.getUserId());
        busiBO.setTabId(Integer.valueOf(0));
        Integer waitCount = this.supCorrectionMapper.selectAPPROListCount(busiBO);
        SupInspectionApprovalCountBO waitCountBO = new SupInspectionApprovalCountBO();
        waitCountBO.setTabId(Integer.valueOf(0));
        waitCountBO.setTabNum(waitCount);
        waitCountBO.setTabName("\u5f85\u5ba1\u6279");
        approvalCountBOS.add(waitCountBO);
        busiBO.setTabId(Integer.valueOf(1));
        Integer passCount = this.supCorrectionMapper.selectAPPROListCount(busiBO);
        SupInspectionApprovalCountBO passCountBO = new SupInspectionApprovalCountBO();
        passCountBO.setTabId(Integer.valueOf(1));
        passCountBO.setTabNum(passCount);
        passCountBO.setTabName("\u5df2\u901a\u8fc7");
        approvalCountBOS.add(passCountBO);
        busiBO.setTabId(Integer.valueOf(2));
        Integer rejectCount = this.supCorrectionMapper.selectAPPROListCount(busiBO);
        SupInspectionApprovalCountBO rejectCountBO = new SupInspectionApprovalCountBO();
        rejectCountBO.setTabId(Integer.valueOf(2));
        rejectCountBO.setTabNum(rejectCount);
        rejectCountBO.setTabName("\u5df2\u9a73\u56de");
        approvalCountBOS.add(rejectCountBO);
        busiBO.setTabId(Integer.valueOf(3));
        Integer allCount = this.supCorrectionMapper.selectAPPROListCount(busiBO);
        SupInspectionApprovalCountBO allCountBO = new SupInspectionApprovalCountBO();
        allCountBO.setTabId(Integer.valueOf(3));
        allCountBO.setTabNum(allCount);
        allCountBO.setTabName("\u5168\u90e8");
        approvalCountBOS.add(allCountBO);
        return approvalCountBOS;
    }
}

