/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.correction;

import cn.hutool.core.util.ObjectUtil;
import com.ohaotian.plugin.db.Page;
import com.tydic.dyc.umc.repository.dao.SupCorrectionMapper;
import com.tydic.dyc.umc.repository.po.SupCorrectionPO;
import com.tydic.dyc.umc.service.correction.bo.UmcQuerySupCorrectionPageListReqBO;
import com.tydic.dyc.umc.service.correction.bo.UmcQuerySupCorrectionPageListRspBO;
import com.tydic.dyc.umc.service.correction.bo.UmcSupCorrectionBO;
import com.tydic.dyc.umc.service.correction.service.UmcQuerySupCorrectionPageListService;
import com.tydic.dyc.umc.service.enterprise.DictionaryBusiService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.umc.service.correction.service.UmcQuerySupCorrectionPageListService"})
public class UmcQuerySupCorrectionPageListServiceImpl
implements UmcQuerySupCorrectionPageListService {
    private static final Logger log = LoggerFactory.getLogger(UmcQuerySupCorrectionPageListServiceImpl.class);
    @Autowired
    private SupCorrectionMapper supCorrectionMapper;
    @Autowired
    private DictionaryBusiService dictionaryBusiService;
    @Value(value="${manager_users:1}")
    private String managerUsers;

    @PostMapping(value={"querySupCorrectionPageList"})
    public UmcQuerySupCorrectionPageListRspBO querySupCorrectionPageList(@RequestBody UmcQuerySupCorrectionPageListReqBO reqBO) {
        UmcQuerySupCorrectionPageListRspBO rspBO = new UmcQuerySupCorrectionPageListRspBO();
        ArrayList<UmcSupCorrectionBO> rows = new ArrayList<UmcSupCorrectionBO>();
        Page page = new Page(reqBO.getPageNo(), reqBO.getPageSize());
        SupCorrectionPO selectPO = new SupCorrectionPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)selectPO);
        selectPO.setCompanyName("");
        selectPO.setCompanyId(null);
        List<String> managerUserList = Arrays.asList(this.managerUsers.split(","));
        if (reqBO.getMenuCode().equals("improvementNoticeSupQueryList") || reqBO.getMenuCode().equals("improvementNoticeSupList ")) {
            selectPO.setSupplierId(reqBO.getSupId());
        } else if (reqBO.getMenuCode().equals("improvementNoticeOperaQueryList") || managerUserList.contains(reqBO.getUserId().toString())) {
            // empty if block
        }
        selectPO.setOrderBy("create_date desc");
        List supCorrectionPOList = this.supCorrectionMapper.getListPage(selectPO, page);
        if (!ObjectUtil.isEmpty((Object)supCorrectionPOList)) {
            Map correctionMap = this.dictionaryBusiService.queryBypCodeBackMap("UMC_PLUS", "CORRECTION_TYPE");
            Map operStatusMap = this.dictionaryBusiService.queryBypCodeBackMap("UMC_PLUS", "CORRECTION_STATUS_OPERATION");
            Map supStatusMap = this.dictionaryBusiService.queryBypCodeBackMap("UMC_PLUS", "CORRECTION_STATUS_SUP");
            Map statusMap = this.dictionaryBusiService.queryBypCodeBackMap("UMC_PLUS", "CORRECTION_STATUS");
            Map punishOpinionMap = this.dictionaryBusiService.queryBypCodeBackMap("UMC_PLUS", "PUNISH_TYPE");
            for (SupCorrectionPO item : supCorrectionPOList) {
                UmcSupCorrectionBO bo = new UmcSupCorrectionBO();
                BeanUtils.copyProperties((Object)item, (Object)bo);
                if (!ObjectUtil.isEmpty((Object)bo.getCorrectionType())) {
                    bo.setCorrectionTypeStr(correctionMap.getOrDefault(bo.getCorrectionType(), ""));
                }
                if (!ObjectUtil.isEmpty((Object)bo.getSupStatus())) {
                    bo.setSupStatusStr(statusMap.getOrDefault(bo.getSupStatus(), ""));
                }
                if (!ObjectUtil.isEmpty((Object)bo.getOperationStatus())) {
                    bo.setOperationStatusStr(statusMap.getOrDefault(bo.getOperationStatus(), ""));
                }
                if (!ObjectUtil.isEmpty((Object)bo.getPunishOpinion())) {
                    bo.setPunishOpinionStr(punishOpinionMap.getOrDefault(bo.getPunishOpinion(), ""));
                }
                rows.add(bo);
            }
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setRows(rows);
        rspBO.setPageNo(Integer.valueOf(page.getPageNo()));
        rspBO.setTotal(Integer.valueOf(page.getTotalCount()));
        rspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        return rspBO;
    }
}

