/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.enable;

import cn.hutool.core.util.ObjectUtil;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Page;
import com.tydic.dyc.authority.model.sysdictionary.impl.ISysDictionaryModelImpl;
import com.tydic.dyc.authority.model.sysdictionary.qrybo.SysDictionaryMapBo;
import com.tydic.dyc.authority.model.sysdictionary.qrybo.SysDictionaryQryBo;
import com.tydic.dyc.umc.repository.dao.UmcPresenterApproverMapper;
import com.tydic.dyc.umc.repository.po.UmcPresenterApproverPO;
import com.tydic.dyc.umc.service.enable.UmcGetPresenterApproverService;
import com.tydic.dyc.umc.service.enable.bo.UmcGetPresenterApproverServiceReqBo;
import com.tydic.dyc.umc.service.enable.bo.UmcGetPresenterApproverServiceRspBo;
import com.tydic.dyc.umc.service.enable.bo.UmcPresenterApproverBo;
import com.tydic.dyc.umc.utils.UmcRu;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.umc.service.enable.UmcGetPresenterApproverService"})
public class UmcGetPresenterApproverServiceImpl
implements UmcGetPresenterApproverService {
    private static final Logger log = LoggerFactory.getLogger(UmcGetPresenterApproverServiceImpl.class);
    @Autowired
    private UmcPresenterApproverMapper umcPresenterApproverMapper;
    @Autowired
    private ISysDictionaryModelImpl iSysDictionaryModel;
    @Value(value="${manager_users}")
    private String managerUsers;

    @PostMapping(value={"getApprover"})
    public UmcGetPresenterApproverServiceRspBo getApprover(@RequestBody UmcGetPresenterApproverServiceReqBo reqBo) {
        UmcGetPresenterApproverServiceRspBo rspBo = (UmcGetPresenterApproverServiceRspBo)UmcRu.success(UmcGetPresenterApproverServiceRspBo.class);
        UmcPresenterApproverPO umcPresenterApproverPO = (UmcPresenterApproverPO)UmcRu.js((Object)reqBo, UmcPresenterApproverPO.class);
        List<String> manager = Arrays.asList(this.managerUsers.split(","));
        if (!CollectionUtils.isEmpty(manager) && manager.contains(reqBo.getUserIdIn().toString())) {
            umcPresenterApproverPO.setPresenterId(null);
        }
        Page page = new Page();
        page.setPageNo(UmcRu.parseInteger((Object)reqBo.getPageNo()).intValue());
        page.setPageSize(UmcRu.parseInteger((Object)reqBo.getPageSize()).intValue());
        List list = this.umcPresenterApproverMapper.getListPage(umcPresenterApproverPO, page);
        if (list != null && list.size() > 0) {
            Map<String, Map<String, String>> dicMap = this.getDic();
            list.forEach(item -> item.setStatusStr((String)((Map)dicMap.get("ENABLE_APPROVER_STATUS")).get(item.getStatus())));
            rspBo.setRows(UmcRu.jsl((List)list, UmcPresenterApproverBo.class));
            rspBo.setTotal(page.getTotalPages());
            rspBo.setRecordsTotal(page.getTotalCount());
            List existList = this.umcPresenterApproverMapper.getList(umcPresenterApproverPO);
            rspBo.setExcludedUserIdList(existList.stream().filter(e -> e.getApproverId() != null).map(UmcPresenterApproverPO::getApproverId).collect(Collectors.toList()));
        }
        return rspBo;
    }

    private Map<String, Map<String, String>> getDic() {
        ArrayList<String> pCodes = new ArrayList<String>();
        pCodes.add("ENABLE_APPROVER_STATUS");
        SysDictionaryQryBo sysDictionaryQryBo = new SysDictionaryQryBo();
        sysDictionaryQryBo.setPCodes(pCodes);
        SysDictionaryMapBo sysDictionaryMapBo = this.iSysDictionaryModel.getDictionaryMap(sysDictionaryQryBo);
        if (ObjectUtil.isNotEmpty((Object)sysDictionaryMapBo)) {
            return sysDictionaryMapBo.getDictionaryMap();
        }
        throw new ZTBusinessException("\u67e5\u8be2\u5b57\u5178\u5931\u8d25");
    }
}

