/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.enable;

import cn.hutool.core.util.ObjectUtil;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.umc.repository.dao.UmcEnableInspectionRelMapper;
import com.tydic.dyc.umc.repository.dao.UmcSupplierEnableInfoMapper;
import com.tydic.dyc.umc.repository.po.UmcEnableInspectionRelPO;
import com.tydic.dyc.umc.repository.po.UmcSupplierEnableInfoPO;
import com.tydic.dyc.umc.service.enable.UmcSupCreateEnableInspRelService;
import com.tydic.dyc.umc.service.enable.bo.UmcSupCreateEnableInspRelServiceReqBo;
import com.tydic.dyc.umc.service.enable.bo.UmcSupCreateEnableInspRelServiceRspBo;
import com.tydic.dyc.umc.utils.IdUtil;
import com.tydic.dyc.umc.utils.UmcRu;
import com.tydic.plugin.encoded.service.CfcEncodedSerialGetService;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialGetServiceReqBO;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialServiceRspBO;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.umc.service.enable.UmcSupCreateEnableInspRelService"})
public class UmcSupCreateEnableInspRelServiceImpl
implements UmcSupCreateEnableInspRelService {
    private static final Logger log = LoggerFactory.getLogger(UmcSupCreateEnableInspRelServiceImpl.class);
    @Autowired
    private UmcSupplierEnableInfoMapper umcSupplierEnableInfoMapper;
    @Autowired
    private UmcEnableInspectionRelMapper umcEnableInspectionRelMapper;
    @Autowired
    private CfcEncodedSerialGetService cfcEncodedSerialGetService;

    @PostMapping(value={"createEnableInspRel"})
    public UmcSupCreateEnableInspRelServiceRspBo createEnableInspRel(@RequestBody UmcSupCreateEnableInspRelServiceReqBo reqBo) {
        log.info("UmcSupCreateEnableInspRelServiceImpl.createEnableInspRel reqBo:{}", (Object)reqBo);
        UmcSupCreateEnableInspRelServiceImpl.validateParams(reqBo);
        UmcSupplierEnableInfoPO enableOrder = this.insertEnableOrder(reqBo);
        Long enableInspRelId = this.inserEnbaleInspRel(reqBo, enableOrder.getId());
        UmcSupCreateEnableInspRelServiceRspBo rspBo = (UmcSupCreateEnableInspRelServiceRspBo)UmcRu.success(UmcSupCreateEnableInspRelServiceRspBo.class);
        rspBo.setEnableId(enableOrder.getId());
        rspBo.setEnableNo(enableOrder.getSupEnableNo());
        rspBo.setEnableInspRelId(enableInspRelId);
        return rspBo;
    }

    private Long inserEnbaleInspRel(UmcSupCreateEnableInspRelServiceReqBo reqBo, Long enableId) {
        this.delExistUmcEnableInspectionRel(enableId, reqBo.getGoodsCategory());
        UmcEnableInspectionRelPO umcEnableInspectionRelPO = new UmcEnableInspectionRelPO();
        umcEnableInspectionRelPO.setId(Long.valueOf(IdUtil.nextId()));
        umcEnableInspectionRelPO.setInspectionCode(reqBo.getInspNo());
        umcEnableInspectionRelPO.setInspectionId(reqBo.getInspId());
        umcEnableInspectionRelPO.setSupEnableInfoId(enableId);
        umcEnableInspectionRelPO.setCreateOperId(reqBo.getUserId());
        umcEnableInspectionRelPO.setCreateOperName(reqBo.getUserName());
        umcEnableInspectionRelPO.setCreateTime(new Date());
        umcEnableInspectionRelPO.setGoodsCategory(reqBo.getGoodsCategory());
        this.umcEnableInspectionRelMapper.insert(umcEnableInspectionRelPO);
        return umcEnableInspectionRelPO.getId();
    }

    private void delExistUmcEnableInspectionRel(Long enableId, String goodsCategory) {
        UmcEnableInspectionRelPO umcEnableInspectionRelPO = new UmcEnableInspectionRelPO();
        umcEnableInspectionRelPO.setSupEnableInfoId(enableId);
        umcEnableInspectionRelPO.setGoodsCategory(goodsCategory);
        umcEnableInspectionRelPO = this.umcEnableInspectionRelMapper.getModelBy(umcEnableInspectionRelPO);
        if (ObjectUtil.isNotEmpty((Object)umcEnableInspectionRelPO)) {
            this.umcEnableInspectionRelMapper.deleteBy(umcEnableInspectionRelPO);
        }
    }

    private UmcSupplierEnableInfoPO insertEnableOrder(UmcSupCreateEnableInspRelServiceReqBo reqBo) {
        UmcSupplierEnableInfoPO umcSupplierEnableInfoPO = new UmcSupplierEnableInfoPO();
        if (reqBo.getSupEnableId() != null) {
            umcSupplierEnableInfoPO.setId(reqBo.getSupEnableId());
        } else {
            umcSupplierEnableInfoPO.setTenantCode(reqBo.getTenantCode());
            umcSupplierEnableInfoPO.setSupId(reqBo.getSupId());
        }
        UmcSupplierEnableInfoPO umcSupplierEnableInfoMapperModelBy = this.umcSupplierEnableInfoMapper.getModelBy(umcSupplierEnableInfoPO);
        if (ObjectUtil.isNotEmpty((Object)umcSupplierEnableInfoMapperModelBy)) {
            return umcSupplierEnableInfoMapperModelBy;
        }
        umcSupplierEnableInfoPO.setId(Long.valueOf(IdUtil.nextId()));
        umcSupplierEnableInfoPO.setSupEnableNo(this.getEnableNo());
        umcSupplierEnableInfoPO.setTenantCode(reqBo.getTenantCode());
        umcSupplierEnableInfoPO.setTenantName(reqBo.getTenantName());
        umcSupplierEnableInfoPO.setSupCode(reqBo.getSupId().toString());
        umcSupplierEnableInfoPO.setSupName(reqBo.getSupName());
        umcSupplierEnableInfoPO.setCreateOperId(reqBo.getUserId());
        umcSupplierEnableInfoPO.setCreateOperName(reqBo.getUserName());
        umcSupplierEnableInfoPO.setCreateTime(new Date());
        umcSupplierEnableInfoPO.setEnableStatus("CAO_GAO");
        umcSupplierEnableInfoPO.setSupplierStatus("DAI_RU_KU");
        this.umcSupplierEnableInfoMapper.insert(umcSupplierEnableInfoPO);
        return umcSupplierEnableInfoPO;
    }

    private String getEnableNo() {
        CfcEncodedSerialGetServiceReqBO cfcEncodedSerialGetServiceReqBO = new CfcEncodedSerialGetServiceReqBO();
        cfcEncodedSerialGetServiceReqBO.setCenter("UMC");
        cfcEncodedSerialGetServiceReqBO.setEncodedRuleCode("SUP_ENABLE_ORDER_NO");
        cfcEncodedSerialGetServiceReqBO.setNum(Integer.valueOf(1));
        cfcEncodedSerialGetServiceReqBO.setOrgType("-1");
        CfcEncodedSerialServiceRspBO cfcEncodedSerialServiceRspBO = this.cfcEncodedSerialGetService.getSerialSimper(cfcEncodedSerialGetServiceReqBO);
        String enablNo = (String)cfcEncodedSerialServiceRspBO.getSerialNoList().get(0);
        return enablNo;
    }

    private static void validateParams(UmcSupCreateEnableInspRelServiceReqBo reqBo) {
        if (ObjectUtil.isEmpty((Object)reqBo)) {
            throw new ZTBusinessException("\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getSupEnableId() == null) {
            throw new ZTBusinessException("\u542f\u7528\u5355\u3010supEnableId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getInspNo())) {
            throw new ZTBusinessException("\u8003\u5bdf\u5355\u53f7\u3010inspNo\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getUserId())) {
            throw new ZTBusinessException("\u7528\u6237id\u3010userId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getUserName())) {
            throw new ZTBusinessException("\u7528\u6237\u540d\u3010userName\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getGoodsCategory())) {
            throw new ZTBusinessException("\u4f7f\u7528\u5546\u54c1\u7c7b\u578b\u3010goodsCategory\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

