/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.inspection;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Page;
import com.tydic.dyc.authority.model.sysdictionary.impl.ISysDictionaryModelImpl;
import com.tydic.dyc.authority.model.sysdictionary.qrybo.SysDictionaryMapBo;
import com.tydic.dyc.authority.model.sysdictionary.qrybo.SysDictionaryQryBo;
import com.tydic.dyc.umc.constants.SupCommConstants;
import com.tydic.dyc.umc.repository.dao.SupInspectionMapper;
import com.tydic.dyc.umc.repository.dao.UmcSupplierEnableInfoMapper;
import com.tydic.dyc.umc.repository.po.SupInspectionPO;
import com.tydic.dyc.umc.service.inspection.bo.DycSupInspectionBO;
import com.tydic.dyc.umc.service.inspection.bo.DycSupQryInspectionResultAbilityReqBO;
import com.tydic.dyc.umc.service.inspection.bo.DycSupQryInspectionResultAbilityRspBO;
import com.tydic.dyc.umc.service.inspection.service.DycQuerySupInspectionResultPageListAbilityService;
import com.tydic.dyc.umc.service.level.bo.UmcSupplierLevelConfigSetDetailQueryReqBo;
import com.tydic.dyc.umc.service.level.bo.UmcSupplierLevelConfigSetDetailQueryRspBo;
import com.tydic.dyc.umc.service.level.service.UmcSupplierLevelConfigSetDetailQueryService;
import com.tydic.dyc.umc.service.rresults.bo.AssessmentLevelSetBO;
import com.tydic.dyc.umc.utils.UmcRu;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.umc.service.inspection.service.DycQuerySupInspectionResultPageListAbilityService"})
public class DycQuerySupInspectionResultPageListAbilityServiceImpl
implements DycQuerySupInspectionResultPageListAbilityService {
    private static final Logger log = LoggerFactory.getLogger(DycQuerySupInspectionResultPageListAbilityServiceImpl.class);
    @Autowired
    private SupInspectionMapper supInspectionMapper;
    @Autowired
    private ISysDictionaryModelImpl iSysDictionaryModel;
    @Autowired
    private UmcSupplierEnableInfoMapper enableInfoMapper;
    @Autowired
    private UmcSupplierLevelConfigSetDetailQueryService umcSupplierLevelConfigSetDetailQueryService;

    @PostMapping(value={"querySupInspectionPageList"})
    public DycSupQryInspectionResultAbilityRspBO querySupInspectionPageList(@RequestBody DycSupQryInspectionResultAbilityReqBO reqBO) {
        LocalDate lastDayOfLastYear;
        LocalDate today;
        DycSupQryInspectionResultAbilityRspBO rspBO = (DycSupQryInspectionResultAbilityRspBO)UmcRu.success(DycSupQryInspectionResultAbilityRspBO.class);
        Map<String, String> measureMap = this.getMeasureMap(reqBO);
        SupInspectionPO supinspectionpo = (SupInspectionPO)UmcRu.js((Object)reqBO, SupInspectionPO.class);
        Page page = new Page();
        page.setPageNo(UmcRu.parseInteger((Object)reqBO.getPageNo()).intValue());
        page.setPageSize(UmcRu.parseInteger((Object)reqBO.getPageSize()).intValue());
        List inspResultPage = new ArrayList();
        supinspectionpo.setOrgId(reqBO.getCompanyId());
        if ("1000".equals(reqBO.getTabId())) {
            supinspectionpo.setScoringType(Integer.valueOf(5));
            supinspectionpo.setInspectionCycleType(Integer.valueOf(3));
            inspResultPage = this.supInspectionMapper.getInspResultPage(supinspectionpo, page);
        } else if ("1001".equals(reqBO.getTabId())) {
            supinspectionpo.setInspectionType(Integer.valueOf(1));
            supinspectionpo.setInspectionCycleType(Integer.valueOf(1));
            today = LocalDate.now();
            lastDayOfLastYear = today.minusYears(1L).with(TemporalAdjusters.lastDayOfYear());
            supinspectionpo.setInspectionDateStart(Date.from(lastDayOfLastYear.atStartOfDay(ZoneId.systemDefault()).toInstant()));
            supinspectionpo.setTenantCode(reqBO.getOrgId().toString());
            inspResultPage = this.supInspectionMapper.getMonthHistoryListPage(supinspectionpo, page);
        } else if ("1002".equals(reqBO.getTabId())) {
            supinspectionpo.setInspectionType(Integer.valueOf(1));
            supinspectionpo.setInspectionCycleType(Integer.valueOf(1));
            today = LocalDate.now();
            lastDayOfLastYear = today.minusYears(1L).with(TemporalAdjusters.lastDayOfYear());
            supinspectionpo.setInspectionDateEnd(Date.from(lastDayOfLastYear.atStartOfDay(ZoneId.systemDefault()).toInstant()));
            supinspectionpo.setTenantCode(reqBO.getOrgId().toString());
            inspResultPage = this.supInspectionMapper.getMonthHistoryListPage(supinspectionpo, page);
        }
        if (inspResultPage != null && inspResultPage.size() > 0) {
            Map<String, Map<String, String>> dicMap = this.getDic();
            rspBO.setRows(UmcRu.jsl(inspResultPage, DycSupInspectionBO.class));
            Map<String, String> supplierTypeMap = dicMap.get("SUPPLIER_TYPE");
            boolean isTab1000 = "1000".equals(reqBO.getTabId());
            for (DycSupInspectionBO item : rspBO.getRows()) {
                String supplierTypeStr = supplierTypeMap != null ? supplierTypeMap.get(item.getSupplierType().toString()) : null;
                item.setSupplierTypeStr(supplierTypeStr);
                if (!isTab1000) continue;
                String punishmentMeasure = measureMap.get(item.getRatingLevel());
                item.setPunishmentMeasures(punishmentMeasure);
            }
            rspBO.setTotal(page.getTotalPages());
            rspBO.setPageNo(page.getPageNo());
            rspBO.setRecordsTotal(page.getTotalCount());
            return rspBO;
        }
        return rspBO;
    }

    private Map<String, String> getMeasureMap(DycSupQryInspectionResultAbilityReqBO reqBO) {
        Map<String, String> measureMap = new HashMap<String, String>();
        UmcSupplierLevelConfigSetDetailQueryReqBo umcSupplierLevelConfigSetDetailQueryReqBo = new UmcSupplierLevelConfigSetDetailQueryReqBo();
        umcSupplierLevelConfigSetDetailQueryReqBo.setApplyScope(SupCommConstants.LevelSetApplyScope.RATING);
        umcSupplierLevelConfigSetDetailQueryReqBo.setBusinessId(reqBO.getOrgId());
        umcSupplierLevelConfigSetDetailQueryReqBo.setRatingDataSources(Integer.valueOf(3));
        umcSupplierLevelConfigSetDetailQueryReqBo.setStatus(SupCommConstants.LevelSetStatus.ENABLE);
        log.info("\u67e5\u8be2\u7b49\u7ea7\u89c4\u5219\u914d\u7f6e\u5165\u53c2={}", (Object)JSON.toJSONString((Object)umcSupplierLevelConfigSetDetailQueryReqBo));
        UmcSupplierLevelConfigSetDetailQueryRspBo umcSupplierLevelConfigSetDetailQueryRspBo = this.umcSupplierLevelConfigSetDetailQueryService.queryLevelConfigSetDetail(umcSupplierLevelConfigSetDetailQueryReqBo);
        log.info("\u67e5\u8be2\u7b49\u7ea7\u89c4\u5219\u914d\u7f6e\u51fa\u53c2={}", (Object)JSON.toJSONString((Object)umcSupplierLevelConfigSetDetailQueryRspBo));
        if (umcSupplierLevelConfigSetDetailQueryRspBo.getRespCode().equals("0000") && ObjectUtil.isNotEmpty((Object)umcSupplierLevelConfigSetDetailQueryRspBo.getAssessmentLevelSetBOS())) {
            List assessmentLevelSetBOS = umcSupplierLevelConfigSetDetailQueryRspBo.getAssessmentLevelSetBOS();
            measureMap = assessmentLevelSetBOS.stream().collect(Collectors.toMap(AssessmentLevelSetBO::getLevelCode, AssessmentLevelSetBO::getMeasures));
        }
        return measureMap;
    }

    private Map<String, Map<String, String>> getDic() {
        ArrayList<String> pCodes = new ArrayList<String>();
        pCodes.add("SUPPLIER_TYPE");
        SysDictionaryQryBo sysDictionaryQryBo = new SysDictionaryQryBo();
        sysDictionaryQryBo.setPCodes(pCodes);
        SysDictionaryMapBo sysDictionaryMapBo = this.iSysDictionaryModel.getDictionaryMap(sysDictionaryQryBo);
        if (ObjectUtil.isNotEmpty((Object)sysDictionaryMapBo)) {
            return sysDictionaryMapBo.getDictionaryMap();
        }
        throw new ZTBusinessException("\u67e5\u8be2\u5b57\u5178\u5931\u8d25");
    }
}

