/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.inspectionscore;

import com.tydic.dyc.umc.repository.dao.SupInspectionMapper;
import com.tydic.dyc.umc.repository.po.SupInspectionPO;
import com.tydic.dyc.umc.service.inspectionscore.bo.DycGetSupInspectionBO;
import com.tydic.dyc.umc.service.inspectionscore.bo.DycGetSupInspectionListReqBO;
import com.tydic.dyc.umc.service.inspectionscore.bo.DycGetSupInspectionListRspBO;
import com.tydic.dyc.umc.service.inspectionscore.service.DycGetSupInspectionListAbilityService;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.umc.service.inspectionscore.service.DycGetSupInspectionListAbilityService"})
public class DycGetSupInspectionListAbilityServiceImpl
implements DycGetSupInspectionListAbilityService {
    private static final Logger log = LoggerFactory.getLogger(DycGetSupInspectionListAbilityServiceImpl.class);
    @Autowired
    private SupInspectionMapper supInspectionMapper;

    @PostMapping(value={"getSupInspectionList"})
    public DycGetSupInspectionListRspBO getSupInspectionList(@RequestBody DycGetSupInspectionListReqBO reqBO) {
        DycGetSupInspectionListRspBO rspBO = new DycGetSupInspectionListRspBO();
        rspBO.setRespCode("0000");
        if (CollectionUtils.isEmpty((Collection)reqBO.getRows())) {
            return rspBO;
        }
        List sups = reqBO.getRows().stream().map(DycGetSupInspectionBO::getSupplierId).collect(Collectors.toList());
        SupInspectionPO supInspectionPO = new SupInspectionPO();
        supInspectionPO.setSupplierIds(sups);
        List supInspectionPOList = this.supInspectionMapper.getList(supInspectionPO);
        if (!CollectionUtils.isEmpty((Collection)supInspectionPOList)) {
            Map<Long, List<SupInspectionPO>> supMap = supInspectionPOList.stream().collect(Collectors.groupingBy(SupInspectionPO::getSupplierId));
            for (DycGetSupInspectionBO each : reqBO.getRows()) {
                if (!supMap.containsKey(each.getSupplierId())) continue;
                List finish = supMap.get(each.getSupplierId()).stream().filter(a -> "4".equals(a.getInspectionStatus()) && each.getCategoryType().equals(a.getCategoryType())).collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(finish)) {
                    finish.stream().forEach(a -> {
                        if (a.getFinishTime() == null) {
                            a.setFinishTime(a.getCreateTime());
                        }
                    });
                    finish = finish.stream().sorted(Comparator.comparing(SupInspectionPO::getFinishTime)).collect(Collectors.toList());
                    BeanUtils.copyProperties(finish.get(finish.size() - 1), (Object)each);
                    continue;
                }
                List todo = supMap.get(each.getSupplierId()).stream().filter(a -> each.getCategoryType().equals(a.getCategoryType())).collect(Collectors.toList());
                if (CollectionUtils.isEmpty(todo)) continue;
                BeanUtils.copyProperties(todo.get(todo.size() - 1), (Object)each);
            }
        }
        rspBO.setRows(reqBO.getRows());
        return rspBO;
    }
}

