/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.objectiveindicators;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.dyc.umc.constants.SupCommConstants;
import com.tydic.dyc.umc.repository.dao.SupEstimatedScoreMapper;
import com.tydic.dyc.umc.repository.dao.SupFinalRatingScoreMapper;
import com.tydic.dyc.umc.repository.dao.SupInspectionMapper;
import com.tydic.dyc.umc.repository.dao.SupObjectiveIndicatorsItemMapper;
import com.tydic.dyc.umc.repository.dao.SupObjectiveIndicatorsMainMapper;
import com.tydic.dyc.umc.repository.dao.UmcOrgInfoMapper;
import com.tydic.dyc.umc.repository.dao.UmcSupplierAssessmentRatingRulesStaticDataMapper;
import com.tydic.dyc.umc.repository.po.SupEstimatedScorePO;
import com.tydic.dyc.umc.repository.po.SupFinalRatingScorePO;
import com.tydic.dyc.umc.repository.po.SupInspectionPO;
import com.tydic.dyc.umc.repository.po.SupObjectiveIndicatorsItemPO;
import com.tydic.dyc.umc.repository.po.SupObjectiveIndicatorsMainPO;
import com.tydic.dyc.umc.repository.po.UmcOrgInfoPo;
import com.tydic.dyc.umc.repository.po.UmcSupplierAssessmentRatingRulesStaticDataPO;
import com.tydic.dyc.umc.service.objectiveindicators.bo.UmcQuerySupplierObjectiveIndicatorsToScoreBO;
import com.tydic.dyc.umc.service.objectiveindicators.bo.UmcQuerySupplierObjectiveIndicatorsToScoreReqBO;
import com.tydic.dyc.umc.service.objectiveindicators.bo.UmcQuerySupplierObjectiveIndicatorsToScoreRspBO;
import com.tydic.dyc.umc.service.objectiveindicators.service.UmcQuerySupplierObjectiveIndicatorsToScoreService;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.umc.service.objectiveindicators.service.UmcQuerySupplierObjectiveIndicatorsToScoreService"})
public class UmcQuerySupplierObjectiveIndicatorsToScoreServiceImpl
implements UmcQuerySupplierObjectiveIndicatorsToScoreService {
    private static final Logger log = LoggerFactory.getLogger(UmcQuerySupplierObjectiveIndicatorsToScoreServiceImpl.class);
    @Autowired
    private UmcSupplierAssessmentRatingRulesStaticDataMapper supplierAssessmentRatingRulesStaticDataMapper;
    @Autowired
    private SupInspectionMapper supInspectionMapper;
    @Autowired
    private SupObjectiveIndicatorsMainMapper supObjectiveIndicatorsMainMapper;
    @Autowired
    private SupObjectiveIndicatorsItemMapper supObjectiveIndicatorsItemMapper;
    @Autowired
    private SupEstimatedScoreMapper supEstimatedScoreMapper;
    @Autowired
    private UmcOrgInfoMapper umcOrgInfoMapper;
    @Autowired
    private SupFinalRatingScoreMapper supFinalRatingScoreMapper;

    @PostMapping(value={"querySupplierObjectiveIndicatorsToScore"})
    public UmcQuerySupplierObjectiveIndicatorsToScoreRspBO querySupplierObjectiveIndicatorsToScore(@RequestBody UmcQuerySupplierObjectiveIndicatorsToScoreReqBO reqBO) {
        UmcQuerySupplierObjectiveIndicatorsToScoreRspBO rspBO = new UmcQuerySupplierObjectiveIndicatorsToScoreRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        this.val(reqBO);
        SupInspectionPO supInspectionPO = new SupInspectionPO();
        if (!ObjectUtil.isEmpty((Object)reqBO.getDycSupInspectionBO())) {
            BeanUtils.copyProperties((Object)reqBO.getDycSupInspectionBO(), (Object)supInspectionPO);
        } else {
            supInspectionPO.setInspectionId(reqBO.getRatingId());
            supInspectionPO = this.supInspectionMapper.getModelBy(supInspectionPO);
        }
        UmcSupplierAssessmentRatingRulesStaticDataPO assessmentRatingListBO = new UmcSupplierAssessmentRatingRulesStaticDataPO();
        assessmentRatingListBO.setRatingRulesId(ObjectUtil.isEmpty((Object)supInspectionPO.getInspectionRuleIdRel()) ? supInspectionPO.getInspectionRuleId() : supInspectionPO.getInspectionRuleIdRel());
        assessmentRatingListBO.setVersion(ObjectUtil.isEmpty((Object)supInspectionPO.getInspectionRuleVersionRel()) ? supInspectionPO.getInspectionRuleVersion() : supInspectionPO.getInspectionRuleVersionRel());
        assessmentRatingListBO.setSelectType(Integer.valueOf(1));
        assessmentRatingListBO.setRelId(supInspectionPO.getInspectionId());
        List assessmentRatingListBOS = this.supplierAssessmentRatingRulesStaticDataMapper.selectIndexList(assessmentRatingListBO);
        SupObjectiveIndicatorsMainPO supObjectiveIndicatorsMainPO = new SupObjectiveIndicatorsMainPO();
        UmcOrgInfoPo umcOrgInfoPo = new UmcOrgInfoPo();
        umcOrgInfoPo.setOrgId(supInspectionPO.getInspectionCompanyId());
        umcOrgInfoPo = this.umcOrgInfoMapper.getModelBy(umcOrgInfoPo);
        log.info("companyId==={}", (Object)umcOrgInfoPo.getCompanyId());
        Long relBusinessId = umcOrgInfoPo.getCompanyId();
        supObjectiveIndicatorsMainPO.setManageBusinessUnitId(relBusinessId);
        supObjectiveIndicatorsMainPO.setYear(String.valueOf(supInspectionPO.getInspectionYear()));
        if (supInspectionPO.getInspectionCycleType().equals(SupCommConstants.InspectionCycleType.QUARTER)) {
            supObjectiveIndicatorsMainPO.setQuarter(String.valueOf(supInspectionPO.getInspectionQuarter()));
        }
        if (supInspectionPO.getInspectionCycleType().equals(SupCommConstants.InspectionCycleType.MONTH)) {
            supObjectiveIndicatorsMainPO.setMonth(String.valueOf(supInspectionPO.getInspectionMonth()));
        }
        supObjectiveIndicatorsMainPO.setRatingPeriod(String.valueOf(supInspectionPO.getInspectionCycleType()));
        supObjectiveIndicatorsMainPO.setStatus("1");
        List supObjectiveIndicatorsMainPOList = this.supObjectiveIndicatorsMainMapper.getList(supObjectiveIndicatorsMainPO);
        if (ObjectUtil.isEmpty((Object)supObjectiveIndicatorsMainPOList) && ObjectUtil.isEmpty((Object)reqBO.getScoreMap())) {
            return rspBO;
        }
        List supObjectiveIndicatorsItemPOList = new ArrayList();
        if (!ObjectUtil.isEmpty((Object)supObjectiveIndicatorsMainPOList)) {
            Set mainIds = supObjectiveIndicatorsMainPOList.stream().map(SupObjectiveIndicatorsMainPO::getId).collect(Collectors.toSet());
            SupObjectiveIndicatorsItemPO supObjectiveIndicatorsItemPO = new SupObjectiveIndicatorsItemPO();
            supObjectiveIndicatorsItemPO.setObjectiveIndicatorsIds(new ArrayList(mainIds));
            supObjectiveIndicatorsItemPO.setSupplierId(supInspectionPO.getSupplierId());
            supObjectiveIndicatorsItemPOList = this.supObjectiveIndicatorsItemMapper.getList(supObjectiveIndicatorsItemPO);
        }
        if (ObjectUtil.isEmpty(supObjectiveIndicatorsItemPOList) && ObjectUtil.isEmpty((Object)reqBO.getScoreMap())) {
            return rspBO;
        }
        Map<String, List<UmcSupplierAssessmentRatingRulesStaticDataPO>> assessmentRatingListMap = assessmentRatingListBOS.stream().collect(Collectors.groupingBy(o -> o.getIndicatorsId() + "-" + o.getRatingIndexId() + "-" + o.getScoringDetailId()));
        Map<Object, Object> supObjectiveIndicatorsItemPOListMap = new HashMap();
        if (!ObjectUtil.isEmpty((Object)supObjectiveIndicatorsMainPOList) && !ObjectUtil.isEmpty(supObjectiveIndicatorsItemPOList)) {
            supObjectiveIndicatorsItemPOListMap = supObjectiveIndicatorsItemPOList.stream().collect(Collectors.groupingBy(o -> o.getIndicatorsId() + "-" + o.getRatingIndexId() + "-" + o.getScoringDetailId()));
        }
        ArrayList<UmcQuerySupplierObjectiveIndicatorsToScoreBO> umcQuerySupplierObjectiveIndicatorsToScoreBOList = new ArrayList<UmcQuerySupplierObjectiveIndicatorsToScoreBO>();
        ArrayList<SupFinalRatingScorePO> supFinalRatingScorePOList = new ArrayList<SupFinalRatingScorePO>();
        for (Map.Entry<String, List<UmcSupplierAssessmentRatingRulesStaticDataPO>> entry : assessmentRatingListMap.entrySet()) {
            UmcQuerySupplierObjectiveIndicatorsToScoreBO bo = new UmcQuerySupplierObjectiveIndicatorsToScoreBO();
            String key = entry.getKey().toString();
            List<UmcSupplierAssessmentRatingRulesStaticDataPO> tempIndicatorsIdList = entry.getValue();
            String scoringMethod = tempIndicatorsIdList.get(0).getScoringMethod();
            if (!supObjectiveIndicatorsItemPOListMap.containsKey(key) || scoringMethod.equals("2")) {
                bo.setIndicatorsId(tempIndicatorsIdList.get(0).getIndicatorsId());
                bo.setIndicatorsName(tempIndicatorsIdList.get(0).getIndicatorsName());
                bo.setRatingIndexId(tempIndicatorsIdList.get(0).getRatingIndexId());
                bo.setRatingIndexName(tempIndicatorsIdList.get(0).getRatingIndexName());
                bo.setScoringDetailId(tempIndicatorsIdList.get(0).getScoringDetailId());
                bo.setScoringDetailName(tempIndicatorsIdList.get(0).getScoringDetailName());
                bo.setWeightId(tempIndicatorsIdList.get(0).getWeightId());
                bo.setWeightSecondId(tempIndicatorsIdList.get(0).getWeightSecondId());
                bo.setWeightThirdId(tempIndicatorsIdList.get(0).getWeightThirdId());
                bo.setObjectiveIndicatorsScoreValue("-999999");
                bo.setMatchScore("-999999");
            }
            if (supObjectiveIndicatorsItemPOListMap.containsKey(key)) {
                bo = this.calculateScore(tempIndicatorsIdList, scoringMethod, (List)supObjectiveIndicatorsItemPOListMap.get(key));
                log.info("bo===={}", (Object)JSON.toJSONString((Object)bo));
                if (!ObjectUtil.isEmpty((Object)bo.getMatchScore())) {
                    bo.setMatchScore(new BigDecimal(bo.getMatchScore()).setScale(2, RoundingMode.HALF_UP).toString());
                }
            }
            umcQuerySupplierObjectiveIndicatorsToScoreBOList.add(bo);
            if (ObjectUtil.isEmpty((Object)reqBO.getScoreMap())) continue;
            String[] keyList = key.split("-", 3);
            SupFinalRatingScorePO supFinalRatingScorePO = new SupFinalRatingScorePO();
            supFinalRatingScorePO.setId(Long.valueOf(Sequence.getInstance().nextId()));
            supFinalRatingScorePO.setInspectionId(supInspectionPO.getInspectionId());
            supFinalRatingScorePO.setIndicatorsId(Long.valueOf(Long.parseLong(keyList[0])));
            supFinalRatingScorePO.setRatingIndexId(Long.valueOf(Long.parseLong(keyList[1])));
            supFinalRatingScorePO.setScoringDetailId(Long.valueOf(Long.parseLong(keyList[2])));
            supFinalRatingScorePO.setEstimatedScore(new BigDecimal(bo.getMatchScore()));
            supFinalRatingScorePO.setUserRating(reqBO.getScoreMap().getOrDefault(key, BigDecimal.ZERO).setScale(2, RoundingMode.HALF_UP));
            supFinalRatingScorePO.setCreateTime(new Date());
            supFinalRatingScorePO.setCreateUserId(Long.valueOf(1L));
            supFinalRatingScorePO.setCreateUserName("admin");
            supFinalRatingScorePOList.add(supFinalRatingScorePO);
        }
        if (!ObjectUtil.isEmpty(umcQuerySupplierObjectiveIndicatorsToScoreBOList)) {
            ArrayList<SupEstimatedScorePO> list = new ArrayList<SupEstimatedScorePO>();
            SupEstimatedScorePO supEstimatedScoreDelPO = new SupEstimatedScorePO();
            supEstimatedScoreDelPO.setInspectionId(reqBO.getRatingId());
            this.supEstimatedScoreMapper.deleteBy(supEstimatedScoreDelPO);
            for (UmcQuerySupplierObjectiveIndicatorsToScoreBO umcQuerySupplierObjectiveIndicatorsToScoreBO : umcQuerySupplierObjectiveIndicatorsToScoreBOList) {
                if (!ObjectUtil.isEmpty((Object)umcQuerySupplierObjectiveIndicatorsToScoreBO.getObjectiveIndicatorsScoreValue()) && umcQuerySupplierObjectiveIndicatorsToScoreBO.getObjectiveIndicatorsScoreValue().equals("-999999") || !ObjectUtil.isEmpty((Object)umcQuerySupplierObjectiveIndicatorsToScoreBO.getMatchScore()) && umcQuerySupplierObjectiveIndicatorsToScoreBO.getMatchScore().equals("-999999")) continue;
                SupEstimatedScorePO supEstimatedScorePO = new SupEstimatedScorePO();
                BeanUtils.copyProperties((Object)umcQuerySupplierObjectiveIndicatorsToScoreBO, (Object)supEstimatedScorePO);
                supEstimatedScorePO.setEstimatedScoreId(Long.valueOf(Sequence.getInstance().nextId()));
                supEstimatedScorePO.setInspectionId(supInspectionPO.getInspectionId());
                supEstimatedScorePO.setEstimatedScore(ObjectUtil.isEmpty((Object)umcQuerySupplierObjectiveIndicatorsToScoreBO.getMatchScore()) ? BigDecimal.ZERO : new BigDecimal(umcQuerySupplierObjectiveIndicatorsToScoreBO.getMatchScore()));
                supEstimatedScorePO.setMatchingResults(umcQuerySupplierObjectiveIndicatorsToScoreBO.getObjectiveIndicatorsScoreValue());
                supEstimatedScorePO.setCreateUserId(reqBO.getUserId());
                supEstimatedScorePO.setCreateUserName(reqBO.getName());
                supEstimatedScorePO.setCreateOrgId(reqBO.getOrgId());
                supEstimatedScorePO.setCreateOrgName(reqBO.getOrgName());
                supEstimatedScorePO.setCreateTime(new Date());
                list.add(supEstimatedScorePO);
            }
            if (!ObjectUtil.isEmpty(list)) {
                this.supEstimatedScoreMapper.insertBatch(list);
            }
        }
        if (!ObjectUtil.isEmpty(supFinalRatingScorePOList) && !ObjectUtil.isEmpty((Object)reqBO.getScoreMap())) {
            this.supFinalRatingScoreMapper.insertBatch(supFinalRatingScorePOList);
        }
        rspBO.setUmcQuerySupplierObjectiveIndicatorsToScoreBOList(umcQuerySupplierObjectiveIndicatorsToScoreBOList);
        return rspBO;
    }

    private void val(UmcQuerySupplierObjectiveIndicatorsToScoreReqBO reqBO) {
        if (ObjectUtil.isEmpty((Object)reqBO.getRatingId())) {
            throw new ZTBusinessException("\u8bc4\u5206\u8868id\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private UmcQuerySupplierObjectiveIndicatorsToScoreBO calculateScore(List<UmcSupplierAssessmentRatingRulesStaticDataPO> ratingRulesStaticDataPOList, String scoringMethod, List<SupObjectiveIndicatorsItemPO> SupObjectiveIndicatorsItemPOList) {
        UmcQuerySupplierObjectiveIndicatorsToScoreBO bo;
        block6: {
            Iterator<UmcSupplierAssessmentRatingRulesStaticDataPO> iterator;
            block9: {
                block8: {
                    block7: {
                        log.info("SupObjectiveIndicatorsItemPOList:{}", (Object)JSON.toJSONString(SupObjectiveIndicatorsItemPOList));
                        log.info("ratingRulesStaticDataPOList:{}", (Object)JSON.toJSONString(ratingRulesStaticDataPOList));
                        bo = new UmcQuerySupplierObjectiveIndicatorsToScoreBO();
                        bo.setIndicatorsId(ratingRulesStaticDataPOList.get(0).getIndicatorsId());
                        bo.setIndicatorsName(ratingRulesStaticDataPOList.get(0).getIndicatorsName());
                        bo.setRatingIndexId(ratingRulesStaticDataPOList.get(0).getRatingIndexId());
                        bo.setRatingIndexName(ratingRulesStaticDataPOList.get(0).getRatingIndexName());
                        bo.setScoringDetailId(ratingRulesStaticDataPOList.get(0).getScoringDetailId());
                        bo.setScoringDetailName(ratingRulesStaticDataPOList.get(0).getScoringDetailName());
                        bo.setWeightId(ratingRulesStaticDataPOList.get(0).getWeightId());
                        bo.setWeightSecondId(ratingRulesStaticDataPOList.get(0).getWeightSecondId());
                        bo.setWeightThirdId(ratingRulesStaticDataPOList.get(0).getWeightThirdId());
                        if (!scoringMethod.equals("3")) break block7;
                        Double sum = SupObjectiveIndicatorsItemPOList.stream().map(SupObjectiveIndicatorsItemPO::getScoreValue).mapToDouble(Double::parseDouble).sum();
                        BigDecimal scoringCriteriaFraction = new BigDecimal(ratingRulesStaticDataPOList.get(0).getScoringCriteriaFraction());
                        BigDecimal eventSum = new BigDecimal(sum);
                        BigDecimal finalScore = scoringCriteriaFraction.multiply(eventSum).setScale(4, RoundingMode.HALF_UP);
                        bo.setObjectiveIndicatorsScoreValue(eventSum.toString());
                        bo.setMatchScore(finalScore.toString());
                        break block6;
                    }
                    if (!scoringMethod.equals("1")) break block8;
                    for (UmcSupplierAssessmentRatingRulesStaticDataPO item : ratingRulesStaticDataPOList) {
                        BigDecimal left = item.getMinScore();
                        BigDecimal right = item.getMaxScore();
                        Optional<SupObjectiveIndicatorsItemPO> maxItem = SupObjectiveIndicatorsItemPOList.stream().max(Comparator.comparingDouble(o -> UmcQuerySupplierObjectiveIndicatorsToScoreServiceImpl.parseScoreValue(o.getScoreValue())));
                        BigDecimal max = new BigDecimal(UmcQuerySupplierObjectiveIndicatorsToScoreServiceImpl.parseScoreValue(maxItem.get().getScoreValue())).multiply(new BigDecimal("100"));
                        if (left.compareTo(max) >= 0 || max.compareTo(right) > 0) continue;
                        bo.setObjectiveIndicatorsScoreValue(maxItem.get().getScoreValue());
                        bo.setMatchScore(item.getScoringCriteriaFraction());
                        break block6;
                    }
                    break block6;
                }
                if (!scoringMethod.equals("4")) break block9;
                for (UmcSupplierAssessmentRatingRulesStaticDataPO item : ratingRulesStaticDataPOList) {
                    BigDecimal left = item.getMinScore();
                    BigDecimal right = item.getMaxScore();
                    Optional<SupObjectiveIndicatorsItemPO> maxItem = SupObjectiveIndicatorsItemPOList.stream().max(Comparator.comparingDouble(o -> UmcQuerySupplierObjectiveIndicatorsToScoreServiceImpl.parseScoreValue(o.getScoreValue())));
                    BigDecimal max = new BigDecimal(UmcQuerySupplierObjectiveIndicatorsToScoreServiceImpl.parseScoreValue(maxItem.get().getScoreValue())).multiply(new BigDecimal("100"));
                    if (left.compareTo(max) >= 0 || max.compareTo(right) > 0) continue;
                    bo.setObjectiveIndicatorsScoreValue(maxItem.get().getScoreValue());
                    BigDecimal ration = item.getRatio().divide(new BigDecimal("100"), 4, RoundingMode.HALF_UP);
                    BigDecimal tolalScore = item.getTolalScore();
                    BigDecimal finalScore = tolalScore.multiply(ration).setScale(4, RoundingMode.HALF_UP);
                    bo.setMatchScore(finalScore.toString());
                    break block6;
                }
                break block6;
            }
            if (!scoringMethod.equals("5") || !(iterator = ratingRulesStaticDataPOList.iterator()).hasNext()) break block6;
            UmcSupplierAssessmentRatingRulesStaticDataPO item = iterator.next();
            BigDecimal tolalScore = item.getTolalScore();
            BigDecimal scoringCriteriaFraction = new BigDecimal(item.getScoringCriteriaFraction());
            Optional<SupObjectiveIndicatorsItemPO> maxItem = SupObjectiveIndicatorsItemPOList.stream().max(Comparator.comparingDouble(o -> UmcQuerySupplierObjectiveIndicatorsToScoreServiceImpl.parseScoreValueCopy(o.getScoreValue())));
            BigDecimal max = new BigDecimal(UmcQuerySupplierObjectiveIndicatorsToScoreServiceImpl.parseScoreValueCopy(maxItem.get().getScoreValue()));
            bo.setObjectiveIndicatorsScoreValue(maxItem.get().getScoreValue());
            BigDecimal achieveProportion = max.divide(scoringCriteriaFraction, 4, RoundingMode.HALF_UP);
            if (achieveProportion.compareTo(BigDecimal.ZERO) <= 0) {
                bo.setMatchScore("0");
            } else if (achieveProportion.compareTo(new BigDecimal("1")) >= 0) {
                bo.setMatchScore(tolalScore.toString());
            } else {
                BigDecimal finalScore = tolalScore.multiply(achieveProportion).setScale(4, RoundingMode.HALF_UP);
                bo.setMatchScore(finalScore.toString());
            }
        }
        return bo;
    }

    private static double parseScoreValue(String scoreValue) {
        if (scoreValue == null || scoreValue.isEmpty()) {
            return 0.0;
        }
        Double d = Double.parseDouble(scoreValue.replace("%", ""));
        if (d > 1.0) {
            d = d / 100.0;
        }
        return d;
    }

    private static double parseScoreValueCopy(String scoreValue) {
        if (scoreValue == null || scoreValue.isEmpty()) {
            return 0.0;
        }
        return Double.parseDouble(scoreValue.replace("%", ""));
    }
}

