/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.qualif;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Page;
import com.tydic.dyc.umc.model.sysdictionary.SysDicDictionaryDo;
import com.tydic.dyc.umc.repository.dao.SupplierCategoryQualificationMappingMapper;
import com.tydic.dyc.umc.repository.dao.UmcEnterpriseQualifMapper;
import com.tydic.dyc.umc.repository.po.UmcEnterpriseQualifPO;
import com.tydic.dyc.umc.service.enterprise.DictionaryBusiService;
import com.tydic.dyc.umc.service.qualif.bo.AnnoxBO;
import com.tydic.dyc.umc.service.qualif.bo.DycSupQualifQryListPageReqBO;
import com.tydic.dyc.umc.service.qualif.bo.DycSupQualifQryListPageRspBO;
import com.tydic.dyc.umc.service.qualif.bo.UmcEnterpriseQualifBO;
import com.tydic.dyc.umc.service.qualif.service.DycSupQualifQryListAbilityService;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.Period;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.umc.service.qualif.service.DycSupQualifQryListAbilityService"})
public class DycSupQualifQryListAbilityServiceImpl
implements DycSupQualifQryListAbilityService {
    private static final Logger log = LoggerFactory.getLogger(DycSupQualifQryListAbilityServiceImpl.class);
    @Autowired
    private UmcEnterpriseQualifMapper umcEnterpriseQualifMapper;
    @Autowired
    private SupplierCategoryQualificationMappingMapper supplierCategoryQualificationMappingMapper;
    @Autowired
    private DictionaryBusiService dictionaryBusiService;

    @PostMapping(value={"supQualifQryList"})
    public DycSupQualifQryListPageRspBO supQualifQryList(@RequestBody DycSupQualifQryListPageReqBO reqBO) {
        DycSupQualifQryListPageRspBO rspBO = new DycSupQualifQryListPageRspBO();
        Page page = new Page();
        page.setPageNo(reqBO.getPageNo().intValue());
        page.setPageSize(reqBO.getPageSize().intValue());
        UmcEnterpriseQualifPO qualifPO = new UmcEnterpriseQualifPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)qualifPO);
        qualifPO.setMaterielCode(reqBO.getMaterialClassification());
        List enterpriseQualifPOList = null;
        Integer star = 0;
        Integer pageSize = 0;
        Integer count = 0;
        if (reqBO.getPageNo() < 0) {
            pageSize = 100000;
            qualifPO.setPageSize(pageSize);
            qualifPO.setStrar(Integer.valueOf(0));
        } else {
            qualifPO.setStrar(Integer.valueOf((reqBO.getPageNo() - 1) * reqBO.getPageSize()));
            qualifPO.setPageSize(reqBO.getPageSize());
        }
        if (reqBO.getEnterpriseId() != null) {
            log.info("\u67e5\u8be2\u53c2\u6570\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)qualifPO));
            count = this.umcEnterpriseQualifMapper.supQualifQryListByBusinessCount(qualifPO);
            enterpriseQualifPOList = this.umcEnterpriseQualifMapper.supQualifQryListByBusiness(qualifPO);
        } else {
            log.info("\u67e5\u8be2\u53c2\u6570\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)qualifPO));
            count = this.umcEnterpriseQualifMapper.supQualifQryListCount(qualifPO);
            enterpriseQualifPOList = this.umcEnterpriseQualifMapper.supQualifQryList(qualifPO);
        }
        if (!CollectionUtil.isEmpty((Collection)enterpriseQualifPOList)) {
            ArrayList<UmcEnterpriseQualifBO> enterpriseQualifBOList = new ArrayList<UmcEnterpriseQualifBO>();
            Map qualifStatusMap = this.dictionaryBusiService.queryBypCodeBackMap("UMC_PLUS", "SUPPLIER_QUALIF_STATUS");
            Map qualifValidStatus = this.dictionaryBusiService.queryBypCodeBackMap("UMC_PLUS", "SUPPLIER_QUALIF_VALID_STATU");
            Map qualifAuditStatus = this.dictionaryBusiService.queryBypCodeBackMap("UMC_PLUS", "SUPPLIER_AUDIT_STATUS");
            Map qualifNameMap = this.dictionaryBusiService.queryBypCodeBackMap("UMC_PLUS", "UMC_QUALIFICATIONS");
            for (UmcEnterpriseQualifPO po : enterpriseQualifPOList) {
                if (po.getQualifId() != null && !po.getQualifId().equals(1L)) {
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                    String str = sdf.format(po.getExpDate());
                    String str1 = sdf.format(po.getIssueDate());
                    Date date = null;
                    Date date1 = null;
                    try {
                        date = sdf.parse(str);
                        date1 = sdf.parse(str1);
                    }
                    catch (ParseException e) {
                        e.printStackTrace();
                    }
                    po.setExpDate(date);
                    po.setIssueDate(date1);
                }
                UmcEnterpriseQualifBO bo = new UmcEnterpriseQualifBO();
                BeanUtils.copyProperties((Object)po, (Object)bo);
                String[] st2 = po.getQualifIdListStr().split(",");
                List<String> ls = Arrays.asList(st2);
                List qualifIds = ls.stream().map(s -> Long.valueOf(s)).collect(Collectors.toList());
                String[] st3 = po.getMaterielCodeList().split(",");
                List<String> ls1 = Arrays.asList(st3);
                bo.setMaterielCodeList(ls1);
                bo.setQualifIds(qualifIds);
                bo.setExpDate(po.getExpDate());
                bo.setIssueDate(po.getIssueDate());
                if (null != po.getQualifFile()) {
                    bo.setQualifFile(JSONObject.parseArray((String)po.getQualifFile(), AnnoxBO.class));
                }
                if (null != po.getQualifStatus()) {
                    bo.setQualifStatusStr((String)qualifStatusMap.get(po.getQualifStatus()));
                }
                if (null != po.getAuditStatus()) {
                    bo.setAuditStatusStr((String)qualifAuditStatus.get(po.getAuditStatus()));
                }
                enterpriseQualifBOList.add(bo);
            }
            SysDicDictionaryDo sysDicDictionaryDo = new SysDicDictionaryDo();
            enterpriseQualifBOList.stream().forEach(a -> {
                if (!StringUtils.isEmpty((Object)a.getValidStatus()) && "2".equals(a.getValidStatus())) {
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTime(a.getExpDate());
                    Period period = Period.between(LocalDate.of(calendar.get(1), calendar.get(2), calendar.get(5)), LocalDate.now());
                    a.setValidStatusStr("\u6709\u6548\u671f\u8fd8\u6709" + period.getDays() + "\u5929");
                } else if (!StringUtils.isEmpty((Object)a.getValidStatus()) && qualifValidStatus.containsKey(a.getValidStatus())) {
                    a.setValidStatusStr((String)qualifValidStatus.get(a.getValidStatus()));
                }
            });
            rspBO.setRows(enterpriseQualifBOList);
        }
        rspBO.setPageNo(reqBO.getPageNo());
        rspBO.setRecordsTotal(count);
        rspBO.setTotal(Integer.valueOf(count % reqBO.getPageSize() == 0 ? count / reqBO.getPageSize() : count / reqBO.getPageSize() + 1));
        rspBO.setRespCode("0000");
        return rspBO;
    }
}

