/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.register;

import com.ohaotian.plugin.db.Page;
import com.tydic.dyc.umc.model.sysdictionary.IUmcSysDicDictionaryModel;
import com.tydic.dyc.umc.model.sysdictionary.SysDicDictionaryDo;
import com.tydic.dyc.umc.repository.dao.UmcSupplierBusinessCategoryMapper;
import com.tydic.dyc.umc.repository.dao.UmcSupplierBusinessIndustryMapper;
import com.tydic.dyc.umc.repository.dao.UmcSupplierBusinessMapper;
import com.tydic.dyc.umc.repository.po.UmcSupplierBusinessCategoryPO;
import com.tydic.dyc.umc.repository.po.UmcSupplierBusinessIndustryPO;
import com.tydic.dyc.umc.repository.po.UmcSupplierBusinessPO;
import com.tydic.dyc.umc.service.register.bo.UmcSupplierBusinessCategoryBo;
import com.tydic.dyc.umc.service.register.bo.UmcSupplierBusinessIndustryBo;
import com.tydic.dyc.umc.service.register.bo.UmcSupplierBusinessUnitBo;
import com.tydic.dyc.umc.service.register.bo.UmcSupplierBusinessUnitQryListReqBo;
import com.tydic.dyc.umc.service.register.bo.UmcSupplierBusinessUnitQryListRspBo;
import com.tydic.dyc.umc.service.register.service.UmcSupplierBusinessUnitQryListService;
import com.tydic.dyc.umc.utils.UmcRu;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.umc.service.register.service.UmcSupplierBusinessUnitQryListService"})
public class UmcSupplierBusinessUnitQryListServiceImpl
implements UmcSupplierBusinessUnitQryListService {
    @Autowired
    private UmcSupplierBusinessIndustryMapper umcSupplierBusinessIndustryMapper;
    @Autowired
    private UmcSupplierBusinessCategoryMapper umcSupplierBusinessCategoryMapper;
    @Autowired
    private UmcSupplierBusinessMapper umcSupplierBusinessMapper;
    @Autowired
    private IUmcSysDicDictionaryModel umcSysDicDictionaryModel;

    @PostMapping(value={"querySupplierBusinessUnitList"})
    public UmcSupplierBusinessUnitQryListRspBo querySupplierBusinessUnitList(@RequestBody UmcSupplierBusinessUnitQryListReqBo reqBo) {
        UmcSupplierBusinessUnitQryListRspBo rspBo = new UmcSupplierBusinessUnitQryListRspBo();
        UmcSupplierBusinessPO umcSupplierBusinessPO = new UmcSupplierBusinessPO();
        umcSupplierBusinessPO.setBusinessUnitName(reqBo.getBusinessUnitName());
        if (reqBo.getOrgIdWeb() == null) {
            umcSupplierBusinessPO.setOrgId(reqBo.getOrgId());
        } else {
            umcSupplierBusinessPO.setOrgId(reqBo.getOrgId());
        }
        Page page = new Page(reqBo.getPageNo().intValue(), reqBo.getPageSize().intValue());
        List list = this.umcSupplierBusinessMapper.getListPage(umcSupplierBusinessPO, page);
        if (CollectionUtils.isEmpty((Collection)list)) {
            rspBo.setRows(new ArrayList(0));
            rspBo.setRespCode("0000");
            rspBo.setRespDesc("\u6210\u529f");
            return rspBo;
        }
        List businessIds = list.stream().map(UmcSupplierBusinessPO::getBusinessId).collect(Collectors.toList());
        Map<Long, List<UmcSupplierBusinessIndustryPO>> industryMap = null;
        UmcSupplierBusinessIndustryPO umcSupplierBusinessIndustryPO = new UmcSupplierBusinessIndustryPO();
        umcSupplierBusinessIndustryPO.setBusinessIdIn(businessIds);
        List industryList = this.umcSupplierBusinessIndustryMapper.getList(umcSupplierBusinessIndustryPO);
        if (!CollectionUtils.isEmpty((Collection)industryList)) {
            industryMap = industryList.stream().collect(Collectors.groupingBy(UmcSupplierBusinessIndustryPO::getBusinessId));
        }
        Map<Long, List<UmcSupplierBusinessCategoryPO>> categoryMap = null;
        UmcSupplierBusinessCategoryPO umcSupplierBusinessCategoryPO = new UmcSupplierBusinessCategoryPO();
        umcSupplierBusinessCategoryPO.setBusinessIdIn(businessIds);
        List categoryList = this.umcSupplierBusinessCategoryMapper.getList(umcSupplierBusinessCategoryPO);
        if (!CollectionUtils.isEmpty((Collection)categoryList)) {
            categoryMap = categoryList.stream().collect(Collectors.groupingBy(UmcSupplierBusinessCategoryPO::getBusinessId));
        }
        Map businessSupplierStatusMap = this.umcSysDicDictionaryModel.queryBypCodeBackMap(new SysDicDictionaryDo("UMC", "BUSINESS_SUPPLIER_STATUS")).getMap();
        Map businessApprovalStatusMap = this.umcSysDicDictionaryModel.queryBypCodeBackMap(new SysDicDictionaryDo("UMC", "BUSINESS_APPROVAL_STATUS")).getMap();
        List businessUnitBoList = UmcRu.jsl((List)list, UmcSupplierBusinessUnitBo.class);
        for (UmcSupplierBusinessUnitBo bo : businessUnitBoList) {
            if (industryMap != null && industryMap.get(bo.getBusinessId()) != null) {
                bo.setBusinessIndustryBoList(UmcRu.jsl(industryMap.get(bo.getBusinessId()), UmcSupplierBusinessIndustryBo.class));
            }
            String industryStr = bo.getBusinessIndustryBoList().stream().map(UmcSupplierBusinessIndustryBo::getIndustryName).collect(Collectors.joining(","));
            bo.setBusinessIndustryStr(industryStr);
            if (categoryMap != null && categoryMap.get(bo.getBusinessId()) != null) {
                bo.setBusinessCategoryBoList(UmcRu.jsl(categoryMap.get(bo.getBusinessId()), UmcSupplierBusinessCategoryBo.class));
            }
            String categoryStr = bo.getBusinessCategoryBoList().stream().map(UmcSupplierBusinessCategoryBo::getCategoryName).collect(Collectors.joining(","));
            bo.setBusinessCategoryStr(categoryStr);
            if (bo.getSupplierStatus() != null && businessSupplierStatusMap.get(bo.getSupplierStatus().toString()) != null) {
                bo.setSupplierStatusStr((String)businessSupplierStatusMap.get(bo.getSupplierStatus().toString()));
            }
            if (bo.getApprovalStatus() == null || businessApprovalStatusMap.get(bo.getApprovalStatus().toString()) == null) continue;
            bo.setApprovalStatusStr((String)businessApprovalStatusMap.get(bo.getApprovalStatus().toString()));
        }
        rspBo.setRows(businessUnitBoList);
        rspBo.setPageNo(reqBo.getPageNo());
        rspBo.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        rspBo.setTotal(Integer.valueOf(page.getTotalPages()));
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }
}

