/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.rules;

import com.ohaotian.plugin.db.Page;
import com.tydic.dyc.umc.model.sysdictionary.SysDicDictionaryDo;
import com.tydic.dyc.umc.model.sysdictionary.qrybo.UmcDictionaryRspBo;
import com.tydic.dyc.umc.repository.UmcSysDicDictionaryRepository;
import com.tydic.dyc.umc.repository.dao.ScoringIndicatorsMapper;
import com.tydic.dyc.umc.repository.dao.UmcEnterpriseInfoMapper;
import com.tydic.dyc.umc.repository.po.ScoringIndicatorsPO;
import com.tydic.dyc.umc.repository.po.UmcEnterpriseInfoPo;
import com.tydic.dyc.umc.service.rules.bo.DycAssessmentRatingIndexBO;
import com.tydic.dyc.umc.service.rules.bo.SupBusinessAssessmentRatingIndexQryAbilityReqBO;
import com.tydic.dyc.umc.service.rules.bo.SupBusinessAssessmentRatingIndexQryAbilityRspBO;
import com.tydic.dyc.umc.service.rules.service.SupBusinessAssessmentRatingIndexQryAbilityService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.umc.service.rules.service.SupBusinessAssessmentRatingIndexQryAbilityService"})
public class SupBusinessAssessmentRatingIndexQryAbilityServiceImpl
implements SupBusinessAssessmentRatingIndexQryAbilityService {
    private static final Logger log = LoggerFactory.getLogger(SupBusinessAssessmentRatingIndexQryAbilityServiceImpl.class);
    @Autowired
    private ScoringIndicatorsMapper scoringIndicatorsMapper;
    @Autowired
    private UmcSysDicDictionaryRepository umcSysDicDictionaryRepository;
    @Autowired
    private UmcEnterpriseInfoMapper umcEnterpriseInfoMapper;

    @PostMapping(value={"queryBusinessRatingIndex"})
    public SupBusinessAssessmentRatingIndexQryAbilityRspBO queryBusinessRatingIndex(@RequestBody SupBusinessAssessmentRatingIndexQryAbilityReqBO reqBO) {
        SupBusinessAssessmentRatingIndexQryAbilityRspBO abilityRspBO = new SupBusinessAssessmentRatingIndexQryAbilityRspBO();
        abilityRspBO.setRespCode("0000");
        ScoringIndicatorsPO indicatorsPO = new ScoringIndicatorsPO();
        indicatorsPO.setIndicatorsCategory(Integer.valueOf(2));
        BeanUtils.copyProperties((Object)reqBO, (Object)indicatorsPO);
        Page page = new Page();
        page.setPageNo(reqBO.getPageNo().intValue());
        page.setPageSize(reqBO.getPageSize().intValue());
        List scoringIndicatorsPOS = this.scoringIndicatorsMapper.selectListGroupByBusiness(indicatorsPO, page);
        abilityRspBO.setPageNo(Integer.valueOf(page.getPageNo()));
        abilityRspBO.setTotal(Integer.valueOf(page.getTotalPages()));
        abilityRspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        if (!CollectionUtils.isEmpty((Collection)scoringIndicatorsPOS)) {
            List ids = scoringIndicatorsPOS.stream().map(ScoringIndicatorsPO::getBusinessCompanyId).collect(Collectors.toList());
            ArrayList<DycAssessmentRatingIndexBO> assessmentRatingIndexBOS = new ArrayList<DycAssessmentRatingIndexBO>();
            UmcEnterpriseInfoPo enterpriseInfoPo = new UmcEnterpriseInfoPo();
            enterpriseInfoPo.setOrgIds(ids);
            List enterpriseInfoPos = this.umcEnterpriseInfoMapper.getOrgListByIds(enterpriseInfoPo);
            Map<Long, String> enterpriseName = enterpriseInfoPos.stream().collect(Collectors.toMap(UmcEnterpriseInfoPo::getOrgId, UmcEnterpriseInfoPo::getOrgName));
            SysDicDictionaryDo sysDicDictionaryDo = new SysDicDictionaryDo();
            sysDicDictionaryDo.setPCode("SCORING_INDICATORS_STATUS");
            UmcDictionaryRspBo dictionaryRspBo = this.umcSysDicDictionaryRepository.queryBypCodeBackMap(sysDicDictionaryDo);
            List scoringIndicatorsPOList = this.scoringIndicatorsMapper.selectListByBusinessId(ids, reqBO.getStatus(), Integer.valueOf(2));
            Map<Long, List<ScoringIndicatorsPO>> groupBy = scoringIndicatorsPOList.stream().collect(Collectors.groupingBy(ScoringIndicatorsPO::getBusinessCompanyId));
            DycAssessmentRatingIndexBO assessmentRatingIndexBO = null;
            for (ScoringIndicatorsPO each : scoringIndicatorsPOS) {
                assessmentRatingIndexBO = new DycAssessmentRatingIndexBO();
                assessmentRatingIndexBO.setBusinessCompanyId(each.getBusinessCompanyId());
                assessmentRatingIndexBO.setBusinessCompanyName(enterpriseName.get(each.getBusinessCompanyId()));
                assessmentRatingIndexBO.setStatus(each.getStatus());
                if (!dictionaryRspBo.getMap().isEmpty()) {
                    assessmentRatingIndexBO.setStatusStr((String)dictionaryRspBo.getMap().get(each.getStatus().toString()));
                }
                if (groupBy.containsKey(each.getBusinessCompanyId())) {
                    List<String> indicatorsNameList = groupBy.get(each.getBusinessCompanyId()).stream().map(ScoringIndicatorsPO::getIndicatorsName).collect(Collectors.toList());
                    assessmentRatingIndexBO.setIndicatorsNameList(indicatorsNameList);
                    assessmentRatingIndexBO.setIndicatorsNameListStr(this.listToString(indicatorsNameList));
                }
                assessmentRatingIndexBOS.add(assessmentRatingIndexBO);
            }
            abilityRspBO.setRows(assessmentRatingIndexBOS);
        }
        return abilityRspBO;
    }

    public String listToString(List<String> list) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < list.size(); ++i) {
            sb.append(list.get(i));
            if (i >= list.size() - 1) continue;
            sb.append("\u3001");
        }
        return sb.toString();
    }
}

