/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.supplier;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import cn.hutool.http.Method;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.authority.model.sysdictionary.impl.ISysDictionaryModelImpl;
import com.tydic.dyc.authority.model.sysdictionary.qrybo.SysDictionaryMapBo;
import com.tydic.dyc.authority.model.sysdictionary.qrybo.SysDictionaryQryBo;
import com.tydic.dyc.umc.repository.dao.UmcSupStatusMapper;
import com.tydic.dyc.umc.repository.dao.UmcSyncDataFailLogMapper;
import com.tydic.dyc.umc.repository.po.UmcSupStatusPO;
import com.tydic.dyc.umc.repository.po.UmcSyncDataFailLogPO;
import com.tydic.dyc.umc.service.supplier.bo.UmcSyncSupExceStatusServiceReqBo;
import com.tydic.dyc.umc.service.supplier.bo.UmcSyncSupExceStatusServiceRspBo;
import com.tydic.dyc.umc.service.supplier.service.UmcSyncSupExceStatusService;
import com.tydic.dyc.umc.utils.IdUtil;
import com.tydic.dyc.umc.utils.UmcRu;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.umc.service.supplier.service.UmcSyncSupExceStatusService"})
public class UmcSyncSupExceStatusServiceImpl
implements UmcSyncSupExceStatusService {
    private static final Logger log = LoggerFactory.getLogger(UmcSyncSupExceStatusServiceImpl.class);
    @Autowired
    private UmcSupStatusMapper umcSupStatusMapper;
    @Autowired
    private UmcSyncDataFailLogMapper umcSyncDataFailLogMapper;
    @Autowired
    private ISysDictionaryModelImpl iSysDictionaryModel;
    @Value(value="${umc.sync.supStatus.url:http://192.168.10.65:30022/OSN/api/syncSupStatus/v1}")
    private String abilityUrl;

    @PostMapping(value={"syncSupStatus"})
    public UmcSyncSupExceStatusServiceRspBo syncSupStatus(@RequestBody UmcSyncSupExceStatusServiceReqBo reqBo) {
        UmcSupStatusPO umcSupStatusPO = new UmcSupStatusPO();
        umcSupStatusPO.setSupId(reqBo.getSupId());
        umcSupStatusPO.setBunessUnitId(reqBo.getBusinessUnitId());
        UmcSupStatusPO modelBy = this.umcSupStatusMapper.getModelBy(umcSupStatusPO);
        if (modelBy == null) {
            return (UmcSyncSupExceStatusServiceRspBo)UmcRu.failed((String)"9999", (String)"\u4f9b\u5e94\u5546\u72b6\u6001\u4e3a\u7a7a", UmcSyncSupExceStatusServiceRspBo.class);
        }
        Map<String, Map<String, String>> dicMap = this.getDic();
        JSONObject supStatusInfo = new JSONObject();
        supStatusInfo.put("supCode", (Object)reqBo.getSupId());
        supStatusInfo.put("supName", (Object)modelBy.getSupName());
        supStatusInfo.put("abnormal", (Object)modelBy.getSupExeStatus());
        supStatusInfo.put("abnormalStr", (Object)dicMap.get("UMC_SUP_EXCEP_STATUS").get(modelBy.getSupExeStatus()));
        supStatusInfo.put("supStatusCode", (Object)modelBy.getSupStatus());
        supStatusInfo.put("supStatusStr", (Object)dicMap.get("ENABLE_ORDER_SUP_STATUS").get(modelBy.getSupStatus()));
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("supStatusInfo", (Object)supStatusInfo);
        HttpResponse httpResponse = new HttpRequest(this.abilityUrl).method(Method.POST).body(jsonObject.toString()).execute();
        log.info("\u4f9b\u5e94\u5546\u72b6\u6001\u540c\u6b65\u51fa\u53c2={}", (Object)httpResponse.body());
        JSONObject parseObject = JSONObject.parseObject((String)httpResponse.body());
        if (!"0000".equals(parseObject.getString("resultCode"))) {
            UmcSyncDataFailLogPO umcSyncDataFailLogPO = new UmcSyncDataFailLogPO();
            umcSyncDataFailLogPO.setId(Long.valueOf(IdUtil.nextId()));
            umcSyncDataFailLogPO.setSupId(reqBo.getSupId());
            umcSyncDataFailLogPO.setReqJson(jsonObject.toString());
            umcSyncDataFailLogPO.setRspJson(httpResponse.body());
            umcSyncDataFailLogPO.setUrl(this.abilityUrl);
            umcSyncDataFailLogPO.setCreateTime(new Date());
            this.umcSyncDataFailLogMapper.insert(umcSyncDataFailLogPO);
        }
        return (UmcSyncSupExceStatusServiceRspBo)UmcRu.success(UmcSyncSupExceStatusServiceRspBo.class);
    }

    private Map<String, Map<String, String>> getDic() {
        ArrayList<String> pCodes = new ArrayList<String>();
        pCodes.add("UMC_SUP_EXCEP_STATUS");
        pCodes.add("ENABLE_ORDER_SUP_STATUS");
        SysDictionaryQryBo sysDictionaryQryBo = new SysDictionaryQryBo();
        sysDictionaryQryBo.setPCodes(pCodes);
        SysDictionaryMapBo sysDictionaryMapBo = this.iSysDictionaryModel.getDictionaryMap(sysDictionaryQryBo);
        if (ObjectUtil.isNotEmpty((Object)sysDictionaryMapBo)) {
            return sysDictionaryMapBo.getDictionaryMap();
        }
        throw new ZTBusinessException("\u67e5\u8be2\u5b57\u5178\u5931\u8d25");
    }
}

