/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.supplier;

import cn.hutool.core.util.ObjectUtil;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.umc.repository.dao.UmcSupStatusLogMapper;
import com.tydic.dyc.umc.repository.dao.UmcSupStatusMapper;
import com.tydic.dyc.umc.repository.po.UmcSupStatusLogPO;
import com.tydic.dyc.umc.repository.po.UmcSupStatusPO;
import com.tydic.dyc.umc.service.supplier.bo.UmcSyncSupExceStatusServiceReqBo;
import com.tydic.dyc.umc.service.supplier.bo.UmcUpdateSupStatusServiceReqBO;
import com.tydic.dyc.umc.service.supplier.bo.UmcUpdateSupStatusServiceRspBO;
import com.tydic.dyc.umc.service.supplier.service.UmcSyncSupExceStatusService;
import com.tydic.dyc.umc.service.supplier.service.UmcUpdateSupStatusService;
import com.tydic.dyc.umc.utils.IdUtil;
import com.tydic.dyc.umc.utils.UmcRu;
import java.util.Date;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Service
@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.umc.service.supplier.service.UmcUpdateSupStatusService"})
public class UmcUpdateSupStatusServiceImpl
implements UmcUpdateSupStatusService {
    private static final Logger log = LoggerFactory.getLogger(UmcUpdateSupStatusServiceImpl.class);
    @Autowired
    private UmcSupStatusLogMapper umcSupStatusLogMapper;
    @Autowired
    private UmcSupStatusMapper umcSupStatusMapper;
    @Autowired
    private UmcSyncSupExceStatusService umcSyncSupExceStatusService;

    @PostMapping(value={"updateSupStatus"})
    public UmcUpdateSupStatusServiceRspBO updateSupStatus(@RequestBody UmcUpdateSupStatusServiceReqBO reqBO) {
        UmcUpdateSupStatusServiceImpl.validateParams(reqBO);
        UmcSupStatusPO umcSupStatusPO = new UmcSupStatusPO();
        umcSupStatusPO.setSupId(reqBO.getSupId());
        umcSupStatusPO.setBunessUnitId(reqBO.getBusinessUnitId());
        umcSupStatusPO = this.umcSupStatusMapper.getModelBy(umcSupStatusPO);
        if (ObjectUtil.isEmpty((Object)umcSupStatusPO)) {
            return (UmcUpdateSupStatusServiceRspBO)UmcRu.failed((String)"9999", (String)"\u4f9b\u5e94\u5546\u72b6\u6001\u4fe1\u606f\u4e0d\u5b58\u5728", UmcUpdateSupStatusServiceRspBO.class);
        }
        this.updateStatus(reqBO);
        this.insertStatusLog(reqBO, umcSupStatusPO);
        CompletableFuture.runAsync(() -> {
            UmcSyncSupExceStatusServiceReqBo syncSupplierDetailsServiceReqBo = new UmcSyncSupExceStatusServiceReqBo();
            syncSupplierDetailsServiceReqBo.setSupId(reqBO.getSupId());
            syncSupplierDetailsServiceReqBo.setBusinessUnitId(reqBO.getBusinessUnitId());
            this.umcSyncSupExceStatusService.syncSupStatus(syncSupplierDetailsServiceReqBo);
        });
        return (UmcUpdateSupStatusServiceRspBO)UmcRu.success(UmcUpdateSupStatusServiceRspBO.class);
    }

    private void updateStatus(UmcUpdateSupStatusServiceReqBO reqBO) {
        UmcSupStatusPO set = new UmcSupStatusPO();
        set.setSupStatus(reqBO.getSupStatus());
        set.setSupExeStatus(reqBO.getSupExeStatus());
        set.setUpdateTime(new Date());
        UmcSupStatusPO where = new UmcSupStatusPO();
        where.setSupId(reqBO.getSupId());
        where.setBunessUnitId(reqBO.getBusinessUnitId());
        this.umcSupStatusMapper.updateBy(set, where);
    }

    private void insertStatusLog(UmcUpdateSupStatusServiceReqBO reqBO, UmcSupStatusPO umcSupStatusPO) {
        UmcSupStatusLogPO umcSupStatusLogPO = new UmcSupStatusLogPO();
        umcSupStatusLogPO.setId(Long.valueOf(IdUtil.nextId()));
        umcSupStatusLogPO.setSupId(reqBO.getSupId());
        umcSupStatusLogPO.setBusinessUnitId(reqBO.getBusinessUnitId());
        umcSupStatusLogPO.setOldSupExeStatus(umcSupStatusPO.getSupExeStatus());
        umcSupStatusLogPO.setOldSupStatus(umcSupStatusPO.getSupStatus());
        umcSupStatusLogPO.setNewSupStatus(reqBO.getSupStatus());
        umcSupStatusLogPO.setNewSupExeStatus(reqBO.getSupExeStatus());
        umcSupStatusLogPO.setCreateTime(new Date());
        this.umcSupStatusLogMapper.insert(umcSupStatusLogPO);
    }

    private static void validateParams(UmcUpdateSupStatusServiceReqBO reqBO) {
        if (ObjectUtil.isEmpty((Object)reqBO.getSupId())) {
            throw new ZTBusinessException("supId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getBusinessUnitId())) {
            throw new ZTBusinessException("businessUnitId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getSupStatus()) && ObjectUtil.isEmpty((Object)reqBO.getSupExeStatus())) {
            throw new ZTBusinessException("supStatus\u548csupExeStatus\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
        }
    }
}

