/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.team;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Page;
import com.tydic.dyc.umc.model.enterprise.IUmcEnterpriseInfoModel;
import com.tydic.dyc.umc.model.enterprise.UmcEnterpriseInfoDo;
import com.tydic.dyc.umc.model.user.IUmcUserInfoModel;
import com.tydic.dyc.umc.repository.dao.SupplierAssessmentScoreTeamMemberMapper;
import com.tydic.dyc.umc.repository.po.SupplierAssessmentScoreTeamMemberPO;
import com.tydic.dyc.umc.service.enterprise.DictionaryBusiService;
import com.tydic.dyc.umc.service.team.bo.AssessmentScoreTeamMemberBO;
import com.tydic.dyc.umc.service.team.bo.UmcSupplierQueryTeamMemberListReqBO;
import com.tydic.dyc.umc.service.team.bo.UmcSupplierQueryTeamMemberListRspBO;
import com.tydic.dyc.umc.service.team.service.UmcSupplierQueryTeamMemberListService;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.umc.service.team.service.UmcSupplierQueryTeamMemberListService"})
public class UmcSupplierQueryTeamMemberListServiceImpl
implements UmcSupplierQueryTeamMemberListService {
    @Autowired
    private SupplierAssessmentScoreTeamMemberMapper supplierAssessmentScoreTeamMemberMapper;
    @Autowired
    private DictionaryBusiService dictionaryBusiService;
    @Autowired
    private IUmcUserInfoModel umcUserInfoModel;
    @Autowired
    private IUmcEnterpriseInfoModel iUmcEnterpriseInfoModel;

    @PostMapping(value={"queryTeamMemberList"})
    public UmcSupplierQueryTeamMemberListRspBO queryTeamMemberList(@RequestBody UmcSupplierQueryTeamMemberListReqBO reqBO) {
        if (null == reqBO.getTeamId()) {
            throw new ZTBusinessException("\u5165\u53c2\u8bc4\u5206\u5c0f\u7ec4ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        UmcSupplierQueryTeamMemberListRspBO rspBO = new UmcSupplierQueryTeamMemberListRspBO();
        SupplierAssessmentScoreTeamMemberPO teamMemberPO = new SupplierAssessmentScoreTeamMemberPO();
        teamMemberPO.setTeamId(reqBO.getTeamId());
        teamMemberPO.setQryNameAccountOrg(reqBO.getQryNameAccountOrg());
        teamMemberPO.setExcludeMemIdList(reqBO.getExcludeMemIdList());
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        List supplierAssessmentScoreTeamMemberPOS = this.supplierAssessmentScoreTeamMemberMapper.selectListPage(teamMemberPO, page);
        if (!CollectionUtils.isEmpty((Collection)supplierAssessmentScoreTeamMemberPOS)) {
            String jsonString = JSONObject.toJSONString((Object)supplierAssessmentScoreTeamMemberPOS, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
            List scoreTeamMemberBOS = JSONObject.parseArray((String)jsonString, AssessmentScoreTeamMemberBO.class);
            List orgIds = scoreTeamMemberBOS.stream().map(AssessmentScoreTeamMemberBO::getBusinessId).collect(Collectors.toList());
            UmcEnterpriseInfoDo pathReqDo = new UmcEnterpriseInfoDo();
            pathReqDo.setOrgIds(orgIds);
            Map orgFullNameMap = this.iUmcEnterpriseInfoModel.getOrgFullNameByOrgIds(pathReqDo).getOrgFullNameByOrgIds();
            Map stopStatusMap = this.dictionaryBusiService.queryBypCodeBackMap("UMC_PLUS", "MEM_STOP_STATUS");
            for (AssessmentScoreTeamMemberBO scoreTeamMemberBO : scoreTeamMemberBOS) {
                if (!StringUtils.isEmpty((Object)scoreTeamMemberBO.getStopStatus()) && null != stopStatusMap.get(scoreTeamMemberBO.getStopStatus())) {
                    scoreTeamMemberBO.setStopStatusStr((String)stopStatusMap.get(scoreTeamMemberBO.getStopStatus()));
                }
                if (CollectionUtils.isEmpty((Map)orgFullNameMap) || !orgFullNameMap.containsKey(scoreTeamMemberBO.getBusinessId())) continue;
                scoreTeamMemberBO.setOrgFullName((String)orgFullNameMap.get(scoreTeamMemberBO.getBusinessId()));
            }
            rspBO.setRows(scoreTeamMemberBOS);
        }
        rspBO.setPageNo(reqBO.getPageNo());
        rspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        rspBO.setTotal(Integer.valueOf(page.getTotalPages()));
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

