/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.atom.aop;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.dyc.atom.annotation.ZycSupDuplicateCommitLimit;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.codec.binary.Hex;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class ZycSupDuplicateCommitLimitAspect {
    private static final Logger log = LoggerFactory.getLogger(ZycSupDuplicateCommitLimitAspect.class);
    @Autowired
    private CacheClient cacheService;

    @Pointcut(value="@annotation(com.tydic.dyc.atom.annotation.ZycSupDuplicateCommitLimit)")
    public void supDuplicateCommitLimit() {
    }

    @Around(value="supDuplicateCommitLimit()")
    public Object around(ProceedingJoinPoint joinPoint) throws Throwable {
        String reqMd = null;
        Object[] args = joinPoint.getArgs();
        String methodName = joinPoint.getSignature().getName();
        MethodSignature methodSignature = (MethodSignature)joinPoint.getSignature();
        Method method = methodSignature.getMethod();
        ZycSupDuplicateCommitLimit info = method.getAnnotation(ZycSupDuplicateCommitLimit.class);
        String expireSecond = info.expireSecond();
        Integer expireSecondInt = Integer.parseInt(expireSecond);
        log.info("expireSecond == {},expireSecondInt==={}", (Object)expireSecond, (Object)expireSecondInt);
        if (null != args && args.length > 0) {
            block10: {
                JSONObject jsonObject = JSON.parseObject((String)JSON.toJSONString((Object)args[0]));
                jsonObject.remove((Object)"traceId");
                try {
                    MessageDigest md = MessageDigest.getInstance("MD5");
                    reqMd = Hex.encodeHexString((byte[])md.digest((methodName + JSON.toJSONString((Object)jsonObject)).getBytes(StandardCharsets.UTF_8)));
                }
                catch (NoSuchAlgorithmException e) {
                    e.printStackTrace();
                    Long userIdIn = (Long)jsonObject.get((Object)"userId");
                    if (null == userIdIn || 0L == userIdIn) break block10;
                    reqMd = userIdIn + joinPoint.toShortString();
                }
            }
            if (null != reqMd) {
                Object o = null;
                try {
                    o = this.cacheService.get(reqMd);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    reqMd = null;
                }
                if (null != o) {
                    throw new ZTBusinessException("\u8bf7\u4e0d\u8981\u91cd\u590d\u63d0\u4ea4");
                }
                if (null != reqMd) {
                    try {
                        this.cacheService.set(reqMd, (Object)reqMd, expireSecondInt.intValue());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        Object result = joinPoint.proceed(args);
        return result;
    }
}

