/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.atom.busicommon.supplier.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.atom.busicommon.supplier.api.DycUmcSupplierInformationChangeService;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.model.common.IUmcCommonModel;
import com.tydic.dyc.umc.model.common.sub.UmcAccessory;
import com.tydic.dyc.umc.model.enterprise.IUmcEnterpriseInfoModel;
import com.tydic.dyc.umc.model.enterprise.UmcEnterpriseInfoDo;
import com.tydic.dyc.umc.model.enterprise.qrybo.UmcEnterpriseBankQryBo;
import com.tydic.dyc.umc.model.enterprise.qrybo.UmcEnterpriseContactQryBo;
import com.tydic.dyc.umc.model.enterprise.qrybo.UmcEnterpriseInfoQryBo;
import com.tydic.dyc.umc.model.enterprise.qrybo.UmcOrgInfoQryBo;
import com.tydic.dyc.umc.model.enterprise.qrybo.UmcOrgInfoRspBo;
import com.tydic.dyc.umc.model.enterprise.sub.UmcEnterpriseBank;
import com.tydic.dyc.umc.model.enterprise.sub.UmcEnterpriseContact;
import com.tydic.dyc.umc.model.enterprise.sub.UmcOrgInfo;
import com.tydic.dyc.umc.model.enterpriseapply.IUmcEnterpriseInfoApplyModel;
import com.tydic.dyc.umc.repository.dao.EnterpriseBusinessScopeMapper;
import com.tydic.dyc.umc.repository.po.EnterpriseBusinessScopePO;
import com.tydic.dyc.umc.service.enterpriseapply.bo.UmcSupplierInformationChangeReqBO;
import com.tydic.dyc.umc.service.enterpriseapply.bo.UmcSupplierInformationChangeRspBO;
import com.tydic.dyc.umc.service.supplieraccess.bo.AnnoxBO;
import com.tydic.dyc.umc.utils.IdUtil;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Transactional
@Service
@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.atom.busicommon.supplier.api.DycUmcSupplierInformationChangeService"})
public class DycUmcSupplierInformationChangeServiceImpl
implements DycUmcSupplierInformationChangeService {
    private static final Logger log = LoggerFactory.getLogger(DycUmcSupplierInformationChangeServiceImpl.class);
    @Autowired
    private IUmcEnterpriseInfoModel iUmcEnterpriseInfoModel;
    @Autowired
    private IUmcEnterpriseInfoApplyModel iUmcEnterpriseInfoApplyModel;
    @Autowired
    private IUmcCommonModel iUmcCommonModel;
    @Autowired
    private EnterpriseBusinessScopeMapper enterpriseBusinessScopeMapper;
    private static final String ENTERPRISE_OBJ_TYPE = "12";

    @PostMapping(value={"changeInformation"})
    public UmcSupplierInformationChangeRspBO changeInformation(@RequestBody UmcSupplierInformationChangeReqBO reqBO) {
        this.validateParams(reqBO);
        this.validateSupName(reqBO);
        this.updateData(reqBO);
        UmcSupplierInformationChangeRspBO rspBo = new UmcSupplierInformationChangeRspBO();
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private void updateData(UmcSupplierInformationChangeReqBO reqBO) {
        try {
            this.updateEnterprise(reqBO);
            this.updateContact(reqBO);
            this.updateOrg(reqBO);
            this.updateBank(reqBO);
            this.updateAccessort(reqBO);
            this.updateABusinessScope(reqBO);
        }
        catch (Exception e) {
            log.error("\u4f9b\u5e94\u5546\u6570\u636e\u66f4\u65b0\u5f02\u5e38", (Throwable)e);
            throw new BaseBusinessException("200100", e.getMessage());
        }
    }

    private void validateSupName(UmcSupplierInformationChangeReqBO reqBO) {
        UmcOrgInfoQryBo orgNameQryBo = new UmcOrgInfoQryBo();
        orgNameQryBo.setOrgName(reqBO.getSupplierName());
        UmcOrgInfoRspBo orgInfoList = this.iUmcEnterpriseInfoModel.getOrgInfoList(orgNameQryBo);
        if (!CollectionUtils.isEmpty((Collection)orgInfoList.getRows())) {
            for (UmcOrgInfo info : orgInfoList.getRows()) {
                if (reqBO.getOrgIdWeb().equals(info.getOrgId())) continue;
                throw new BaseBusinessException("200100", "\u4f9b\u5e94\u5546\u540d\u79f0\u91cd\u590d\uff0c\u8bf7\u4fee\u6539\u4f9b\u5e94\u5546\u540d\u79f0");
            }
        }
    }

    private void validateParams(UmcSupplierInformationChangeReqBO reqBO) {
        if (reqBO.getOrgIdWeb() == null) {
            throw new ZTBusinessException("\u5165\u53c2\u673a\u6784ID\u3010orgIdWeb\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getSupplierType())) {
            throw new ZTBusinessException("\u4f9b\u5e94\u5546\u7c7b\u578b\u3010supplierType\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getSupplierName())) {
            throw new ZTBusinessException("\u4f9b\u5e94\u5546\u540d\u79f0\u3010supplierName\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getConsignerName())) {
            throw new ZTBusinessException("\u8054\u7cfb\u4eba\u3010consignerName\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getPhoneNumber())) {
            throw new ZTBusinessException("\u8054\u7cfb\u4eba\u624b\u673a\u53f7\u7801\u3010phoneNumber\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getEmail())) {
            throw new ZTBusinessException("\u8054\u7cfb\u4eba\u90ae\u7bb1\u3010email\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getConsignerIdcardNum())) {
            throw new ZTBusinessException("\u8054\u7cfb\u4eba\u8bc1\u4ef6\u53f7\u7801\u3010consignerIdcardNum\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getCapaPicture())) {
            throw new ZTBusinessException("\u4f01\u4e1a\u6388\u6743\u59d4\u6258\u4e66\u626b\u63cf\u4ef6\u3010capaPicture\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getConsignerCardPro())) {
            throw new ZTBusinessException("\u88ab\u6388\u6743\u4eba\u8eab\u4efd\u8bc1\u6b63\u9762\u7167\u7247\u3010consignerCardPro\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getConsignerCardCon())) {
            throw new ZTBusinessException("\u88ab\u6388\u6743\u4eba\u8eab\u4efd\u8bc1\u53cd\u9762\u7167\u7247\u3010consignerCardCon\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getContactDirectLeader())) {
            throw new ZTBusinessException("\u8054\u7cfb\u4eba\u76f4\u5c5e\u9886\u5bfc\u3010contactDirectLeader\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getContactDirectLeaderMobile())) {
            throw new ZTBusinessException("\u76f4\u5c5e\u9886\u5bfc\u624b\u673a\u53f7\u7801\u3010contactDirectLeaderMobile\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getContactDirectLeaderEmail())) {
            throw new ZTBusinessException("\u76f4\u5c5e\u9886\u5bfc\u90ae\u7bb1\u3010contactDirectLeaderEmail\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getCompanyType())) {
            throw new ZTBusinessException("\u516c\u53f8\u7c7b\u578b\u3010companyType\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getOrgCertificateCode())) {
            throw new ZTBusinessException("\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u3010orgCertificateCode\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getCapital())) {
            throw new ZTBusinessException("\u6ce8\u518c\u8d44\u91d1\u3010capital\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getLegalPerson())) {
            throw new ZTBusinessException("\u6cd5\u5b9a\u4ee3\u8868\u4eba\u3010legalPerson\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getLegalPersonIdcardNum())) {
            throw new ZTBusinessException("\u6cd5\u4eba\u8bc1\u4ef6\u53f7\u7801\u3010legalPersonIdcardNum\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getPersonnelSize())) {
            throw new ZTBusinessException("\u516c\u53f8\u4eba\u5458\u89c4\u6a21\u3010personnelSize\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getLandProperties())) {
            throw new ZTBusinessException("\u529e\u516c\u5360\u5730\u6027\u8d28\u3010landProperties\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getOfficePhotos())) {
            throw new ZTBusinessException("\u529e\u516c\u7167\u7247\u3010officePhotos\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getPlantLandProperties())) {
            throw new ZTBusinessException("\u5382\u623f\u5360\u5730\u6027\u8d28\u3010plantLandProperties\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getBankName())) {
            throw new ZTBusinessException("\u5f00\u6237\u94f6\u884c\u3010bankName\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getBankAccountName())) {
            throw new ZTBusinessException("\u5f00\u6237\u540d\u79f0\u3010bankAccountName\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getBankAccount())) {
            throw new ZTBusinessException("\u5f00\u6237\u94f6\u884c\u8d26\u53f7\u3010bankAccount\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getBankLinkNo())) {
            throw new ZTBusinessException("\u5f00\u6237\u94f6\u884c\u8054\u884c\u53f7\u3010bankLinkNo\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getBankAddr())) {
            throw new ZTBusinessException("\u5f00\u6237\u884c\u5730\u5740\u3010bankAddr\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void updateABusinessScope(UmcSupplierInformationChangeReqBO reqBO) {
        EnterpriseBusinessScopePO scopePO = new EnterpriseBusinessScopePO();
        scopePO.setOrgId(reqBO.getOrgIdWeb());
        scopePO = this.enterpriseBusinessScopeMapper.getModelBy(scopePO);
        if (scopePO != null) {
            EnterpriseBusinessScopePO set = new EnterpriseBusinessScopePO();
            set.setBusinessScope(reqBO.getBusinessScope());
            EnterpriseBusinessScopePO where = new EnterpriseBusinessScopePO();
            where.setOrgId(reqBO.getOrgIdWeb());
            this.enterpriseBusinessScopeMapper.updateBy(set, where);
        } else {
            EnterpriseBusinessScopePO insertPo = new EnterpriseBusinessScopePO();
            insertPo.setBusinessScope(reqBO.getBusinessScope());
            insertPo.setOrgId(reqBO.getOrgIdWeb());
            this.enterpriseBusinessScopeMapper.insert(insertPo);
        }
    }

    private void updateAccessort(UmcSupplierInformationChangeReqBO reqBO) {
        ArrayList<UmcAccessory> delAccessoryList = new ArrayList<UmcAccessory>();
        ArrayList<UmcAccessory> insertUmcAccessories = new ArrayList<UmcAccessory>();
        if (reqBO.getPlantPhotos() != null && reqBO.getPlantPhotos().size() > 0) {
            this.buildAccessory(reqBO.getPlantPhotos(), insertUmcAccessories, reqBO, "PLANT_PHOTO", delAccessoryList);
        }
        if (reqBO.getOfficePhotos() != null && reqBO.getOfficePhotos().size() > 0) {
            this.buildAccessory(reqBO.getOfficePhotos(), insertUmcAccessories, reqBO, "OFFICE_PHOTOS", delAccessoryList);
        }
        if (reqBO.getPlantLeaseContractAccessory() != null && reqBO.getPlantLeaseContractAccessory().size() > 0) {
            this.buildAccessory(reqBO.getPlantLeaseContractAccessory(), insertUmcAccessories, reqBO, "PLANT_LEASE_CONTRACT", delAccessoryList);
        }
        if (reqBO.getLeaseContractAccessory() != null && reqBO.getLeaseContractAccessory().size() > 0) {
            this.buildAccessory(reqBO.getLeaseContractAccessory(), insertUmcAccessories, reqBO, "LEASE_CONTRACT", delAccessoryList);
        }
        for (UmcAccessory umcAccessory : delAccessoryList) {
            this.iUmcCommonModel.deleteAccessory(umcAccessory);
        }
        this.iUmcCommonModel.insetAccessory(insertUmcAccessories);
    }

    private static void buildDelAccessory(List<UmcAccessory> delAccessoryList, String attachmentType) {
    }

    private void buildAccessory(List<AnnoxBO> annoxBOS, List<UmcAccessory> umcAccessories, UmcSupplierInformationChangeReqBO reqBO, String accessoryType, List<UmcAccessory> delAccessoryList) {
        UmcAccessory accessory = new UmcAccessory();
        accessory.setObjId(reqBO.getOrgIdWeb());
        accessory.setAttachmentType(accessoryType);
        delAccessoryList.add(accessory);
        for (AnnoxBO plantPhoto : annoxBOS) {
            UmcAccessory umcAccessory = new UmcAccessory();
            umcAccessory.setId(Long.valueOf(IdUtil.nextId()));
            umcAccessory.setObjId(reqBO.getOrgIdWeb());
            umcAccessory.setObjType(ENTERPRISE_OBJ_TYPE);
            umcAccessory.setAttachmentType(accessoryType);
            umcAccessory.setTenantId(reqBO.getTenantIdIn());
            umcAccessory.setAccessoryName(plantPhoto.getName());
            umcAccessory.setAccessoryUrl(plantPhoto.getPath());
            umcAccessory.setCreateTime(new Date());
            umcAccessory.setCreateOperId(reqBO.getUserId().toString());
            umcAccessories.add(umcAccessory);
        }
    }

    private void updateOrg(UmcSupplierInformationChangeReqBO reqBO) {
        UmcOrgInfoQryBo orgInfoQryBo = this.getUmcOrgInfoQryBo(reqBO);
        UmcOrgInfo insertOrgInfo = new UmcOrgInfo();
        if (null != orgInfoQryBo) {
            BeanUtils.copyProperties((Object)orgInfoQryBo, (Object)insertOrgInfo);
        }
        if (ObjectUtil.isNotEmpty((Object)reqBO.getSupplierName())) {
            insertOrgInfo.setOrgName(reqBO.getSupplierName());
        }
        if (ObjectUtil.isNotEmpty((Object)reqBO.getSupplierShortName())) {
            insertOrgInfo.setOrgAlias(reqBO.getSupplierShortName());
        }
        if (ObjectUtil.isNotEmpty((Object)reqBO.getOrgCode())) {
            insertOrgInfo.setOrgCode(reqBO.getOrgCode());
        }
        if (orgInfoQryBo != null) {
            insertOrgInfo.setUpdateOperId(reqBO.getUserId());
            insertOrgInfo.setUpdateTime(new Date());
            insertOrgInfo.setUpdateOperName(reqBO.getName());
            this.iUmcEnterpriseInfoModel.updateOrgInfo(insertOrgInfo);
        } else {
            insertOrgInfo.setCreateOperId(reqBO.getUserId());
            insertOrgInfo.setCreateTime(new Date());
            insertOrgInfo.setCreateOperName(reqBO.getName());
            this.iUmcEnterpriseInfoModel.createOrgInfo(insertOrgInfo);
        }
    }

    @NotNull
    private UmcOrgInfoQryBo getUmcOrgInfoQryBo(UmcSupplierInformationChangeReqBO reqBO) {
        UmcOrgInfoQryBo orgInfoQryBo = new UmcOrgInfoQryBo();
        orgInfoQryBo.setOrgId(reqBO.getOrgIdWeb());
        UmcOrgInfo orgInfo = this.iUmcEnterpriseInfoModel.getOrgInfo(orgInfoQryBo);
        if (orgInfo == null) {
            throw new BaseBusinessException("200100", "\u673a\u6784\u4fe1\u606f\u4e3a\u7a7a");
        }
        return orgInfoQryBo;
    }

    private void updateContact(UmcSupplierInformationChangeReqBO reqBO) {
        UmcEnterpriseContact enterpriseContact = this.getUmcEnterpriseContact(reqBO);
        UmcEnterpriseContact insertBo = new UmcEnterpriseContact();
        if (enterpriseContact != null) {
            BeanUtils.copyProperties((Object)enterpriseContact, (Object)insertBo);
        }
        insertBo.setTenantId(reqBO.getTenantIdIn());
        insertBo.setOrgId(reqBO.getOrgIdWeb());
        if (ObjectUtil.isNotEmpty((Object)reqBO.getConsignerName())) {
            insertBo.setContactName(reqBO.getConsignerName());
        }
        if (ObjectUtil.isNotEmpty((Object)reqBO.getConsignerIdcardNum())) {
            insertBo.setCardNum(reqBO.getConsignerIdcardNum());
        }
        if (!CollectionUtils.isEmpty((Collection)reqBO.getConsignerCardPro())) {
            insertBo.setCardPicPeople(JSONObject.toJSONString((Object)reqBO.getConsignerCardPro()));
        }
        if (ObjectUtil.isNotEmpty((Object)reqBO.getTel())) {
            insertBo.setTel(reqBO.getTel());
        }
        if (ObjectUtil.isNotEmpty((Object)reqBO.getPhoneNumber())) {
            insertBo.setPhoneNumber(reqBO.getPhoneNumber());
        }
        if (ObjectUtil.isNotEmpty((Object)reqBO.getEmail())) {
            insertBo.setEmail(reqBO.getEmail());
        }
        if (!CollectionUtils.isEmpty((Collection)reqBO.getConsignerCardCon())) {
            insertBo.setCardPicNational(JSONObject.toJSONString((Object)reqBO.getConsignerCardCon()));
        }
        if (ObjectUtil.isNotEmpty((Object)reqBO.getSex())) {
            insertBo.setSex(reqBO.getSex());
        }
        if (enterpriseContact != null) {
            insertBo.setUpdateOperId(reqBO.getUserId());
            insertBo.setUpdateOperName(reqBO.getName());
            insertBo.setUpdateTime(new Date());
            this.iUmcEnterpriseInfoModel.updateEnterpriseContact(insertBo);
        } else {
            insertBo.setCreateOperId(reqBO.getUserId());
            insertBo.setCreateOperName(reqBO.getName());
            insertBo.setCreateTime(new Date());
            this.iUmcEnterpriseInfoModel.createEnterpriseContact(insertBo);
        }
    }

    private UmcEnterpriseContact getUmcEnterpriseContact(UmcSupplierInformationChangeReqBO reqBO) {
        UmcEnterpriseContactQryBo contactQryBo = new UmcEnterpriseContactQryBo();
        contactQryBo.setOrgId(reqBO.getOrgIdWeb());
        UmcEnterpriseContact enterpriseContact = this.iUmcEnterpriseInfoModel.getEnterpriseContact(contactQryBo);
        return enterpriseContact;
    }

    public void updateEnterprise(UmcSupplierInformationChangeReqBO reqBO) {
        UmcEnterpriseInfoDo eninfoMainPO = this.getUmcEnterpriseInfoDo(reqBO);
        UmcEnterpriseInfoDo umcEnterpriseInfoDo = DycUmcSupplierInformationChangeServiceImpl.buildUmcEnterpriseInfoDo(reqBO, eninfoMainPO);
        this.iUmcEnterpriseInfoModel.updateEnterpriseInfo(umcEnterpriseInfoDo);
    }

    private static UmcEnterpriseInfoDo buildUmcEnterpriseInfoDo(UmcSupplierInformationChangeReqBO reqBO, UmcEnterpriseInfoDo eninfoMainPO) {
        UmcEnterpriseInfoDo umcEnterpriseInfoDo = new UmcEnterpriseInfoDo();
        BeanUtils.copyProperties((Object)eninfoMainPO, (Object)umcEnterpriseInfoDo);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        umcEnterpriseInfoDo.setOrgName(reqBO.getSupplierName());
        umcEnterpriseInfoDo.setOrgShortName(reqBO.getSupplierShortName());
        umcEnterpriseInfoDo.setOrgEnName(reqBO.getSupplierEnName());
        if (ObjectUtil.isNotEmpty((Object)reqBO.getSupplierType())) {
            umcEnterpriseInfoDo.setSupplierType(reqBO.getSupplierType());
            if (reqBO.getSupplierType().equals("6")) {
                umcEnterpriseInfoDo.setSupplierTypeOther(reqBO.getSupplierTypeOther());
            }
        }
        umcEnterpriseInfoDo.setCreditNo(reqBO.getOrgCertificateCode());
        umcEnterpriseInfoDo.setCapaPicture(JSONObject.toJSONString((Object)reqBO.getCapaPicture()));
        if (reqBO.getEffDate() != null) {
            umcEnterpriseInfoDo.setEffDate(simpleDateFormat.format(reqBO.getEffDate()));
        }
        umcEnterpriseInfoDo.setBusinessLicense(JSONObject.toJSONString((Object)reqBO.getBusinessLicense()));
        umcEnterpriseInfoDo.setProvince(reqBO.getProvinceName());
        umcEnterpriseInfoDo.setLegalPerson(reqBO.getLegalPerson());
        umcEnterpriseInfoDo.setLegalCertificateType(reqBO.getLegalPersonIdcardType());
        umcEnterpriseInfoDo.setLegalCertificateNum(reqBO.getLegalPersonIdcardNum());
        umcEnterpriseInfoDo.setLegalCertificateFront(JSONObject.toJSONString((Object)reqBO.getLegalPersonCardPro()));
        umcEnterpriseInfoDo.setLegalCertificateBack(JSONObject.toJSONString((Object)reqBO.getLegalPersonCardCan()));
        umcEnterpriseInfoDo.setAddress(reqBO.getAddress());
        umcEnterpriseInfoDo.setCapital(reqBO.getCapital());
        umcEnterpriseInfoDo.setCreateOperId(reqBO.getUserId());
        umcEnterpriseInfoDo.setCreateOperName(reqBO.getName());
        umcEnterpriseInfoDo.setBusinessIicenseStartDate(reqBO.getBusinessIicenseStartDate());
        umcEnterpriseInfoDo.setBusinessLicenseEndDate(reqBO.getBusinessLicenseEndDate());
        umcEnterpriseInfoDo.setCompanyRole(reqBO.getCompanyRole());
        umcEnterpriseInfoDo.setUpperCompany(reqBO.getUpperCompany());
        umcEnterpriseInfoDo.setMembershipGroup(reqBO.getMembershipGroup());
        umcEnterpriseInfoDo.setPersonnelSize(reqBO.getPersonnelSize());
        umcEnterpriseInfoDo.setLeaseContract(reqBO.getLeaseContract());
        umcEnterpriseInfoDo.setLandProperties(reqBO.getLandProperties());
        umcEnterpriseInfoDo.setPlantLandProperties(reqBO.getPlantLandProperties());
        umcEnterpriseInfoDo.setPlantLeaseContract(reqBO.getPlantLeaseContract());
        umcEnterpriseInfoDo.setContactDirectLeader(reqBO.getContactDirectLeader());
        umcEnterpriseInfoDo.setContactDirectLeaderMobile(reqBO.getContactDirectLeaderMobile());
        umcEnterpriseInfoDo.setContactDirectLeaderEmail(reqBO.getContactDirectLeaderEmail());
        return umcEnterpriseInfoDo;
    }

    private UmcEnterpriseInfoDo getUmcEnterpriseInfoDo(UmcSupplierInformationChangeReqBO reqBO) {
        UmcEnterpriseInfoQryBo enterpriseInfoMainPO = new UmcEnterpriseInfoQryBo();
        enterpriseInfoMainPO.setOrgId(reqBO.getOrgIdWeb());
        UmcEnterpriseInfoDo eninfoMainPO = this.iUmcEnterpriseInfoModel.getEnterpriseInfo(enterpriseInfoMainPO);
        return eninfoMainPO;
    }

    public void updateBank(UmcSupplierInformationChangeReqBO reqBO) {
        UmcEnterpriseBank enterpriseBankInfoPO = this.getUmcEnterpriseBank(reqBO);
        UmcEnterpriseBank infoPO = new UmcEnterpriseBank();
        infoPO.setBankAccount(reqBO.getBankAccount());
        infoPO.setBankName(reqBO.getBankName());
        infoPO.setBankAccountName(reqBO.getBankAccountName());
        infoPO.setBankLinkNo(reqBO.getBankLinkNo());
        infoPO.setBankAddr(reqBO.getBankAddr());
        infoPO.setOrgId(reqBO.getOrgIdWeb());
        infoPO.setTenantId(reqBO.getTenantIdIn());
        if (enterpriseBankInfoPO != null) {
            infoPO.setBankId(enterpriseBankInfoPO.getBankId());
        } else {
            infoPO.setBankId(Long.valueOf(IdUtil.nextId()));
        }
        if (null != enterpriseBankInfoPO) {
            infoPO.setUpdateOperId(reqBO.getUserId());
            infoPO.setUpdateTime(new Date());
            infoPO.setUpdateOperName(reqBO.getName());
            this.iUmcEnterpriseInfoModel.updateEnterpriseBank(infoPO);
        } else {
            infoPO.setCreateOperId(reqBO.getUserId());
            infoPO.setCreateOperName(reqBO.getName());
            infoPO.setCreateTime(new Date());
            this.iUmcEnterpriseInfoModel.createEnterpriseBank(infoPO);
        }
    }

    private UmcEnterpriseBank getUmcEnterpriseBank(UmcSupplierInformationChangeReqBO reqBO) {
        UmcEnterpriseBankQryBo bankInfoPO = new UmcEnterpriseBankQryBo();
        bankInfoPO.setOrgId(reqBO.getOrgIdWeb());
        UmcEnterpriseBank enterpriseBankInfoPO = this.iUmcEnterpriseInfoModel.getEnterpriseBank(bankInfoPO);
        return enterpriseBankInfoPO;
    }
}

