/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.atom.busicommon.supplier.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.atom.busicommon.supplier.api.UmcSupplierBusinessCreateService;
import com.tydic.dyc.atom.busicommon.supplier.bo.UmcSupplierBusinessCreateReqBo;
import com.tydic.dyc.atom.busicommon.supplier.bo.UmcSupplierBusinessCreateRspBo;
import com.tydic.dyc.umc.constants.UmcStatusConstant;
import com.tydic.dyc.umc.repository.dao.UmcSupplierBusinessCategoryMapper;
import com.tydic.dyc.umc.repository.dao.UmcSupplierBusinessIndustryMapper;
import com.tydic.dyc.umc.repository.dao.UmcSupplierBusinessMapper;
import com.tydic.dyc.umc.repository.po.UmcSupplierBusinessCategoryPO;
import com.tydic.dyc.umc.repository.po.UmcSupplierBusinessIndustryPO;
import com.tydic.dyc.umc.repository.po.UmcSupplierBusinessPO;
import com.tydic.dyc.umc.service.register.bo.UmcSupplierBusinessCategoryBo;
import com.tydic.dyc.umc.service.register.bo.UmcSupplierBusinessIndustryBo;
import com.tydic.dyc.umc.utils.IdUtil;
import com.tydic.dyc.umc.utils.UmcRu;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

public class UmcSupplierBusinessCreateServiceImpl
implements UmcSupplierBusinessCreateService {
    @Autowired
    private UmcSupplierBusinessIndustryMapper umcSupplierBusinessIndustryMapper;
    @Autowired
    private UmcSupplierBusinessCategoryMapper umcSupplierBusinessCategoryMapper;
    @Autowired
    private UmcSupplierBusinessMapper umcSupplierBusinessMapper;

    public UmcSupplierBusinessCreateRspBo createSupplierBusiness(UmcSupplierBusinessCreateReqBo reqBO) {
        this.validateParams(reqBO);
        UmcSupplierBusinessPO checkBusinessPo = new UmcSupplierBusinessPO();
        checkBusinessPo.setOrgId(reqBO.getOrgIdIn());
        checkBusinessPo.setBusinessUnitId(reqBO.getBusinessUnitId());
        if (this.umcSupplierBusinessMapper.getCheckBy(checkBusinessPo) > 0) {
            throw new ZTBusinessException("\u4e1a\u52a1\u5355\u4f4d\u5df2\u5b58\u5728");
        }
        Date now = new Date();
        UmcSupplierBusinessPO umcSupplierBusinessPO = new UmcSupplierBusinessPO();
        umcSupplierBusinessPO.setBusinessId(Long.valueOf(IdUtil.nextId()));
        umcSupplierBusinessPO.setOrgId(reqBO.getOrgId());
        umcSupplierBusinessPO.setBusinessUnitId(reqBO.getBusinessUnitId());
        umcSupplierBusinessPO.setBusinessUnitName(reqBO.getBusinessUnitName());
        umcSupplierBusinessPO.setBusinessUnitCode(reqBO.getBusinessUnitCode());
        umcSupplierBusinessPO.setApprovalStatus(UmcStatusConstant.BusinessApprovalStatus.DRAFT);
        umcSupplierBusinessPO.setCreateTime(now);
        umcSupplierBusinessPO.setCreateOperId(reqBO.getUserIdIn().toString());
        this.umcSupplierBusinessMapper.insert(umcSupplierBusinessPO);
        ArrayList<UmcSupplierBusinessIndustryPO> industryPOList = new ArrayList<UmcSupplierBusinessIndustryPO>();
        for (UmcSupplierBusinessIndustryBo industryBo : reqBO.getBusinessIndustryBoList()) {
            UmcSupplierBusinessIndustryPO industryPO = new UmcSupplierBusinessIndustryPO();
            industryPO.setBusinessIndustryId(Long.valueOf(IdUtil.nextId()));
            industryPO.setBusinessId(umcSupplierBusinessPO.getBusinessId());
            industryPO.setIndustryId(industryBo.getIndustryId());
            industryPO.setIndustryCode(industryBo.getIndustryCode());
            industryPO.setIndustryName(industryBo.getIndustryName());
            industryPO.setCreateTime(now);
            industryPO.setCreateOperId(reqBO.getUserIdIn().toString());
            industryPOList.add(industryPO);
        }
        this.umcSupplierBusinessIndustryMapper.insertBatch(industryPOList);
        ArrayList<UmcSupplierBusinessCategoryPO> categoryPOList = new ArrayList<UmcSupplierBusinessCategoryPO>();
        for (UmcSupplierBusinessCategoryBo categoryBo : reqBO.getBusinessCategoryBoList()) {
            UmcSupplierBusinessCategoryPO categoryPO = new UmcSupplierBusinessCategoryPO();
            categoryPO.setBusinessCategoryId(Long.valueOf(IdUtil.nextId()));
            categoryPO.setBusinessId(umcSupplierBusinessPO.getBusinessId());
            categoryPO.setCategoryId(categoryBo.getCategoryId());
            categoryPO.setCategoryCode(categoryBo.getCategoryCode());
            categoryPO.setCategoryName(categoryBo.getCategoryName());
            categoryPO.setCreateTime(now);
            categoryPO.setCreateOperId(reqBO.getUserIdIn().toString());
            categoryPOList.add(categoryPO);
        }
        this.umcSupplierBusinessCategoryMapper.insertBatch(categoryPOList);
        return (UmcSupplierBusinessCreateRspBo)UmcRu.success(UmcSupplierBusinessCreateRspBo.class);
    }

    private void validateParams(UmcSupplierBusinessCreateReqBo reqBO) {
        if (null == reqBO) {
            throw new ZTBusinessException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getBusinessUnitId()) {
            throw new ZTBusinessException("\u4e1a\u52a1\u5355\u4f4dID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getBusinessUnitCode())) {
            throw new ZTBusinessException("\u4e1a\u52a1\u5355\u4f4d\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getBusinessUnitName())) {
            throw new ZTBusinessException("\u4e1a\u52a1\u5355\u4f4d\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getBusinessIndustryBoList())) {
            throw new ZTBusinessException("\u4e1a\u52a1\u5355\u4f4d\u884c\u4e1a\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (UmcSupplierBusinessIndustryBo industryBo : reqBO.getBusinessIndustryBoList()) {
            if (StringUtils.isBlank((CharSequence)industryBo.getIndustryCode())) {
                throw new ZTBusinessException("\u4e1a\u52a1\u5355\u4f4d\u884c\u4e1a\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)industryBo.getIndustryName())) {
                throw new ZTBusinessException("\u4e1a\u52a1\u5355\u4f4d\u884c\u4e1a\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null != industryBo.getIndustryId()) continue;
            throw new ZTBusinessException("\u4e1a\u52a1\u5355\u4f4d\u884c\u4e1aID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getBusinessCategoryBoList())) {
            throw new ZTBusinessException("\u4e1a\u52a1\u5355\u4f4d\u5206\u7c7b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (UmcSupplierBusinessCategoryBo categoryBo : reqBO.getBusinessCategoryBoList()) {
            if (StringUtils.isBlank((CharSequence)categoryBo.getCategoryCode())) {
                throw new ZTBusinessException("\u4e1a\u52a1\u5355\u4f4d\u5206\u7c7b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)categoryBo.getCategoryName())) {
                throw new ZTBusinessException("\u4e1a\u52a1\u5355\u4f4d\u5206\u7c7b\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null != categoryBo.getCategoryId()) continue;
            throw new ZTBusinessException("\u4e1a\u52a1\u5355\u4f4d\u5206\u7c7bID\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

